/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.cardinality;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.CompositeExpressionSelectivityCalculator;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.ExpressionSelectivityCalculator$;
import org.neo4j.cypher.internal.compiler.planner.logical.cardinality.SelectivityCombiner;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsBoundingBoxSeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsDistanceSeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsPropertyScannable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsPropertySeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsStringRangeSeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.AsValueRangeSeekable$;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.InequalityRangeSeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.PointBoundingBoxSeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.PointDistanceSeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.PrefixRangeSeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.PropertySeekable;
import org.neo4j.cypher.internal.compiler.planner.logical.plans.Scannable;
import org.neo4j.cypher.internal.expressions.Contains;
import org.neo4j.cypher.internal.expressions.EndsWith;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.PartialPredicate;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.logical.plans.PrefixRange;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CompositeExpressionSelectivityCalculator$
implements Serializable {
    public static final CompositeExpressionSelectivityCalculator$ MODULE$ = new CompositeExpressionSelectivityCalculator$();

    public Selectivity selectivityForCompositeIndexPredicates(CompositeExpressionSelectivityCalculator.SelectivitiesForPredicates selectivitiesForPredicates, SelectivityCombiner combiner) {
        Selectivity assumedUniqueSelectivityPerPredicate = selectivitiesForPredicates.uniqueSelectivity().$up(1.0 / (double)selectivitiesForPredicates.numberOfIndexedProperties());
        Seq selectivitiesAssumingExistence = (Seq)selectivitiesForPredicates.solvedPredicates().toSeq().map((Function1 & Serializable)predicate -> MODULE$.getPredicateSelectivity(assumedUniqueSelectivityPerPredicate, combiner, (Expression)predicate));
        return selectivitiesForPredicates.existsSelectivity().$times((Selectivity)combiner.andTogetherSelectivities((Iterable<Selectivity>)selectivitiesAssumingExistence).getOrElse((Function0 & Serializable)() -> Selectivity$.MODULE$.ONE()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Selectivity getPredicateSelectivity(Selectivity assumedUniqueSelectivityPerPredicate, SelectivityCombiner combiner, Expression predicate) {
        Option<InequalityRangeSeekable> option;
        Option<PointBoundingBoxSeekable> option2;
        Option<PointDistanceSeekable> option3;
        PrefixRange<Expression> prefixRange;
        PrefixRangeSeekable prefixRangeSeekable;
        Option<PrefixRangeSeekable> option4;
        Option<PropertySeekable> option5;
        Expression expression;
        while ((expression = predicate) instanceof PartialPredicate) {
            PartialPredicate partialPredicate = (PartialPredicate)expression;
            predicate = partialPredicate.coveredPredicate();
        }
        if (expression != null && !(option5 = AsPropertySeekable$.MODULE$.unapply(expression)).isEmpty()) {
            PropertySeekable seekable = (PropertySeekable)option5.get();
            Option sizeHint = seekable.args().sizeHint();
            return ExpressionSelectivityCalculator$.MODULE$.indexSelectivityWithSizeHint((Option<Object>)sizeHint, (Function1<Object, Selectivity>)(Function1 & Serializable)size -> CompositeExpressionSelectivityCalculator$.$anonfun$getPredicateSelectivity$1(combiner, assumedUniqueSelectivityPerPredicate, BoxesRunTime.unboxToInt((Object)size)));
        }
        if (expression != null && !(option4 = AsStringRangeSeekable$.MODULE$.unapply(expression)).isEmpty() && (prefixRangeSeekable = (PrefixRangeSeekable)option4.get()) != null && (prefixRange = prefixRangeSeekable.range()) != null) {
            Expression prefix = (Expression)prefixRange.prefix();
            return ExpressionSelectivityCalculator$.MODULE$.indexSelectivityForSubstringSargable(prefix, ExpressionSelectivityCalculator$.MODULE$.indexSelectivityForSubstringSargable$default$2());
        }
        if (expression instanceof Contains) {
            Property property;
            Expression expression2;
            Contains contains = (Contains)expression;
            Expression expression3 = contains.lhs();
            Expression substring = contains.rhs();
            if (expression3 instanceof Property && (expression2 = (property = (Property)expression3).map()) instanceof Variable) {
                return ExpressionSelectivityCalculator$.MODULE$.indexSelectivityForSubstringSargable(substring, ExpressionSelectivityCalculator$.MODULE$.indexSelectivityForSubstringSargable$default$2());
            }
        }
        if (expression instanceof EndsWith) {
            Property property;
            Expression expression4;
            EndsWith endsWith = (EndsWith)expression;
            Expression expression5 = endsWith.lhs();
            Expression substring = endsWith.rhs();
            if (expression5 instanceof Property && (expression4 = (property = (Property)expression5).map()) instanceof Variable) {
                return ExpressionSelectivityCalculator$.MODULE$.indexSelectivityForSubstringSargable(substring, ExpressionSelectivityCalculator$.MODULE$.indexSelectivityForSubstringSargable$default$2());
            }
        }
        if (expression != null && !(option3 = AsDistanceSeekable$.MODULE$.unapply(expression)).isEmpty()) {
            return Selectivity$.MODULE$.apply(PlannerDefaults$.MODULE$.DEFAULT_RANGE_SEEK_FACTOR());
        }
        if (expression != null && !(option2 = AsBoundingBoxSeekable$.MODULE$.unapply(expression)).isEmpty()) {
            return Selectivity$.MODULE$.apply(PlannerDefaults$.MODULE$.DEFAULT_RANGE_SEEK_FACTOR());
        }
        if (expression != null && !(option = AsValueRangeSeekable$.MODULE$.unapply(expression)).isEmpty()) {
            InequalityRangeSeekable seekable = (InequalityRangeSeekable)option.get();
            return ExpressionSelectivityCalculator$.MODULE$.getPropertyPredicateRangeSelectivity(seekable, assumedUniqueSelectivityPerPredicate);
        }
        if (expression == null) return PlannerDefaults$.MODULE$.DEFAULT_PREDICATE_SELECTIVITY();
        Option<Scannable<Expression>> option6 = AsPropertyScannable$.MODULE$.unapply(expression);
        if (option6.isEmpty()) return PlannerDefaults$.MODULE$.DEFAULT_PREDICATE_SELECTIVITY();
        return Selectivity$.MODULE$.ONE();
    }

    public CompositeExpressionSelectivityCalculator apply(PlanContext planContext, boolean planningTextIndexesEnabled, boolean planningRangeIndexesEnabled, boolean planningPointIndexesEnabled) {
        return new CompositeExpressionSelectivityCalculator(planContext, planningTextIndexesEnabled, planningRangeIndexesEnabled, planningPointIndexesEnabled);
    }

    public Option<Tuple4<PlanContext, Object, Object, Object>> unapply(CompositeExpressionSelectivityCalculator x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.planContext(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.planningTextIndexesEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.planningRangeIndexesEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.planningPointIndexesEnabled())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CompositeExpressionSelectivityCalculator$.class);
    }

    public static final /* synthetic */ Selectivity $anonfun$getPredicateSelectivity$1(SelectivityCombiner combiner$2, Selectivity assumedUniqueSelectivityPerPredicate$2, int size) {
        return (Selectivity)combiner$2.orTogetherSelectivities((Iterable<Selectivity>)((Iterable)package$.MODULE$.Seq().fill(size, (Function0 & Serializable)() -> assumedUniqueSelectivityPerPredicate$2))).get();
    }

    private CompositeExpressionSelectivityCalculator$() {
    }
}

