/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryPlannerKit;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPQueryGraphSolver;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPQueryGraphSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.JoinDisconnectedQueryGraphComponents;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.SingleComponentPlannerTrait;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class IDPQueryGraphSolver$
implements Serializable {
    public static final IDPQueryGraphSolver$ MODULE$ = new IDPQueryGraphSolver$();
    private static final boolean VERBOSE = Boolean.getBoolean("pickBestPlan.VERBOSE");

    public boolean VERBOSE() {
        return VERBOSE;
    }

    public <Solvable> IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> composeSolverSteps(QueryGraph queryGraph, InterestingOrderConfig interestingOrderConfig, QueryPlannerKit kit, LogicalPlanningContext context, Seq<IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext>> generators) {
        Seq combinedSolverSteps = (Seq)generators.map((Function1 & Serializable)x$1 -> MODULE$.selectingAndSortingSolverStep(queryGraph, interestingOrderConfig, kit, context, (IDPSolverStep)x$1));
        return (IDPSolverStep)combinedSolverSteps.foldLeft(IDPSolverStep$.MODULE$.empty(), (Function2 & Serializable)(x$2, x$3) -> x$2.$plus$plus(x$3));
    }

    public <Solvable> IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> selectingAndSortingSolverStep(QueryGraph queryGraph, InterestingOrderConfig interestingOrderConfig, QueryPlannerKit kit, LogicalPlanningContext context, IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> solverStep2) {
        IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> iDPSolverStep;
        IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> selectingSolverStep = solverStep2.map((Function1<LogicalPlan, LogicalPlan>)(Function1 & Serializable)plan -> (LogicalPlan)kit.select().apply(plan, (Object)queryGraph));
        if (interestingOrderConfig.orderToSolve().isEmpty()) {
            iDPSolverStep = selectingSolverStep;
        } else {
            IDPSolverStep<Solvable, LogicalPlan, LogicalPlanningContext> sortingSolverStep = selectingSolverStep.flatMap((Function1<LogicalPlan, IterableOnce<LogicalPlan>>)(Function1 & Serializable)plan -> SortPlanner$.MODULE$.maybeSortedPlan((LogicalPlan)plan, interestingOrderConfig, context, true).filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)IDPQueryGraphSolver$.$anonfun$selectingAndSortingSolverStep$3(plan, x$4))));
            iDPSolverStep = selectingSolverStep.$plus$plus(sortingSolverStep);
        }
        return iDPSolverStep;
    }

    public ExtraRequirement<LogicalPlan> extraRequirementForInterestingOrder(LogicalPlanningContext context, InterestingOrderConfig interestingOrderConfig) {
        return interestingOrderConfig.orderToSolve().isEmpty() ? ExtraRequirement$.MODULE$.empty() : new ExtraRequirement<LogicalPlan>(interestingOrderConfig, context){
            private final InterestingOrderConfig interestingOrderConfig$3;
            private final LogicalPlanningContext context$3;

            public boolean fulfils(LogicalPlan plan) {
                SortPlanner.SatisfiedForPlan asSortedAsPossible = new SortPlanner.SatisfiedForPlan(plan);
                InterestingOrder.Satisfaction satisfaction = SortPlanner$.MODULE$.orderSatisfaction(this.interestingOrderConfig$3, this.context$3, plan);
                boolean bl = satisfaction != null && asSortedAsPossible.unapply(satisfaction);
                return bl;
            }
            {
                this.interestingOrderConfig$3 = interestingOrderConfig$3;
                this.context$3 = context$3;
            }
        };
    }

    public IDPQueryGraphSolver apply(SingleComponentPlannerTrait singleComponentSolver, JoinDisconnectedQueryGraphComponents componentConnector, IDPQueryGraphSolverMonitor monitor) {
        return new IDPQueryGraphSolver(singleComponentSolver, componentConnector, monitor);
    }

    public Option<Tuple2<SingleComponentPlannerTrait, JoinDisconnectedQueryGraphComponents>> unapply(IDPQueryGraphSolver x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.singleComponentSolver(), (Object)x$0.componentConnector()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IDPQueryGraphSolver$.class);
    }

    public static final /* synthetic */ boolean $anonfun$selectingAndSortingSolverStep$3(LogicalPlan plan$1, LogicalPlan x$4) {
        LogicalPlan logicalPlan = x$4;
        LogicalPlan logicalPlan2 = plan$1;
        return !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null);
    }

    private IDPQueryGraphSolver$() {
    }
}

