/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.idp;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.compiler.helpers.IteratorSupport$;
import org.neo4j.cypher.internal.compiler.planner.logical.ProjectingSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.BestResults;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.ExtraRequirement;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.Goal;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPCache;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolver$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverMonitor;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPSolverStep;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IDPTable;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.IdRegistry;
import org.neo4j.exceptions.InternalException;
import org.neo4j.time.Stopwatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001B\t\u0013\u0001\rB\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\")1\u000f\u0001C\u0001i\"1q\u0010\u0001C\u0001\u0003\u00039\u0011\"a\u000b\u0013\u0003\u0003E\t!!\f\u0007\u0011E\u0011\u0012\u0011!E\u0001\u0003_Aaa]\u0007\u0005\u0002\u0005E\u0002\"CA\u001a\u001bE\u0005I\u0011AA\u001b\u0011%\ti&DI\u0001\n\u0003\tyFA\u0005J\tB\u001bv\u000e\u001c<fe*\u00111\u0003F\u0001\u0004S\u0012\u0004(BA\u000b\u0017\u0003\u001dawnZ5dC2T!a\u0006\r\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011DG\u0001\tG>l\u0007/\u001b7fe*\u00111\u0004H\u0001\tS:$XM\u001d8bY*\u0011QDH\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005}\u0001\u0013!\u00028f_RR'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0016\t\u0011\u0012DhP\n\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0017!C4f]\u0016\u0014\u0018\r^8s!\u0015ic\u0006M\u001e?\u001b\u0005\u0011\u0012BA\u0018\u0013\u00055IE\tU*pYZ,'o\u0015;faB\u0011\u0011G\r\u0007\u0001\t\u0015\u0019\u0004A1\u00015\u0005!\u0019v\u000e\u001c<bE2,\u0017CA\u001b9!\t1c'\u0003\u00028O\t9aj\u001c;iS:<\u0007C\u0001\u0014:\u0013\tQtEA\u0002B]f\u0004\"!\r\u001f\u0005\u000bu\u0002!\u0019\u0001\u001b\u0003\rI+7/\u001e7u!\t\tt\bB\u0003A\u0001\t\u0007AGA\u0004D_:$X\r\u001f;\u0002%A\u0014xN[3di&twmU3mK\u000e$xN\u001d\t\u0004\u0007\u0012[T\"\u0001\u000b\n\u0005\u0015#\"A\u0005)s_*,7\r^5oON+G.Z2u_J\fqB]3hSN$(/\u001f$bGR|'/\u001f\t\u0004M!S\u0015BA%(\u0005%1UO\\2uS>t\u0007\u0007E\u0002.\u0017BJ!\u0001\u0014\n\u0003\u0015%#'+Z4jgR\u0014\u00180\u0001\u0007uC\ndWMR1di>\u0014\u0018\u0010E\u0003'\u001f*\u000b\u0006,\u0003\u0002QO\tIa)\u001e8di&|gN\r\t\u0005%V\u00034H\u0004\u0002.'&\u0011AKE\u0001\ba\u0006\u001c7.Y4f\u0013\t1vK\u0001\u0003TK\u0016$'B\u0001+\u0013!\ri\u0013lO\u0005\u00035J\u0011\u0001\"\u0013#Q)\u0006\u0014G.Z\u0001\r[\u0006DH+\u00192mKNK'0\u001a\t\u0003MuK!AX\u0014\u0003\u0007%sG/\u0001\fji\u0016\u0014\u0018\r^5p]\u0012+(/\u0019;j_:d\u0015.\\5u!\t1\u0013-\u0003\u0002cO\t!Aj\u001c8h\u0003A)\u0007\u0010\u001e:b%\u0016\fX/\u001b:f[\u0016tG\u000fE\u0002.KnJ!A\u001a\n\u0003!\u0015CHO]1SKF,\u0018N]3nK:$\u0018aB7p]&$xN\u001d\t\u0003[%L!A\u001b\n\u0003!%#\u0005kU8mm\u0016\u0014Xj\u001c8ji>\u0014\u0018\u0001E:u_B<\u0016\r^2i\r\u0006\u001cGo\u001c:z!\r1\u0003*\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003az\tA\u0001^5nK&\u0011!o\u001c\u0002\n'R|\u0007o^1uG\"\fa\u0001P5oSRtDCC;wobL(p\u001f?~}B)Q\u0006\u0001\u0019<}!)1F\u0003a\u0001Y!)\u0011I\u0003a\u0001\u0005\"9aI\u0003I\u0001\u0002\u00049\u0005bB'\u000b!\u0003\u0005\rA\u0014\u0005\u00067*\u0001\r\u0001\u0018\u0005\u0006?*\u0001\r\u0001\u0019\u0005\u0006G*\u0001\r\u0001\u001a\u0005\u0006O*\u0001\r\u0001\u001b\u0005\u0006W*\u0001\r\u0001\\\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003\u0007\tI!!\u0004\u0002(A!Q&!\u0002<\u0013\r\t9A\u0005\u0002\f\u0005\u0016\u001cHOU3tk2$8\u000f\u0003\u0004\u0002\f-\u0001\r!U\u0001\u0005g\u0016,G\rC\u0004\u0002\u0010-\u0001\r!!\u0005\u0002\u0017%t\u0017\u000e^5bYR{Gi\u001c\t\u0006\u0003'\t\t\u0003\r\b\u0005\u0003+\tyB\u0004\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYBI\u0001\u0007yI|w\u000e\u001e \n\u0003!J!\u0001V\u0014\n\t\u0005\r\u0012Q\u0005\u0002\u0004'\u0016\f(B\u0001+(\u0011\u0019\tIc\u0003a\u0001}\u000591m\u001c8uKb$\u0018!C%E!N{GN^3s!\tiSb\u0005\u0002\u000eKQ\u0011\u0011QF\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0011\u0005]\u0012QIA-\u00037*\"!!\u000f+\t\u0005m\u0012q\t\t\u0005M!\u000bi\u0004E\u0003.\u0003\u007f\t\u0019%C\u0002\u0002BI\u0011\u0011\u0003R3gCVdG/\u00133SK\u001eL7\u000f\u001e:z!\r\t\u0014Q\t\u0003\u0006g=\u0011\r\u0001N\u0016\u0003\u0003\u0013\u0002B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&A\u0005v]\u000eDWmY6fI*\u0019\u00111K\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u00055#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)Qh\u0004b\u0001i\u0011)\u0001i\u0004b\u0001i\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\u0002\"!\u0019\u0002l\u0005E\u0014QO\u000b\u0003\u0003GRC!!\u001a\u0002HAAaeTA4\u0003[\n\u0019\b\u0005\u0003.\u0017\u0006%\u0004cA\u0019\u0002l\u0011)1\u0007\u0005b\u0001iA1!+VA5\u0003_\u00022!MA9\t\u0015i\u0004C1\u00015!\u0011i\u0013,a\u001c\u0005\u000b\u0001\u0003\"\u0019\u0001\u001b")
public class IDPSolver<Solvable, Result, Context> {
    private final IDPSolverStep<Solvable, Result, Context> generator;
    private final ProjectingSelector<Result> projectingSelector;
    private final Function0<IdRegistry<Solvable>> registryFactory;
    private final Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> tableFactory;
    private final int maxTableSize;
    private final long iterationDurationLimit;
    private final ExtraRequirement<Result> extraRequirement;
    private final IDPSolverMonitor monitor;
    private final Function0<Stopwatch> stopWatchFactory;

    public static <Solvable, Result, Context> Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> $lessinit$greater$default$4() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <Solvable, Result, Context> Function0<DefaultIdRegistry<Solvable>> $lessinit$greater$default$3() {
        return IDPSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public BestResults<Result> apply(Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>> seed, Seq<Solvable> initialToDo, Context context) {
        BestResults<Object> bestResults;
        Object bestResult;
        IdRegistry registry = (IdRegistry)this.registryFactory.apply();
        ObjectRef toDo = ObjectRef.create((Object)new Goal(registry.registerAll(initialToDo)));
        IDPTable table = (IDPTable)this.tableFactory.apply((Object)registry, seed);
        int iterations = 0;
        while (((Goal)toDo.elem).size() > 1) {
            this.monitor.startIteration(++iterations);
            int largestFinished = this.generateBestCandidates$1(((Goal)toDo.elem).size(), toDo, table, registry, context);
            if (largestFinished <= 0) {
                throw new InternalException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Unfortunately, the planner was unable to find a plan within the constraints provided.\n           |Try increasing the config values `" + GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold.name() + "`\n           |and `" + GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold.name() + "` to allow\n           |for a larger sub-plan table and longer planning time.")));
            }
            Goal bestGoal = this.findBestCandidateInBlock$1(largestFinished, table);
            this.monitor.endIteration(iterations, largestFinished, table.size());
            IDPSolver.compactBlock$1(bestGoal, registry, table, toDo);
        }
        this.monitor.foundPlanAfter(iterations);
        Tuple2 tuple2 = table.plans().map((Function1 & Serializable)x0$1 -> {
            Object result;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    result = tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            boolean fulfilsReq = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)fulfilsReq), result);
            return tuple23;
        }).partition((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)IDPSolver.$anonfun$apply$15(x0$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator plansFulfillingReq = (Iterator)tuple2._1();
        Iterator plans = (Iterator)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)plansFulfillingReq, (Object)plans);
        Tuple2 tuple23 = tuple22;
        Iterator plansFulfillingReq2 = (Iterator)tuple23._1();
        Iterator plans2 = (Iterator)tuple23._2();
        Tuple2 tuple24 = (Tuple2)IteratorSupport$.MODULE$.RichIterator(plans2).toSingleOption().getOrElse((Function0 & Serializable)() -> {
            throw new InternalException("Expected a single plan to be left in the plan table");
        });
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Object object = bestResult = tuple24._2();
        Object bestResult2 = object;
        if (plansFulfillingReq2.hasNext()) {
            Object plan;
            Tuple2 tuple25 = (Tuple2)IteratorSupport$.MODULE$.RichIterator(plansFulfillingReq2).toSingleOption().getOrElse((Function0 & Serializable)() -> {
                throw new InternalException("Expected a single plan that fulfils the requirements to be left in the plan table");
            });
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            Object object2 = plan = tuple25._2();
            Object plan2 = object2;
            bestResults = new BestResults<Object>(bestResult2, (Option<Object>)new Some(plan2));
        } else {
            bestResults = new BestResults<Object>(bestResult2, (Option<Object>)None$.MODULE$);
        }
        return bestResults;
    }

    private final Function1 candidateSelector$1(Function0 resolved) {
        return (Function1 & Serializable)x$2 -> $this.projectingSelector.apply((Function1 & Serializable)x -> Predef$.MODULE$.identity(x), x$2, (Function0<String>)resolved);
    }

    private final Function1 goalSelector$1(Function0 resolved) {
        return (Function1 & Serializable)x$3 -> $this.projectingSelector.apply((Function1 & Serializable)x0$1 -> {
            Object result;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object object = result = tuple2._2();
            return object;
        }, x$3, (Function0<String>)resolved);
    }

    public static final /* synthetic */ void $anonfun$apply$8(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, false, candidate);
    }

    public static final /* synthetic */ void $anonfun$apply$9(BooleanRef foundNoCandidate$1, IDPTable table$1, Goal goal$1, Object candidate) {
        foundNoCandidate$1.elem = false;
        table$1.put(goal$1, true, candidate);
    }

    private final int generateBestCandidates$1(int maxBlockSize, ObjectRef toDo$1, IDPTable table$1, IdRegistry registry$1, Object context$1) {
        int largestFinishedIteration = 0;
        int blockSize = 1;
        boolean keepGoing = true;
        Stopwatch start = (Stopwatch)this.stopWatchFactory.apply();
        while (keepGoing && blockSize <= maxBlockSize) {
            BooleanRef foundNoCandidate = BooleanRef.create((boolean)true);
            Iterator<Goal> goals = ((Goal)toDo$1.elem).subGoals(++blockSize);
            while (keepGoing && goals.hasNext()) {
                Goal goal = (Goal)goals.next();
                if (table$1.contains(goal, false)) continue;
                Vector candidates = this.generator.apply(registry$1, goal, table$1, context$1).toVector();
                Tuple2 tuple2 = candidates.partition((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)this.extraRequirement.fulfils(result)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Iterable extraCandidates = (Iterable)tuple2._1();
                Iterable baseCandidates = (Iterable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)extraCandidates, (Object)baseCandidates);
                Tuple2 tuple23 = tuple22;
                Iterable extraCandidates2 = (Iterable)tuple23._1();
                Iterable baseCandidates2 = (Iterable)tuple23._2();
                Option bestExtraCandidate = (Option)this.candidateSelector$1((Function0 & Serializable)() -> "best sorted plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply((Object)extraCandidates2);
                ((Option)this.candidateSelector$1((Function0 & Serializable)() -> "best overall plan for " + goal.bitSet() + "@" + registry$1.explode(goal.bitSet())).apply(baseCandidates2.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(bestExtraCandidate).toIterable()))).foreach((Function1 & Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$8(foundNoCandidate, table$1, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                bestExtraCandidate.foreach((Function1 & Serializable)candidate -> {
                    IDPSolver.$anonfun$apply$9(foundNoCandidate, table$1, goal, candidate);
                    return BoxedUnit.UNIT;
                });
                keepGoing = blockSize == 2 || table$1.size() <= this.maxTableSize && !start.hasTimedOut(this.iterationDurationLimit, TimeUnit.MILLISECONDS);
            }
            largestFinishedIteration = foundNoCandidate.elem || goals.hasNext() ? largestFinishedIteration : blockSize;
        }
        return largestFinishedIteration;
    }

    public static final /* synthetic */ Nothing$ $anonfun$apply$11(int blockSize$1, Iterable blockCandidates$1, IDPTable table$1) {
        throw new InternalException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Found no solution for block with size " + blockSize$1 + ",\n             |" + blockCandidates$1 + " were the selected candidates from the table " + table$1)));
    }

    private final Goal findBestCandidateInBlock$1(int blockSize, IDPTable table$1) {
        Goal goal;
        Vector blockCandidates = table$1.unsortedPlansOfSize(blockSize).toVector();
        Option bestInBlock = (Option)this.goalSelector$1((Function0 & Serializable)() -> "Best candidate for block size " + blockSize).apply((Object)blockCandidates);
        Tuple2 tuple2 = (Tuple2)bestInBlock.getOrElse(() -> IDPSolver.$anonfun$apply$11(blockSize, (Iterable)blockCandidates, table$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Goal goal2 = goal = (Goal)tuple2._1();
        Goal goal3 = goal2;
        return goal3;
    }

    private static final void compactBlock$1(Goal original, IdRegistry registry$1, IDPTable table$1, ObjectRef toDo$1) {
        int newId = registry$1.compact(original.bitSet());
        IDPCache.Results results = table$1.apply(original);
        if (results == null) {
            throw new MatchError(results);
        }
        Option result = results.result();
        Option sortedResult = results.sortedResult();
        Tuple2 tuple2 = new Tuple2(result, sortedResult);
        Tuple2 tuple22 = tuple2;
        Option result2 = (Option)tuple22._1();
        Option sortedResult2 = (Option)tuple22._2();
        result2.foreach((Function1 & Serializable)x$6 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), false, x$6);
            return BoxedUnit.UNIT;
        });
        sortedResult2.foreach((Function1 & Serializable)x$7 -> {
            table$1.put(new Goal((BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)newId))), true, x$7);
            return BoxedUnit.UNIT;
        });
        toDo$1.elem = new Goal((BitSet)((Goal)toDo$1.elem).bitSet().$minus$minus((IterableOnce)original.bitSet()).$plus((Object)BoxesRunTime.boxToInteger((int)newId)));
        table$1.removeAllTracesOf(original);
    }

    public static final /* synthetic */ boolean $anonfun$apply$15(Tuple2 x0$2) {
        boolean fulfilsReq;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = fulfilsReq = tuple2._1$mcZ$sp();
        return bl;
    }

    public IDPSolver(IDPSolverStep<Solvable, Result, Context> generator, ProjectingSelector<Result> projectingSelector, Function0<IdRegistry<Solvable>> registryFactory, Function2<IdRegistry<Solvable>, Iterable<Tuple2<Tuple2<Set<Solvable>, Object>, Result>>, IDPTable<Result>> tableFactory, int maxTableSize, long iterationDurationLimit, ExtraRequirement<Result> extraRequirement, IDPSolverMonitor monitor, Function0<Stopwatch> stopWatchFactory) {
        this.generator = generator;
        this.projectingSelector = projectingSelector;
        this.registryFactory = registryFactory;
        this.tableFactory = tableFactory;
        this.maxTableSize = maxTableSize;
        this.iterationDurationLimit = iterationDurationLimit;
        this.extraRequirement = extraRequirement;
        this.monitor = monitor;
        this.stopWatchFactory = stopWatchFactory;
    }
}

