/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.projection$;
import org.neo4j.cypher.internal.expressions.CountStar;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.HasLabels;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.expressions.functions.Count$;
import org.neo4j.cypher.internal.expressions.functions.Function;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.PatternLength;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.Predicate;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryPagination;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.SimplePatternLength$;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class countStorePlanner$
implements Product,
Serializable {
    public static final countStorePlanner$ MODULE$ = new countStorePlanner$();

    static {
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Option<LogicalPlan> apply(SinglePlannerQuery query, LogicalPlanningContext context) {
        QueryHorizon queryHorizon = query.horizon();
        if (queryHorizon instanceof AggregatingQueryProjection) {
            AggregatingQueryProjection aggregatingQueryProjection = (AggregatingQueryProjection)queryHorizon;
            Map groupingKeys = aggregatingQueryProjection.groupingExpressions();
            Map aggregatingExpressions = aggregatingQueryProjection.aggregationExpressions();
            QueryPagination queryPagination = aggregatingQueryProjection.queryPagination();
            Selections selections = aggregatingQueryProjection.selections();
            if (groupingKeys.isEmpty() && query.queryInput().isEmpty() && aggregatingExpressions.size() == 1 && queryPagination.isEmpty()) {
                Tuple2 tuple2 = (Tuple2)aggregatingExpressions.head();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String columnName = (String)tuple2._1();
                Expression exp = (Expression)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)columnName, (Object)exp);
                String columnName2 = (String)tuple22._1();
                Expression exp2 = (Expression)tuple22._2();
                Option<LogicalPlan> countStorePlan = this.checkForValidQueryGraph(query, columnName2, exp2, context);
                return countStorePlan.map((Function1 & Serializable)plan -> {
                    LogicalPlan projectionPlan = projection$.MODULE$.apply((LogicalPlan)plan, (Map<String, Expression>)groupingKeys, (Option<Map<String, Expression>>)new Some((Object)groupingKeys), context);
                    return context.staticComponents().logicalPlanProducer().planHorizonSelection(projectionPlan, (Seq<Expression>)selections.flatPredicates(), InterestingOrderConfig$.MODULE$.empty(), context);
                });
            }
        }
        return None$.MODULE$;
    }

    private Option<LogicalPlan> checkForValidQueryGraph(SinglePlannerQuery query, String columnName, Expression exp, LogicalPlanningContext context) {
        QueryGraph queryGraph = query.queryGraph();
        if (queryGraph != null) {
            SeqOps seqOps;
            scala.collection.immutable.Set patternRelationships = queryGraph.patternRelationships();
            scala.collection.immutable.Set quantifiedPathPatterns = queryGraph.quantifiedPathPatterns();
            scala.collection.immutable.Set patternNodes = queryGraph.patternNodes();
            scala.collection.immutable.Set argumentIds = queryGraph.argumentIds();
            Selections selections = queryGraph.selections();
            IndexedSeq indexedSeq = queryGraph.optionalMatches();
            scala.collection.immutable.Set hints2 = queryGraph.hints();
            scala.collection.immutable.Set shortestRelationshipPatterns = queryGraph.shortestRelationshipPatterns();
            scala.collection.immutable.Set shortestPathPatterns = queryGraph.selectivePathPatterns();
            if (indexedSeq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)indexedSeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0 && hints2.isEmpty() && shortestRelationshipPatterns.isEmpty() && quantifiedPathPatterns.isEmpty() && query.queryGraph().readOnly() && countStorePlanner$.patternHasNoDependencies$1(query) && shortestPathPatterns.isEmpty()) {
                return this.checkForValidAggregations(query, columnName, exp, (scala.collection.immutable.Set<PatternRelationship>)patternRelationships, (scala.collection.immutable.Set<String>)patternNodes, (scala.collection.immutable.Set<String>)argumentIds, selections, context);
            }
        }
        return None$.MODULE$;
    }

    private Option<LogicalPlan> checkForValidAggregations(SinglePlannerQuery query, String columnName, Expression exp, scala.collection.immutable.Set<PatternRelationship> patternRelationships, scala.collection.immutable.Set<String> patternNodes, scala.collection.immutable.Set<String> argumentIds, Selections selections, LogicalPlanningContext context) {
        boolean bl = false;
        FunctionInvocation functionInvocation = null;
        Expression expression = exp;
        if (expression instanceof FunctionInvocation) {
            bl = true;
            functionInvocation = (FunctionInvocation)expression;
            boolean bl2 = functionInvocation.distinct();
            IndexedSeq indexedSeq = functionInvocation.args();
            if (!bl2 && indexedSeq instanceof Vector) {
                Expression expression2;
                Vector vector = (Vector)indexedSeq;
                SeqOps seqOps = package$.MODULE$.Vector().unapplySeq((SeqOps)vector);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (expression2 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Variable) {
                    Variable variable = (Variable)expression2;
                    String variableName = variable.name();
                    Function function = functionInvocation.function();
                    Count$ count$ = Count$.MODULE$;
                    if (!(function != null ? !function.equals(count$) : count$ != null)) {
                        return this.trySolveNodeOrRelationshipAggregation(query, columnName, (Option<String>)new Some((Object)variableName), patternRelationships, patternNodes, argumentIds, selections, context, this.trySolveNodeOrRelationshipAggregation$default$9());
                    }
                }
            }
        }
        if (expression instanceof CountStar) {
            return this.trySolveNodeOrRelationshipAggregation(query, columnName, (Option<String>)None$.MODULE$, patternRelationships, patternNodes, argumentIds, selections, context, this.trySolveNodeOrRelationshipAggregation$default$9());
        }
        if (bl) {
            boolean bl3 = functionInvocation.distinct();
            IndexedSeq indexedSeq = functionInvocation.args();
            if (!bl3 && indexedSeq instanceof Vector) {
                Expression expression3;
                Vector vector = (Vector)indexedSeq;
                SeqOps seqOps = package$.MODULE$.Vector().unapplySeq((SeqOps)vector);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (expression3 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Property) {
                    Property property = (Property)expression3;
                    Expression expression4 = property.map();
                    PropertyKeyName propKeyName = property.propertyKey();
                    if (expression4 instanceof Variable) {
                        Variable variable = (Variable)expression4;
                        String variableName = variable.name();
                        Function function = functionInvocation.function();
                        Count$ count$ = Count$.MODULE$;
                        if (!(function != null ? !function.equals(count$) : count$ != null)) {
                            return this.trySolveNodeOrRelationshipAggregation(query, columnName, (Option<String>)new Some((Object)variableName), patternRelationships, patternNodes, argumentIds, selections, context, (Option<PropertyKeyName>)new Some((Object)propKeyName));
                        }
                    }
                }
            }
        }
        return None$.MODULE$;
    }

    private Option<LogicalPlan> trySolveNodeOrRelationshipAggregation(SinglePlannerQuery query, String columnName, Option<String> variableName, scala.collection.immutable.Set<PatternRelationship> patternRelationships, scala.collection.immutable.Set<String> patternNodes, scala.collection.immutable.Set<String> argumentIds, Selections selections, LogicalPlanningContext context, Option<PropertyKeyName> propertyKeyName) {
        if (patternRelationships.isEmpty() && patternNodes.nonEmpty() && variableName.forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)patternNodes.contains((Object)elem))) && this.noWrongPredicates(patternNodes, selections)) {
            if (this.couldPlanCountStoreLookupOnAllLabels(variableName, selections, propertyKeyName, context)) {
                List allLabels = patternNodes.toList().map((Function1 & Serializable)n -> MODULE$.findLabel((String)n, selections));
                return new Some((Object)context.staticComponents().logicalPlanProducer().planCountStoreNodeAggregation(query, columnName, (List<Option<LabelName>>)allLabels, argumentIds, context));
            }
            return None$.MODULE$;
        }
        if (patternRelationships.size() == 1 && this.notLoop((PatternRelationship)patternRelationships.head())) {
            Seq types = ((PatternRelationship)patternRelationships.head()).types();
            if (types.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)countStorePlanner$.MODULE$.relTypeImpliesProperty(x$3, (Option<PropertyKeyName>)propertyKeyName, context)))) {
                return this.trySolveRelationshipAggregation(query, columnName, variableName, (PatternRelationship)patternRelationships.head(), argumentIds, selections, context);
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private Option<PropertyKeyName> trySolveNodeOrRelationshipAggregation$default$9() {
        return None$.MODULE$;
    }

    private boolean couldPlanCountStoreLookupOnAllLabels(Option<String> variableName, Selections selections, Option<PropertyKeyName> propertyKeyName, LogicalPlanningContext context) {
        return variableName.isEmpty() || propertyKeyName.isEmpty() || this.findLabel((String)variableName.get(), selections).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)countStorePlanner$.MODULE$.labelImpliesProperty(x$4, (Option<PropertyKeyName>)propertyKeyName, context)));
    }

    private boolean relTypeImpliesProperty(RelTypeName relTypeName, Option<PropertyKeyName> propertyKeyName, LogicalPlanningContext context) {
        return propertyKeyName.forall((Function1 & Serializable)prop -> BoxesRunTime.boxToBoolean((boolean)countStorePlanner$.$anonfun$relTypeImpliesProperty$1(context, relTypeName, prop)));
    }

    private boolean labelImpliesProperty(LabelName labelName, Option<PropertyKeyName> propertyKeyName, LogicalPlanningContext context) {
        return propertyKeyName.forall((Function1 & Serializable)prop -> BoxesRunTime.boxToBoolean((boolean)countStorePlanner$.$anonfun$labelImpliesProperty$1(context, labelName, prop)));
    }

    private boolean notLoop(PatternRelationship r) {
        String string = r.left();
        String string2 = r.right();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private Option<LogicalPlan> trySolveRelationshipAggregation(SinglePlannerQuery query, String columnName, Option<String> variableName, PatternRelationship patternRelationship, scala.collection.immutable.Set<String> argumentIds, Selections selections, LogicalPlanningContext context) {
        PatternRelationship patternRelationship2 = patternRelationship;
        if (patternRelationship2 != null) {
            String relId = patternRelationship2.name();
            Tuple2 tuple2 = patternRelationship2.boundaryNodes();
            SemanticDirection direction = patternRelationship2.dir();
            Seq types = patternRelationship2.types();
            PatternLength patternLength = patternRelationship2.length();
            if (tuple2 != null) {
                String startNodeId = (String)tuple2._1();
                String endNodeId = (String)tuple2._2();
                if (SimplePatternLength$.MODULE$.equals(patternLength) && variableName.forall((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)countStorePlanner$.$anonfun$trySolveRelationshipAggregation$1(relId, startNodeId, endNodeId, name))) && this.noWrongPredicates((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{startNodeId, endNodeId}))), selections)) {
                    Tuple3 tuple3 = new Tuple3(this.findLabel(startNodeId, selections), (Object)direction, this.findLabel(endNodeId, selections));
                    if (tuple3 != null) {
                        Option option = (Option)tuple3._1();
                        SemanticDirection semanticDirection = (SemanticDirection)tuple3._2();
                        Option option2 = (Option)tuple3._3();
                        if (None$.MODULE$.equals(option) && SemanticDirection.OUTGOING$.MODULE$.equals(semanticDirection) && None$.MODULE$.equals(option2)) {
                            return countStorePlanner$.planRelAggr$1((Option)None$.MODULE$, (Option)None$.MODULE$, context, query, columnName, types, argumentIds);
                        }
                    }
                    if (tuple3 != null) {
                        Option option = (Option)tuple3._1();
                        SemanticDirection semanticDirection = (SemanticDirection)tuple3._2();
                        Option option3 = (Option)tuple3._3();
                        if (None$.MODULE$.equals(option) && SemanticDirection.INCOMING$.MODULE$.equals(semanticDirection) && None$.MODULE$.equals(option3)) {
                            return countStorePlanner$.planRelAggr$1((Option)None$.MODULE$, (Option)None$.MODULE$, context, query, columnName, types, argumentIds);
                        }
                    }
                    if (tuple3 != null) {
                        Option option = (Option)tuple3._1();
                        SemanticDirection semanticDirection = (SemanticDirection)tuple3._2();
                        Option endLabel = (Option)tuple3._3();
                        if (None$.MODULE$.equals(option) && SemanticDirection.OUTGOING$.MODULE$.equals(semanticDirection)) {
                            return countStorePlanner$.planRelAggr$1((Option)None$.MODULE$, endLabel, context, query, columnName, types, argumentIds);
                        }
                    }
                    if (tuple3 != null) {
                        Option startLabel = (Option)tuple3._1();
                        SemanticDirection semanticDirection = (SemanticDirection)tuple3._2();
                        Option option = (Option)tuple3._3();
                        if (SemanticDirection.OUTGOING$.MODULE$.equals(semanticDirection) && None$.MODULE$.equals(option)) {
                            return countStorePlanner$.planRelAggr$1(startLabel, (Option)None$.MODULE$, context, query, columnName, types, argumentIds);
                        }
                    }
                    if (tuple3 != null) {
                        Option option = (Option)tuple3._1();
                        SemanticDirection semanticDirection = (SemanticDirection)tuple3._2();
                        Option endLabel = (Option)tuple3._3();
                        if (None$.MODULE$.equals(option) && SemanticDirection.INCOMING$.MODULE$.equals(semanticDirection)) {
                            return countStorePlanner$.planRelAggr$1(endLabel, (Option)None$.MODULE$, context, query, columnName, types, argumentIds);
                        }
                    }
                    if (tuple3 != null) {
                        Option startLabel = (Option)tuple3._1();
                        SemanticDirection semanticDirection = (SemanticDirection)tuple3._2();
                        Option option = (Option)tuple3._3();
                        if (SemanticDirection.INCOMING$.MODULE$.equals(semanticDirection) && None$.MODULE$.equals(option)) {
                            return countStorePlanner$.planRelAggr$1((Option)None$.MODULE$, startLabel, context, query, columnName, types, argumentIds);
                        }
                    }
                    return None$.MODULE$;
                }
            }
        }
        return None$.MODULE$;
    }

    private boolean noWrongPredicates(scala.collection.immutable.Set<String> nodeIds, Selections selections) {
        Tuple2 tuple2 = selections.predicates().partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)countStorePlanner$.$anonfun$noWrongPredicates$1(nodeIds, x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set labelPredicates = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set other = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)labelPredicates, (Object)other);
        scala.collection.immutable.Set labelPredicates2 = (scala.collection.immutable.Set)tuple22._1();
        scala.collection.immutable.Set other2 = (scala.collection.immutable.Set)tuple22._2();
        Map groupedLabelPredicates = labelPredicates2.groupBy((Function1 & Serializable)x$6 -> (scala.collection.immutable.Set)x$6.dependencies().intersect((Set)nodeIds));
        return groupedLabelPredicates.values().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)countStorePlanner$.$anonfun$noWrongPredicates$4(x$7))) && other2.isEmpty();
    }

    private Option<LabelName> findLabel(String nodeId, Selections selections) {
        return selections.predicates().collectFirst((PartialFunction)new Serializable(nodeId){
            private static final long serialVersionUID = 0L;
            private final String nodeId$1;

            public final <A1 extends Predicate, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    scala.collection.immutable.Set nIds = A1.dependencies();
                    Expression h = A1.expr();
                    if (h instanceof HasLabels) {
                        HasLabels hasLabels = (HasLabels)h;
                        scala.collection.immutable.Set set = nIds;
                        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.nodeId$1}));
                        if (!(set != null ? !set.equals(object) : object != null) && hasLabels.labels().size() == 1) {
                            return (B1)hasLabels.labels().head();
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Predicate x1) {
                Predicate predicate = x1;
                if (predicate != null) {
                    scala.collection.immutable.Set nIds = predicate.dependencies();
                    Expression h = predicate.expr();
                    if (h instanceof HasLabels) {
                        HasLabels hasLabels = (HasLabels)h;
                        scala.collection.immutable.Set set = nIds;
                        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.nodeId$1}));
                        if (!(set != null ? !set.equals(object) : object != null) && hasLabels.labels().size() == 1) {
                            return true;
                        }
                    }
                }
                return false;
            }
            {
                this.nodeId$1 = nodeId$1;
            }
        });
    }

    public String productPrefix() {
        return "countStorePlanner";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof countStorePlanner$;
    }

    public int hashCode() {
        return 1544386656;
    }

    public String toString() {
        return "countStorePlanner";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(countStorePlanner$.class);
    }

    private static final boolean patternHasNoDependencies$1(SinglePlannerQuery query$1) {
        QueryGraph qg = query$1.queryGraph();
        return qg.patternNodes().$plus$plus((IterableOnce)qg.patternRelationships().map((Function1 & Serializable)x$2 -> x$2.name())).intersect((Set)qg.argumentIds()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$relTypeImpliesProperty$1(LogicalPlanningContext context$4, RelTypeName relTypeName$1, PropertyKeyName prop) {
        return context$4.staticComponents().planContext().hasRelationshipPropertyExistenceConstraint(relTypeName$1.name(), prop.name());
    }

    public static final /* synthetic */ boolean $anonfun$labelImpliesProperty$1(LogicalPlanningContext context$5, LabelName labelName$1, PropertyKeyName prop) {
        return context$5.staticComponents().planContext().hasNodePropertyExistenceConstraint(labelName$1.name(), prop.name());
    }

    public static final /* synthetic */ boolean $anonfun$trySolveRelationshipAggregation$1(String relId$1, String startNodeId$1, String endNodeId$1, String name) {
        return ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{relId$1, startNodeId$1, endNodeId$1}))).contains((Object)name);
    }

    private static final Option planRelAggr$1(Option fromLabel, Option toLabel, LogicalPlanningContext context$6, SinglePlannerQuery query$2, String columnName$1, Seq types$1, scala.collection.immutable.Set argumentIds$1) {
        return new Some((Object)context$6.staticComponents().logicalPlanProducer().planCountStoreRelationshipAggregation(query$2, columnName$1, (Option<LabelName>)fromLabel, (Seq<RelTypeName>)types$1, (Option<LabelName>)toLabel, (scala.collection.immutable.Set<String>)argumentIds$1, context$6));
    }

    public static final /* synthetic */ boolean $anonfun$noWrongPredicates$1(scala.collection.immutable.Set nodeIds$1, Predicate x0$1) {
        Predicate predicate = x0$1;
        if (predicate != null) {
            scala.collection.immutable.Set nIds = predicate.dependencies();
            Expression h = predicate.expr();
            if (h instanceof HasLabels) {
                HasLabels hasLabels = (HasLabels)h;
                if (nIds.forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)nodeIds$1.contains((Object)elem))) && hasLabels.labels().size() == 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$noWrongPredicates$4(scala.collection.immutable.Set x$7) {
        return x$7.size() == 1;
    }

    private countStorePlanner$() {
    }
}

