/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.CatalogName$;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.GraphSelection;
import org.neo4j.cypher.internal.ast.SingleQuery;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.Union;
import org.neo4j.cypher.internal.ast.UseGraph;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.compiler.phases.PlannerContext;
import org.neo4j.cypher.internal.compiler.planner.VerifyGraphTarget;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.frontend.phases.BaseContains;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.VisitorPhase;
import org.neo4j.cypher.internal.frontend.phases.factories.PlanPipelineTransformerFactory;
import org.neo4j.cypher.internal.util.StepSequencer;
import org.neo4j.cypher.internal.util.StepSequencer$DefaultPostCondition$completed$;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class VerifyGraphTarget$
implements VisitorPhase<PlannerContext, BaseState>,
StepSequencer.Step,
StepSequencer.DefaultPostCondition,
PlanPipelineTransformerFactory,
Product,
Serializable {
    public static final VerifyGraphTarget$ MODULE$ = new VerifyGraphTarget$();
    private static volatile StepSequencer$DefaultPostCondition$completed$ completed$module;

    static {
        Transformer.$init$((Transformer)MODULE$);
        Phase.$init$((Phase)MODULE$);
        VisitorPhase.$init$((VisitorPhase)MODULE$);
        StepSequencer.DefaultPostCondition.$init$((StepSequencer.DefaultPostCondition)MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Object process(Object from, BaseContext context) {
        return VisitorPhase.process$((VisitorPhase)this, (Object)from, (BaseContext)context);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends PlannerContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions) {
        return Transformer.checkConditions$((Transformer)this, (Object)state, conditions);
    }

    public StepSequencer$DefaultPostCondition$completed$ completed() {
        if (completed$module == null) {
            this.completed$lzycompute$1();
        }
        return completed$module;
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING;
    }

    public void visit(BaseState value, PlannerContext context) {
        this.verifyGraphTarget(context.databaseReferenceRepository(), value.statement(), context.databaseId());
    }

    public Set<StepSequencer.Condition> preConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{new BaseContains(ClassTag$.MODULE$.apply(Statement.class)), new BaseContains(ClassTag$.MODULE$.apply(SemanticState.class))}));
    }

    public Set<StepSequencer.Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StepSequencer.Condition[]{this.completed()}));
    }

    public Set<StepSequencer.Condition> invalidatedConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    public VisitorPhase<PlannerContext, BaseState> getTransformer(boolean pushdownPropertyReads, Seq<SemanticFeature> semanticFeatures) {
        return this;
    }

    private void verifyGraphTarget(DatabaseReferenceRepository databaseReferenceRepository, Statement statement, NamedDatabaseId databaseId) {
        Option<VerifyGraphTarget.GraphNameWithContext> option = this.evaluateGraphSelection(statement);
        if (option instanceof Some) {
            Some some;
            DatabaseReferenceImpl.Internal databaseReference;
            Some some2 = (Some)option;
            VerifyGraphTarget.GraphNameWithContext graphNameWithContext = (VerifyGraphTarget.GraphNameWithContext)some2.value();
            Option option2 = OptionConverters$.MODULE$.toScala(databaseReferenceRepository.getInternalByAlias(new NormalizedDatabaseName(graphNameWithContext.graphName().qualifiedNameString())));
            if (None$.MODULE$.equals(option2)) {
                throw new DatabaseNotFoundException("Database " + graphNameWithContext.graphName().qualifiedNameString() + " not found");
            }
            if (option2 instanceof Some && !(databaseReference = (DatabaseReferenceImpl.Internal)(some = (Some)option2).value()).databaseId().equals((Object)databaseId)) {
                boolean bl;
                boolean bl2;
                VerifyGraphTarget.GraphNameWithContext graphNameWithContext2 = graphNameWithContext;
                if (graphNameWithContext2 != null && (bl2 = graphNameWithContext2.combinedWithAmbientGraph())) {
                    throw new InvalidSemanticsException("Using multiple graphs in the same query is not supported on standard databases. This capability is supported on composite databases only.");
                }
                if (graphNameWithContext2 != null && !(bl = graphNameWithContext2.combinedWithAmbientGraph())) {
                    throw new InvalidSemanticsException("Query routing is not available in embedded sessions. Try running the query using a Neo4j driver or the HTTP API.");
                }
                throw new MatchError((Object)graphNameWithContext2);
            }
            return;
        }
    }

    private Option<VerifyGraphTarget.GraphNameWithContext> evaluateGraphSelection(Statement statement) {
        return this.findGraphSelection(statement).map((Function1 & Serializable)graphSelection -> MODULE$.evaluateGraphSelection((VerifyGraphTarget.PositionalGraphSelection)graphSelection));
    }

    private Option<VerifyGraphTarget.PositionalGraphSelection> findGraphSelection(Statement statement) {
        Option<GraphSelection> option = this.leadingGraphSelection(statement);
        if (option instanceof Some) {
            Some some = (Some)option;
            GraphSelection graphSelection = (GraphSelection)some.value();
            return new Some((Object)new VerifyGraphTarget.PositionalGraphSelection(graphSelection, true));
        }
        if (None$.MODULE$.equals(option)) {
            Option option2 = statement.folder().treeFindByClass(ClassTag$.MODULE$.apply(UseGraph.class));
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                UseGraph graphSelection = (UseGraph)some.value();
                return new Some((Object)new VerifyGraphTarget.PositionalGraphSelection((GraphSelection)graphSelection, false));
            }
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    private VerifyGraphTarget.GraphNameWithContext evaluateGraphSelection(VerifyGraphTarget.PositionalGraphSelection graphSelection) {
        Expression expression = graphSelection.graphSelection().expression();
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            return new VerifyGraphTarget.GraphNameWithContext(this.nameFromVar(variable), !graphSelection.leading());
        }
        if (expression instanceof Property) {
            Property property = (Property)expression;
            return new VerifyGraphTarget.GraphNameWithContext(this.nameFromProp(property), !graphSelection.leading());
        }
        throw new InvalidSemanticsException("Expected static graph selection");
    }

    private CatalogName nameFromVar(Variable variable) {
        return CatalogName$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{variable.name()}));
    }

    private CatalogName nameFromProp(Property property) {
        return new CatalogName(VerifyGraphTarget$.parts$1((Expression)property));
    }

    private Option<SingleQuery> leftmostSingleQuery(Statement statement) {
        while (true) {
            Statement statement2;
            if ((statement2 = statement) instanceof SingleQuery) {
                SingleQuery singleQuery = (SingleQuery)statement2;
                return new Some((Object)singleQuery);
            }
            if (!(statement2 instanceof Union)) break;
            Union union = (Union)statement2;
            statement = union.lhs();
        }
        return None$.MODULE$;
    }

    private Option<GraphSelection> leadingGraphSelection(Statement statement) {
        Option<SingleQuery> singleQuery = this.leftmostSingleQuery(statement);
        Option clause = singleQuery.flatMap((Function1 & Serializable)x$1 -> x$1.clauses().headOption());
        return clause.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Clause, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof GraphSelection) {
                    GraphSelection graphSelection = (GraphSelection)A1;
                    return (B1)graphSelection;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Clause x1) {
                Clause clause = x1;
                return clause instanceof GraphSelection;
            }
        });
    }

    public String productPrefix() {
        return "VerifyGraphTarget";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof VerifyGraphTarget$;
    }

    public int hashCode() {
        return 829748774;
    }

    public String toString() {
        return "VerifyGraphTarget";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(VerifyGraphTarget$.class);
    }

    private final void completed$lzycompute$1() {
        VerifyGraphTarget$ verifyGraphTarget$ = this;
        synchronized (verifyGraphTarget$) {
            if (completed$module == null) {
                completed$module = new StepSequencer$DefaultPostCondition$completed$((StepSequencer.DefaultPostCondition)this);
            }
        }
    }

    private static final List parts$1(Expression expr) {
        Expression expression = expr;
        if (expression instanceof Property) {
            Property property = (Property)expression;
            return (List)VerifyGraphTarget$.parts$1(property.map()).$colon$plus((Object)property.propertyKey().name());
        }
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            String name = variable.name();
            return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        }
        throw new InvalidSemanticsException("Expected graph name segment");
    }

    private VerifyGraphTarget$() {
    }
}

