/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.UnresolvedCall;
import org.neo4j.cypher.internal.compiler.DeprecatedProcedureNotification;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignature;
import org.neo4j.cypher.internal.frontend.phases.QualifiedName;
import org.neo4j.cypher.internal.frontend.phases.ResolvedCall;
import org.neo4j.cypher.internal.frontend.phases.ResolvedFunctionInvocation;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.UserFunctionSignature;
import org.neo4j.cypher.internal.frontend.phases.VisitorPhase;
import org.neo4j.cypher.internal.util.DeprecatedFunctionNotification;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.StepSequencer;
import org.neo4j.exceptions.InternalException;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ProcedureAndFunctionDeprecationWarnings$
implements VisitorPhase<BaseContext, BaseState>,
Product,
Serializable {
    public static final ProcedureAndFunctionDeprecationWarnings$ MODULE$ = new ProcedureAndFunctionDeprecationWarnings$();

    static {
        Transformer.$init$((Transformer)MODULE$);
        Phase.$init$((Phase)MODULE$);
        VisitorPhase.$init$((VisitorPhase)MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Object process(Object from, BaseContext context) {
        return VisitorPhase.process$((VisitorPhase)this, (Object)from, (BaseContext)context);
    }

    public Set<StepSequencer.Condition> postConditions() {
        return VisitorPhase.postConditions$((VisitorPhase)this);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions) {
        return Transformer.checkConditions$((Transformer)this, (Object)state, conditions);
    }

    public void visit(BaseState value, BaseContext context) {
        Set<InternalNotification> warnings = this.findDeprecations(value.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1 & Serializable)notification -> {
            internalNotificationLogger.log(notification);
            return BoxedUnit.UNIT;
        });
    }

    private Set<InternalNotification> findDeprecations(Statement statement) {
        return (Set)statement.folder().treeFold((Object)Predef$.MODULE$.Set().empty(), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Some some;
                UserFunctionSignature userFunctionSignature;
                ResolvedFunctionInvocation resolvedFunctionInvocation;
                Option option;
                ResolvedCall resolvedCall;
                ProcedureSignature procedureSignature;
                A1 A1 = x1;
                if (A1 instanceof ResolvedCall && (procedureSignature = (resolvedCall = (ResolvedCall)A1).signature()) != null) {
                    QualifiedName name = procedureSignature.name();
                    Option option2 = procedureSignature.deprecationInfo();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        String deprecatedBy = (String)some2.value();
                        return (B1)(Function1 & Serializable)seq -> new Foldable.SkipChildren((Object)seq.$plus((Object)new DeprecatedProcedureNotification(resolvedCall.position(), name.toString(), deprecatedBy)));
                    }
                }
                if (A1 instanceof ResolvedFunctionInvocation && (option = (resolvedFunctionInvocation = (ResolvedFunctionInvocation)A1).fcnSignature()) instanceof Some && (userFunctionSignature = (UserFunctionSignature)(some = (Some)option).value()) != null) {
                    QualifiedName name = userFunctionSignature.name();
                    Option option3 = userFunctionSignature.deprecationInfo();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        String deprecatedBy = (String)some3.value();
                        return (B1)(Function1 & Serializable)seq -> new Foldable.SkipChildren((Object)seq.$plus((Object)new DeprecatedFunctionNotification(resolvedFunctionInvocation.position(), name.toString(), deprecatedBy)));
                    }
                }
                if (A1 instanceof UnresolvedCall) {
                    throw new InternalException("Expected procedures to have been resolved already");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Option option;
                Some some;
                UserFunctionSignature userFunctionSignature;
                ResolvedFunctionInvocation resolvedFunctionInvocation;
                Option option2;
                Option option3;
                ResolvedCall resolvedCall;
                ProcedureSignature procedureSignature;
                Object object = x1;
                if (object instanceof ResolvedCall && (procedureSignature = (resolvedCall = (ResolvedCall)object).signature()) != null && (option3 = procedureSignature.deprecationInfo()) instanceof Some) {
                    return true;
                }
                if (object instanceof ResolvedFunctionInvocation && (option2 = (resolvedFunctionInvocation = (ResolvedFunctionInvocation)object).fcnSignature()) instanceof Some && (userFunctionSignature = (UserFunctionSignature)(some = (Some)option2).value()) != null && (option = userFunctionSignature.deprecationInfo()) instanceof Some) {
                    return true;
                }
                return object instanceof UnresolvedCall;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.frontend.phases.ResolvedCall org.neo4j.cypher.internal.frontend.phases.QualifiedName java.lang.String scala.collection.immutable.Set ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.frontend.phases.ResolvedFunctionInvocation org.neo4j.cypher.internal.frontend.phases.QualifiedName java.lang.String scala.collection.immutable.Set )}, serializedLambda);
            }
        });
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    public String productPrefix() {
        return "ProcedureAndFunctionDeprecationWarnings";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcedureAndFunctionDeprecationWarnings$;
    }

    public int hashCode() {
        return 1948933679;
    }

    public String toString() {
        return "ProcedureAndFunctionDeprecationWarnings";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProcedureAndFunctionDeprecationWarnings$.class);
    }

    private ProcedureAndFunctionDeprecationWarnings$() {
    }
}

