/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps.index;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.planner.logical.LeafPlanRestrictions;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.EntityIndexLeafPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.EntityIndexLeafPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProvider;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.IndexCompatiblePredicatesProviderContext;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.NodeIndexLeafPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.NodeIndexPlanProvider;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.HasLabels;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.ordering.NoProvidedOrderFactory$;
import org.neo4j.cypher.internal.ir.ordering.ProvidedOrderFactory;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class NodeIndexLeafPlanner$
implements IndexCompatiblePredicatesProvider,
Serializable {
    public static final NodeIndexLeafPlanner$ MODULE$ = new NodeIndexLeafPlanner$();

    static {
        IndexCompatiblePredicatesProvider.$init$(MODULE$);
    }

    @Override
    public Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> findIndexCompatiblePredicates(Set<Expression> predicates, Set<LogicalVariable> arguments, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext) {
        return IndexCompatiblePredicatesProvider.findIndexCompatiblePredicates$(this, predicates, arguments, semanticTable, planContext, indexPredicateProviderContext);
    }

    public Set<NodeIndexLeafPlanner.NodeIndexMatch> findIndexMatchesForQueryGraph(QueryGraph qg, SemanticTable semanticTable, PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, InterestingOrderConfig interestingOrderConfig, ProvidedOrderFactory providedOrderFactory, boolean findTextIndexes, boolean findRangeIndexes, boolean findPointIndexes) {
        Set predicates = qg.selections().flatPredicates().toSet();
        Map allLabelPredicatesMap = qg.selections().labelPredicates();
        if (allLabelPredicatesMap.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> compatiblePropertyPredicates = this.findIndexCompatiblePredicates((Set<Expression>)predicates, (Set<LogicalVariable>)qg.argumentIds(), semanticTable, planContext, indexPredicateProviderContext);
        Iterable matches = (Iterable)((IterableOps)compatiblePropertyPredicates.groupBy((Function1 & Serializable)x$1 -> x$1.variable()).map((Function1 & Serializable)propertyPredicates -> {
            LogicalVariable variable = (LogicalVariable)propertyPredicates._1();
            Set labelPredicates = (Set)allLabelPredicatesMap.getOrElse((Object)variable, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            return new Tuple3(propertyPredicates, (Object)variable, (Object)labelPredicates);
        })).flatMap((Function1 & Serializable)x$2 -> {
            Tuple3 tuple3 = x$2;
            if (tuple3 != null) {
                Tuple2 propertyPredicates = (Tuple2)tuple3._1();
                LogicalVariable variable = (LogicalVariable)tuple3._2();
                Set labelPredicates = (Set)tuple3._3();
                return (Set)MODULE$.findIndexMatches(variable, (Set<EntityIndexLeafPlanner.IndexCompatiblePredicate>)((Set)propertyPredicates._2()), (Set<HasLabels>)labelPredicates, interestingOrderConfig, semanticTable, planContext, providedOrderFactory, findTextIndexes, findRangeIndexes, findPointIndexes).map((Function1 & Serializable)indexMatch -> indexMatch);
            }
            throw new MatchError((Object)tuple3);
        });
        return matches.toSet();
    }

    private Set<NodeIndexLeafPlanner.NodeIndexMatch> findIndexMatches(LogicalVariable variable, Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> indexCompatiblePredicates, Set<HasLabels> labelPredicates, InterestingOrderConfig interestingOrderConfig, SemanticTable semanticTable, PlanContext planContext, ProvidedOrderFactory providedOrderFactory, boolean findTextIndexes, boolean findRangeIndexes, boolean findPointIndexes) {
        return (Set)labelPredicates.flatMap((Function1 & Serializable)labelPredicate -> (Seq)labelPredicate.labels().flatMap((Function1 & Serializable)labelName -> (Set)Option$.MODULE$.option2Iterable(semanticTable.id(labelName)).toSet().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)NodeIndexLeafPlanner$.$anonfun$findIndexMatches$3(check$ifrefutable$1))).flatMap((Function1 & Serializable)labelId -> MODULE$.indexDescriptorsForLabel((LabelId)labelId, planContext, findTextIndexes, findRangeIndexes, findPointIndexes).flatMap((Function1 & Serializable)indexDescriptor -> (Set)((IterableOps)EntityIndexLeafPlanner$.MODULE$.predicatesForIndex((IndexDescriptor)indexDescriptor, indexCompatiblePredicates, interestingOrderConfig, semanticTable, (Map<String, Seq<SchemaValueType>>)planContext.getNodePropertiesWithTypeConstraint(labelName.name()), providedOrderFactory).map((Function1 & Serializable)predicatesForIndex -> {
            NodeIndexLeafPlanner.NodeIndexMatch indexMatch = new NodeIndexLeafPlanner.NodeIndexMatch(variable, (HasLabels)labelPredicate, (LabelName)labelName, (LabelId)labelId, predicatesForIndex.predicatesInOrder(), predicatesForIndex.providedOrder(), predicatesForIndex.indexOrder(), (IndexDescriptor)indexDescriptor);
            return new Tuple2(predicatesForIndex, (Object)indexMatch);
        })).map((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                NodeIndexLeafPlanner.NodeIndexMatch indexMatch = (NodeIndexLeafPlanner.NodeIndexMatch)tuple2._2();
                return indexMatch;
            }
            throw new MatchError((Object)tuple2);
        })))));
    }

    public InterestingOrderConfig findIndexMatchesForQueryGraph$default$5() {
        return InterestingOrderConfig$.MODULE$.empty();
    }

    public ProvidedOrderFactory findIndexMatchesForQueryGraph$default$6() {
        return NoProvidedOrderFactory$.MODULE$;
    }

    public boolean findIndexMatchesForQueryGraph$default$7() {
        return true;
    }

    public boolean findIndexMatchesForQueryGraph$default$8() {
        return true;
    }

    public boolean findIndexMatchesForQueryGraph$default$9() {
        return true;
    }

    private Iterator<IndexDescriptor> indexDescriptorsForLabel(LabelId labelId, PlanContext planContext, boolean findTextIndexes, boolean findRangeIndexes, boolean findPointIndexes) {
        return (findRangeIndexes ? planContext.rangeIndexesGetForLabel(NameId$.MODULE$.toKernelEncode((NameId)labelId)) : package$.MODULE$.Iterator().empty()).$plus$plus((Function0 & Serializable)() -> {
            if (findTextIndexes) {
                return planContext.textIndexesGetForLabel(NameId$.MODULE$.toKernelEncode((NameId)labelId));
            }
            return package$.MODULE$.Iterator().empty();
        }).$plus$plus((Function0 & Serializable)() -> {
            if (findPointIndexes) {
                return planContext.pointIndexesGetForLabel(NameId$.MODULE$.toKernelEncode((NameId)labelId));
            }
            return package$.MODULE$.Iterator().empty();
        });
    }

    @Override
    public Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> implicitIndexCompatiblePredicates(PlanContext planContext, IndexCompatiblePredicatesProviderContext indexPredicateProviderContext, Set<Expression> predicates, Set<EntityIndexLeafPlanner.IndexCompatiblePredicate> explicitCompatiblePredicates, Function2<LogicalVariable, Set<LogicalVariable>, Object> valid) {
        return (Set)predicates.flatMap((Function1 & Serializable)x0$1 -> {
            Expression expression = x0$1;
            if (expression instanceof HasLabels) {
                Variable variable;
                HasLabels hasLabels = (HasLabels)expression;
                Expression variable2 = hasLabels.expression();
                Seq labels = hasLabels.labels();
                if (variable2 instanceof Variable && BoxesRunTime.unboxToBoolean((Object)valid.apply((Object)(variable = (Variable)variable2), (Object)Predef$.MODULE$.Set().empty()))) {
                    Set constrainedPropNames = indexPredicateProviderContext.outerPlanHasUpdates() || planContext.txStateHasChanges() ? Predef$.MODULE$.Set().empty() : planContext.getNodePropertiesWithExistenceConstraint(((LabelName)labels.head()).name());
                    return EntityIndexLeafPlanner$.MODULE$.implicitIsNotNullPredicates((LogicalVariable)variable, indexPredicateProviderContext.aggregatingProperties(), (Set<String>)constrainedPropNames, explicitCompatiblePredicates);
                }
            }
            return Predef$.MODULE$.Set().empty();
        });
    }

    public NodeIndexLeafPlanner apply(Seq<NodeIndexPlanProvider> planProviders, LeafPlanRestrictions restrictions) {
        return new NodeIndexLeafPlanner(planProviders, restrictions);
    }

    public Option<Tuple2<Seq<NodeIndexPlanProvider>, LeafPlanRestrictions>> unapply(NodeIndexLeafPlanner x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.planProviders(), (Object)x$0.restrictions()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NodeIndexLeafPlanner$.class);
    }

    public static final /* synthetic */ boolean $anonfun$findIndexMatches$3(LabelId check$ifrefutable$1) {
        LabelId labelId = check$ifrefutable$1;
        return labelId != null;
    }

    private NodeIndexLeafPlanner$() {
    }
}

