/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.helpers;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.helpers.PropertyAccessHelper;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.Variable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.package$;

public final class AggregationHelper$ {
    public static final AggregationHelper$ MODULE$ = new AggregationHelper$();

    private <T> T check(FunctionInvocation aggregationFunction, Function1<Expression, T> result, T otherResult) {
        Expression expression = (Expression)aggregationFunction.args().head();
        if (expression instanceof Property) {
            Property property = (Property)expression;
            return (T)result.apply((Object)property);
        }
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            return (T)result.apply((Object)variable);
        }
        return otherResult;
    }

    public <T> T checkMinOrMax(Expression aggregation2, Function1<Expression, T> minResult, Function1<Expression, T> maxResult, T otherResult) {
        Expression expression = aggregation2;
        if (expression instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)expression;
            String string = functionInvocation.name();
            switch (string == null ? 0 : string.hashCode()) {
                case 107876: {
                    if (!"max".equals(string)) break;
                    return this.check(functionInvocation, maxResult, otherResult);
                }
                case 108114: {
                    if (!"min".equals(string)) break;
                    return this.check(functionInvocation, minResult, otherResult);
                }
            }
            return otherResult;
        }
        return otherResult;
    }

    public Set<PropertyAccessHelper.PropertyAccess> extractProperties(Map<String, Expression> aggregationExpressions, Map<String, Expression> renamings) {
        return ((IterableOnceOps)aggregationExpressions.values().flatMap((Function1 & Serializable)x$1 -> MODULE$.extractPropertyForValue((Expression)x$1, renamings).map((Function1 & Serializable)x0$1 -> {
            Property property = x0$1;
            if (property != null) {
                Expression expression = property.map();
                PropertyKeyName propertyKeyName = property.propertyKey();
                if (expression instanceof Variable) {
                    Variable variable = (Variable)expression;
                    String varName = variable.name();
                    if (propertyKeyName != null) {
                        String propName = propertyKeyName.name();
                        return new PropertyAccessHelper.PropertyAccess(varName, propName);
                    }
                }
            }
            throw new IllegalStateException("expression must be a property value");
        }))).toSet();
    }

    public Option<Property> extractPropertyForValue(Expression expression, Map<String, Expression> renamings) {
        return this.inner$1(expression, renamings, (Option)None$.MODULE$);
    }

    private final Option inner$1(Expression expression, Map renamings, Option property) {
        block6: {
            Variable variable;
            while (true) {
                Property property2;
                Expression expression2;
                SeqOps seqOps;
                FunctionInvocation functionInvocation;
                IndexedSeq indexedSeq;
                Expression expression3;
                if ((expression3 = expression) instanceof FunctionInvocation && (indexedSeq = (functionInvocation = (FunctionInvocation)expression3).args()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)indexedSeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) >= 0) {
                    Expression expr = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    if (expr instanceof FunctionInvocation) {
                        return None$.MODULE$;
                    }
                    expression = expr;
                    continue;
                }
                if (expression3 instanceof Property && (expression2 = (property2 = (Property)expression3).map()) instanceof Variable) {
                    Variable variable2 = (Variable)expression2;
                    String varName = variable2.name();
                    if (renamings.contains((Object)varName)) {
                        Expression expression4 = (Expression)renamings.apply((Object)varName);
                        property = new Some((Object)property2);
                        expression = expression4;
                        continue;
                    }
                    return new Some((Object)property2);
                }
                if (!(expression3 instanceof Variable)) break block6;
                variable = (Variable)expression3;
                String varName = variable.name();
                if (!renamings.contains((Object)varName)) break;
                Object object = renamings.apply((Object)varName);
                Variable variable3 = variable;
                if (!(object == null ? variable3 != null : !object.equals(variable3))) break;
                Expression expression5 = (Expression)renamings.apply((Object)varName);
                expression = expression5;
            }
            if (property.nonEmpty()) {
                return new Some((Object)new Property((Expression)variable, ((Property)property.get()).propertyKey(), ((Property)property.get()).position()));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private AggregationHelper$() {
    }
}

