/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.CommandClause;
import org.neo4j.cypher.internal.ast.GraphReference;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.compiler.planner.logical.CandidateSelector;
import org.neo4j.cypher.internal.compiler.planner.logical.EagerAnalyzer;
import org.neo4j.cypher.internal.compiler.planner.logical.EagerAnalyzer$;
import org.neo4j.cypher.internal.compiler.planner.logical.EventHorizonPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.SortPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.idp.BestResults;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig;
import org.neo4j.cypher.internal.compiler.planner.logical.ordering.InterestingOrderConfig$;
import org.neo4j.cypher.internal.compiler.planner.logical.plannerQueryPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.aggregation$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.distinct$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.projection$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.skipAndLimit$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.ir.AbstractProcedureCallProjection;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.CallSubqueryHorizon;
import org.neo4j.cypher.internal.ir.CommandProjection;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.RunQueryAtProjection;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.ir.ast.IRExpression;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.logical.plans.CachedProperties;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.util.Foldable;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class PlanEventHorizon$
implements EventHorizonPlanner,
Product,
Serializable {
    public static final PlanEventHorizon$ MODULE$ = new PlanEventHorizon$();

    static {
        EventHorizonPlanner.$init$(MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public final BestResults<LogicalPlan> planHorizon(SinglePlannerQuery plannerQuery, BestResults<LogicalPlan> incomingPlans, Option<InterestingOrder> prevInterestingOrder, LogicalPlanningContext context) {
        return EventHorizonPlanner.planHorizon$(this, plannerQuery, incomingPlans, prevInterestingOrder, context);
    }

    @Override
    public BestResults<LogicalPlan> doPlanHorizon(SinglePlannerQuery plannerQuery, BestResults<LogicalPlan> incomingPlans, Option<InterestingOrder> prevInterestingOrder, LogicalPlanningContext context) {
        boolean tailHasRequiredOrder;
        CandidateSelector pickBest = context.plannerState().config().pickBestCandidate().apply(context);
        InterestingOrderConfig sortIfSelfRequiredConfig = InterestingOrderConfig$.MODULE$.apply(plannerQuery.interestingOrder());
        InterestingOrderConfig sortIfTailOrSelfRequiredConfig = InterestingOrderConfig$.MODULE$.interestingOrderForPart(plannerQuery, false, true);
        boolean currentPartHasRequiredOrder = plannerQuery.interestingOrder().requiredOrderCandidate().nonEmpty();
        InterestingOrderConfig interestingOrderConfig = sortIfSelfRequiredConfig;
        InterestingOrderConfig interestingOrderConfig2 = sortIfTailOrSelfRequiredConfig;
        boolean bl = (interestingOrderConfig == null ? interestingOrderConfig2 != null : !((Object)interestingOrderConfig).equals(interestingOrderConfig2)) ? true : (tailHasRequiredOrder = false);
        if (currentPartHasRequiredOrder) {
            LogicalPlan bestOverall = (LogicalPlan)pickBest.apply((Iterable)new .colon.colon((Object)this.planSortIfSelfRequired$1(plannerQuery, incomingPlans, prevInterestingOrder, context, sortIfSelfRequiredConfig), (List)Nil$.MODULE$).$plus$plus((IterableOnce)PlanEventHorizon$.maintainSort$1(incomingPlans, plannerQuery, prevInterestingOrder, context, sortIfTailOrSelfRequiredConfig)), (Function0<String>)(Function0 & Serializable)() -> "best overall plan with horizon").getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("Planner returned no best overall plan");
            });
            return new BestResults<LogicalPlan>(bestOverall, (Option<LogicalPlan>)None$.MODULE$);
        }
        if (tailHasRequiredOrder) {
            LogicalPlan bestOverall = this.planSortIfSelfRequired$1(plannerQuery, incomingPlans, prevInterestingOrder, context, sortIfSelfRequiredConfig);
            Option bestSorted = pickBest.apply((Iterable)new .colon.colon((Object)this.planSortIfTailOrSelfRequired$1(plannerQuery, incomingPlans, prevInterestingOrder, context, sortIfTailOrSelfRequiredConfig), (List)Nil$.MODULE$).$plus$plus((IterableOnce)PlanEventHorizon$.maintainSort$1(incomingPlans, plannerQuery, prevInterestingOrder, context, sortIfTailOrSelfRequiredConfig)), (Function0<String>)(Function0 & Serializable)() -> "best sorted plan with horizon");
            return new BestResults<LogicalPlan>(bestOverall, bestSorted);
        }
        LogicalPlan bestOverall = this.planSortIfSelfRequired$1(plannerQuery, incomingPlans, prevInterestingOrder, context, sortIfSelfRequiredConfig);
        return new BestResults<LogicalPlan>(bestOverall, (Option<LogicalPlan>)None$.MODULE$);
    }

    public LogicalPlan planHorizonForPlan(SinglePlannerQuery query, LogicalPlan plan, Option<InterestingOrder> previousInterestingOrder, LogicalPlanningContext context, InterestingOrderConfig interestingOrderConfig) {
        LogicalPlan logicalPlan;
        LogicalPlan selectedPlan = context.plannerState().config().applySelections().apply(plan, query.queryGraph(), interestingOrderConfig, context);
        boolean updateSolvedOrdering = query.interestingOrder().requiredOrderCandidate().nonEmpty();
        Function1 & Serializable planSort = (Function1 & Serializable)x$2 -> SortPlanner$.MODULE$.ensureSortedPlanWithSolved((LogicalPlan)x$2, interestingOrderConfig, context, updateSolvedOrdering);
        Function1 & Serializable planSkipAndLimit = (Function1 & Serializable)x$3 -> skipAndLimit$.MODULE$.apply((LogicalPlan)x$3, query, context);
        QueryHorizon queryHorizon = query.horizon();
        if (queryHorizon instanceof AggregatingQueryProjection) {
            AggregatingQueryProjection aggregatingQueryProjection = (AggregatingQueryProjection)queryHorizon;
            Function1 & Serializable planAggregation = (Function1 & Serializable)x$4 -> aggregation$.MODULE$.apply((LogicalPlan)x$4, aggregatingQueryProjection, interestingOrderConfig.orderToReport(), previousInterestingOrder, context);
            logicalPlan = (LogicalPlan)Function$.MODULE$.chain((Seq)new .colon.colon((Object)planAggregation, (List)new .colon.colon((Object)planSort, (List)new .colon.colon((Object)planSkipAndLimit, (List)new .colon.colon((Object)PlanEventHorizon$.planWhere$1(aggregatingQueryProjection.selections(), context, interestingOrderConfig), (List)Nil$.MODULE$))))).apply((Object)selectedPlan);
        } else if (queryHorizon instanceof RegularQueryProjection) {
            RegularQueryProjection regularQueryProjection = (RegularQueryProjection)queryHorizon;
            Function1 & Serializable projectSubqueryExpressions = (Function1 & Serializable)p -> {
                Map subqueryExpressionProjections = (Map)regularQueryProjection.projections().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PlanEventHorizon$.$anonfun$planHorizonForPlan$6(x$5)));
                return projection$.MODULE$.apply((LogicalPlan)p, (Map<LogicalVariable, Expression>)subqueryExpressionProjections, (Option<Map<LogicalVariable, Expression>>)new Some((Object)subqueryExpressionProjections), context);
            };
            Function1 & Serializable planProjection = (Function1 & Serializable)p -> {
                if (regularQueryProjection.projections().isEmpty() && query.tail().isEmpty()) {
                    if (context.plannerState().isInSubquery()) {
                        return p;
                    }
                    return context.staticComponents().logicalPlanProducer().planEmptyProjection((LogicalPlan)p, context);
                }
                return projection$.MODULE$.apply((LogicalPlan)p, (Map<LogicalVariable, Expression>)regularQueryProjection.projections(), (Option<Map<LogicalVariable, Expression>>)new Some((Object)regularQueryProjection.projections()), context);
            };
            logicalPlan = context.settings().executionModel().providedOrderPreserving() ? PlanEventHorizon$.sortFirstWithFallback$1(selectedPlan, interestingOrderConfig, context, planSort, planSkipAndLimit, planProjection, regularQueryProjection, projectSubqueryExpressions) : (LogicalPlan)PlanEventHorizon$.projectSubqueryExpressionsFirst$1(projectSubqueryExpressions, planSort, planSkipAndLimit, planProjection, regularQueryProjection, context, interestingOrderConfig).apply((Object)selectedPlan);
        } else if (queryHorizon instanceof DistinctQueryProjection) {
            DistinctQueryProjection distinctQueryProjection = (DistinctQueryProjection)queryHorizon;
            logicalPlan = (LogicalPlan)Function$.MODULE$.chain((Seq)new .colon.colon((Object)PlanEventHorizon$.planDistinct$1(distinctQueryProjection, context), (List)new .colon.colon((Object)planSort, (List)new .colon.colon((Object)planSkipAndLimit, (List)new .colon.colon((Object)PlanEventHorizon$.planWhere$1(distinctQueryProjection.selections(), context, interestingOrderConfig), (List)Nil$.MODULE$))))).apply((Object)selectedPlan);
        } else if (queryHorizon instanceof UnwindProjection) {
            UnwindProjection unwindProjection = (UnwindProjection)queryHorizon;
            LogicalVariable variable = unwindProjection.variable();
            Expression expression = unwindProjection.exp();
            LogicalPlan projected = context.staticComponents().logicalPlanProducer().planUnwind(selectedPlan, variable, expression, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof AbstractProcedureCallProjection) {
            AbstractProcedureCallProjection abstractProcedureCallProjection = (AbstractProcedureCallProjection)queryHorizon;
            LogicalPlan projected = context.staticComponents().logicalPlanProducer().planProcedureCall(plan, abstractProcedureCallProjection.call(), context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof LoadCSVProjection) {
            LoadCSVProjection loadCSVProjection = (LoadCSVProjection)queryHorizon;
            LogicalVariable variableName = loadCSVProjection.variable();
            Expression url = loadCSVProjection.url();
            CSVFormat format = loadCSVProjection.format();
            Option fieldTerminator = loadCSVProjection.fieldTerminator();
            LogicalPlan projected = context.staticComponents().logicalPlanProducer().planLoadCSV(plan, variableName, url, format, (Option<StringLiteral>)fieldTerminator, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof PassthroughAllHorizon) {
            LogicalPlan projected = context.staticComponents().logicalPlanProducer().planPassAll(plan, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof CallSubqueryHorizon) {
            CallSubqueryHorizon callSubqueryHorizon = (CallSubqueryHorizon)queryHorizon;
            PlannerQuery callSubquery = callSubqueryHorizon.callSubquery();
            boolean correlated = callSubqueryHorizon.correlated();
            boolean yielding = callSubqueryHorizon.yielding();
            Option inTransactionsParameters = callSubqueryHorizon.inTransactionsParameters();
            boolean optional = callSubqueryHorizon.optional();
            LogicalPlanningContext subqueryContext = correlated ? context.withModifiedPlannerState((Function1<LogicalPlanningContext.PlannerState, LogicalPlanningContext.PlannerState>)(Function1 & Serializable)x$7 -> x$7.forSubquery().withUpdatedLabelInfo(plan, context.staticComponents().planningAttributes().solveds()).withPreviouslyCachedProperties(((CachedProperties)context.staticComponents().planningAttributes().cachedPropertiesPerPlan().get(plan.id())).entries())) : context.withModifiedPlannerState((Function1<LogicalPlanningContext.PlannerState, LogicalPlanningContext.PlannerState>)(Function1 & Serializable)x$8 -> x$8.forSubquery().withPreviouslyCachedProperties(((CachedProperties)context.staticComponents().planningAttributes().cachedPropertiesPerPlan().get(plan.id())).entries()));
            LogicalPlan subPlan = plannerQueryPlanner$.MODULE$.plan(callSubquery, subqueryContext, plannerQueryPlanner$.MODULE$.plan$default$3());
            LogicalPlan finalSubPlan = optional ? context.staticComponents().logicalPlanProducer().planOptional(subPlan, (Set<LogicalVariable>)plan.availableSymbols(), subqueryContext) : subPlan;
            LogicalPlan projected = context.staticComponents().logicalPlanProducer().planSubquery(plan, finalSubPlan, context, correlated, yielding, (Option<SubqueryCall.InTransactionsParameters>)inTransactionsParameters, optional);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(projected, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof CommandProjection) {
            CommandProjection commandProjection = (CommandProjection)queryHorizon;
            CommandClause clause = commandProjection.clause();
            LogicalPlan commandPlan = context.staticComponents().logicalPlanProducer().planCommand(plan, clause, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(commandPlan, interestingOrderConfig, context, updateSolvedOrdering);
        } else if (queryHorizon instanceof RunQueryAtProjection) {
            RunQueryAtProjection runQueryAtProjection = (RunQueryAtProjection)queryHorizon;
            GraphReference graphReference = runQueryAtProjection.graphReference();
            String queryString = runQueryAtProjection.queryString();
            Set parameters = runQueryAtProjection.parameters();
            Map importsAsParameters = runQueryAtProjection.importsAsParameters();
            Set columns = runQueryAtProjection.columns();
            LogicalPlan runQueryAt = context.staticComponents().logicalPlanProducer().planRunQueryAt(plan, graphReference, queryString, (Set<Parameter>)parameters, (Map<Parameter, LogicalVariable>)importsAsParameters, (Set<LogicalVariable>)columns, context);
            logicalPlan = SortPlanner$.MODULE$.ensureSortedPlanWithSolved(runQueryAt, interestingOrderConfig, context, updateSolvedOrdering);
        } else {
            throw new MatchError((Object)queryHorizon);
        }
        LogicalPlan projectedPlan = logicalPlan;
        EagerAnalyzer eagerAnalyzer = EagerAnalyzer$.MODULE$.apply(context);
        return eagerAnalyzer.horizonEagerize(projectedPlan, query);
    }

    public String productPrefix() {
        return "PlanEventHorizon";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PlanEventHorizon$;
    }

    public int hashCode() {
        return -120284278;
    }

    public String toString() {
        return "PlanEventHorizon";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlanEventHorizon$.class);
    }

    private final LogicalPlan planSortIfSelfRequired$1(SinglePlannerQuery plannerQuery$1, BestResults incomingPlans$1, Option prevInterestingOrder$1, LogicalPlanningContext context$1, InterestingOrderConfig sortIfSelfRequiredConfig$1) {
        return this.planHorizonForPlan(plannerQuery$1, (LogicalPlan)incomingPlans$1.bestResult(), (Option<InterestingOrder>)prevInterestingOrder$1, context$1, sortIfSelfRequiredConfig$1);
    }

    private final LogicalPlan planSortIfTailOrSelfRequired$1(SinglePlannerQuery plannerQuery$1, BestResults incomingPlans$1, Option prevInterestingOrder$1, LogicalPlanningContext context$1, InterestingOrderConfig sortIfTailOrSelfRequiredConfig$1) {
        return this.planHorizonForPlan(plannerQuery$1, (LogicalPlan)incomingPlans$1.bestResult(), (Option<InterestingOrder>)prevInterestingOrder$1, context$1, sortIfTailOrSelfRequiredConfig$1);
    }

    private static final Option maintainSort$1(BestResults incomingPlans$1, SinglePlannerQuery plannerQuery$1, Option prevInterestingOrder$1, LogicalPlanningContext context$1, InterestingOrderConfig sortIfTailOrSelfRequiredConfig$1) {
        return incomingPlans$1.bestResultFulfillingReq().map((Function1 & Serializable)x$1 -> MODULE$.planHorizonForPlan(plannerQuery$1, (LogicalPlan)x$1, (Option<InterestingOrder>)prevInterestingOrder$1, context$1, sortIfTailOrSelfRequiredConfig$1));
    }

    private static final Function1 planWhere$1(Selections selections, LogicalPlanningContext context$2, InterestingOrderConfig interestingOrderConfig$1) {
        return (Function1 & Serializable)p -> {
            if (selections.isEmpty()) {
                return p;
            }
            scala.collection.immutable.Seq predicates = selections.flatPredicates();
            return context$2.staticComponents().logicalPlanProducer().planHorizonSelection((LogicalPlan)p, (scala.collection.immutable.Seq<Expression>)predicates, interestingOrderConfig$1, context$2);
        };
    }

    public static final /* synthetic */ boolean $anonfun$planHorizonForPlan$6(Tuple2 x$5) {
        return ((Foldable)x$5._2()).folder().treeFindByClass(ClassTag$.MODULE$.apply(IRExpression.class)).nonEmpty();
    }

    private static final Function1 sortFirst$1(Function1 planSort$1, Function1 planSkipAndLimit$1, Function1 planProjection$1, RegularQueryProjection x3$1, LogicalPlanningContext context$2, InterestingOrderConfig interestingOrderConfig$1) {
        return Function$.MODULE$.chain((Seq)new .colon.colon((Object)planSort$1, (List)new .colon.colon((Object)planSkipAndLimit$1, (List)new .colon.colon((Object)planProjection$1, (List)new .colon.colon((Object)PlanEventHorizon$.planWhere$1(x3$1.selections(), context$2, interestingOrderConfig$1), (List)Nil$.MODULE$)))));
    }

    private static final Function1 projectSubqueryExpressionsFirst$1(Function1 projectSubqueryExpressions$1, Function1 planSort$1, Function1 planSkipAndLimit$1, Function1 planProjection$1, RegularQueryProjection x3$1, LogicalPlanningContext context$2, InterestingOrderConfig interestingOrderConfig$1) {
        return Function$.MODULE$.chain((Seq)new .colon.colon((Object)projectSubqueryExpressions$1, (List)new .colon.colon((Object)PlanEventHorizon$.sortFirst$1(planSort$1, planSkipAndLimit$1, planProjection$1, x3$1, context$2, interestingOrderConfig$1), (List)Nil$.MODULE$)));
    }

    private static final LogicalPlan sortFirstWithFallback$1(LogicalPlan initialPlan, InterestingOrderConfig interestingOrderConfig$1, LogicalPlanningContext context$2, Function1 planSort$1, Function1 planSkipAndLimit$1, Function1 planProjection$1, RegularQueryProjection x3$1, Function1 projectSubqueryExpressions$1) {
        LogicalPlan sortedPlan = (LogicalPlan)PlanEventHorizon$.sortFirst$1(planSort$1, planSkipAndLimit$1, planProjection$1, x3$1, context$2, interestingOrderConfig$1).apply((Object)initialPlan);
        InterestingOrder.Satisfaction satisfaction = SortPlanner$.MODULE$.orderSatisfaction(interestingOrderConfig$1, context$2, sortedPlan);
        if (satisfaction != null && InterestingOrder.FullSatisfaction$.MODULE$.unapply(satisfaction)) {
            return sortedPlan;
        }
        return (LogicalPlan)PlanEventHorizon$.projectSubqueryExpressionsFirst$1(projectSubqueryExpressions$1, planSort$1, planSkipAndLimit$1, planProjection$1, x3$1, context$2, interestingOrderConfig$1).apply((Object)initialPlan);
    }

    private static final Function1 planDistinct$1(DistinctQueryProjection x4$1, LogicalPlanningContext context$2) {
        return (Function1 & Serializable)x$6 -> distinct$.MODULE$.apply((LogicalPlan)x$6, x4$1, context$2);
    }

    private PlanEventHorizon$() {
    }
}

