/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.cardinality.assumeIndependence;

import org.neo4j.cypher.internal.compiler.planner.logical.PlannerDefaults$;
import org.neo4j.cypher.internal.ir.VarPatternLength;
import org.neo4j.cypher.internal.util.Repetition;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.UpperBound;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Range;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class RepetitionCardinalityModel$ {
    public static final RepetitionCardinalityModel$ MODULE$ = new RepetitionCardinalityModel$();
    private static final int MAX_VAR_LENGTH = 32;

    public int MAX_VAR_LENGTH() {
        return MAX_VAR_LENGTH;
    }

    public Range varPatternLengthAsRange(VarPatternLength varPatternLength) {
        int n;
        Option option = varPatternLength.max();
        if (option instanceof Some) {
            Some some = (Some)option;
            int limit = BoxesRunTime.unboxToInt((Object)some.value());
            n = Math.min(limit, this.MAX_VAR_LENGTH());
        } else if (None$.MODULE$.equals(option)) {
            n = this.MAX_VAR_LENGTH();
        } else {
            throw new MatchError((Object)option);
        }
        int maximumBound = n;
        int minimumBound = Math.min(varPatternLength.min(), maximumBound);
        return package$.MODULE$.Range().inclusive(minimumBound, maximumBound);
    }

    public Range quantifiedPathPatternRepetitionAsRange(Repetition repetition) {
        int n;
        UpperBound upperBound = repetition.max();
        if (UpperBound.Unlimited$.MODULE$.equals(upperBound)) {
            n = this.MAX_VAR_LENGTH();
        } else if (upperBound instanceof UpperBound.Limited) {
            UpperBound.Limited limited = (UpperBound.Limited)upperBound;
            long limit = limited.n();
            n = limit < (long)this.MAX_VAR_LENGTH() ? (int)limit : this.MAX_VAR_LENGTH();
        } else {
            throw new MatchError((Object)upperBound);
        }
        int maximumBound = n;
        int minimumBound = (int)Math.min(repetition.min(), (long)maximumBound);
        return package$.MODULE$.Range().inclusive(minimumBound, maximumBound);
    }

    public Selectivity relationshipUniquenessSelectivity(int differentRelationships, int uniqueRelationships, int repetitions) {
        int differentRelationshipsPredicates = repetitions * repetitions * differentRelationships;
        int uniqueRelationshipsPredicates = repetitions * (repetitions - 1) / 2 * uniqueRelationships;
        return PlannerDefaults$.MODULE$.DEFAULT_REL_UNIQUENESS_SELECTIVITY().$up((double)(differentRelationshipsPredicates + uniqueRelationshipsPredicates));
    }

    private RepetitionCardinalityModel$() {
    }
}

