/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.AliasedReturnItem;
import org.neo4j.cypher.internal.ast.AscSortItem;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.CommandClause;
import org.neo4j.cypher.internal.ast.Create;
import org.neo4j.cypher.internal.ast.Delete;
import org.neo4j.cypher.internal.ast.DescSortItem;
import org.neo4j.cypher.internal.ast.Foreach;
import org.neo4j.cypher.internal.ast.InputDataStream;
import org.neo4j.cypher.internal.ast.LoadCSV;
import org.neo4j.cypher.internal.ast.Match;
import org.neo4j.cypher.internal.ast.Merge;
import org.neo4j.cypher.internal.ast.MergeAction;
import org.neo4j.cypher.internal.ast.OnCreate;
import org.neo4j.cypher.internal.ast.OnMatch;
import org.neo4j.cypher.internal.ast.OrderBy;
import org.neo4j.cypher.internal.ast.Query;
import org.neo4j.cypher.internal.ast.Remove;
import org.neo4j.cypher.internal.ast.RemoveItem;
import org.neo4j.cypher.internal.ast.RemoveLabelItem;
import org.neo4j.cypher.internal.ast.RemovePropertyItem;
import org.neo4j.cypher.internal.ast.Return;
import org.neo4j.cypher.internal.ast.ReturnItem;
import org.neo4j.cypher.internal.ast.ReturnItems;
import org.neo4j.cypher.internal.ast.SetClause;
import org.neo4j.cypher.internal.ast.SetExactPropertiesFromMapItem;
import org.neo4j.cypher.internal.ast.SetIncludingPropertiesFromMapItem;
import org.neo4j.cypher.internal.ast.SetItem;
import org.neo4j.cypher.internal.ast.SetLabelItem;
import org.neo4j.cypher.internal.ast.SetPropertyItem;
import org.neo4j.cypher.internal.ast.SetPropertyItems;
import org.neo4j.cypher.internal.ast.SortItem;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.ast.UnresolvedCall;
import org.neo4j.cypher.internal.ast.Unwind;
import org.neo4j.cypher.internal.ast.Where;
import org.neo4j.cypher.internal.ast.With;
import org.neo4j.cypher.internal.ast.Yield;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.PlannerQueryBuilder;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.StatementConverters$;
import org.neo4j.cypher.internal.compiler.helpers.AggregationHelper$;
import org.neo4j.cypher.internal.compiler.planner.ProcedureCallProjection;
import org.neo4j.cypher.internal.expressions.EveryPath;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.HasLabels;
import org.neo4j.cypher.internal.expressions.In;
import org.neo4j.cypher.internal.expressions.IsAggregate$;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.LogicalProperty;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.LogicalVariable$;
import org.neo4j.cypher.internal.expressions.MapExpression;
import org.neo4j.cypher.internal.expressions.NodePattern;
import org.neo4j.cypher.internal.expressions.Null;
import org.neo4j.cypher.internal.expressions.PatternElement;
import org.neo4j.cypher.internal.expressions.PatternPart;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.RelationshipChain;
import org.neo4j.cypher.internal.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.expressions.SimplePattern;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection$;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.CommandProjection;
import org.neo4j.cypher.internal.ir.CreateNode;
import org.neo4j.cypher.internal.ir.CreatePattern;
import org.neo4j.cypher.internal.ir.CreateRelationship;
import org.neo4j.cypher.internal.ir.DeleteExpression;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection$;
import org.neo4j.cypher.internal.ir.ForeachPattern;
import org.neo4j.cypher.internal.ir.HasHeaders$;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.MergeNodePattern;
import org.neo4j.cypher.internal.ir.MergeRelationshipPattern;
import org.neo4j.cypher.internal.ir.MutatingPattern;
import org.neo4j.cypher.internal.ir.NoHeaders$;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PatternLength;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryGraph$;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryPagination;
import org.neo4j.cypher.internal.ir.QueryPagination$;
import org.neo4j.cypher.internal.ir.QueryProjection;
import org.neo4j.cypher.internal.ir.QueryProjection$;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.RegularQueryProjection$;
import org.neo4j.cypher.internal.ir.RegularSinglePlannerQuery;
import org.neo4j.cypher.internal.ir.RegularSinglePlannerQuery$;
import org.neo4j.cypher.internal.ir.RemoveLabelPattern;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.Selections$;
import org.neo4j.cypher.internal.ir.SetLabelPattern;
import org.neo4j.cypher.internal.ir.SetMutatingPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertiesPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertyPattern;
import org.neo4j.cypher.internal.ir.SetPropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetPropertiesPattern;
import org.neo4j.cypher.internal.ir.SetPropertyPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertiesPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertyPattern;
import org.neo4j.cypher.internal.ir.SimplePatternLength$;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery$;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.ir.helpers.ExpressionConverters;
import org.neo4j.cypher.internal.ir.helpers.ExpressionConverters$;
import org.neo4j.cypher.internal.ir.helpers.PatternConverters;
import org.neo4j.cypher.internal.ir.helpers.PatternConverters$;
import org.neo4j.cypher.internal.ir.ordering.ColumnOrder;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrderCandidate;
import org.neo4j.cypher.internal.ir.ordering.RequiredOrderCandidate;
import org.neo4j.cypher.internal.label_expressions.LabelExpression;
import org.neo4j.cypher.internal.label_expressions.LabelExpressionLeafName;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.exceptions.InternalException;
import org.neo4j.exceptions.SyntaxException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class ClauseConverters$ {
    public static final ClauseConverters$ MODULE$ = new ClauseConverters$();

    public PlannerQueryBuilder addToLogicalPlanInput(PlannerQueryBuilder acc, Clause clause, Option<Clause> nextClause, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker, boolean nonTerminating) {
        Clause clause2 = clause;
        if (clause2 instanceof Return) {
            Return return_ = (Return)clause2;
            return this.addReturnToLogicalPlanInput(acc, return_, nonTerminating);
        }
        if (clause2 instanceof Match) {
            Match match = (Match)clause2;
            return this.addMatchToLogicalPlanInput(acc, match, anonymousVariableNameGenerator);
        }
        if (clause2 instanceof With) {
            With with = (With)clause2;
            return this.addWithToLogicalPlanInput(acc, with, nextClause);
        }
        if (clause2 instanceof Unwind) {
            Unwind unwind = (Unwind)clause2;
            return this.addUnwindToLogicalPlanInput(acc, unwind);
        }
        if (clause2 instanceof ResolvedCall) {
            ResolvedCall resolvedCall = (ResolvedCall)clause2;
            return this.addCallToLogicalPlanInput(acc, resolvedCall);
        }
        if (clause2 instanceof Create) {
            Create create = (Create)clause2;
            return this.addCreateToLogicalPlanInput(acc, create);
        }
        if (clause2 instanceof SetClause) {
            SetClause setClause = (SetClause)clause2;
            return this.addSetClauseToLogicalPlanInput(acc, setClause);
        }
        if (clause2 instanceof Delete) {
            Delete delete = (Delete)clause2;
            return this.addDeleteToLogicalPlanInput(acc, delete);
        }
        if (clause2 instanceof Remove) {
            Remove remove = (Remove)clause2;
            return this.addRemoveToLogicalPlanInput(acc, remove);
        }
        if (clause2 instanceof Merge) {
            Merge merge = (Merge)clause2;
            return this.addMergeToLogicalPlanInput(acc, merge);
        }
        if (clause2 instanceof LoadCSV) {
            LoadCSV loadCSV = (LoadCSV)clause2;
            return this.addLoadCSVToLogicalPlanInput(acc, loadCSV);
        }
        if (clause2 instanceof Foreach) {
            Foreach foreach = (Foreach)clause2;
            return this.addForeachToLogicalPlanInput(acc, foreach, anonymousVariableNameGenerator, cancellationChecker);
        }
        if (clause2 instanceof InputDataStream) {
            InputDataStream inputDataStream = (InputDataStream)clause2;
            return this.addInputDataStreamToLogicalPlanInput(acc, inputDataStream);
        }
        if (clause2 instanceof SubqueryCall) {
            SubqueryCall subqueryCall = (SubqueryCall)clause2;
            return this.addCallSubqueryToLogicalPlanInput(acc, subqueryCall, anonymousVariableNameGenerator, cancellationChecker);
        }
        if (clause2 instanceof CommandClause) {
            CommandClause commandClause = (CommandClause)clause2;
            return this.addCommandClauseToLogicalPlanInput(acc, commandClause);
        }
        if (clause2 instanceof Yield) {
            Yield yield = (Yield)clause2;
            return this.addYieldToLogicalPlanInput(acc, yield);
        }
        if (clause2 instanceof UnresolvedCall) {
            UnresolvedCall unresolvedCall = (UnresolvedCall)clause2;
            throw new IllegalArgumentException(unresolvedCall + " is not expected here");
        }
        throw new InternalException("Received an AST-clause that has no representation the QG: " + clause2);
    }

    private PlannerQueryBuilder addLoadCSVToLogicalPlanInput(PlannerQueryBuilder acc, LoadCSV clause) {
        return acc.withHorizon((QueryHorizon)new LoadCSVProjection(clause.variable().name(), clause.urlString(), (CSVFormat)(clause.withHeaders() ? HasHeaders$.MODULE$ : NoHeaders$.MODULE$), clause.fieldTerminator())).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addInputDataStreamToLogicalPlanInput(PlannerQueryBuilder acc, InputDataStream clause) {
        return acc.withQueryInput((Seq<String>)((Seq)clause.variables().map((Function1 & Serializable)x$1 -> x$1.name())));
    }

    private Selections asSelections(Option<Where> optWhere) {
        return Selections$.MODULE$.apply((scala.collection.immutable.Set)optWhere.map((Function1 & Serializable)x$2 -> ExpressionConverters.PredicateConverter$.MODULE$.asPredicates$extension(ExpressionConverters$.MODULE$.PredicateConverter(x$2.expression()))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty()));
    }

    private QueryProjection asQueryProjection(boolean distinct2, Seq<ReturnItem> items, boolean returningQueryProjection) {
        Seq seq;
        Seq groupingKeys;
        block7: {
            Tuple2 tuple2;
            block6: {
                tuple2 = items.partition((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)IsAggregate$.MODULE$.apply(item.expression())));
                if (tuple2 == null) break block6;
                Seq aggregatingItems = (Seq)tuple2._1();
                groupingKeys = (Seq)tuple2._2();
                if (aggregatingItems == null) break block6;
                seq = aggregatingItems;
                if (groupingKeys != null) break block7;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq2 = groupingKeys;
        Tuple2 tuple2 = new Tuple2((Object)seq, (Object)seq2);
        Seq aggregatingItems = (Seq)tuple2._1();
        Seq groupingKeys2 = (Seq)tuple2._2();
        Map projectionMap = ClauseConverters$.turnIntoMap$1(groupingKeys2);
        Map aggregationsMap = ClauseConverters$.turnIntoMap$1(aggregatingItems);
        if (projectionMap.values().exists((Function1 & Serializable)expr -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.MODULE$.containsAggregateOutsideOfAggregatingHorizon(expr)))) {
            throw new InternalException("Grouping keys contains aggregation. AST has not been rewritten?");
        }
        if (aggregationsMap.nonEmpty()) {
            Map x$1 = projectionMap;
            Map x$2 = aggregationsMap;
            boolean x$3 = returningQueryProjection;
            QueryPagination x$4 = AggregatingQueryProjection$.MODULE$.apply$default$3();
            Selections x$5 = AggregatingQueryProjection$.MODULE$.apply$default$4();
            return new AggregatingQueryProjection(x$1, x$2, x$4, x$5, x$3);
        }
        if (distinct2) {
            Map x$6 = projectionMap;
            boolean x$7 = returningQueryProjection;
            QueryPagination x$8 = DistinctQueryProjection$.MODULE$.apply$default$2();
            Selections x$9 = DistinctQueryProjection$.MODULE$.apply$default$3();
            return new DistinctQueryProjection(x$6, x$8, x$9, x$7);
        }
        Map x$10 = projectionMap;
        boolean x$11 = returningQueryProjection;
        QueryPagination x$12 = RegularQueryProjection$.MODULE$.apply$default$2();
        Selections x$13 = RegularQueryProjection$.MODULE$.apply$default$3();
        return new RegularQueryProjection(x$10, x$12, x$13, x$11);
    }

    private PlannerQueryBuilder addReturnToLogicalPlanInput(PlannerQueryBuilder acc, Return clause, boolean nonTerminating) {
        Return return_ = clause;
        if (return_ != null) {
            boolean distinct2 = return_.distinct();
            ReturnItems returnItems = return_.returnItems();
            Option optOrderBy = return_.orderBy();
            Option skip = return_.skip();
            Option limit = return_.limit();
            if (returnItems != null) {
                boolean star = returnItems.includeExisting();
                Seq items = returnItems.items();
                if (!star) {
                    QueryPagination queryPagination = new QueryPagination(QueryPagination$.MODULE$.apply$default$1(), QueryPagination$.MODULE$.apply$default$2()).withSkip(skip).withLimit(limit);
                    QueryProjection projection2 = this.asQueryProjection(distinct2, (Seq<ReturnItem>)items, !nonTerminating).withPagination(queryPagination);
                    InterestingOrder requiredOrder = this.findRequiredOrder((QueryHorizon)projection2, (Option<OrderBy>)optOrderBy);
                    return acc.withHorizon((QueryHorizon)projection2).withInterestingOrder(requiredOrder).withPropagatedTailInterestingOrder();
                }
            }
        }
        throw new InternalException("AST needs to be rewritten before it can be used for planning. Got: " + clause);
    }

    public InterestingOrder findRequiredOrder(QueryHorizon horizon, Option<OrderBy> optOrderBy) {
        Seq interestingOrderCandidates;
        RequiredOrderCandidate requiredOrderCandidate;
        block10: {
            Tuple2 tuple2;
            block9: {
                Seq sortItems = optOrderBy.isDefined() ? ((OrderBy)optOrderBy.get()).sortItems() : (Seq)package$.MODULE$.Seq().empty();
                QueryHorizon queryHorizon = horizon;
                if (queryHorizon instanceof RegularQueryProjection) {
                    RegularQueryProjection regularQueryProjection = (RegularQueryProjection)queryHorizon;
                    Map projections = regularQueryProjection.projections();
                    RequiredOrderCandidate requiredOrderCandidate2 = this.extractColumnOrderFromOrderBy((Seq<SortItem>)sortItems, (Map<String, Expression>)projections);
                    v0 = new Tuple2((Object)requiredOrderCandidate2, (Object)package$.MODULE$.Seq().empty());
                } else if (queryHorizon instanceof AggregatingQueryProjection) {
                    AggregatingQueryProjection aggregatingQueryProjection = (AggregatingQueryProjection)queryHorizon;
                    Map groupingExpressions = aggregatingQueryProjection.groupingExpressions();
                    Map aggregationExpressions = aggregatingQueryProjection.aggregationExpressions();
                    RequiredOrderCandidate requiredOrderCandidate3 = this.extractColumnOrderFromOrderBy((Seq<SortItem>)sortItems, (Map<String, Expression>)groupingExpressions);
                    Seq interestingCandidates = (Seq)this.interestingOrderCandidatesForGroupingExpressions((Map<String, Expression>)groupingExpressions).$plus$plus(this.interestingOrderCandidateForMinOrMax((Map<String, Expression>)groupingExpressions, (Map<String, Expression>)aggregationExpressions));
                    v0 = new Tuple2((Object)requiredOrderCandidate3, (Object)interestingCandidates);
                } else if (queryHorizon instanceof DistinctQueryProjection) {
                    DistinctQueryProjection distinctQueryProjection = (DistinctQueryProjection)queryHorizon;
                    Map groupingExpressions = distinctQueryProjection.groupingExpressions();
                    RequiredOrderCandidate requiredOrderCandidate4 = this.extractColumnOrderFromOrderBy((Seq<SortItem>)sortItems, (Map<String, Expression>)groupingExpressions);
                    Seq<InterestingOrderCandidate> interestingCandidates = this.interestingOrderCandidatesForGroupingExpressions((Map<String, Expression>)groupingExpressions);
                    v0 = new Tuple2((Object)requiredOrderCandidate4, interestingCandidates);
                } else {
                    v0 = tuple2 = new Tuple2((Object)new RequiredOrderCandidate((Seq)package$.MODULE$.Seq().empty()), (Object)package$.MODULE$.Seq().empty());
                }
                if (tuple2 == null) break block9;
                requiredOrderCandidate = (RequiredOrderCandidate)tuple2._1();
                interestingOrderCandidates = (Seq)tuple2._2();
                if (interestingOrderCandidates != null) break block10;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq = interestingOrderCandidates;
        Tuple2 tuple2 = new Tuple2((Object)requiredOrderCandidate, (Object)seq);
        RequiredOrderCandidate requiredOrderCandidate5 = (RequiredOrderCandidate)tuple2._1();
        Seq interestingOrderCandidates2 = (Seq)tuple2._2();
        return new InterestingOrder(requiredOrderCandidate5, interestingOrderCandidates2);
    }

    private Option<InterestingOrderCandidate> interestingOrderCandidateForMinOrMax(Map<String, Expression> groupingExpressions, Map<String, Expression> aggregationExpressions) {
        if (groupingExpressions.isEmpty() && aggregationExpressions.size() == 1) {
            Expression value = (Expression)aggregationExpressions.apply(aggregationExpressions.keys().head());
            Seq columns = (Seq)AggregationHelper$.MODULE$.checkMinOrMax(value, (Function1 & Serializable)e -> new .colon.colon((Object)new ColumnOrder.Asc(e, ColumnOrder.Asc$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (Function1 & Serializable)e -> new .colon.colon((Object)new ColumnOrder.Desc(e, ColumnOrder.Desc$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), package$.MODULE$.Seq().empty());
            return new Some((Object)new InterestingOrderCandidate(columns));
        }
        return None$.MODULE$;
    }

    private Seq<InterestingOrderCandidate> interestingOrderCandidatesForGroupingExpressions(Map<String, Expression> groupingExpressions) {
        Seq propsAndVars = ((IterableOnceOps)groupingExpressions.values().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Property) {
                    Property property = (Property)A1;
                    return (B1)property;
                }
                if (A1 instanceof Variable) {
                    Variable variable = (Variable)A1;
                    return (B1)variable;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (expression instanceof Property) {
                    return true;
                }
                return expression instanceof Variable;
            }
        })).toSeq();
        .colon.colon orderings = new .colon.colon((Function1 & Serializable)x$5 -> new ColumnOrder.Asc(x$5, Predef$.MODULE$.Map().empty()), (List)new .colon.colon((Function1 & Serializable)x$6 -> new ColumnOrder.Desc(x$6, Predef$.MODULE$.Map().empty()), (List)Nil$.MODULE$));
        return (Seq)propsAndVars.flatMap(arg_0 -> ClauseConverters$.$anonfun$interestingOrderCandidatesForGroupingExpressions$3((Seq)orderings, arg_0));
    }

    private RequiredOrderCandidate extractColumnOrderFromOrderBy(Seq<SortItem> sortItems, Map<String, Expression> projections) {
        Seq columns = (Seq)sortItems.map((Function1 & Serializable)x0$1 -> {
            Variable variable;
            Option option;
            Expression e;
            Variable variable2;
            Option option2;
            Expression e2;
            boolean bl = false;
            AscSortItem ascSortItem = null;
            boolean bl2 = false;
            DescSortItem descSortItem = null;
            SortItem sortItem = x0$1;
            if (sortItem instanceof AscSortItem) {
                Variable variable3;
                Option option3;
                Property property;
                Expression expression;
                bl = true;
                ascSortItem = (AscSortItem)sortItem;
                Expression e3 = ascSortItem.expression();
                if (e3 instanceof Property && (expression = (property = (Property)e3).map()) instanceof Variable && !(option3 = LogicalVariable$.MODULE$.unapply(variable3 = (Variable)expression)).isEmpty()) {
                    String varName = (String)option3.get();
                    Option option4 = projections.get((Object)varName);
                    if (option4 instanceof Some) {
                        Some some = (Some)option4;
                        Expression expression2 = (Expression)some.value();
                        return new ColumnOrder.Asc((Expression)property, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)varName), (Object)expression2)})));
                    }
                    if (None$.MODULE$.equals(option4)) {
                        return new ColumnOrder.Asc((Expression)property, ColumnOrder.Asc$.MODULE$.apply$default$2());
                    }
                    throw new MatchError((Object)option4);
                }
            }
            if (sortItem instanceof DescSortItem) {
                Variable variable4;
                Option option5;
                Property property;
                Expression expression;
                bl2 = true;
                descSortItem = (DescSortItem)sortItem;
                Expression e4 = descSortItem.expression();
                if (e4 instanceof Property && (expression = (property = (Property)e4).map()) instanceof Variable && !(option5 = LogicalVariable$.MODULE$.unapply(variable4 = (Variable)expression)).isEmpty()) {
                    String varName = (String)option5.get();
                    Option option6 = projections.get((Object)varName);
                    if (option6 instanceof Some) {
                        Some some = (Some)option6;
                        Expression expression3 = (Expression)some.value();
                        return new ColumnOrder.Desc((Expression)property, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)varName), (Object)expression3)})));
                    }
                    if (None$.MODULE$.equals(option6)) {
                        return new ColumnOrder.Desc((Expression)property, ColumnOrder.Desc$.MODULE$.apply$default$2());
                    }
                    throw new MatchError((Object)option6);
                }
            }
            if (bl && (e2 = ascSortItem.expression()) instanceof Variable && !(option2 = LogicalVariable$.MODULE$.unapply(variable2 = (Variable)e2)).isEmpty()) {
                String name = (String)option2.get();
                Option option7 = projections.get((Object)name);
                if (option7 instanceof Some) {
                    Some some = (Some)option7;
                    Expression expression = (Expression)some.value();
                    return new ColumnOrder.Asc((Expression)variable2, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)expression)})));
                }
                if (None$.MODULE$.equals(option7)) {
                    return new ColumnOrder.Asc((Expression)variable2, ColumnOrder.Asc$.MODULE$.apply$default$2());
                }
                throw new MatchError((Object)option7);
            }
            if (bl2 && (e = descSortItem.expression()) instanceof Variable && !(option = LogicalVariable$.MODULE$.unapply(variable = (Variable)e)).isEmpty()) {
                String name = (String)option.get();
                Option option8 = projections.get((Object)name);
                if (option8 instanceof Some) {
                    Some some = (Some)option8;
                    Expression expression = (Expression)some.value();
                    return new ColumnOrder.Desc((Expression)variable, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)expression)})));
                }
                if (None$.MODULE$.equals(option8)) {
                    return new ColumnOrder.Desc((Expression)variable, ColumnOrder.Desc$.MODULE$.apply$default$2());
                }
                throw new MatchError((Object)option8);
            }
            if (bl) {
                Expression expression = ascSortItem.expression();
                scala.collection.immutable.Set depNames = (scala.collection.immutable.Set)expression.dependencies().map((Function1 & Serializable)x$7 -> x$7.name());
                Map orderProjections = (Map)projections.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)depNames.contains(p._1())));
                return new ColumnOrder.Asc(expression, orderProjections);
            }
            if (bl2) {
                Expression expression = descSortItem.expression();
                scala.collection.immutable.Set depNames = (scala.collection.immutable.Set)expression.dependencies().map((Function1 & Serializable)x$8 -> x$8.name());
                Map orderProjections = (Map)projections.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)depNames.contains(p._1())));
                return new ColumnOrder.Desc(expression, orderProjections);
            }
            throw new MatchError((Object)sortItem);
        });
        return new RequiredOrderCandidate(columns);
    }

    private PlannerQueryBuilder addSetClauseToLogicalPlanInput(PlannerQueryBuilder acc, SetClause clause) {
        return (PlannerQueryBuilder)clause.items().foldLeft((Object)acc, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                SetItem item = (SetItem)tuple2._2();
                return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$9 -> x$9.addMutatingPatterns((MutatingPattern)MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern(acc.semanticTable(), item)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private PlannerQueryBuilder addCreateToLogicalPlanInput(PlannerQueryBuilder builder, Create clause) {
        ArrayBuffer nodes = new ArrayBuffer();
        ArrayBuffer relationships = new ArrayBuffer();
        scala.collection.mutable.Set seenPatternNodes = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        seenPatternNodes.$plus$plus$eq(builder.allSeenPatternNodes());
        clause.pattern().patternParts().foreach((Function1 & Serializable)x0$1 -> {
            ClauseConverters$.$anonfun$addCreateToLogicalPlanInput$1(nodes, seenPatternNodes, relationships, clause, x0$1);
            return BoxedUnit.UNIT;
        });
        return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$15 -> x$15.addMutatingPatterns((MutatingPattern)new CreatePattern(nodes.toSeq(), relationships.toSeq())));
    }

    public scala.collection.immutable.Set<LabelName> org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$getLabelNameSet(Option<LabelExpression> labelExpression) {
        return (scala.collection.immutable.Set)labelExpression.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LabelExpression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                LabelExpression.Leaf leaf;
                LabelExpressionLeafName labelName;
                A1 A1 = x1;
                if (A1 instanceof LabelExpression.Leaf && (labelName = (leaf = (LabelExpression.Leaf)A1).name()) instanceof LabelName) {
                    LabelName labelName2 = (LabelName)labelName;
                    return (B1)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LabelName[]{labelName2}));
                }
                if (A1 instanceof LabelExpression.ColonConjunction) {
                    LabelExpression.ColonConjunction colonConjunction = (LabelExpression.ColonConjunction)A1;
                    LabelExpression lhs = colonConjunction.lhs();
                    LabelExpression rhs = colonConjunction.rhs();
                    return (B1)ClauseConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$getLabelNameSet((Option<LabelExpression>)new Some((Object)lhs)).$plus$plus(ClauseConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$getLabelNameSet((Option<LabelExpression>)new Some((Object)rhs)));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LabelExpression x1) {
                LabelExpression.Leaf leaf;
                LabelExpressionLeafName labelName;
                LabelExpression labelExpression = x1;
                if (labelExpression instanceof LabelExpression.Leaf && (labelName = (leaf = (LabelExpression.Leaf)labelExpression).name()) instanceof LabelName) {
                    return true;
                }
                return labelExpression instanceof LabelExpression.ColonConjunction;
            }
        }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    private IndexedSeq<ClauseConverters.CreateNodeCommand> dedup(Vector<ClauseConverters.CreateNodeCommand> nodePatterns) {
        scala.collection.mutable.Set seen = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        ListBuffer result = ListBuffer$.MODULE$.empty();
        nodePatterns.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$dedup$1(seen, result, x0$1)));
        return result.toIndexedSeq();
    }

    private ClauseConverters.CreateNodeCommand createNodeCommand(NodePattern pattern) {
        NodePattern nodePattern = pattern;
        if (nodePattern != null) {
            Option option = nodePattern.variable();
            Option labelExpression = nodePattern.labelExpression();
            Option props = nodePattern.properties();
            Option option2 = nodePattern.predicate();
            if (option instanceof Some) {
                Some some = (Some)option;
                LogicalVariable variable = (LogicalVariable)some.value();
                if (None$.MODULE$.equals(option2)) {
                    return new ClauseConverters.CreateNodeCommand(new CreateNode(variable.name(), this.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$getLabelNameSet((Option<LabelExpression>)labelExpression), props), variable);
                }
            }
        }
        throw new InternalException("All nodes must be named at this instance");
    }

    private Tuple2<Vector<ClauseConverters.CreateNodeCommand>, Vector<ClauseConverters.CreateRelCommand>> allCreatePatterns(PatternElement element) {
        boolean bl = false;
        RelationshipChain relationshipChain = null;
        PatternElement patternElement = element;
        if (patternElement instanceof NodePattern) {
            NodePattern nodePattern = (NodePattern)patternElement;
            return new Tuple2(package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClauseConverters.CreateNodeCommand[]{this.createNodeCommand(nodePattern)})), (Object)package$.MODULE$.Vector().empty());
        }
        if (patternElement instanceof RelationshipChain) {
            NodePattern nodePattern;
            Option option;
            bl = true;
            relationshipChain = (RelationshipChain)patternElement;
            SimplePattern leftNode = relationshipChain.element();
            RelationshipPattern relationshipPattern = relationshipChain.relationship();
            NodePattern rightNode = relationshipChain.rightNode();
            if (leftNode instanceof NodePattern && (option = (nodePattern = (NodePattern)leftNode).variable()) instanceof Some) {
                Some some = (Some)option;
                LogicalVariable leftVar = (LogicalVariable)some.value();
                if (relationshipPattern != null) {
                    Option option2 = relationshipPattern.variable();
                    Option option3 = relationshipPattern.labelExpression();
                    Option properties = relationshipPattern.properties();
                    SemanticDirection direction = relationshipPattern.direction();
                    if (option2 instanceof Some) {
                        LabelExpression.Leaf leaf;
                        LabelExpressionLeafName relType;
                        Some some2;
                        LabelExpression labelExpression;
                        Some some3 = (Some)option2;
                        LogicalVariable relVar = (LogicalVariable)some3.value();
                        if (option3 instanceof Some && (labelExpression = (LabelExpression)(some2 = (Some)option3).value()) instanceof LabelExpression.Leaf && (relType = (leaf = (LabelExpression.Leaf)labelExpression).name()) instanceof RelTypeName) {
                            Option option4;
                            RelTypeName relTypeName = (RelTypeName)relType;
                            if (rightNode != null && (option4 = rightNode.variable()) instanceof Some) {
                                Some some4 = (Some)option4;
                                LogicalVariable rightVar = (LogicalVariable)some4.value();
                                return new Tuple2(package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClauseConverters.CreateNodeCommand[]{this.createNodeCommand(nodePattern), this.createNodeCommand(rightNode)})), package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClauseConverters.CreateRelCommand[]{new ClauseConverters.CreateRelCommand(new CreateRelationship(relVar.name(), leftVar.name(), relTypeName, rightVar.name(), direction, properties), relVar)})));
                            }
                        }
                    }
                }
            }
        }
        if (bl) {
            SimplePattern left = relationshipChain.element();
            RelationshipPattern relationshipPattern = relationshipChain.relationship();
            NodePattern rightNode = relationshipChain.rightNode();
            if (relationshipPattern != null) {
                Option option = relationshipPattern.variable();
                Option option5 = relationshipPattern.labelExpression();
                Option properties = relationshipPattern.properties();
                SemanticDirection direction = relationshipPattern.direction();
                if (option instanceof Some) {
                    LabelExpression.Leaf leaf;
                    LabelExpressionLeafName relType;
                    Some some;
                    LabelExpression labelExpression;
                    Some some5 = (Some)option;
                    LogicalVariable relVar = (LogicalVariable)some5.value();
                    if (option5 instanceof Some && (labelExpression = (LabelExpression)(some = (Some)option5).value()) instanceof LabelExpression.Leaf && (relType = (leaf = (LabelExpression.Leaf)labelExpression).name()) instanceof RelTypeName) {
                        Option option6;
                        RelTypeName relTypeName = (RelTypeName)relType;
                        if (rightNode != null && (option6 = rightNode.variable()) instanceof Some) {
                            Some some6 = (Some)option6;
                            LogicalVariable rightVar = (LogicalVariable)some6.value();
                            Tuple2<Vector<ClauseConverters.CreateNodeCommand>, Vector<ClauseConverters.CreateRelCommand>> tuple2 = this.allCreatePatterns((PatternElement)left);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            Vector nodes = (Vector)tuple2._1();
                            Vector rels = (Vector)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)nodes, (Object)rels);
                            Vector nodes2 = (Vector)tuple22._1();
                            Vector rels2 = (Vector)tuple22._2();
                            return new Tuple2(nodes2.$colon$plus((Object)this.createNodeCommand(rightNode)), rels2.$colon$plus((Object)new ClauseConverters.CreateRelCommand(new CreateRelationship(relVar.name(), ((ClauseConverters.CreateNodeCommand)nodes2.last()).create().idName(), relTypeName, rightVar.name(), direction, properties), relVar)));
                        }
                    }
                }
            }
        }
        throw new MatchError((Object)patternElement);
    }

    private PlannerQueryBuilder addDeleteToLogicalPlanInput(PlannerQueryBuilder acc, Delete clause) {
        return acc.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$17 -> x$17.addMutatingPatterns((Seq)clause.expressions().map((Function1 & Serializable)x$18 -> new DeleteExpression(x$18, clause.forced()))));
    }

    private Seq<ReturnItem> asReturnItems(QueryGraph current, ReturnItems returnItems) {
        ReturnItems returnItems2 = returnItems;
        if (returnItems2 != null) {
            boolean star = returnItems2.includeExisting();
            Seq items = returnItems2.items();
            if (star) {
                return (Seq)QueryProjection$.MODULE$.forIds(current.allCoveredIds()).$plus$plus((IterableOnce)items);
            }
        }
        if (returnItems2 != null) {
            Seq items = returnItems2.items();
            return items;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private PlannerQueryBuilder addMatchToLogicalPlanInput(PlannerQueryBuilder acc, Match clause, AnonymousVariableNameGenerator anonymousVariableNameGenerator) {
        PatternConverters.DestructResult patternContent = PatternConverters.PatternDestructor$.MODULE$.destructed$extension(PatternConverters$.MODULE$.PatternDestructor(clause.pattern()), anonymousVariableNameGenerator);
        PlannerQueryBuilder accWithMaybeHorizon = ClauseConverters$.qppHasDependencyToPreviousClauses$1(patternContent, acc) ? acc.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(new QueryGraph(QueryGraph$.MODULE$.apply$default$1(), QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8(), QueryGraph$.MODULE$.apply$default$9()), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())) : acc;
        Selections selections = this.asSelections((Option<Where>)clause.where());
        if (clause.optional()) {
            return accWithMaybeHorizon.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)qg -> {
                Selections x$1 = selections;
                scala.collection.immutable.Set x$2 = patternContent.nodeIds().toSet();
                scala.collection.immutable.Set x$3 = patternContent.rels().toSet();
                scala.collection.immutable.Set x$4 = patternContent.quantifiedPathPatterns().toSet();
                scala.collection.immutable.Set x$5 = clause.hints().toSet();
                scala.collection.immutable.Set x$6 = patternContent.shortestPaths().toSet();
                scala.collection.immutable.Set x$7 = QueryGraph$.MODULE$.apply$default$4();
                IndexedSeq x$8 = QueryGraph$.MODULE$.apply$default$6();
                IndexedSeq x$9 = QueryGraph$.MODULE$.apply$default$9();
                return qg.withAddedOptionalMatch(new QueryGraph(x$3, x$4, x$2, x$7, x$1, x$8, x$5, x$6, x$9));
            });
        }
        return accWithMaybeHorizon.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)qg -> qg.addSelections(selections).addPatternNodes(patternContent.nodeIds()).addPatternRelationships(patternContent.rels().toSet()).addQuantifiedPathPatterns(patternContent.quantifiedPathPatterns().toSet()).addHints((IterableOnce)clause.hints()).addShortestPaths(patternContent.shortestPaths()));
    }

    private PlannerQueryBuilder addCallSubqueryToLogicalPlanInput(PlannerQueryBuilder acc, SubqueryCall clause, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker) {
        Query subquery;
        Query x$1 = subquery = clause.innerQuery();
        SemanticTable x$2 = acc.semanticTable();
        AnonymousVariableNameGenerator x$3 = anonymousVariableNameGenerator;
        CancellationChecker x$4 = cancellationChecker;
        boolean x$5 = false;
        boolean x$6 = true;
        scala.collection.immutable.Set<String> x$7 = StatementConverters$.MODULE$.toPlannerQuery$default$5();
        PlannerQuery callSubquery = StatementConverters$.MODULE$.toPlannerQuery(x$1, x$2, x$3, x$4, x$7, false, true);
        return acc.withCallSubquery(callSubquery, subquery.isCorrelated(), subquery.isReturning(), (Option<SubqueryCall.InTransactionsParameters>)clause.inTransactionsParameters());
    }

    private PlannerQueryBuilder addCommandClauseToLogicalPlanInput(PlannerQueryBuilder acc, CommandClause clause) {
        return acc.withHorizon((QueryHorizon)new CommandProjection(clause)).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addYieldToLogicalPlanInput(PlannerQueryBuilder builder, Yield yield) {
        Selections selections = this.asSelections((Option<Where>)yield.where());
        Seq<ReturnItem> returnItems = this.asReturnItems(builder.currentQueryGraph(), yield.returnItems());
        QueryPagination queryPagination = new QueryPagination(QueryPagination$.MODULE$.apply$default$1(), QueryPagination$.MODULE$.apply$default$2()).withLimit(yield.limit()).withSkip(yield.skip());
        QueryProjection queryProjection = this.asQueryProjection(false, returnItems, false).withPagination(queryPagination).withSelection(selections);
        InterestingOrder requiredOrder = this.findRequiredOrder((QueryHorizon)queryProjection, (Option<OrderBy>)yield.orderBy());
        return builder.withHorizon((QueryHorizon)queryProjection).withInterestingOrder(requiredOrder).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(new QueryGraph(QueryGraph$.MODULE$.apply$default$1(), QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8(), QueryGraph$.MODULE$.apply$default$9()), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
    }

    private Map<PropertyKeyName, Expression> toPropertyMap(Option<Expression> expr) {
        Some some;
        Expression expression;
        Option<Expression> option = expr;
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Map().empty();
        }
        if (option instanceof Some && (expression = (Expression)(some = (Some)option).value()) instanceof MapExpression) {
            MapExpression mapExpression = (MapExpression)expression;
            Seq items = mapExpression.items();
            return items.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        throw new InternalException("Expected MapExpression, got " + option);
    }

    private Seq<Expression> toPropertySelection(LogicalVariable identifier, Map<PropertyKeyName, Expression> map2) {
        return ((IterableOnceOps)map2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PropertyKeyName k = (PropertyKeyName)tuple2._1();
                Expression e = (Expression)tuple2._2();
                return new In((Expression)new Property((Expression)identifier, k, k.position()), (Expression)new ListLiteral((Seq)new .colon.colon((Object)e, (List)Nil$.MODULE$), e.position()), identifier.position());
            }
            throw new MatchError((Object)tuple2);
        })).toIndexedSeq();
    }

    public SetMutatingPattern org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern(SemanticTable semanticTable, SetItem setItem) {
        boolean bl = false;
        SetPropertyItem setPropertyItem = null;
        boolean bl2 = false;
        SetPropertyItems setPropertyItems = null;
        boolean bl3 = false;
        SetExactPropertiesFromMapItem setExactPropertiesFromMapItem = null;
        boolean bl4 = false;
        SetIncludingPropertiesFromMapItem setIncludingPropertiesFromMapItem = null;
        SetItem setItem2 = setItem;
        if (setItem2 instanceof SetLabelItem) {
            SetLabelItem setLabelItem = (SetLabelItem)setItem2;
            Variable id = setLabelItem.variable();
            Seq labels = setLabelItem.labels();
            return new SetLabelPattern(id.name(), labels);
        }
        if (setItem2 instanceof SetPropertyItem) {
            bl = true;
            setPropertyItem = (SetPropertyItem)setItem2;
            LogicalProperty logicalProperty = setPropertyItem.property();
            Expression expr = setPropertyItem.expression();
            if (logicalProperty instanceof Property) {
                Variable variable;
                Property property = (Property)logicalProperty;
                Expression node = property.map();
                PropertyKeyName propertyKey = property.propertyKey();
                if (node instanceof Variable && semanticTable.isNode((Expression)(variable = (Variable)node))) {
                    return new SetNodePropertyPattern(variable.name(), propertyKey, expr);
                }
            }
        }
        if (setItem2 instanceof SetPropertyItems) {
            Variable variable;
            bl2 = true;
            setPropertyItems = (SetPropertyItems)setItem2;
            Expression node = setPropertyItems.map();
            Seq items = setPropertyItems.items();
            if (node instanceof Variable && semanticTable.isNode((Expression)(variable = (Variable)node))) {
                return new SetNodePropertiesPattern(variable.name(), items);
            }
        }
        if (bl) {
            LogicalProperty logicalProperty = setPropertyItem.property();
            Expression expr = setPropertyItem.expression();
            if (logicalProperty instanceof Property) {
                Variable variable;
                Property property = (Property)logicalProperty;
                Expression rel = property.map();
                PropertyKeyName propertyKey = property.propertyKey();
                if (rel instanceof Variable && semanticTable.isRelationship((Expression)(variable = (Variable)rel))) {
                    return new SetRelationshipPropertyPattern(variable.name(), propertyKey, expr);
                }
            }
        }
        if (bl2) {
            Variable variable;
            Expression rel = setPropertyItems.map();
            Seq items = setPropertyItems.items();
            if (rel instanceof Variable && semanticTable.isRelationship((Expression)(variable = (Variable)rel))) {
                return new SetRelationshipPropertiesPattern(variable.name(), items);
            }
        }
        if (bl) {
            LogicalProperty logicalProperty = setPropertyItem.property();
            Expression expr = setPropertyItem.expression();
            if (logicalProperty instanceof Property) {
                Property property = (Property)logicalProperty;
                Expression entityExpr = property.map();
                PropertyKeyName propertyKey = property.propertyKey();
                return new SetPropertyPattern(entityExpr, propertyKey, expr);
            }
        }
        if (bl2) {
            Expression entityExpr = setPropertyItems.map();
            Seq items = setPropertyItems.items();
            return new SetPropertiesPattern(entityExpr, items);
        }
        if (setItem2 instanceof SetExactPropertiesFromMapItem) {
            bl3 = true;
            setExactPropertiesFromMapItem = (SetExactPropertiesFromMapItem)setItem2;
            Variable node = setExactPropertiesFromMapItem.variable();
            Expression expression = setExactPropertiesFromMapItem.expression();
            if (semanticTable.isNode((Expression)node)) {
                return new SetNodePropertiesFromMapPattern(node.name(), expression, true);
            }
        }
        if (bl3) {
            Variable rel = setExactPropertiesFromMapItem.variable();
            Expression expression = setExactPropertiesFromMapItem.expression();
            if (semanticTable.isRelationship((Expression)rel)) {
                return new SetRelationshipPropertiesFromMapPattern(rel.name(), expression, true);
            }
        }
        if (bl3) {
            Variable vr = setExactPropertiesFromMapItem.variable();
            Expression expression = setExactPropertiesFromMapItem.expression();
            return new SetPropertiesFromMapPattern((Expression)vr, expression, true);
        }
        if (setItem2 instanceof SetIncludingPropertiesFromMapItem) {
            bl4 = true;
            setIncludingPropertiesFromMapItem = (SetIncludingPropertiesFromMapItem)setItem2;
            Variable node = setIncludingPropertiesFromMapItem.variable();
            Expression expression = setIncludingPropertiesFromMapItem.expression();
            if (semanticTable.isNode((Expression)node)) {
                return new SetNodePropertiesFromMapPattern(node.name(), expression, false);
            }
        }
        if (bl4) {
            Variable rel = setIncludingPropertiesFromMapItem.variable();
            Expression expression = setIncludingPropertiesFromMapItem.expression();
            if (semanticTable.isRelationship((Expression)rel)) {
                return new SetRelationshipPropertiesFromMapPattern(rel.name(), expression, false);
            }
        }
        if (bl4) {
            Variable vr = setIncludingPropertiesFromMapItem.variable();
            Expression expression = setIncludingPropertiesFromMapItem.expression();
            return new SetPropertiesFromMapPattern((Expression)vr, expression, false);
        }
        throw new MatchError((Object)setItem2);
    }

    private PlannerQueryBuilder addMergeToLogicalPlanInput(PlannerQueryBuilder builder, Merge clause) {
        PatternElement pattern;
        Seq onCreate = (Seq)((IterableOps)clause.actions().collect((PartialFunction)new Serializable(builder){
            private static final long serialVersionUID = 0L;
            private final PlannerQueryBuilder builder$1;

            public final <A1 extends MergeAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof OnCreate) {
                    OnCreate onCreate = (OnCreate)A1;
                    SetClause setClause = onCreate.action();
                    return (B1)setClause.items().map((Function1 & Serializable)setItem -> ClauseConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern($this.builder$1.semanticTable(), (SetItem)setItem));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(MergeAction x1) {
                MergeAction mergeAction = x1;
                return mergeAction instanceof OnCreate;
            }
            {
                this.builder$1 = builder$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$$anonfun$2 org.neo4j.cypher.internal.ast.SetItem )}, serializedLambda);
            }
        })).flatten(Predef$.MODULE$.$conforms());
        Seq onMatch = (Seq)((IterableOps)clause.actions().collect((PartialFunction)new Serializable(builder){
            private static final long serialVersionUID = 0L;
            private final PlannerQueryBuilder builder$1;

            public final <A1 extends MergeAction, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof OnMatch) {
                    OnMatch onMatch = (OnMatch)A1;
                    SetClause setClause = onMatch.action();
                    return (B1)setClause.items().map((Function1 & Serializable)setItem -> ClauseConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern($this.builder$1.semanticTable(), (SetItem)setItem));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(MergeAction x2) {
                MergeAction mergeAction = x2;
                return mergeAction instanceof OnMatch;
            }
            {
                this.builder$1 = builder$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$$anonfun$3 org.neo4j.cypher.internal.ast.SetItem )}, serializedLambda);
            }
        })).flatten(Predef$.MODULE$.$conforms());
        boolean bl = false;
        EveryPath everyPath = null;
        PatternPart patternPart = clause.pattern();
        if (patternPart instanceof EveryPath) {
            bl = true;
            everyPath = (EveryPath)patternPart;
            PatternElement patternElement = everyPath.element();
            if (patternElement instanceof NodePattern) {
                NodePattern nodePattern = (NodePattern)patternElement;
                Option option = nodePattern.variable();
                Option labelExpression = nodePattern.labelExpression();
                Option props = nodePattern.properties();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogicalVariable id = (LogicalVariable)some.value();
                    scala.collection.immutable.Set<LabelName> labels = this.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$getLabelNameSet((Option<LabelExpression>)labelExpression);
                    scala.collection.immutable.Set<String> currentlyAvailableVariables = builder.currentlyAvailableVariables();
                    scala.collection.immutable.Set labelPredicates = (scala.collection.immutable.Set)labels.map((Function1 & Serializable)l -> new HasLabels((Expression)id, (Seq)new .colon.colon(l, (List)Nil$.MODULE$), id.position()));
                    Seq<Expression> propertyPredicates = this.toPropertySelection(id, this.toPropertyMap((Option<Expression>)props));
                    CreateNode createNodePattern = new CreateNode(id.name(), labels, props);
                    scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{id.name()}));
                    Selections x$2 = Selections$.MODULE$.from((Iterable)labelPredicates.$plus$plus(propertyPredicates));
                    scala.collection.immutable.Set<String> x$3 = currentlyAvailableVariables;
                    scala.collection.immutable.Set x$4 = QueryGraph$.MODULE$.apply$default$1();
                    scala.collection.immutable.Set x$5 = QueryGraph$.MODULE$.apply$default$2();
                    IndexedSeq x$6 = QueryGraph$.MODULE$.apply$default$6();
                    scala.collection.immutable.Set x$7 = QueryGraph$.MODULE$.apply$default$7();
                    scala.collection.immutable.Set x$8 = QueryGraph$.MODULE$.apply$default$8();
                    IndexedSeq x$9 = QueryGraph$.MODULE$.apply$default$9();
                    QueryGraph matchGraph = new QueryGraph(x$4, x$5, x$1, x$3, x$2, x$6, x$7, x$8, x$9);
                    QueryGraph queryGraph = QueryGraph$.MODULE$.empty().withArgumentIds(matchGraph.argumentIds()).addMutatingPatterns((MutatingPattern)new MergeNodePattern(createNodePattern, matchGraph, onCreate, onMatch));
                    return builder.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(queryGraph, RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())).withHorizon((QueryHorizon)this.asQueryProjection(false, (Seq<ReturnItem>)QueryProjection$.MODULE$.forIds(queryGraph.allCoveredIds()), false)).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(RegularSinglePlannerQuery$.MODULE$.apply$default$1(), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
                }
            }
        }
        if (bl && (pattern = everyPath.element()) instanceof RelationshipChain) {
            RelationshipChain relationshipChain = (RelationshipChain)pattern;
            Tuple2<Vector<ClauseConverters.CreateNodeCommand>, Vector<ClauseConverters.CreateRelCommand>> tuple2 = this.allCreatePatterns((PatternElement)relationshipChain);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Vector nodes = (Vector)tuple2._1();
            Vector rels = (Vector)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)nodes, (Object)rels);
            Vector nodes2 = (Vector)tuple22._1();
            Vector rels2 = (Vector)tuple22._2();
            IndexedSeq<ClauseConverters.CreateNodeCommand> dedupedNodes = this.dedup((Vector<ClauseConverters.CreateNodeCommand>)nodes2);
            Set<String> seenPatternNodes = builder.allSeenPatternNodes();
            IndexedSeq nodesToCreate = (IndexedSeq)dedupedNodes.filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$addMergeToLogicalPlanInput$2(seenPatternNodes, x0$1)));
            scala.collection.immutable.Set nodesCreatedBefore = ((IterableOnceOps)dedupedNodes.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$addMergeToLogicalPlanInput$3(seenPatternNodes, x0$2)))).toSet();
            nodesCreatedBefore.collectFirst((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends ClauseConverters.CreateNodeCommand, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    CreateNode c;
                    A1 A1 = x3;
                    if (A1 != null && ((c = A1.create()).labels().nonEmpty() || c.properties().nonEmpty())) {
                        throw new SyntaxException("Can't create node `" + c.idName() + "` with labels or properties here. The variable is already declared in this context");
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(ClauseConverters.CreateNodeCommand x3) {
                    CreateNode c;
                    ClauseConverters.CreateNodeCommand createNodeCommand = x3;
                    return createNodeCommand != null && ((c = createNodeCommand.create()).labels().nonEmpty() || c.properties().nonEmpty());
                }
            });
            Selections selections = this.asSelections((Option<Where>)clause.where());
            Vector hasLabels = (Vector)nodes2.flatMap((Function1 & Serializable)x0$3 -> {
                ClauseConverters.CreateNodeCommand createNodeCommand = x0$3;
                if (createNodeCommand != null) {
                    CreateNode n = createNodeCommand.create();
                    LogicalVariable v = createNodeCommand.variable();
                    return (scala.collection.immutable.Set)n.labels().map((Function1 & Serializable)l -> new HasLabels((Expression)v, (Seq)new .colon.colon(l, (List)Nil$.MODULE$), v.position()));
                }
                throw new MatchError((Object)createNodeCommand);
            });
            Vector hasProps = (Vector)((IterableOps)nodes2.flatMap((Function1 & Serializable)x0$4 -> {
                ClauseConverters.CreateNodeCommand createNodeCommand = x0$4;
                if (createNodeCommand != null) {
                    CreateNode n = createNodeCommand.create();
                    LogicalVariable v = createNodeCommand.variable();
                    return MODULE$.toPropertySelection(v, MODULE$.toPropertyMap((Option<Expression>)n.properties()));
                }
                throw new MatchError((Object)createNodeCommand);
            })).$plus$plus((IterableOnce)rels2.flatMap((Function1 & Serializable)x0$5 -> {
                ClauseConverters.CreateRelCommand createRelCommand = x0$5;
                if (createRelCommand != null) {
                    CreateRelationship r = createRelCommand.create();
                    LogicalVariable v = createRelCommand.variable();
                    return MODULE$.toPropertySelection(v, MODULE$.toPropertyMap((Option<Expression>)r.properties()));
                }
                throw new MatchError((Object)createRelCommand);
            }));
            scala.collection.immutable.Set x$10 = ((IterableOnceOps)nodes2.map((Function1 & Serializable)x$21 -> x$21.create().idName())).toSet();
            scala.collection.immutable.Set x$11 = ((IterableOnceOps)rels2.map((Function1 & Serializable)x0$6 -> {
                ClauseConverters.CreateRelCommand createRelCommand = x0$6;
                if (createRelCommand != null) {
                    CreateRelationship r = createRelCommand.create();
                    return new PatternRelationship(r.idName(), new Tuple2((Object)r.leftNode(), (Object)r.rightNode()), r.direction(), (Seq)new .colon.colon((Object)r.relType(), (List)Nil$.MODULE$), (PatternLength)SimplePatternLength$.MODULE$);
                }
                throw new MatchError((Object)createRelCommand);
            })).toSet();
            Selections x$12 = selections.$plus$plus(Selections$.MODULE$.from((Iterable)hasLabels.$plus$plus((IterableOnce)hasProps)));
            scala.collection.immutable.Set x$13 = (scala.collection.immutable.Set)builder.currentlyAvailableVariables().$plus$plus((IterableOnce)nodesCreatedBefore.map((Function1 & Serializable)x$22 -> x$22.create().idName()));
            scala.collection.immutable.Set x$14 = QueryGraph$.MODULE$.apply$default$2();
            IndexedSeq x$15 = QueryGraph$.MODULE$.apply$default$6();
            scala.collection.immutable.Set x$16 = QueryGraph$.MODULE$.apply$default$7();
            scala.collection.immutable.Set x$17 = QueryGraph$.MODULE$.apply$default$8();
            IndexedSeq x$18 = QueryGraph$.MODULE$.apply$default$9();
            QueryGraph matchGraph = new QueryGraph(x$11, x$14, x$10, x$13, x$12, x$15, x$16, x$17, x$18);
            QueryGraph queryGraph = QueryGraph$.MODULE$.empty().withArgumentIds(matchGraph.argumentIds()).addMutatingPatterns((MutatingPattern)new MergeRelationshipPattern((Seq)nodesToCreate.map((Function1 & Serializable)x$23 -> x$23.create()), (Seq)rels2.map((Function1 & Serializable)x$24 -> x$24.create()), matchGraph, onCreate, onMatch));
            return builder.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(queryGraph, RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())).withHorizon((QueryHorizon)this.asQueryProjection(false, (Seq<ReturnItem>)QueryProjection$.MODULE$.forIds(queryGraph.allCoveredIds()), false)).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(RegularSinglePlannerQuery$.MODULE$.apply$default$1(), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
        }
        throw new InternalException("Received an AST-clause that has no representation the QG: " + patternPart);
    }

    private PlannerQueryBuilder addWithToLogicalPlanInput(PlannerQueryBuilder builder, With clause, Option<Clause> nextClause) {
        With with = clause;
        if (with != null) {
            boolean bl = with.distinct();
            ReturnItems ri = with.returnItems();
            Option option = with.orderBy();
            Option option2 = with.skip();
            Option option3 = with.limit();
            Option where = with.where();
            if (!bl && None$.MODULE$.equals(option) && None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3) && ClauseConverters$.optionalMatchesOK$1(where, builder, nextClause) && ClauseConverters$.noUpdates$1(builder) && ClauseConverters$.returnItemsOK$1(ri) && ClauseConverters$.noShortestPaths$1(builder)) {
                Selections selections = this.asSelections((Option<Where>)where);
                return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$25 -> x$25.addSelections(selections));
            }
        }
        if (with != null) {
            boolean distinct2 = with.distinct();
            ReturnItems projection2 = with.returnItems();
            Option orderBy = with.orderBy();
            Option skip = with.skip();
            Option limit = with.limit();
            Option where = with.where();
            Selections selections = this.asSelections((Option<Where>)where);
            Seq<ReturnItem> returnItems = this.asReturnItems(builder.currentQueryGraph(), projection2);
            QueryPagination queryPagination = new QueryPagination(QueryPagination$.MODULE$.apply$default$1(), QueryPagination$.MODULE$.apply$default$2()).withLimit(limit).withSkip(skip);
            QueryProjection queryProjection = this.asQueryProjection(distinct2, returnItems, false).withPagination(queryPagination).withSelection(selections);
            InterestingOrder requiredOrder = this.findRequiredOrder((QueryHorizon)queryProjection, (Option<OrderBy>)orderBy);
            return builder.withHorizon((QueryHorizon)queryProjection).withInterestingOrder(requiredOrder).withPropagatedTailInterestingOrder().withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(new QueryGraph(QueryGraph$.MODULE$.apply$default$1(), QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8(), QueryGraph$.MODULE$.apply$default$9()), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
        }
        throw new InternalException("AST needs to be rewritten before it can be used for planning. Got: " + clause);
    }

    private PlannerQueryBuilder addUnwindToLogicalPlanInput(PlannerQueryBuilder builder, Unwind clause) {
        return builder.withHorizon((QueryHorizon)new UnwindProjection(clause.variable().name(), clause.expression())).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addCallToLogicalPlanInput(PlannerQueryBuilder builder, ResolvedCall call) {
        return builder.withHorizon(new ProcedureCallProjection(call)).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addForeachToLogicalPlanInput(PlannerQueryBuilder builder, Foreach clause, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker) {
        scala.collection.immutable.Set<String> currentlyAvailableVariables = builder.currentlyAvailableVariables();
        Variable foreachVariable = clause.variable();
        PlannerQueryBuilder innerBuilder = new PlannerQueryBuilder((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty(), builder.semanticTable()).amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$26 -> {
            String string = foreachVariable.name();
            return x$26.addArgumentIds((Seq)currentlyAvailableVariables.toIndexedSeq().$plus$colon((Object)string));
        }).withHorizon((QueryHorizon)new PassthroughAllHorizon());
        SinglePlannerQuery innerPlannerQuery = StatementConverters$.MODULE$.addClausesToPlannerQueryBuilder((Seq<Clause>)clause.updates(), innerBuilder, anonymousVariableNameGenerator, cancellationChecker, false).build();
        ForeachPattern foreachPattern = new ForeachPattern(clause.variable().name(), clause.expression(), innerPlannerQuery);
        scala.collection.immutable.Set<String> x$1 = currentlyAvailableVariables;
        IndexedSeq x$2 = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ForeachPattern[]{foreachPattern}));
        scala.collection.immutable.Set x$3 = QueryGraph$.MODULE$.apply$default$1();
        scala.collection.immutable.Set x$4 = QueryGraph$.MODULE$.apply$default$2();
        scala.collection.immutable.Set x$5 = QueryGraph$.MODULE$.apply$default$3();
        Selections x$6 = QueryGraph$.MODULE$.apply$default$5();
        IndexedSeq x$7 = QueryGraph$.MODULE$.apply$default$6();
        scala.collection.immutable.Set x$8 = QueryGraph$.MODULE$.apply$default$7();
        scala.collection.immutable.Set x$9 = QueryGraph$.MODULE$.apply$default$8();
        QueryGraph foreachGraph = new QueryGraph(x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$2);
        return builder.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(foreachGraph, RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())).withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(RegularSinglePlannerQuery$.MODULE$.apply$default$1(), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
    }

    private PlannerQueryBuilder addRemoveToLogicalPlanInput(PlannerQueryBuilder acc, Remove clause) {
        return (PlannerQueryBuilder)clause.items().foldLeft((Object)acc, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemoveLabelItem) {
                    RemoveLabelItem removeLabelItem = (RemoveLabelItem)removeItem;
                    LogicalVariable variable = removeLabelItem.variable();
                    Seq labelNames = removeLabelItem.labels();
                    return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$27 -> x$27.addMutatingPatterns((MutatingPattern)new RemoveLabelPattern(variable.name(), labelNames)));
                }
            }
            if (tuple2 != null) {
                RemovePropertyItem removePropertyItem;
                LogicalProperty logicalProperty;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemovePropertyItem && (logicalProperty = (removePropertyItem = (RemovePropertyItem)removeItem).property()) instanceof Property) {
                    Property property = (Property)logicalProperty;
                    Expression variable = property.map();
                    PropertyKeyName propertyKey = property.propertyKey();
                    if (variable instanceof Variable) {
                        Variable variable2 = (Variable)variable;
                        if (acc.semanticTable().isNode((Expression)variable2)) {
                            return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$28 -> x$28.addMutatingPatterns((MutatingPattern)new SetNodePropertyPattern(variable2.name(), propertyKey, (Expression)new Null(propertyKey.position()))));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                RemovePropertyItem removePropertyItem;
                LogicalProperty logicalProperty;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemovePropertyItem && (logicalProperty = (removePropertyItem = (RemovePropertyItem)removeItem).property()) instanceof Property) {
                    Property property = (Property)logicalProperty;
                    Expression variable = property.map();
                    PropertyKeyName propertyKey = property.propertyKey();
                    if (variable instanceof Variable) {
                        Variable variable3 = (Variable)variable;
                        if (acc.semanticTable().isRelationship((Expression)variable3)) {
                            return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$29 -> x$29.addMutatingPatterns((MutatingPattern)new SetRelationshipPropertyPattern(variable3.name(), propertyKey, (Expression)new Null(propertyKey.position()))));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                RemovePropertyItem removePropertyItem;
                LogicalProperty logicalProperty;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemovePropertyItem && (logicalProperty = (removePropertyItem = (RemovePropertyItem)removeItem).property()) instanceof Property) {
                    Property property = (Property)logicalProperty;
                    Expression variable = property.map();
                    PropertyKeyName propertyKey = property.propertyKey();
                    return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$30 -> x$30.addMutatingPatterns((MutatingPattern)new SetPropertyPattern(variable, propertyKey, (Expression)new Null(propertyKey.position()))));
                }
            }
            if (tuple2 != null) {
                RemoveItem other = (RemoveItem)tuple2._2();
                throw new InternalException("REMOVE " + other + " not supported in cost planner yet");
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private boolean containsAggregateOutsideOfAggregatingHorizon(Expression expr) {
        return BoxesRunTime.unboxToBoolean((Object)expr.folder().treeFold((Object)BoxesRunTime.boxToBoolean((boolean)false), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 instanceof AggregatingQueryProjection) {
                    return (B1)(Function1 & Serializable)x$31 -> anonfun.containsAggregateOutsideOfAggregatingHorizon.1.$anonfun$applyOrElse$3(BoxesRunTime.unboxToBoolean((Object)x$31));
                }
                if (A1 != null && !(option = IsAggregate$.MODULE$.unapply(A1)).isEmpty()) {
                    return (B1)(Function1 & Serializable)x$32 -> anonfun.containsAggregateOutsideOfAggregatingHorizon.1.$anonfun$applyOrElse$4(BoxesRunTime.unboxToBoolean((Object)x$32));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Option option;
                Object object = x1;
                if (object instanceof AggregatingQueryProjection) {
                    return true;
                }
                return object != null && !(option = IsAggregate$.MODULE$.unapply(object)).isEmpty();
            }

            public static final /* synthetic */ Foldable.SkipChildren $anonfun$applyOrElse$3(boolean x$31) {
                return new Foldable.SkipChildren((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }

            public static final /* synthetic */ Foldable.SkipChildren $anonfun$applyOrElse$4(boolean x$32) {
                return new Foldable.SkipChildren((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3$adapted(java.lang.Object ), $anonfun$applyOrElse$4$adapted(java.lang.Object )}, serializedLambda);
            }
        }));
    }

    private static final Map turnIntoMap$1(Seq x) {
        return ((IterableOnceOps)x.map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.expression()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Seq $anonfun$interestingOrderCandidatesForGroupingExpressions$3(Seq orderings$1, Expression prop) {
        return (Seq)orderings$1.map((Function1 & Serializable)indexOrder -> new InterestingOrderCandidate((Seq)new .colon.colon((Object)((Product)indexOrder.apply((Object)prop)), (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ boolean $anonfun$addCreateToLogicalPlanInput$2(scala.collection.mutable.Set seenPatternNodes$1, ClauseConverters.CreateNodeCommand x0$2) {
        ClauseConverters.CreateNodeCommand createNodeCommand = x0$2;
        if (createNodeCommand != null) {
            CreateNode pattern = createNodeCommand.create();
            return seenPatternNodes$1.apply((Object)pattern.idName());
        }
        throw new MatchError((Object)createNodeCommand);
    }

    public static final /* synthetic */ void $anonfun$addCreateToLogicalPlanInput$1(ArrayBuffer nodes$1, scala.collection.mutable.Set seenPatternNodes$1, ArrayBuffer relationships$1, Create clause$1, PatternPart x0$1) {
        PatternElement pattern;
        boolean bl = false;
        EveryPath everyPath = null;
        PatternPart patternPart = x0$1;
        if (patternPart instanceof EveryPath) {
            bl = true;
            everyPath = (EveryPath)patternPart;
            PatternElement patternElement = everyPath.element();
            if (patternElement instanceof NodePattern) {
                NodePattern nodePattern = (NodePattern)patternElement;
                Option option = nodePattern.variable();
                Option labelExpression = nodePattern.labelExpression();
                Option props = nodePattern.properties();
                Option option2 = nodePattern.predicate();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogicalVariable id = (LogicalVariable)some.value();
                    if (None$.MODULE$.equals(option2)) {
                        scala.collection.immutable.Set<LabelName> labels = MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$getLabelNameSet((Option<LabelExpression>)labelExpression);
                        nodes$1.$plus$eq((Object)new CreateNode(id.name(), labels, props));
                        seenPatternNodes$1.$plus$eq((Object)id.name());
                        return;
                    }
                }
            }
        }
        if (bl && (pattern = everyPath.element()) instanceof RelationshipChain) {
            RelationshipChain relationshipChain = (RelationshipChain)pattern;
            Tuple2<Vector<ClauseConverters.CreateNodeCommand>, Vector<ClauseConverters.CreateRelCommand>> tuple2 = MODULE$.allCreatePatterns((PatternElement)relationshipChain);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Vector currentNodes = (Vector)tuple2._1();
            Vector currentRelationships = (Vector)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)currentNodes, (Object)currentRelationships);
            Vector currentNodes2 = (Vector)tuple22._1();
            Vector currentRelationships2 = (Vector)tuple22._2();
            IndexedSeq<ClauseConverters.CreateNodeCommand> dedupedNodes = MODULE$.dedup((Vector<ClauseConverters.CreateNodeCommand>)currentNodes2);
            Tuple2 tuple23 = dedupedNodes.partition((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$addCreateToLogicalPlanInput$2(seenPatternNodes$1, x0$2)));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            IndexedSeq nodesCreatedBefore = (IndexedSeq)tuple23._1();
            IndexedSeq nodesToCreate = (IndexedSeq)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)nodesCreatedBefore, (Object)nodesToCreate);
            IndexedSeq nodesCreatedBefore2 = (IndexedSeq)tuple24._1();
            IndexedSeq nodesToCreate2 = (IndexedSeq)tuple24._2();
            nodesCreatedBefore2.collectFirst((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends ClauseConverters.CreateNodeCommand, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    CreateNode c;
                    A1 A1 = x1;
                    if (A1 != null && ((c = A1.create()).labels().nonEmpty() || c.properties().nonEmpty())) {
                        throw new SyntaxException("Can't create node `" + c.idName() + "` with labels or properties here. The variable is already declared in this context");
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(ClauseConverters.CreateNodeCommand x1) {
                    CreateNode c;
                    ClauseConverters.CreateNodeCommand createNodeCommand = x1;
                    return createNodeCommand != null && ((c = createNodeCommand.create()).labels().nonEmpty() || c.properties().nonEmpty());
                }
            });
            nodes$1.$plus$plus$eq((IterableOnce)nodesToCreate2.map((Function1 & Serializable)x$12 -> x$12.create()));
            seenPatternNodes$1.$plus$plus$eq((IterableOnce)nodesToCreate2.map((Function1 & Serializable)x$13 -> x$13.create().idName()));
            relationships$1.$plus$plus$eq((IterableOnce)currentRelationships2.map((Function1 & Serializable)x$14 -> x$14.create()));
            return;
        }
        throw new InternalException("Received an AST-clause that has no representation the QG: " + clause$1);
    }

    public static final /* synthetic */ boolean $anonfun$dedup$1(scala.collection.mutable.Set seen$1, ListBuffer result$1, ClauseConverters.CreateNodeCommand x0$1) {
        ClauseConverters.CreateNodeCommand createNodeCommand = x0$1;
        if (createNodeCommand != null) {
            CreateNode pattern = createNodeCommand.create();
            if (!seen$1.apply((Object)pattern.idName())) {
                v0 = result$1.$plus$eq((Object)createNodeCommand);
            } else {
                if (pattern.labels().nonEmpty() || pattern.properties().nonEmpty()) {
                    throw new SyntaxException("Can't create node `" + pattern.idName() + "` with labels or properties here. The variable is already declared in this context");
                }
                v0 = BoxedUnit.UNIT;
            }
            return seen$1.add((Object)pattern.idName());
        }
        throw new MatchError((Object)createNodeCommand);
    }

    private static final boolean qppHasDependencyToPreviousClauses$1(PatternConverters.DestructResult patternContent$1, PlannerQueryBuilder acc$2) {
        scala.collection.immutable.Set qppDependencies = ((IterableOnceOps)patternContent$1.quantifiedPathPatterns().flatMap((Function1 & Serializable)x$19 -> x$19.dependencies())).toSet();
        scala.collection.immutable.Set<String> availableVars = acc$2.currentlyAvailableVariables();
        return qppDependencies.intersect(availableVars).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$addMergeToLogicalPlanInput$2(Set seenPatternNodes$2, ClauseConverters.CreateNodeCommand x0$1) {
        ClauseConverters.CreateNodeCommand createNodeCommand = x0$1;
        if (createNodeCommand != null) {
            CreateNode pattern = createNodeCommand.create();
            return seenPatternNodes$2.apply((Object)pattern.idName());
        }
        throw new MatchError((Object)createNodeCommand);
    }

    public static final /* synthetic */ boolean $anonfun$addMergeToLogicalPlanInput$3(Set seenPatternNodes$2, ClauseConverters.CreateNodeCommand x0$2) {
        ClauseConverters.CreateNodeCommand createNodeCommand = x0$2;
        if (createNodeCommand != null) {
            CreateNode pattern = createNodeCommand.create();
            return seenPatternNodes$2.apply((Object)pattern.idName());
        }
        throw new MatchError((Object)createNodeCommand);
    }

    private static final boolean optionalMatchesOK$1(Option where, PlannerQueryBuilder builder$2, Option nextClause$1) {
        Match match;
        Some some;
        Clause m;
        Option option;
        return !builder$2.currentQueryGraph().hasOptionalPatterns() || where.isEmpty() && (option = nextClause$1) instanceof Some && (m = (Clause)(some = (Some)option).value()) instanceof Match && (match = (Match)m).optional();
    }

    private static final boolean noUpdates$1(PlannerQueryBuilder builder$2) {
        return !builder$2.currentQueryGraph().containsUpdates() && builder$2.readOnly();
    }

    private static final boolean noShortestPaths$1(PlannerQueryBuilder builder$2) {
        return builder$2.currentQueryGraph().shortestPathPatterns().isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$addWithToLogicalPlanInput$1(ReturnItem x0$1) {
        ReturnItem returnItem = x0$1;
        if (!(returnItem instanceof AliasedReturnItem)) throw new InternalException("This should have been rewritten to an AliasedReturnItem.");
        AliasedReturnItem aliasedReturnItem = (AliasedReturnItem)returnItem;
        if (MODULE$.containsAggregateOutsideOfAggregatingHorizon(aliasedReturnItem.expression())) return false;
        Expression expression = aliasedReturnItem.expression();
        LogicalVariable logicalVariable = aliasedReturnItem.variable();
        if (expression != null) {
            if (!expression.equals(logicalVariable)) return false;
            return true;
        }
        if (logicalVariable == null) return true;
        return false;
    }

    private static final boolean returnItemsOK$1(ReturnItems ri) {
        return ri.items().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$addWithToLogicalPlanInput$1(x0$1)));
    }

    private ClauseConverters$() {
    }
}

