/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.ProcedureResultItem;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.UnresolvedCall;
import org.neo4j.cypher.internal.compiler.DeprecatedFieldNotification;
import org.neo4j.cypher.internal.compiler.ProcedureWarningNotification;
import org.neo4j.cypher.internal.compiler.phases.ProcedureWarnings$;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.VisitorPhase;
import org.neo4j.cypher.internal.logical.plans.FieldSignature;
import org.neo4j.cypher.internal.logical.plans.ProcedureSignature;
import org.neo4j.cypher.internal.logical.plans.QualifiedName;
import org.neo4j.cypher.internal.logical.plans.ResolvedCall;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.StepSequencer;
import org.neo4j.exceptions.InternalException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ProcedureWarnings$
implements VisitorPhase<BaseContext, BaseState>,
Product,
Serializable {
    public static final ProcedureWarnings$ MODULE$ = new ProcedureWarnings$();

    static {
        Transformer.$init$((Transformer)MODULE$);
        Phase.$init$((Phase)MODULE$);
        VisitorPhase.$init$((VisitorPhase)MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Object process(Object from, BaseContext context) {
        return VisitorPhase.process$((VisitorPhase)this, (Object)from, (BaseContext)context);
    }

    public Set<StepSequencer.Condition> postConditions() {
        return VisitorPhase.postConditions$((VisitorPhase)this);
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions) {
        return Transformer.checkConditions$((Transformer)this, (Object)state, conditions);
    }

    public void visit(BaseState value, BaseContext context) {
        Set<InternalNotification> warnings = this.findWarnings(value.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1 & Serializable)notification -> {
            internalNotificationLogger.log(notification);
            return BoxedUnit.UNIT;
        });
    }

    private Set<InternalNotification> findWarnings(Statement statement) {
        return (Set)statement.folder().treeFold((Object)Predef$.MODULE$.Set().empty(), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                ResolvedCall resolvedCall = null;
                A1 A1 = x1;
                if (A1 instanceof ResolvedCall) {
                    bl = true;
                    resolvedCall = (ResolvedCall)A1;
                    ProcedureSignature procedureSignature = resolvedCall.signature();
                    if (procedureSignature != null) {
                        QualifiedName name = procedureSignature.name();
                        Option option = procedureSignature.warning();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String warning = (String)some.value();
                            return (B1)(Function1 & Serializable)seq -> new Foldable.SkipChildren((Object)seq.$plus((Object)new ProcedureWarningNotification(resolvedCall.position(), name.toString(), warning)));
                        }
                    }
                }
                if (bl) {
                    ProcedureSignature procedureSignature = resolvedCall.signature();
                    IndexedSeq results = resolvedCall.callResults();
                    if (procedureSignature != null) {
                        QualifiedName name = procedureSignature.name();
                        Option option = procedureSignature.outputSignature();
                        Option option2 = procedureSignature.deprecationInfo();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            IndexedSeq output = (IndexedSeq)some.value();
                            if (None$.MODULE$.equals(option2) && output.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findWarnings.1.$anonfun$applyOrElse$4(x$1)))) {
                                return (B1)(Function1 & Serializable)set -> new Foldable.SkipChildren((Object)set.$plus$plus(ProcedureWarnings$.MODULE$.org$neo4j$cypher$internal$compiler$phases$ProcedureWarnings$$usedDeprecatedFields(name.toString(), (Seq<ProcedureResultItem>)results, (Seq<FieldSignature>)output)));
                            }
                        }
                    }
                }
                if (A1 instanceof UnresolvedCall) {
                    throw new InternalException("Expected procedures to have been resolved already");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                ProcedureSignature procedureSignature;
                boolean bl = false;
                ResolvedCall resolvedCall = null;
                Object object = x1;
                if (object instanceof ResolvedCall) {
                    Option option;
                    bl = true;
                    resolvedCall = (ResolvedCall)object;
                    ProcedureSignature procedureSignature2 = resolvedCall.signature();
                    if (procedureSignature2 != null && (option = procedureSignature2.warning()) instanceof Some) {
                        return true;
                    }
                }
                if (bl && (procedureSignature = resolvedCall.signature()) != null) {
                    Option option = procedureSignature.outputSignature();
                    Option option2 = procedureSignature.deprecationInfo();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        IndexedSeq output = (IndexedSeq)some.value();
                        if (None$.MODULE$.equals(option2) && output.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findWarnings.1.$anonfun$isDefinedAt$1(x$1)))) {
                            return true;
                        }
                    }
                }
                return object instanceof UnresolvedCall;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$4(FieldSignature x$1) {
                return x$1.deprecated();
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(FieldSignature x$1) {
                return x$1.deprecated();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.neo4j.cypher.internal.logical.plans.ResolvedCall org.neo4j.cypher.internal.logical.plans.QualifiedName java.lang.String scala.collection.immutable.Set ), $anonfun$applyOrElse$4$adapted(org.neo4j.cypher.internal.logical.plans.FieldSignature ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.logical.plans.QualifiedName scala.collection.immutable.IndexedSeq scala.collection.immutable.IndexedSeq scala.collection.immutable.Set ), $anonfun$isDefinedAt$1$adapted(org.neo4j.cypher.internal.logical.plans.FieldSignature )}, serializedLambda);
            }
        });
    }

    public Seq<DeprecatedFieldNotification> org$neo4j$cypher$internal$compiler$phases$ProcedureWarnings$$usedDeprecatedFields(String procedure, Seq<ProcedureResultItem> used, Seq<FieldSignature> available) {
        return (Seq)((IterableOps)used.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)available.exists((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)ProcedureWarnings$.$anonfun$usedDeprecatedFields$2(r, o)))))).map((Function1 & Serializable)r -> new DeprecatedFieldNotification(r.position(), procedure, r.outputName()));
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    public String productPrefix() {
        return "ProcedureWarnings";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcedureWarnings$;
    }

    public int hashCode() {
        return -2016614358;
    }

    public String toString() {
        return "ProcedureWarnings";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProcedureWarnings$.class);
    }

    public static final /* synthetic */ boolean $anonfun$usedDeprecatedFields$2(ProcedureResultItem r$1, FieldSignature o) {
        String string = o.name();
        String string2 = r$1.outputName();
        return !(string != null ? !string.equals(string2) : string2 != null) && o.deprecated();
    }

    private ProcedureWarnings$() {
    }
}

