/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.collection;

import java.util.Comparator;
import java.util.Iterator;
import org.neo4j.cypher.internal.collection.MemoryTrackingHeap;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class DefaultComparatorSortTable<T>
extends MemoryTrackingHeap<T> {
    private static final long SHALLOW_INSTANCE_SIZE = HeapEstimator.shallowSizeOfInstance(DefaultComparatorSortTable.class);

    public DefaultComparatorSortTable(Comparator<? super T> comparator, int initialSize) {
        this(comparator, initialSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public DefaultComparatorSortTable(Comparator<? super T> comparator, int initialSize, MemoryTracker memoryTracker) {
        super(comparator.reversed(), initialSize, memoryTracker, SHALLOW_INSTANCE_SIZE);
    }

    public int getSize() {
        return this.size;
    }

    public void reset() {
        this.clear();
    }

    @VisibleForTesting
    Iterator<T> unorderedIterator() {
        return this.getIterator();
    }

    public boolean add(T e) {
        return super.insert(e);
    }

    public T peek() {
        return (T)this.heap[0];
    }

    public T poll() {
        Object result = this.heap[0];
        if (result != null) {
            int n = --this.size;
            Object x = this.heap[n];
            this.heap[n] = null;
            if (n > 0) {
                this.siftDown(0, x, n);
            }
        }
        return (T)result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void siftDown(T x) {
        super.siftDown(0, x, this.size);
    }

    @Override
    protected void overflow(long maxSize) {
        throw CypherExecutionException.internalError((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Sort table cannot hold more than " + maxSize + " elements."));
    }
}

