/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public interface MREValidator {
    public static final MREValidator TRAIL_MODE = (direction, depth, rels, relCursor) -> {
        boolean isUnique = true;
        switch (direction) {
            case FORWARD: {
                for (int i = 0; i < depth && isUnique; ++i) {
                    isUnique = rels[i].id() != relCursor.relationshipReference();
                }
                break;
            }
            case BACKWARD: {
                for (int i = rels.length - 1; i > rels.length - depth - 1 && isUnique; --i) {
                    isUnique = rels[i].id() != relCursor.relationshipReference();
                }
                break;
            }
        }
        return isUnique;
    };
    public static final MREValidator WALK_MODE = (direction, depth, rels, relCursor) -> true;

    public boolean validateRelationships(TraversalDirection var1, int var2, VirtualRelationshipValue[] var3, RelationshipTraversalEntities var4);
}

