/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks;

import java.io.Serializable;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005m3AAC\u0006\u0001=!)1\u0005\u0001C\u0001I!9a\u0005\u0001b\u0001\n\u00039\u0003B\u0002\u001c\u0001A\u0003%\u0001\u0006C\u00048\u0001\t\u0007I\u0011\u0001\u001d\t\ru\u0002\u0001\u0015!\u0003:\u0011\u0015q\u0004\u0001\"\u0011@\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015I\u0006\u0001\"\u0011[\u0005Q1\u0016n];bY&T\u0018N\\4Q!\n\u001b\u0006j\\8lg*\u0011A\"D\u0001\u0006Q>|7n\u001d\u0006\u0003\u001d=\tQ\u0001\u001d9cMNT!\u0001E\t\u0002\u0013Q\u0014\u0018M^3sg\u0006d'B\u0001\n\u0014\u0003\u001dAW\r\u001c9feNT!\u0001F\u000b\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0017/\u000511.\u001a:oK2T!\u0001G\r\u0002\u0011%tG/\u001a:oC2T!AG\u000e\u0002\u000b9,w\u000e\u000e6\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\nS\"A\u0006\n\u0005\tZ!A\u0003)Q\u0005\u001a\u001b\u0006j\\8lg\u00061A(\u001b8jiz\"\u0012!\n\t\u0003A\u0001\tQA\\8eKN,\u0012\u0001\u000b\t\u0004SA\u0012T\"\u0001\u0016\u000b\u0005-b\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003[9\n!bY8mY\u0016\u001cG/[8o\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019+\u0005\u001dA\u0015m\u001d5TKR\u0004\"a\r\u001b\u000e\u00035I!!N\u0007\u0003\u00139{G-Z*uCR,\u0017A\u00028pI\u0016\u001c\b%\u0001\u0003sK2\u001cX#A\u001d\u0011\u0007%\u0002$\b\u0005\u00024w%\u0011A(\u0004\u0002\u000f)^|w+Y=TS\u001et\u0007o\\:u\u0003\u0015\u0011X\r\\:!\u0003!!\u0017n]2pm\u0016\u0014Hc\u0001!E\rB\u0011\u0011IQ\u0007\u0002]%\u00111I\f\u0002\u0005+:LG\u000fC\u0003F\r\u0001\u0007!'\u0001\u0003o_\u0012,\u0007\"B$\u0007\u0001\u0004A\u0015!\u00033je\u0016\u001cG/[8o!\t\u0019\u0014*\u0003\u0002K\u001b\t\u0011BK]1wKJ\u001c\u0018\r\u001c#je\u0016\u001cG/[8o\u0003E\tG\rZ*pkJ\u001cWmU5h]B|7\u000f\u001e\u000b\u0004\u00016{\u0005\"\u0002(\b\u0001\u0004Q\u0014\u0001C:jO:\u0004xn\u001d;\t\u000bA;\u0001\u0019A)\u0002!1,gn\u001a;i\rJ|WnU8ve\u000e,\u0007CA!S\u0013\t\u0019fFA\u0002J]R\f\u0011#\u00193e)\u0006\u0014x-\u001a;TS\u001et\u0007o\\:u)\r\u0001ek\u0016\u0005\u0006\u001d\"\u0001\rA\u000f\u0005\u00061\"\u0001\r!U\u0001\u000fY\u0016tw\r\u001e5U_R\u000b'oZ3u\u0003!1\u0017N\\5tQ\u0016$G#\u0001!")
public class VisualizingPPBSHooks
extends PPBFSHooks {
    private final HashSet<NodeState> nodes = HashSet$.MODULE$.empty();
    private final HashSet<TwoWaySignpost> rels = HashSet$.MODULE$.empty();

    public HashSet<NodeState> nodes() {
        return this.nodes;
    }

    public HashSet<TwoWaySignpost> rels() {
        return this.rels;
    }

    @Override
    public void discover(NodeState node, TraversalDirection direction) {
        this.nodes().add((Object)node);
    }

    @Override
    public void addSourceSignpost(TwoWaySignpost signpost, int lengthFromSource) {
        this.rels().add((Object)signpost);
    }

    @Override
    public void addTargetSignpost(TwoWaySignpost signpost, int lengthToTarget) {
        this.rels().add((Object)signpost);
    }

    @Override
    public void finished() {
        String vertices = ((IterableOnceOps)((IterableOps)this.nodes().toSeq().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.id()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)n -> VisualizingPPBSHooks.nodeName$1(n))).mkString("\n");
        String edges = ((IterableOnceOps)this.rels().map((Function1 & Serializable)rel -> {
            StringBuilder sb = new StringBuilder().append(VisualizingPPBSHooks.nodeName$1(rel.prevNode)).append(" -> ").append(VisualizingPPBSHooks.nodeName$1(rel.forwardNode)).append("[");
            Object object = !rel.lengths.isEmpty() ? sb.append("headlabel=<<font color=\"darkgreen\">").append(rel.lengths.renderSourceLengths()).append("</font>>") : BoxedUnit.UNIT;
            Object object2 = rel.minTargetDistance() != -1 ? sb.append(" taillabel=<<font color=\"purple\">").append(rel.minTargetDistance()).append("</font>>") : BoxedUnit.UNIT;
            return sb.append("]").append(";").toString();
        })).mkString("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("edge[weight=1000 style=invis]\n");
        this.nodes().groupBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)VisualizingPPBSHooks.$anonfun$finished$4(x$2))).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HashSet ns = (HashSet)tuple2._2();
                return sb.append(((IterableOnceOps)((IterableOps)ns.toSeq().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.id()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)n -> VisualizingPPBSHooks.nodeName$1(n))).mkString(" -> ")).append("\n");
            }
            throw new MatchError((Object)tuple2);
        });
        String columns = sb.toString();
        String ranks = ((IterableOnceOps)this.nodes().groupBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.id())).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                HashSet ns = (HashSet)tuple2._2();
                StringBuilder sb = new StringBuilder();
                sb.append("rank=same { edge[weight=1000 style=invis] ");
                sb.append(((IterableOnceOps)((IterableOps)ns.toSeq().sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)VisualizingPPBSHooks.$anonfun$finished$10(x$5)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)n -> VisualizingPPBSHooks.nodeName$1(n))).mkString(" -> "));
                sb.append("}");
                return sb.toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n");
        String graph = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |digraph {\n                   |// styling\n                   |edge[labelfontsize=7 arrowsize=0.3 penwidth=0.5 labelfontname=courier]\n                   |node[fontsize=8 fontname=courier]\n                   |\n                   |// node states\n                   |" + vertices + "\n                   |\n                   |// signposts\n                   |" + edges + "\n                   |\n                   |// these invisible heavily-weighted edges force the layout engine to form a grid:\n                   |\n                   |" + columns + "\n                   |" + ranks + "\n                   |}"));
        Predef$.MODULE$.println((Object)graph);
    }

    private static final String nodeName$1(NodeState n) {
        String string;
        SlotOrName slotOrName = n.state().slotOrName();
        if (slotOrName instanceof SlotOrName.VarName) {
            String name;
            SlotOrName.VarName varName = (SlotOrName.VarName)slotOrName;
            string = name = varName.name();
        } else {
            string = Integer.toString(n.state().id());
        }
        String state = string;
        return "\"(" + n.id() + "," + state + ")\"";
    }

    public static final /* synthetic */ int $anonfun$finished$4(NodeState x$2) {
        return x$2.state().id();
    }

    public static final /* synthetic */ int $anonfun$finished$10(NodeState x$5) {
        return x$5.state().id();
    }
}

