/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.profiling;

import org.neo4j.cypher.result.OperatorProfile;
import org.neo4j.internal.schema.IndexDescriptor;

public class ProfilingTracerData
implements OperatorProfile {
    private long time;
    private long dbHits;
    private long rows;
    private long pageCacheHits;
    private long pageCacheMisses;
    private long maxAllocatedMemory;

    public void update(long time, long dbHits, long rows, long pageCacheHits, long pageCacheMisses, long maxAllocatedMemory) {
        this.time += time;
        this.dbHits += dbHits;
        this.rows += rows;
        this.pageCacheHits += pageCacheHits;
        this.pageCacheMisses += pageCacheMisses;
        this.maxAllocatedMemory += maxAllocatedMemory;
    }

    @Override
    public long time() {
        return this.time;
    }

    @Override
    public long dbHits() {
        return this.dbHits;
    }

    @Override
    public long rows() {
        return this.rows;
    }

    @Override
    public long pageCacheHits() {
        return this.pageCacheHits;
    }

    @Override
    public long pageCacheMisses() {
        return this.pageCacheMisses;
    }

    @Override
    public long maxAllocatedMemory() {
        return this.maxAllocatedMemory;
    }

    @Override
    public IndexDescriptor[] indexesUsed() {
        return new IndexDescriptor[0];
    }

    @Override
    public int[] indexUseCount() {
        return new int[0];
    }

    public void sanitize() {
        if (this.time < -1L) {
            this.time = -1L;
        }
        if (this.dbHits < -1L) {
            this.dbHits = -1L;
        }
        if (this.rows < -1L) {
            this.rows = -1L;
        }
        if (this.pageCacheHits < -1L) {
            this.pageCacheHits = -1L;
        }
        if (this.pageCacheMisses < -1L) {
            this.pageCacheMisses = -1L;
        }
        if (this.maxAllocatedMemory < -1L) {
            this.maxAllocatedMemory = -1L;
        }
    }

    public int hashCode() {
        return OperatorProfile.hashCode(this);
    }

    public boolean equals(Object o) {
        return OperatorProfile.equals(this, o);
    }

    public String toString() {
        return OperatorProfile.toString(this);
    }
}

