/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.v3_5.util.CypherTypeException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CypherCoercions {
    private static final Map<Class<? extends Neo4jTypes.AnyType>, Coercer> CONVERTERS = new HashMap<Class<? extends Neo4jTypes.AnyType>, Coercer>();

    private CypherCoercions() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static TextValue asTextValue(AnyValue value) {
        if (!(value instanceof TextValue)) {
            throw CypherCoercions.cantCoerce(value, "String");
        }
        return (TextValue)value;
    }

    public static NodeValue asNodeValue(AnyValue value) {
        if (!(value instanceof NodeValue)) {
            throw CypherCoercions.cantCoerce(value, "Node");
        }
        return (NodeValue)value;
    }

    public static RelationshipValue asRelationshipValue(AnyValue value) {
        if (!(value instanceof RelationshipValue)) {
            throw CypherCoercions.cantCoerce(value, "Relationship");
        }
        return (RelationshipValue)value;
    }

    public static PathValue asPathValue(AnyValue value) {
        if (!(value instanceof PathValue)) {
            throw CypherCoercions.cantCoerce(value, "Path");
        }
        return (PathValue)value;
    }

    public static IntegralValue asIntegralValue(AnyValue value) {
        if (!(value instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value, "Integer");
        }
        return Values.longValue((long)((NumberValue)value).longValue());
    }

    public static FloatingPointValue asFloatingPointValue(AnyValue value) {
        if (!(value instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value, "Float");
        }
        return Values.doubleValue((double)((NumberValue)value).doubleValue());
    }

    public static BooleanValue asBooleanValue(AnyValue value) {
        if (!(value instanceof BooleanValue)) {
            throw CypherCoercions.cantCoerce(value, "Boolean");
        }
        return (BooleanValue)value;
    }

    public static NumberValue asNumberValue(AnyValue value) {
        if (!(value instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value, "Number");
        }
        return (NumberValue)value;
    }

    public static PointValue asPointValue(AnyValue value) {
        if (!(value instanceof PointValue)) {
            throw CypherCoercions.cantCoerce(value, "Point");
        }
        return (PointValue)value;
    }

    public static DateValue asDateValue(AnyValue value) {
        if (!(value instanceof DateValue)) {
            throw CypherCoercions.cantCoerce(value, "Date");
        }
        return (DateValue)value;
    }

    public static TimeValue asTimeValue(AnyValue value) {
        if (!(value instanceof TimeValue)) {
            throw CypherCoercions.cantCoerce(value, "Time");
        }
        return (TimeValue)value;
    }

    public static LocalTimeValue asLocalTimeValue(AnyValue value) {
        if (!(value instanceof LocalTimeValue)) {
            throw CypherCoercions.cantCoerce(value, "LocalTime");
        }
        return (LocalTimeValue)value;
    }

    public static LocalDateTimeValue asLocalDateTimeValue(AnyValue value) {
        if (!(value instanceof LocalDateTimeValue)) {
            throw CypherCoercions.cantCoerce(value, "LocalDateTime");
        }
        return (LocalDateTimeValue)value;
    }

    public static DateTimeValue asDateTimeValue(AnyValue value) {
        if (!(value instanceof DateTimeValue)) {
            throw CypherCoercions.cantCoerce(value, "DateTime");
        }
        return (DateTimeValue)value;
    }

    public static DurationValue asDurationValue(AnyValue value) {
        if (!(value instanceof DurationValue)) {
            throw CypherCoercions.cantCoerce(value, "Duration");
        }
        return (DurationValue)value;
    }

    public static MapValue asMapValue(AnyValue value, DbAccess access) {
        if (value instanceof MapValue) {
            return (MapValue)value;
        }
        if (value instanceof NodeValue) {
            return access.nodeAsMap(((NodeValue)value).id());
        }
        if (value instanceof RelationshipValue) {
            return access.relationshipAsMap(((RelationshipValue)value).id());
        }
        throw CypherCoercions.cantCoerce(value, "Map");
    }

    public static ListValue asList(AnyValue value, Neo4jTypes.AnyType innerType, DbAccess access) {
        return new ListCoercer().apply(value, innerType, access);
    }

    private static CypherTypeException cantCoerce(AnyValue value, String type) {
        return new CypherTypeException(String.format("Can't coerce `%s` to %s", value, type), null);
    }

    private AnyValue coerceTo(AnyValue value, DbAccess access, Neo4jTypes.AnyType types) {
        Coercer function = CONVERTERS.get(types.getClass());
        return function.apply(value, types, access);
    }

    private static Neo4jTypes.AnyType nextInner(Neo4jTypes.AnyType type) {
        if (type instanceof Neo4jTypes.ListType) {
            return ((Neo4jTypes.ListType)type).innerType();
        }
        return type;
    }

    private static ListValue fastListConversion(AnyValue value) {
        if (value instanceof ListValue) {
            return (ListValue)value;
        }
        if (value instanceof ArrayValue) {
            return VirtualValues.fromArray((ArrayValue)((ArrayValue)value));
        }
        if (value instanceof PathValue) {
            return ((PathValue)value).asList();
        }
        throw CypherCoercions.cantCoerce(value, "List");
    }

    static {
        CONVERTERS.put(Neo4jTypes.NTAny.getClass(), (a, ignore1, ignore2) -> a);
        CONVERTERS.put(Neo4jTypes.NTString.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asTextValue(a));
        CONVERTERS.put(Neo4jTypes.NTNumber.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asNumberValue(a));
        CONVERTERS.put(Neo4jTypes.NTInteger.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asIntegralValue(a));
        CONVERTERS.put(Neo4jTypes.NTFloat.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asFloatingPointValue(a));
        CONVERTERS.put(Neo4jTypes.NTBoolean.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asBooleanValue(a));
        CONVERTERS.put(Neo4jTypes.NTMap.getClass(), (a, ignore, c) -> CypherCoercions.asMapValue(a, c));
        CONVERTERS.put(Neo4jTypes.NTNode.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asNodeValue(a));
        CONVERTERS.put(Neo4jTypes.NTRelationship.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asRelationshipValue(a));
        CONVERTERS.put(Neo4jTypes.NTPath.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asPathValue(a));
        CONVERTERS.put(Neo4jTypes.NTGeometry.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asPointValue(a));
        CONVERTERS.put(Neo4jTypes.NTPoint.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asPointValue(a));
        CONVERTERS.put(Neo4jTypes.NTDateTime.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asDateTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTLocalDateTime.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asLocalDateTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTDate.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asDateValue(a));
        CONVERTERS.put(Neo4jTypes.NTTime.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTLocalTime.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asLocalTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTDuration.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asDurationValue(a));
        CONVERTERS.put(Neo4jTypes.ListType.class, new ListCoercer());
    }

    private static class ListCoercer
    implements Coercer {
        private ListCoercer() {
        }

        public ListValue apply(AnyValue value, Neo4jTypes.AnyType innerType, DbAccess access) {
            if (innerType == Neo4jTypes.NTAny) {
                return CypherCoercions.fastListConversion(value);
            }
            if (!(value instanceof SequenceValue)) {
                throw CypherCoercions.cantCoerce(value, "List");
            }
            SequenceValue listValue = (SequenceValue)value;
            Coercer innerCoercer = (Coercer)CONVERTERS.get(innerType.getClass());
            AnyValue[] coercedValues = new AnyValue[listValue.length()];
            Neo4jTypes.AnyType nextInner = CypherCoercions.nextInner(innerType);
            if (listValue.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
                for (int i = 0; i < coercedValues.length; ++i) {
                    AnyValue nextItem = listValue.value(i);
                    coercedValues[i] = nextItem == Values.NO_VALUE ? Values.NO_VALUE : innerCoercer.apply(nextItem, nextInner, access);
                }
            } else {
                int i = 0;
                for (AnyValue anyValue : listValue) {
                    AnyValue nextItem = listValue.value(i);
                    coercedValues[i++] = nextItem == Values.NO_VALUE ? Values.NO_VALUE : innerCoercer.apply(anyValue, nextInner, access);
                }
            }
            return VirtualValues.list((AnyValue[])coercedValues);
        }
    }

    @FunctionalInterface
    static interface Coercer {
        public AnyValue apply(AnyValue var1, Neo4jTypes.AnyType var2, DbAccess var3);
    }

    private static class ListMapper
    implements ValueMapper<ListValue> {
        private ListMapper() {
        }

        public ListValue mapPath(PathValue value) {
            return null;
        }

        public ListValue mapNode(VirtualNodeValue value) {
            return null;
        }

        public ListValue mapRelationship(VirtualRelationshipValue value) {
            return null;
        }

        public ListValue mapMap(MapValue value) {
            return null;
        }

        public ListValue mapNoValue() {
            return null;
        }

        public ListValue mapSequence(SequenceValue value) {
            return null;
        }

        public ListValue mapText(TextValue value) {
            return null;
        }

        public ListValue mapBoolean(BooleanValue value) {
            return null;
        }

        public ListValue mapNumber(NumberValue value) {
            return null;
        }

        public ListValue mapDateTime(DateTimeValue value) {
            return null;
        }

        public ListValue mapLocalDateTime(LocalDateTimeValue value) {
            return null;
        }

        public ListValue mapDate(DateValue value) {
            return null;
        }

        public ListValue mapTime(TimeValue value) {
            return null;
        }

        public ListValue mapLocalTime(LocalTimeValue value) {
            return null;
        }

        public ListValue mapDuration(DurationValue value) {
            return null;
        }

        public ListValue mapPoint(PointValue value) {
            return null;
        }
    }
}

