/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.collections.api.block.function.primitive.IntFunction0;
import org.eclipse.collections.api.map.primitive.MutableLongIntMap;
import org.github.jamm.Unmetered;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingUnifiedMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;
import org.neo4j.storageengine.api.RelationshipSelection;

public class CachingExpandInto
extends DefaultCloseListenable {
    static final long CACHING_EXPAND_INTO_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(CachingExpandInto.class) + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE;
    static final long EXPAND_INTO_SELECTION_CURSOR_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ExpandIntoSelectionCursor.class);
    static final long FROM_CACHE_SELECTION_CURSOR_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(FromCachedSelectionCursor.class);
    private static final int EXPENSIVE_DEGREE = -1;
    private final RelationshipCache relationshipCache;
    private final NodeDegreeCache degreeCache;
    @Unmetered
    private final Read read;
    @Unmetered
    private final Direction direction;
    private final MemoryTracker scopedMemoryTracker;
    private static final int DEFAULT_CAPACITY = 100000;

    public CachingExpandInto(Read read, Direction direction, MemoryTracker memoryTracker) {
        this(read, direction, memoryTracker, 100000);
    }

    public CachingExpandInto(Read read, Direction direction, MemoryTracker memoryTracker, int capacity) {
        this.scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        this.scopedMemoryTracker.allocateHeap(CACHING_EXPAND_INTO_SHALLOW_SIZE);
        this.read = read;
        this.direction = direction;
        this.relationshipCache = new RelationshipCache(capacity, this.scopedMemoryTracker);
        this.degreeCache = new NodeDegreeCache(capacity, this.scopedMemoryTracker);
    }

    public void closeInternal() {
        this.scopedMemoryTracker.close();
    }

    public boolean isClosed() {
        return false;
    }

    public RelationshipTraversalCursor connectingRelationships(NodeCursor nodeCursor, RelationshipTraversalCursor traversalCursor, long firstNode, int[] types, long secondNode) {
        boolean secondNodeHasCheapDegrees;
        Iterator<Relationship> connections = this.relationshipCache.get(firstNode, secondNode, this.direction);
        if (connections != null) {
            return new FromCachedSelectionCursor(connections, this.read, firstNode, secondNode);
        }
        Direction reverseDirection = this.direction.reverse();
        int secondDegree = this.degreeCache.getIfAbsentPut(secondNode, (IntFunction0 & Serializable)() -> CachingExpandInto.calculateTotalDegreeIfCheap(this.read, secondNode, nodeCursor, reverseDirection, types));
        if (secondDegree == 0) {
            return Cursors.emptyTraversalCursor((Read)this.read);
        }
        boolean bl = secondNodeHasCheapDegrees = secondDegree != -1;
        if (!CachingExpandInto.singleNode(this.read, nodeCursor, firstNode)) {
            return Cursors.emptyTraversalCursor((Read)this.read);
        }
        boolean firstNodeHasCheapDegrees = nodeCursor.supportsFastDegreeLookup();
        if (firstNodeHasCheapDegrees && secondNodeHasCheapDegrees) {
            Direction relDirection;
            long toNode;
            int firstDegree = this.degreeCache.getIfAbsentPut(firstNode, (IntFunction0 & Serializable)() -> CachingExpandInto.calculateTotalDegree(nodeCursor, this.direction, types));
            if (firstDegree < secondDegree) {
                toNode = secondNode;
                relDirection = this.direction;
            } else {
                CachingExpandInto.singleNode(this.read, nodeCursor, secondNode);
                toNode = firstNode;
                relDirection = reverseDirection;
            }
            return this.connectingRelationshipsCursor(RelationshipSelections.relationshipsCursor((RelationshipTraversalCursor)traversalCursor, (NodeCursor)nodeCursor, (int[])types, (Direction)relDirection), toNode, firstNode, secondNode);
        }
        if (secondNodeHasCheapDegrees) {
            long toNode = secondNode;
            return this.connectingRelationshipsCursor(RelationshipSelections.relationshipsCursor((RelationshipTraversalCursor)traversalCursor, (NodeCursor)nodeCursor, (int[])types, (Direction)this.direction), toNode, firstNode, secondNode);
        }
        if (firstNodeHasCheapDegrees) {
            CachingExpandInto.singleNode(this.read, nodeCursor, secondNode);
            long toNode = firstNode;
            return this.connectingRelationshipsCursor(RelationshipSelections.relationshipsCursor((RelationshipTraversalCursor)traversalCursor, (NodeCursor)nodeCursor, (int[])types, (Direction)reverseDirection), toNode, firstNode, secondNode);
        }
        long toNode = secondNode;
        return this.connectingRelationshipsCursor(RelationshipSelections.relationshipsCursor((RelationshipTraversalCursor)traversalCursor, (NodeCursor)nodeCursor, (int[])types, (Direction)this.direction), toNode, firstNode, secondNode);
    }

    public RelationshipTraversalCursor connectingRelationships(CursorFactory cursors, NodeCursor nodeCursor, long fromNode, int[] types, long toNode, CursorContext cursorContext) {
        return this.connectingRelationships(nodeCursor, cursors.allocateRelationshipTraversalCursor(cursorContext), fromNode, types, toNode);
    }

    private static int calculateTotalDegreeIfCheap(Read read, long node, NodeCursor nodeCursor, Direction direction, int[] types) {
        if (!CachingExpandInto.singleNode(read, nodeCursor, node)) {
            return 0;
        }
        if (!nodeCursor.supportsFastDegreeLookup()) {
            return -1;
        }
        return CachingExpandInto.calculateTotalDegree(nodeCursor, direction, types);
    }

    private static int calculateTotalDegree(NodeCursor nodeCursor, Direction direction, int[] types) {
        return nodeCursor.degree(RelationshipSelection.selection((int[])types, (Direction)direction));
    }

    private static boolean singleNode(Read read, NodeCursor nodeCursor, long node) {
        read.singleNode(node, nodeCursor);
        return nodeCursor.next();
    }

    private RelationshipTraversalCursor connectingRelationshipsCursor(RelationshipTraversalCursor allRelationships, long toNode, long firstNode, long secondNode) {
        return new ExpandIntoSelectionCursor(allRelationships, this.scopedMemoryTracker, toNode, firstNode, secondNode);
    }

    private static Relationship relationship(RelationshipTraversalCursor allRelationships) {
        return new Relationship(allRelationships.relationshipReference(), allRelationships.sourceNodeReference(), allRelationships.targetNodeReference(), allRelationships.propertiesReference(), allRelationships.type());
    }

    private static class Relationship {
        static final long RELATIONSHIP_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Relationship.class);
        private final long id;
        private final long from;
        private final long to;
        private final long properties;
        private final int type;

        private Relationship(long id, long from, long to, long properties, int type) {
            this.id = id;
            this.from = from;
            this.to = to;
            this.properties = properties;
            this.type = type;
        }
    }

    static class RelationshipCache {
        static final long REL_CACHE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipCache.class);
        private final HeapTrackingUnifiedMap<Key, HeapTrackingArrayList<Relationship>> map;
        private final int capacity;
        private final MemoryTracker memoryTracker;

        RelationshipCache(int capacity, MemoryTracker memoryTracker) {
            this.capacity = capacity;
            this.memoryTracker = memoryTracker;
            this.memoryTracker.allocateHeap(REL_CACHE_SHALLOW_SIZE);
            this.map = HeapTrackingCollections.newMap((MemoryTracker)memoryTracker);
        }

        public void add(long start, long end, Direction direction, HeapTrackingArrayList<Relationship> relationships, long heapSizeOfRelationships) {
            if (this.map.size() < this.capacity) {
                this.map.put((Object)RelationshipCache.key(start, end, direction), relationships);
                this.memoryTracker.allocateHeap(heapSizeOfRelationships);
                this.memoryTracker.allocateHeap(Key.KEY_SHALLOW_SIZE);
            }
        }

        public Iterator<Relationship> get(long start, long end, Direction direction) {
            HeapTrackingArrayList cachedValue = (HeapTrackingArrayList)this.map.get((Object)RelationshipCache.key(start, end, direction));
            return cachedValue == null ? null : cachedValue.iterator();
        }

        public static Key key(long startNode, long endNode, Direction direction) {
            long b;
            long a;
            if (direction == Direction.BOTH && startNode > endNode) {
                a = endNode;
                b = startNode;
            } else {
                a = startNode;
                b = endNode;
            }
            return new Key(a, b);
        }

        static class Key {
            static long KEY_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Key.class);
            private final long a;
            private final long b;

            Key(long a, long b) {
                this.a = a;
                this.b = b;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                if (this.a != key.a) {
                    return false;
                }
                return this.b == key.b;
            }

            public int hashCode() {
                int result = (int)(this.a ^ this.a >>> 32);
                result = 31 * result + (int)(this.b ^ this.b >>> 32);
                return result;
            }
        }
    }

    static class NodeDegreeCache {
        static final long DEGREE_CACHE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeDegreeCache.class);
        private final int capacity;
        private final MutableLongIntMap degreeCache;

        NodeDegreeCache(MemoryTracker memoryTracker) {
            this(100000, memoryTracker);
        }

        NodeDegreeCache(int capacity, MemoryTracker memoryTracker) {
            this.capacity = capacity;
            memoryTracker.allocateHeap(DEGREE_CACHE_SHALLOW_SIZE);
            this.degreeCache = HeapTrackingCollections.newLongIntMap((MemoryTracker)memoryTracker);
        }

        public int getIfAbsentPut(long node, IntFunction0 update) {
            if (this.degreeCache.size() >= this.capacity) {
                if (this.degreeCache.containsKey(node)) {
                    return this.degreeCache.get(node);
                }
                return update.getAsInt();
            }
            if (this.degreeCache.containsKey(node)) {
                return this.degreeCache.get(node);
            }
            int value = update.getAsInt();
            this.degreeCache.put(node, value);
            return value;
        }
    }

    private class ExpandIntoSelectionCursor
    extends DefaultCloseListenable
    implements RelationshipTraversalCursor {
        @Unmetered
        private final RelationshipTraversalCursor allRelationships;
        private final long otherNode;
        private final long firstNode;
        private final long secondNode;
        private HeapTrackingArrayList<Relationship> connections;
        private final ScopedMemoryTracker innerMemoryTracker;

        ExpandIntoSelectionCursor(RelationshipTraversalCursor allRelationships, MemoryTracker outerMemoryTracker, long otherNode, long firstNode, long secondNode) {
            this.allRelationships = allRelationships;
            this.otherNode = otherNode;
            this.firstNode = firstNode;
            this.secondNode = secondNode;
            this.innerMemoryTracker = new ScopedMemoryTracker(outerMemoryTracker);
            this.connections = HeapTrackingArrayList.newArrayList((MemoryTracker)this.innerMemoryTracker);
            this.innerMemoryTracker.allocateHeap(EXPAND_INTO_SELECTION_CURSOR_SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        }

        public void otherNode(NodeCursor cursor) {
            this.allRelationships.otherNode(cursor);
        }

        public long originNodeReference() {
            return this.allRelationships.originNodeReference();
        }

        public void removeTracer() {
            this.allRelationships.removeTracer();
        }

        public void closeInternal() {
            this.allRelationships.close();
            this.connections = null;
            this.innerMemoryTracker.close();
        }

        public long relationshipReference() {
            return this.allRelationships.relationshipReference();
        }

        public int type() {
            return this.allRelationships.type();
        }

        public long otherNodeReference() {
            return this.allRelationships.otherNodeReference();
        }

        public long sourceNodeReference() {
            return this.allRelationships.sourceNodeReference();
        }

        public long targetNodeReference() {
            return this.allRelationships.targetNodeReference();
        }

        public boolean next() {
            while (this.allRelationships.next()) {
                if (this.allRelationships.otherNodeReference() != this.otherNode) continue;
                this.innerMemoryTracker.allocateHeap(Relationship.RELATIONSHIP_SHALLOW_SIZE);
                this.connections.add((Object)CachingExpandInto.relationship(this.allRelationships));
                return true;
            }
            if (this.connections == null) {
                return false;
            }
            long diff = this.innerMemoryTracker.estimatedHeapMemory() - EXPAND_INTO_SELECTION_CURSOR_SHALLOW_SIZE;
            CachingExpandInto.this.relationshipCache.add(this.firstNode, this.secondNode, CachingExpandInto.this.direction, this.connections, diff);
            this.close();
            return false;
        }

        public long propertiesReference() {
            return this.allRelationships.propertiesReference();
        }

        public void properties(PropertyCursor cursor) {
            this.allRelationships.properties(cursor);
        }

        public void setTracer(KernelReadTracer tracer) {
            this.allRelationships.setTracer(tracer);
        }

        public void source(NodeCursor nodeCursor) {
            this.allRelationships.source(nodeCursor);
        }

        public void target(NodeCursor nodeCursor) {
            this.allRelationships.target(nodeCursor);
        }

        public boolean isClosed() {
            return this.allRelationships.isClosed();
        }
    }

    private class FromCachedSelectionCursor
    implements RelationshipTraversalCursor {
        @Unmetered
        private Iterator<Relationship> relationships;
        private Relationship currentRelationship;
        @Unmetered
        private final Read read;
        private int token;
        private final long firstNode;
        private final long secondNode;

        FromCachedSelectionCursor(Iterator<Relationship> relationships, Read read, long firstNode, long secondNode) {
            this.relationships = relationships;
            this.read = read;
            this.firstNode = firstNode;
            this.secondNode = secondNode;
            CachingExpandInto.this.scopedMemoryTracker.allocateHeap(FROM_CACHE_SELECTION_CURSOR_SHALLOW_SIZE);
        }

        public boolean next() {
            if (this.relationships != null && this.relationships.hasNext()) {
                this.currentRelationship = this.relationships.next();
                return true;
            }
            this.close();
            return false;
        }

        public void removeTracer() {
        }

        public void otherNode(NodeCursor cursor) {
            this.read.singleNode(this.otherNodeReference(), cursor);
        }

        public long originNodeReference() {
            return this.currentRelationship.from;
        }

        public void setTracer(KernelReadTracer tracer) {
        }

        public void close() {
            if (this.relationships != null) {
                this.relationships = null;
                CachingExpandInto.this.scopedMemoryTracker.releaseHeap(FROM_CACHE_SELECTION_CURSOR_SHALLOW_SIZE);
            }
        }

        public void closeInternal() {
        }

        public boolean isClosed() {
            return false;
        }

        public void setCloseListener(CloseListener closeListener) {
            if (closeListener != null) {
                closeListener.onClosed((AutoCloseablePlus)this);
            }
        }

        public void setToken(int token) {
            this.token = token;
        }

        public int getToken() {
            return this.token;
        }

        public long relationshipReference() {
            return this.currentRelationship.id;
        }

        public int type() {
            return this.currentRelationship.type;
        }

        public long otherNodeReference() {
            return this.currentRelationship.from == this.firstNode ? this.secondNode : this.firstNode;
        }

        public long sourceNodeReference() {
            return this.currentRelationship.from;
        }

        public long targetNodeReference() {
            return this.currentRelationship.to;
        }

        public long propertiesReference() {
            return this.currentRelationship.properties;
        }

        public void properties(PropertyCursor cursor) {
            this.read.relationshipProperties(this.currentRelationship.id, this.currentRelationship.properties, cursor);
        }

        public void source(NodeCursor nodeCursor) {
            this.read.singleNode(this.sourceNodeReference(), nodeCursor);
        }

        public void target(NodeCursor nodeCursor) {
            this.read.singleNode(this.targetNodeReference(), nodeCursor);
        }
    }
}

