/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.NodeJuxtaposition;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;

public class PGStateBuilder {
    private int nextId = 0;

    public BuilderState newState(boolean isStartState, boolean isFinalState) {
        return new BuilderState(new State(this.nextId++, SlotOrName.none(), new NodeJuxtaposition[0], new RelationshipExpansion[0], isStartState, isFinalState));
    }

    public BuilderState newState() {
        return this.newState(false, false);
    }

    public BuilderState newStartState() {
        return this.newState(true, false);
    }

    public BuilderState newFinalState() {
        return this.newState(false, true);
    }

    public static class BuilderState {
        private final State state;

        private BuilderState(State state) {
            this.state = state;
        }

        public void addNodeJuxtaposition(LongPredicate nodePredicate, BuilderState targetBuilderState) {
            NodeJuxtaposition[] existing = this.state.getNodeJuxtapositions();
            NodeJuxtaposition[] longer = new NodeJuxtaposition[existing.length + 1];
            System.arraycopy(existing, 0, longer, 0, existing.length);
            longer[existing.length] = new NodeJuxtaposition(nodePredicate, targetBuilderState.state);
            this.state.setNodeJuxtapositions(longer);
        }

        public void addRelationshipExpansion(Predicate<RelationshipTraversalCursor> relPredicate, int[] types, Direction direction, LongPredicate nodePredicate, BuilderState targetBuilderState) {
            RelationshipExpansion[] existing = this.state.getRelationshipExpansions();
            RelationshipExpansion[] longer = new RelationshipExpansion[existing.length + 1];
            System.arraycopy(existing, 0, longer, 0, existing.length);
            longer[existing.length] = new RelationshipExpansion(relPredicate, types, direction, SlotOrName.none(), nodePredicate, targetBuilderState.state);
            this.state.setRelationshipExpansions(longer);
        }

        public State state() {
            return this.state;
        }
    }
}

