/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingIntArrayList;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeData;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;

public final class PathTracer
extends PrefetchingIterator<TracedPath> {
    private final PPBFSHooks hooks;
    private NodeData targetNode;
    private NodeData sourceNode;
    private int dgLength;
    private final HeapTrackingArrayList<TwoWaySignpost> activeSignposts;
    private final HeapTrackingIntArrayList nodeSourceSignpostIndices;
    private final BitSet pgTrailToTarget;
    private final BitSet betweenDuplicateRels;
    private int currentDgLengthToTarget;
    private boolean saturated;
    private boolean shouldReturnSingleNodePath;
    private boolean ready = false;

    public boolean isSaturated() {
        return this.saturated;
    }

    public PathTracer(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.activeSignposts = HeapTrackingArrayList.newArrayList((MemoryTracker)memoryTracker);
        this.nodeSourceSignpostIndices = HeapTrackingIntArrayList.newIntArrayList((MemoryTracker)memoryTracker);
        this.pgTrailToTarget = new BitSet();
        this.betweenDuplicateRels = new BitSet();
        this.hooks = hooks;
    }

    public void setSourceNode(NodeData sourceNode) {
        this.ready = false;
        this.sourceNode = sourceNode;
    }

    public void resetWithNewTargetNodeAndDGLength(NodeData targetNode, int dgLength) {
        this.ready = true;
        this.targetNode = targetNode;
        Preconditions.checkArgument((targetNode.remainingTargetCount() >= 0 ? 1 : 0) != 0, (String)"remainingTargetCount should not be decremented beyond 0");
        this.saturated = targetNode.remainingTargetCount() == 0;
        this.activeSignposts.clear();
        this.nodeSourceSignpostIndices.clear();
        this.nodeSourceSignpostIndices.add(-1);
        this.pgTrailToTarget.clear();
        this.pgTrailToTarget.set(0);
        this.betweenDuplicateRels.clear();
        this.dgLength = dgLength;
        this.currentDgLengthToTarget = 0;
        this.shouldReturnSingleNodePath = targetNode == this.sourceNode && dgLength == 0;
        super.reset();
    }

    public boolean ready() {
        return this.ready;
    }

    private NodeData current() {
        return this.activeSignposts.isEmpty() ? this.targetNode : ((TwoWaySignpost)this.activeSignposts.last()).prevNode;
    }

    private int currentIndex() {
        return this.nodeSourceSignpostIndices.last();
    }

    private void deactivateCurrent() {
        this.nodeSourceSignpostIndices.removeLast();
        if (this.activeSignposts.notEmpty()) {
            TwoWaySignpost currentSignpost = (TwoWaySignpost)this.activeSignposts.removeLast();
            this.currentDgLengthToTarget -= currentSignpost.dataGraphLength();
            int dgLengthFromSource = this.dgLength - this.currentDgLengthToTarget;
            this.hooks.deactivateSignpost(dgLengthFromSource, currentSignpost);
            currentSignpost.deActivate();
            if (!currentSignpost.isVerifiedAtLength(dgLengthFromSource) && !this.betweenDuplicateRels.get(this.activeSignposts.size())) {
                NodeData nodeBeforeCurrent = this.activeSignposts.isEmpty() ? this.targetNode : ((TwoWaySignpost)this.activeSignposts.get((int)(this.activeSignposts.size() - 1))).prevNode;
                currentSignpost.pruneSourceLength(dgLengthFromSource);
                nodeBeforeCurrent.synchronizeLength(dgLengthFromSource);
            }
        }
    }

    private void activateSignpost(NodeData current, int nextIndex) {
        TwoWaySignpost sourceSignpost = current.getSourceSignpost(nextIndex);
        this.activeSignposts.add((Object)sourceSignpost);
        this.betweenDuplicateRels.set(this.activeSignposts.size() - 1, false);
        this.hooks.activateSignpost(this.dgLength - this.currentDgLengthToTarget, sourceSignpost);
        this.currentDgLengthToTarget += sourceSignpost.dataGraphLength();
        this.nodeSourceSignpostIndices.set(this.nodeSourceSignpostIndices.size() - 1, nextIndex);
        this.nodeSourceSignpostIndices.add(-1);
        boolean isTargetPGTrail = this.pgTrailToTarget.get(this.activeSignposts.size() - 1) && !sourceSignpost.isActive();
        this.pgTrailToTarget.set(this.activeSignposts.size(), isTargetPGTrail);
        if (isTargetPGTrail && !sourceSignpost.hasBeenTraced()) {
            sourceSignpost.setMinDistToTarget(this.currentDgLengthToTarget);
        }
    }

    protected TracedPath fetchNextOrNull() {
        if (!this.ready) {
            throw new IllegalStateException("PathTracer attempted to iterate without fully configuring.");
        }
        if (this.shouldReturnSingleNodePath && !this.saturated) {
            this.shouldReturnSingleNodePath = false;
            return this.currentPath();
        }
        while (this.nodeSourceSignpostIndices.notEmpty()) {
            int currentIndex;
            NodeData current = this.current();
            int nextIndex = current.nextSignpostIndexForLength(currentIndex = this.currentIndex(), this.dgLength - this.currentDgLengthToTarget);
            if (nextIndex == -1) {
                this.deactivateCurrent();
                continue;
            }
            this.activateSignpost(current, nextIndex);
            TwoWaySignpost sourceSignpost = (TwoWaySignpost)this.activeSignposts.last();
            if (sourceSignpost.isActive() && this.allNodesAreValidatedBetweenDuplicates()) {
                this.hooks.skippingDuplicateRelationship(this.targetNode, this.activeSignposts);
                this.hooks.deactivateSignpost(this.dgLength - this.currentDgLengthToTarget, sourceSignpost);
                this.activeSignposts.removeLast();
                this.nodeSourceSignpostIndices.removeLast();
                this.currentDgLengthToTarget -= sourceSignpost.dataGraphLength();
                continue;
            }
            sourceSignpost.activate();
            if (sourceSignpost.prevNode != this.sourceNode || !this.validateTrail() || this.saturated) continue;
            TracedPath path = this.currentPath();
            this.hooks.returnPath(path);
            return path;
        }
        return null;
    }

    private boolean allNodesAreValidatedBetweenDuplicates() {
        TwoWaySignpost lastSignpost = (TwoWaySignpost)this.activeSignposts.last();
        int dgLengthFromSource = this.dgLength - this.currentDgLengthToTarget;
        if (!lastSignpost.prevNode.validatedAtLength(dgLengthFromSource)) {
            return false;
        }
        dgLengthFromSource += lastSignpost.dataGraphLength();
        for (int i = this.activeSignposts.size() - 2; i >= 0; --i) {
            TwoWaySignpost candidate = (TwoWaySignpost)this.activeSignposts.get(i);
            if (!candidate.prevNode.validatedAtLength(dgLengthFromSource)) {
                return false;
            }
            if (candidate.dataGraphRelationshipEquals(lastSignpost)) {
                this.betweenDuplicateRels.set(i + 1, this.activeSignposts.size() - 1, true);
                return true;
            }
            dgLengthFromSource += candidate.dataGraphLength();
        }
        throw new IllegalStateException("Expected duplicate relationship in SHORTEST trail validation");
    }

    private TracedPath currentPath() {
        PathEntity[] entities = new PathEntity[this.activeSignposts.size() + this.dgLength + 1];
        int index = entities.length - 1;
        entities[index--] = PathEntity.fromNode(this.targetNode);
        for (TwoWaySignpost signpost : this.activeSignposts) {
            if (signpost instanceof TwoWaySignpost.RelSignpost) {
                TwoWaySignpost.RelSignpost relSignpost = (TwoWaySignpost.RelSignpost)signpost;
                entities[index--] = PathEntity.fromRel(relSignpost);
            }
            entities[index--] = PathEntity.fromNode(signpost.prevNode);
        }
        Preconditions.checkState((index == -1 ? 1 : 0) != 0, (String)("Traced path length was not as expected (expected " + entities.length + " but found " + (entities.length - (index + 1)) + ")"));
        return new TracedPath(entities);
    }

    private boolean validateTrail() {
        int dgLengthFromSource = 0;
        for (int i = this.activeSignposts.size() - 1; i >= 0; --i) {
            NodeData node;
            TwoWaySignpost signpost = (TwoWaySignpost)this.activeSignposts.get(i);
            dgLengthFromSource += signpost.dataGraphLength();
            for (int j = this.activeSignposts.size() - 1; j > i; --j) {
                if (!signpost.dataGraphRelationshipEquals((TwoWaySignpost)this.activeSignposts.get(j))) continue;
                this.hooks.invalidTrail((Function0<TracedPath>)((Function0)this::currentPath));
                return false;
            }
            if (signpost.isVerifiedAtLength(dgLengthFromSource)) continue;
            signpost.setVerified(dgLengthFromSource);
            NodeData nodeData = node = i == 0 ? this.targetNode : ((TwoWaySignpost)this.activeSignposts.get((int)(i - 1))).prevNode;
            if (node.validatedAtLength(dgLengthFromSource)) continue;
            node.validateLengthState(dgLengthFromSource, this.dgLength - dgLengthFromSource);
        }
        return true;
    }

    public NodeData targetNode() {
        return this.targetNode;
    }

    public void decrementTargetCount() {
        if (this.targetNode.decrementTargetCount()) {
            this.saturated = true;
        }
    }

    public record TracedPath(PathEntity[] entities) {
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("(");
            PathEntity last = null;
            for (PathEntity e : this.entities) {
                switch (e.entityType) {
                    case NODE: {
                        if (last == null || last.entityType == EntityType.RELATIONSHIP) {
                            sb.append(e.id).append("@").append(e.slotOrName);
                            break;
                        }
                        if (last.slotOrName == e.slotOrName) break;
                        sb.append(",").append(e.slotOrName);
                        break;
                    }
                    case RELATIONSHIP: {
                        sb.append(")-[").append(e.id).append("]-(");
                    }
                }
                last = e;
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public record PathEntity(SlotOrName slotOrName, long id, EntityType entityType) {
        static PathEntity fromNode(NodeData node) {
            return new PathEntity(node.state().slotOrName(), node.id(), EntityType.NODE);
        }

        static PathEntity fromRel(TwoWaySignpost.RelSignpost signpost) {
            return new PathEntity(signpost.slotOrName(), signpost.relId, EntityType.RELATIONSHIP);
        }

        public AnyValue idValue() {
            return switch (this.entityType) {
                default -> throw new IncompatibleClassChangeError();
                case EntityType.NODE -> VirtualValues.node((long)this.id);
                case EntityType.RELATIONSHIP -> VirtualValues.relationship((long)this.id);
            };
        }
    }
}

