/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import java.util.stream.Collectors;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeData;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.util.Preconditions;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TwoWaySignpost {
    public static final int NO_TARGET_DISTANCE = -1;
    public final NodeData prevNode;
    public final NodeData forwardNode;
    protected final BitSet lengthsFromSource;
    protected final BitSet verifiedAtLengthFromSource;
    protected int minDistToTarget = -1;

    public TwoWaySignpost(NodeData prevNode, NodeData forwardNode, int lengthFromSource) {
        this.prevNode = prevNode;
        this.forwardNode = forwardNode;
        this.lengthsFromSource = new BitSet();
        this.verifiedAtLengthFromSource = new BitSet();
        this.lengthsFromSource.set(lengthFromSource);
    }

    public static RelSignpost fromRelExpansion(NodeData prevNode, long relId, NodeData forwardNode, RelationshipExpansion relationshipExpansion, int lengthFromSource) {
        return new RelSignpost(prevNode, relId, forwardNode, relationshipExpansion, lengthFromSource);
    }

    public static NodeSignpost fromNodeJuxtaposition(NodeData prevNode, NodeData forwardNode, int lengthFromSource) {
        return new NodeSignpost(prevNode, forwardNode, lengthFromSource);
    }

    public abstract int dataGraphLength();

    public boolean hasBeenTraced() {
        return this.minDistToTarget != -1;
    }

    public void setMinDistToTarget(int dgDist) {
        Preconditions.checkState((!this.hasBeenTraced() ? 1 : 0) != 0, (String)"A signpost should only have setMinDistToTarget() called upon it on the first trace");
        this.minDistToTarget = dgDist;
        this.prevNode.addTargetSignpost(this, dgDist);
    }

    public int minDistToTarget() {
        return this.minDistToTarget;
    }

    public abstract boolean isDoublyActive();

    public abstract void activate();

    public abstract void deactivate();

    public void addSourceLength(int lengthFromSource) {
        this.lengthsFromSource.set(lengthFromSource);
    }

    public boolean hasSourceLength(int length) {
        return this.lengthsFromSource.get(length);
    }

    public void propagate(int lengthFromSource, int lengthToTarget) {
        int newLength = lengthFromSource + this.dataGraphLength();
        this.forwardNode.newPropagatedLengthFromSource(newLength, lengthToTarget - this.dataGraphLength());
        this.addSourceLength(newLength);
    }

    public void pruneSourceLength(int lengthFromSource) {
        this.prevNode.dataManager.hooks.pruneSourceLength(this, lengthFromSource);
        this.lengthsFromSource.set(lengthFromSource, false);
        this.forwardNode.synchronizeLengthAfterPrune(lengthFromSource);
    }

    public void setVerified(int lengthFromSource) {
        this.prevNode.dataManager.hooks.setVerified(this, lengthFromSource);
        this.verifiedAtLengthFromSource.set(lengthFromSource, true);
    }

    public boolean isVerifiedAtLength(int length) {
        return this.verifiedAtLengthFromSource.get(length);
    }

    public abstract boolean dataGraphRelationshipEquals(TwoWaySignpost var1);

    public static final class RelSignpost
    extends TwoWaySignpost {
        public final long relId;
        private final RelationshipExpansion relationshipExpansion;
        private int activations;

        private RelSignpost(NodeData prevNode, long relId, NodeData forwardNode, RelationshipExpansion relationshipExpansion, int lengthFromSource) {
            super(prevNode, forwardNode, lengthFromSource);
            this.relId = relId;
            this.relationshipExpansion = relationshipExpansion;
            this.activations = 0;
        }

        @Override
        public boolean isDoublyActive() {
            return this.activations > 1;
        }

        @Override
        public void activate() {
            ++this.activations;
        }

        @Override
        public void deactivate() {
            Preconditions.checkArgument((this.activations > 0 ? 1 : 0) != 0, (String)"Signpost activations should never be negative");
            --this.activations;
        }

        @Override
        public int dataGraphLength() {
            return 1;
        }

        @Override
        public boolean dataGraphRelationshipEquals(TwoWaySignpost other) {
            if (!(other instanceof RelSignpost)) {
                return false;
            }
            RelSignpost otherRS = (RelSignpost)other;
            return this.relId == otherRS.relId;
        }

        public SlotOrName slotOrName() {
            return this.relationshipExpansion.slotOrName();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("RE ").append(this.prevNode).append("-[");
            if (this.slotOrName() != SlotOrName.none()) {
                sb.append(this.slotOrName()).append("@");
            }
            sb.append(this.relId).append("]->").append(this.forwardNode);
            if (this.minDistToTarget != -1) {
                sb.append(", minDistToTarget: ").append(this.minDistToTarget);
            }
            if (!this.lengthsFromSource.isEmpty()) {
                String lengths = this.lengthsFromSource.stream().mapToObj(i -> i + (this.verifiedAtLengthFromSource.get(i) ? "\u2713" : "?")).collect(Collectors.joining(",", "{", "}"));
                sb.append(", lengthsFromSource: ").append(lengths);
            }
            return sb.toString();
        }
    }

    public static final class NodeSignpost
    extends TwoWaySignpost {
        private NodeSignpost(NodeData prevNode, NodeData forwardNode, int lengthFromSource) {
            super(prevNode, forwardNode, lengthFromSource);
        }

        @Override
        public boolean isDoublyActive() {
            return false;
        }

        @Override
        public void activate() {
        }

        @Override
        public void deactivate() {
        }

        @Override
        public int dataGraphLength() {
            return 0;
        }

        @Override
        public boolean dataGraphRelationshipEquals(TwoWaySignpost other) {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("NJ ").append(this.prevNode).append(" ").append(this.forwardNode);
            if (this.minDistToTarget != -1) {
                sb.append(", minDistToTarget: ").append(this.minDistToTarget);
            }
            if (!this.lengthsFromSource.isEmpty()) {
                String lengths = this.lengthsFromSource.stream().mapToObj(i -> i + (this.verifiedAtLengthFromSource.get(i) ? "\u2713" : "?")).collect(Collectors.joining(",", "{", "}"));
                sb.append(", lengthsFromSource: ").append(lengths);
            }
            return sb.toString();
        }
    }
}

