/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.neo4j.cypher.internal.runtime.MergeSortNodeCursor;
import org.neo4j.cypher.internal.runtime.MergeSortRelationshipCursor;
import org.neo4j.cypher.internal.runtime.UnorderedNodeCursor;
import org.neo4j.cypher.internal.runtime.UnorderedRelationshipCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.ValueIndexCursor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.math.Ordering;
import scala.math.PartialOrdering;

public final class CompositeValueIndexCursor$ {
    public static final CompositeValueIndexCursor$ MODULE$ = new CompositeValueIndexCursor$();
    private static final Comparator<Value> REVERSE_COMPARATOR = new Comparator<Value>(){

        public Comparator<Value> reversed() {
            return Comparator.super.reversed();
        }

        public Comparator<Value> thenComparing(Comparator<? super Value> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        public <U> Comparator<Value> thenComparing(Function<? super Value, ? extends U> x$1, Comparator<? super U> x$2) {
            return Comparator.super.thenComparing(x$1, x$2);
        }

        public <U extends Comparable<? super U>> Comparator<Value> thenComparing(Function<? super Value, ? extends U> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        public Comparator<Value> thenComparingInt(ToIntFunction<? super Value> x$1) {
            return Comparator.super.thenComparingInt(x$1);
        }

        public Comparator<Value> thenComparingLong(ToLongFunction<? super Value> x$1) {
            return Comparator.super.thenComparingLong(x$1);
        }

        public Comparator<Value> thenComparingDouble(ToDoubleFunction<? super Value> x$1) {
            return Comparator.super.thenComparingDouble(x$1);
        }

        public int compare(Value o1, Value o2) {
            return -Values.COMPARATOR.compare(o1, o2);
        }
    };
    private static final Ordering<ValueIndexCursor> ASCENDING = new Ordering<ValueIndexCursor>(){
        private static final long serialVersionUID = 0L;

        public Some tryCompare(Object x, Object y) {
            return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lteq(Object x, Object y) {
            return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gteq(Object x, Object y) {
            return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lt(Object x, Object y) {
            return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gt(Object x, Object y) {
            return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean equiv(Object x, Object y) {
            return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
        }

        public Object max(Object x, Object y) {
            return Ordering.max$((Ordering)this, (Object)x, (Object)y);
        }

        public Object min(Object x, Object y) {
            return Ordering.min$((Ordering)this, (Object)x, (Object)y);
        }

        public Ordering<ValueIndexCursor> reverse() {
            return Ordering.reverse$((Ordering)this);
        }

        public boolean isReverseOf(Ordering<?> other) {
            return Ordering.isReverseOf$((Ordering)this, other);
        }

        public <U> Ordering<U> on(Function1<U, ValueIndexCursor> f) {
            return Ordering.on$((Ordering)this, f);
        }

        public Ordering<ValueIndexCursor> orElse(Ordering<ValueIndexCursor> other) {
            return Ordering.orElse$((Ordering)this, other);
        }

        public <S> Ordering<ValueIndexCursor> orElseBy(Function1<ValueIndexCursor, S> f, Ordering<S> ord) {
            return Ordering.orElseBy$((Ordering)this, f, ord);
        }

        public Ordering.OrderingOps mkOrderingOps(Object lhs) {
            return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
        }

        public final int compare(ValueIndexCursor x, ValueIndexCursor y) {
            return CompositeValueIndexCursor$.org$neo4j$cypher$internal$runtime$CompositeValueIndexCursor$$$anonfun$ASCENDING$1(x, y);
        }
        {
            PartialOrdering.$init$((PartialOrdering)this);
            Ordering.$init$((Ordering)this);
        }
    };
    private static final Ordering<ValueIndexCursor> DESCENDING = new Ordering<ValueIndexCursor>(){
        private static final long serialVersionUID = 0L;

        public Some tryCompare(Object x, Object y) {
            return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lteq(Object x, Object y) {
            return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gteq(Object x, Object y) {
            return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lt(Object x, Object y) {
            return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gt(Object x, Object y) {
            return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean equiv(Object x, Object y) {
            return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
        }

        public Object max(Object x, Object y) {
            return Ordering.max$((Ordering)this, (Object)x, (Object)y);
        }

        public Object min(Object x, Object y) {
            return Ordering.min$((Ordering)this, (Object)x, (Object)y);
        }

        public Ordering<ValueIndexCursor> reverse() {
            return Ordering.reverse$((Ordering)this);
        }

        public boolean isReverseOf(Ordering<?> other) {
            return Ordering.isReverseOf$((Ordering)this, other);
        }

        public <U> Ordering<U> on(Function1<U, ValueIndexCursor> f) {
            return Ordering.on$((Ordering)this, f);
        }

        public Ordering<ValueIndexCursor> orElse(Ordering<ValueIndexCursor> other) {
            return Ordering.orElse$((Ordering)this, other);
        }

        public <S> Ordering<ValueIndexCursor> orElseBy(Function1<ValueIndexCursor, S> f, Ordering<S> ord) {
            return Ordering.orElseBy$((Ordering)this, f, ord);
        }

        public Ordering.OrderingOps mkOrderingOps(Object lhs) {
            return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
        }

        public final int compare(ValueIndexCursor x, ValueIndexCursor y) {
            return CompositeValueIndexCursor$.org$neo4j$cypher$internal$runtime$CompositeValueIndexCursor$$$anonfun$DESCENDING$1(x, y);
        }
        {
            PartialOrdering.$init$((PartialOrdering)this);
            Ordering.$init$((Ordering)this);
        }
    };

    private int compare(ValueIndexCursor x, ValueIndexCursor y, Comparator<Value> comparator) {
        int np = x.numberOfProperties();
        Predef$.MODULE$.require(y.numberOfProperties() == np);
        for (int i = 0; i < np; ++i) {
            int cmp = comparator.compare(x.propertyValue(i), y.propertyValue(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private Comparator<Value> REVERSE_COMPARATOR() {
        return REVERSE_COMPARATOR;
    }

    private Ordering<ValueIndexCursor> ASCENDING() {
        return ASCENDING;
    }

    private Ordering<ValueIndexCursor> DESCENDING() {
        return DESCENDING;
    }

    public NodeValueIndexCursor ascending(NodeValueIndexCursor[] cursors) {
        return new MergeSortNodeCursor(cursors, this.ASCENDING());
    }

    public NodeValueIndexCursor descending(NodeValueIndexCursor[] cursors) {
        return new MergeSortNodeCursor(cursors, this.DESCENDING());
    }

    public NodeValueIndexCursor unordered(NodeValueIndexCursor[] cursors) {
        return new UnorderedNodeCursor(cursors);
    }

    public RelationshipValueIndexCursor ascending(RelationshipValueIndexCursor[] cursors) {
        return new MergeSortRelationshipCursor(cursors, this.ASCENDING());
    }

    public RelationshipValueIndexCursor descending(RelationshipValueIndexCursor[] cursors) {
        return new MergeSortRelationshipCursor(cursors, this.DESCENDING());
    }

    public RelationshipValueIndexCursor unordered(RelationshipValueIndexCursor[] cursors) {
        return new UnorderedRelationshipCursor(cursors);
    }

    public static final /* synthetic */ int org$neo4j$cypher$internal$runtime$CompositeValueIndexCursor$$$anonfun$ASCENDING$1(ValueIndexCursor x, ValueIndexCursor y) {
        return MODULE$.compare(x, y, MODULE$.REVERSE_COMPARATOR());
    }

    public static final /* synthetic */ int org$neo4j$cypher$internal$runtime$CompositeValueIndexCursor$$$anonfun$DESCENDING$1(ValueIndexCursor x, ValueIndexCursor y) {
        return MODULE$.compare(x, y, (Comparator<Value>)Values.COMPARATOR);
    }

    private CompositeValueIndexCursor$() {
    }
}

