/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.BFSExpander;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.DataManager;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeData;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PathTracer;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ProductGraphTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class PGPathPropagatingBFS<Row>
extends PrefetchingIterator<Row>
implements AutoCloseable {
    private final DataManager dataManager;
    private final BFSExpander bfsExpander;
    private final NodeData sourceData;
    private final long intoTarget;
    private final PathTracer pathTracer;
    private final Function<PathTracer.TracedPath, Row> toRow;
    private final Predicate<Row> nonInlinedPredicate;
    private final Boolean isGroupSelector;
    private final MemoryTracker memoryTracker;
    private final PPBFSHooks hooks;
    private final AssertOpen assertOpen;
    private int nextDepth = 0;
    private boolean isInitialLevel = true;
    private Iterator<NodeData> currentTargets = Collections.emptyIterator();
    private boolean targetSaturated = false;
    private boolean groupYielded = false;

    public PGPathPropagatingBFS(long source, long intoTarget, State startState, ProductGraphTraversalCursor.DataGraphRelationshipCursor graphCursor, PathTracer pathTracer, Function<PathTracer.TracedPath, Row> toRow, Predicate<Row> nonInlinedPredicate, Boolean isGroupSelector, int initialCountForTargetNodes, int numberOfNfaStates, MemoryTracker mt, PPBFSHooks hooks, AssertOpen assertOpen) {
        this.intoTarget = intoTarget;
        this.pathTracer = pathTracer;
        this.toRow = toRow;
        this.nonInlinedPredicate = nonInlinedPredicate;
        this.isGroupSelector = isGroupSelector;
        this.memoryTracker = mt.getScopedMemoryTracker();
        this.hooks = hooks;
        this.assertOpen = assertOpen;
        this.dataManager = new DataManager(this.memoryTracker, hooks, initialCountForTargetNodes, numberOfNfaStates);
        this.bfsExpander = new BFSExpander(this.dataManager, new ProductGraphTraversalCursor(graphCursor, this.memoryTracker), intoTarget, hooks, this.memoryTracker);
        this.sourceData = new NodeData(this.memoryTracker, source, startState, 0, this.dataManager, intoTarget);
        this.memoryTracker.allocateHeap(this.sourceData.estimatedHeapUsage());
        this.dataManager.addToNextLevel(this.sourceData);
        pathTracer.reset();
        this.hooks.newRow(source);
    }

    public static <Row> PGPathPropagatingBFS<Row> create(long source, long intoTarget, State startState, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, PathTracer pathTracer, Function<PathTracer.TracedPath, Row> toRow, Predicate<Row> nonInlinedPredicate, Boolean isGroupSelector, int initialCountForTargetNodes, int numberOfNfaStates, MemoryTracker mt, PPBFSHooks hooks, AssertOpen assertOpen) {
        return new PGPathPropagatingBFS<Row>(source, intoTarget, startState, new ProductGraphTraversalCursor.DataGraphRelationshipCursorImpl(read, nodeCursor, relCursor), pathTracer, toRow, nonInlinedPredicate, isGroupSelector, initialCountForTargetNodes, numberOfNfaStates, mt, hooks, assertOpen);
    }

    protected Row fetchNextOrNull() {
        if (this.targetSaturated) {
            return null;
        }
        while (true) {
            if (this.pathTracer.ready()) {
                while (this.pathTracer.hasNext()) {
                    PathTracer.TracedPath path = (PathTracer.TracedPath)this.pathTracer.next();
                    Row row = this.toRow.apply(path);
                    if (!this.nonInlinedPredicate.test(row)) continue;
                    if (this.isGroupSelector.booleanValue()) {
                        this.groupYielded = true;
                    } else {
                        this.pathTracer.decrementTargetCount();
                    }
                    if (this.intoTarget != -1L && this.pathTracer.isSaturated()) {
                        this.targetSaturated = true;
                    }
                    return row;
                }
            }
            if (this.groupYielded) {
                this.groupYielded = false;
                this.pathTracer.decrementTargetCount();
                if (this.intoTarget != -1L && this.pathTracer.isSaturated()) {
                    this.targetSaturated = true;
                    return null;
                }
            }
            if (!this.currentTargets.hasNext()) {
                if (this.nextLevelWithTargets()) {
                    this.currentTargets = this.dataManager.targets().iterator();
                } else {
                    this.targetSaturated = true;
                    return null;
                }
            }
            this.pathTracer.reset();
            this.pathTracer.initialize(this.sourceData, this.currentTargets.next(), this.nextDepth);
        }
    }

    public int nextDepth() {
        return this.nextDepth;
    }

    private boolean nextLevelWithTargets() {
        if (this.zeroHopLevel()) {
            return true;
        }
        do {
            if (this.shouldQuit()) {
                return false;
            }
            if (this.nextLevel()) continue;
            return false;
        } while (!this.dataManager.hasTargets());
        return true;
    }

    private boolean shouldQuit() {
        return !this.dataManager.hasLiveTargets() && !this.dataManager.hasNodesToExpand();
    }

    private boolean nextLevel() {
        this.assertOpen.assertOpen();
        ++this.nextDepth;
        this.hooks.nextLevel(this.nextDepth);
        this.dataManager.clearTargets();
        if (!this.dataManager.hasNodesToPropagateOrExpand()) {
            this.hooks.noMoreNodes();
            return false;
        }
        if (this.dataManager.hasNodesToExpand()) {
            this.bfsExpander.expandLevel(this.nextDepth);
            this.dataManager.allocateNextLevel();
        }
        this.dataManager.propagateAll(this.nextDepth);
        return true;
    }

    private boolean zeroHopLevel() {
        if (!this.isInitialLevel) {
            return false;
        }
        this.isInitialLevel = false;
        Preconditions.checkState((this.nextDepth == 0 ? 1 : 0) != 0, (String)"zeroHopLevel called for nonzero depth");
        this.hooks.nextLevel(0);
        this.bfsExpander.floodInitialNodeJuxtapositions();
        this.dataManager.allocateNextLevel();
        if (this.sourceData.isTarget()) {
            this.dataManager.addTarget(this.sourceData);
        }
        return this.dataManager.hasTargetsWithRemainingCount();
    }

    public void setTracer(KernelReadTracer tracer) {
        this.bfsExpander.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.bfsExpander.close();
        this.dataManager.close();
        this.memoryTracker.close();
    }
}

