/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataReader;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ComposedSourceCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ListCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansionCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.DirectedTypes;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;

public class ProductGraphTraversalCursor
implements AutoCloseable {
    private final DataGraphRelationshipCursor graphCursor;
    private boolean initialized = false;
    private final DirectedTypes directedTypes;
    private final ComposedSourceCursor<List<State>, State, RelationshipExpansion> nfaCursor;

    public ProductGraphTraversalCursor(Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker mt) {
        this(new DataGraphRelationshipCursorImpl(read, nodeCursor, relCursor), mt);
    }

    public ProductGraphTraversalCursor(DataGraphRelationshipCursor graph, MemoryTracker mt) {
        this.graphCursor = graph;
        this.nfaCursor = new ComposedSourceCursor(new ListCursor(), new RelationshipExpansionCursor());
        this.directedTypes = new DirectedTypes(mt);
    }

    public State targetState() {
        return this.nfaCursor.current().targetState();
    }

    public State currentInputState() {
        return this.nfaCursor.currentIntermediate();
    }

    public long otherNodeReference() {
        return this.graphCursor.otherNode();
    }

    public long relationshipReference() {
        return this.graphCursor.relationshipReference();
    }

    public RelationshipExpansion relationshipExpansion() {
        return this.nfaCursor.current();
    }

    public boolean next() {
        if (!this.initialized) {
            if (!this.nextRelationship()) {
                return false;
            }
            this.initialized = true;
        }
        while (true) {
            if (this.nfaCursor.next()) {
                if (!this.evaluateCurrent()) continue;
                return true;
            }
            if (!this.nextRelationship()) break;
        }
        return false;
    }

    private boolean nextRelationship() {
        this.nfaCursor.reset();
        return this.graphCursor.nextRelationship();
    }

    private boolean evaluateCurrent() {
        RelationshipExpansion expansion = this.nfaCursor.current();
        return this.graphCursor.direction().matches(expansion.direction()) && (expansion.types() == null || ArrayUtils.contains((int[])expansion.types(), (int)this.graphCursor.type())) && expansion.testRelationship(this.graphCursor) && expansion.testNode(this.graphCursor.otherNode());
    }

    public void setNodeAndStates(long nodeId, List<State> states) {
        this.initialized = false;
        this.nfaCursor.setSource(states);
        this.directedTypes.clear();
        while (this.nfaCursor.next()) {
            RelationshipExpansion expansion = this.nfaCursor.current();
            this.directedTypes.addTypes(expansion.types(), expansion.direction());
        }
        this.nfaCursor.reset();
        this.graphCursor.setNode(nodeId, RelationshipSelection.selection((DirectedTypes)this.directedTypes));
    }

    public void setTracer(KernelReadTracer tracer) {
        this.graphCursor.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.nfaCursor.close();
    }

    public static class DataGraphRelationshipCursorImpl
    implements DataGraphRelationshipCursor {
        private final Read read;
        private final NodeCursor node;
        private final RelationshipTraversalCursor rel;

        public DataGraphRelationshipCursorImpl(Read read, NodeCursor node, RelationshipTraversalCursor rel) {
            this.read = read;
            this.node = node;
            this.rel = rel;
        }

        @Override
        public boolean nextRelationship() {
            return this.rel.next();
        }

        @Override
        public void setTracer(KernelReadTracer tracer) {
            this.node.setTracer(tracer);
            this.rel.setTracer(tracer);
        }

        @Override
        public void setNode(long nodeId, RelationshipSelection relationshipSelection) {
            this.read.singleNode(nodeId, this.node);
            if (!this.node.next()) {
                throw new EntityNotFoundException("Node " + nodeId + " was unexpectedly deleted");
            }
            this.node.relationships(this.rel, relationshipSelection);
        }

        public long relationshipReference() {
            return this.rel.reference();
        }

        @Override
        public long originNode() {
            return this.rel.originNodeReference();
        }

        @Override
        public long otherNode() {
            return this.rel.otherNodeReference();
        }

        public long sourceNodeReference() {
            return this.rel.sourceNodeReference();
        }

        public long targetNodeReference() {
            return this.rel.targetNodeReference();
        }

        public void source(NodeCursor cursor) {
            this.rel.source(cursor);
        }

        public void target(NodeCursor cursor) {
            this.rel.target(cursor);
        }

        public int type() {
            return this.rel.type();
        }
    }

    public static interface DataGraphRelationshipCursor
    extends RelationshipDataReader {
        public boolean nextRelationship();

        public void setNode(long var1, RelationshipSelection var3);

        public long originNode();

        public long otherNode();

        default public RelationshipDirection direction() {
            return RelationshipDirection.directionOfStrict((long)this.originNode(), (long)this.sourceNodeReference(), (long)this.targetNodeReference());
        }

        public void setTracer(KernelReadTracer var1);
    }
}

