/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.cypher.internal.runtime.ResourceMonitor;
import org.neo4j.cypher.internal.runtime.ResourcePool;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import scala.collection.Iterator;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m3AAC\u0006\u0001-!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\t\rq\u0002\u0001\u0015!\u0003,\u0011\u0015i\u0004\u0001\"\u0011?\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015Q\u0006\u0001\"\u0011Z\u0005Y!\u0006N]3bIN\u000bg-\u001a*fg>,(oY3Q_>d'B\u0001\u0007\u000e\u0003\u001d\u0011XO\u001c;j[\u0016T!AD\b\u0002\u0011%tG/\u001a:oC2T!\u0001E\t\u0002\r\rL\b\u000f[3s\u0015\t\u00112#A\u0003oK>$$NC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yyR\"A\u0006\n\u0005\u0001Z!\u0001\u0004*fg>,(oY3Q_>d\u0017aB7p]&$xN\u001d\t\u0003=\rJ!\u0001J\u0006\u0003\u001fI+7o\\;sG\u0016luN\\5u_J\fa\u0001P5oSRtDCA\u0014)!\tq\u0002\u0001C\u0003\"\u0005\u0001\u0007!%A\u0005sKN|WO]2fgV\t1\u0006E\u0002-cMj\u0011!\f\u0006\u0003]=\nA!\u001e;jY*\t\u0001'\u0001\u0003kCZ\f\u0017B\u0001\u001a.\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0003iij\u0011!\u000e\u0006\u0003m]\n1!\u00199j\u0015\tA\u0014(\u0001\u0004lKJtW\r\u001c\u0006\u0003\u001dEI!aO\u001b\u0003#\u0005+Ho\\\"m_N,\u0017M\u00197f!2,8/\u0001\u0006sKN|WO]2fg\u0002\n1!\u00193e)\ty$\t\u0005\u0002\u0019\u0001&\u0011\u0011)\u0007\u0002\u0005+:LG\u000fC\u0003D\u000b\u0001\u00071'\u0001\u0005sKN|WO]2f\u0003\u0019\u0011X-\\8wKR\u0011a)\u0013\t\u00031\u001dK!\u0001S\r\u0003\u000f\t{w\u000e\\3b]\")1I\u0002a\u0001g\u0005\u0019\u0011\r\u001c7\u0015\u00031\u00032!T+4\u001d\tq5K\u0004\u0002P%6\t\u0001K\u0003\u0002R+\u00051AH]8pizJ\u0011AG\u0005\u0003)f\tq\u0001]1dW\u0006<W-\u0003\u0002W/\nA\u0011\n^3sCR|'O\u0003\u0002U3\u0005)1\r\\3beR\tq(\u0001\u0005dY>\u001cX-\u00117m\u0001")
public class ThreadSafeResourcePool
implements ResourcePool {
    private final ResourceMonitor monitor;
    private final Collection<AutoCloseablePlus> resources;

    @Override
    public String toString() {
        return ResourcePool.toString$(this);
    }

    public Collection<AutoCloseablePlus> resources() {
        return this.resources;
    }

    @Override
    public void add(AutoCloseablePlus resource) {
        this.resources().add(resource);
    }

    @Override
    public boolean remove(AutoCloseablePlus resource) {
        return this.resources().remove(resource);
    }

    @Override
    public Iterator<AutoCloseablePlus> all() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.resources().iterator()).asScala();
    }

    @Override
    public void clear() {
        this.resources().clear();
    }

    @Override
    public void closeAll() {
        java.util.Iterator<AutoCloseablePlus> iterator = this.resources().iterator();
        Throwable error = null;
        while (iterator.hasNext()) {
            try {
                AutoCloseablePlus resource = iterator.next();
                this.monitor.close(resource);
                resource.setCloseListener(null);
                resource.close();
            }
            catch (Throwable t) {
                error = Exceptions.chain(error, (Throwable)t);
            }
        }
        if (error != null) {
            throw error;
        }
        this.resources().clear();
    }

    public ThreadSafeResourcePool(ResourceMonitor monitor) {
        this.monitor = monitor;
        ResourcePool.$init$(this);
        this.resources = new ConcurrentLinkedQueue<AutoCloseablePlus>();
    }
}

