/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public final class CursorUtils {
    private CursorUtils() {
        throw new UnsupportedOperationException();
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        assert (node >= -1L);
        return CursorUtils.nodeGetProperty(read, nodeCursor, node, propertyCursor, prop, true);
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop, boolean throwOnDeleted) throws EntityNotFoundException {
        assert (node >= -1L);
        if (node == -1L) {
            return Values.NO_VALUE;
        }
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            if (throwOnDeleted && read.nodeDeletedInTransaction(node)) {
                throw new EntityNotFoundException(String.format("Node with id %d has been deleted in this transaction", node));
            }
            return Values.NO_VALUE;
        }
        return CursorUtils.nodeGetProperty(nodeCursor, propertyCursor, prop);
    }

    public static Value nodeGetProperty(NodeCursor nodeCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        nodeCursor.properties(propertyCursor, PropertySelection.selection((int)prop));
        return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public static AnyValue[] entityGetProperties(EntityCursor entityCursor, PropertyCursor propertyCursor, int[] tokens) {
        assert (entityCursor.reference() != -1L);
        entityCursor.properties(propertyCursor, PropertySelection.selection((int[])tokens));
        Object[] values = new Value[tokens.length];
        Arrays.fill(values, Values.NO_VALUE);
        while (propertyCursor.next()) {
            int index = ArrayUtils.indexOf((int[])tokens, (int)propertyCursor.propertyKey());
            values[index] = propertyCursor.propertyValue();
        }
        return values;
    }

    public static boolean nodeHasProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        if (prop == -1) {
            return false;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return CursorUtils.nodeHasProperty(nodeCursor, propertyCursor, prop);
    }

    public static boolean nodeHasProperty(NodeCursor nodeCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return false;
        }
        nodeCursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
        return propertyCursor.next();
    }

    public static boolean nodeHasLabel(Read read, NodeCursor nodeCursor, long node, int label) {
        if (label == -1) {
            return false;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return nodeCursor.hasLabel(label);
    }

    public static boolean nodeHasALabel(Read read, NodeCursor nodeCursor, long node) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return nodeCursor.hasLabel();
    }

    public static boolean nodeHasALabel(NodeCursor nodeCursor) {
        return nodeCursor.hasLabel();
    }

    public static boolean nodeHasAnyLabel(Read read, NodeCursor nodeCursor, long node, int[] labels) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return CursorUtils.nodeHasAnyLabel(nodeCursor, labels);
    }

    public static boolean nodeHasAnyLabel(NodeCursor cursor, int[] labels) {
        TokenSet nodeLabels = cursor.labels();
        for (int label : labels) {
            if (!nodeLabels.contains(label)) continue;
            return true;
        }
        return false;
    }

    public static boolean relationshipHasType(Read read, RelationshipScanCursor relationshipCursor, long relationship, int type) {
        if (type == -1) {
            return false;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            return false;
        }
        return relationshipCursor.type() == type;
    }

    public static RelationshipTraversalCursor nodeGetRelationships(Read read, CursorFactory cursors, NodeCursor node, long nodeId, Direction direction, int[] types, CursorContext cursorContext) {
        read.singleNode(nodeId, node);
        if (!node.next()) {
            return Cursors.emptyTraversalCursor((Read)read);
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.OUTGOING -> RelationshipSelections.outgoingCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types, (CursorContext)cursorContext);
            case Direction.INCOMING -> RelationshipSelections.incomingCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types, (CursorContext)cursorContext);
            case Direction.BOTH -> RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types, (CursorContext)cursorContext);
        };
    }

    public static Value relationshipGetProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        return CursorUtils.relationshipGetProperty(read, relationshipCursor, relationship, propertyCursor, prop, true);
    }

    public static Value relationshipGetProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop, boolean throwOnDeleted) throws EntityNotFoundException {
        assert (relationship >= -1L);
        if (relationship == -1L) {
            return Values.NO_VALUE;
        }
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            if (throwOnDeleted && read.relationshipDeletedInTransaction(relationship)) {
                throw new EntityNotFoundException(String.format("Relationship with id %d has been deleted in this transaction", relationship));
            }
            return Values.NO_VALUE;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.selection((int)prop));
        return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public static Value relationshipGetProperty(RelationshipDataAccessor relationshipCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.selection((int)prop));
        return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public static boolean relationshipHasProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        if (prop == -1) {
            return false;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            return false;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
        return propertyCursor.next();
    }

    public static boolean relationshipHasProperty(RelationshipDataAccessor relationshipCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return false;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
        return propertyCursor.next();
    }

    public static RelationshipTraversalCursor nodeGetRelationships(Read read, CursorFactory cursors, NodeCursor node, long nodeId, Direction direction, CursorContext cursorContext) {
        return CursorUtils.nodeGetRelationships(read, cursors, node, nodeId, direction, null, cursorContext);
    }

    public static AnyValue propertyGet(String key, AnyValue container, Read read, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        assert (container != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (container instanceof VirtualNodeValue) {
            return CursorUtils.nodeGetProperty(read, nodeCursor, ((VirtualNodeValue)container).id(), propertyCursor, dbAccess.propertyKey(key));
        }
        if (container instanceof VirtualRelationshipValue) {
            return CursorUtils.relationshipGetProperty(read, relationshipScanCursor, ((VirtualRelationshipValue)container).id(), propertyCursor, dbAccess.propertyKey(key));
        }
        if (container instanceof MapValue) {
            return ((MapValue)container).get(key);
        }
        if (container instanceof TemporalValue) {
            return ((TemporalValue)container).get(key);
        }
        if (container instanceof DurationValue) {
            return ((DurationValue)container).get(key);
        }
        if (container instanceof PointValue) {
            return ((PointValue)container).get(key);
        }
        throw new CypherTypeException(String.format("Type mismatch: expected a map but was %s", container), null);
    }
}

