/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.neo4j.cypher.operations.CypherFunctions;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValues;
import org.neo4j.values.Comparison;
import org.neo4j.values.Equality;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public final class CypherBoolean {
    private static final BooleanMapper BOOLEAN_MAPPER = new BooleanMapper();

    private CypherBoolean() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static Value xor(AnyValue lhs, AnyValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        return lhs == Values.TRUE ^ rhs == Values.TRUE ? Values.TRUE : Values.FALSE;
    }

    public static Value not(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        return in != Values.TRUE ? Values.TRUE : Values.FALSE;
    }

    public static Value equals(AnyValue lhs, AnyValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        Equality compare = lhs.ternaryEquals(rhs);
        return switch (compare) {
            default -> throw new IncompatibleClassChangeError();
            case Equality.TRUE -> Values.TRUE;
            case Equality.FALSE -> Values.FALSE;
            case Equality.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value notEquals(AnyValue lhs, AnyValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        Equality compare = lhs.ternaryEquals(rhs);
        return switch (compare) {
            default -> throw new IncompatibleClassChangeError();
            case Equality.TRUE -> Values.FALSE;
            case Equality.FALSE -> Values.TRUE;
            case Equality.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static BooleanValue regex(TextValue lhs, TextValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        String regexString = rhs.stringValue();
        try {
            boolean matches = Pattern.compile(regexString).matcher(lhs.stringValue()).matches();
            return matches ? Values.TRUE : Values.FALSE;
        }
        catch (PatternSyntaxException e) {
            throw new InvalidSemanticsException("Invalid Regex: " + e.getMessage(), null);
        }
    }

    public static BooleanValue regex(TextValue text, Pattern pattern) {
        assert (text != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        boolean matches = pattern.matcher(text.stringValue()).matches();
        return matches ? Values.TRUE : Values.FALSE;
    }

    public static Value lessThan(AnyValue lhs, AnyValue rhs) {
        if (AnyValue.isNanAndNumber((AnyValue)lhs, (AnyValue)rhs)) {
            return Values.FALSE;
        }
        Comparison comparison = AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs);
        return switch (comparison) {
            default -> throw new IncompatibleClassChangeError();
            case Comparison.EQUAL -> {
                if (lhs.isIncomparableType()) {
                    yield Values.NO_VALUE;
                }
                yield Values.FALSE;
            }
            case Comparison.GREATER_THAN -> Values.FALSE;
            case Comparison.SMALLER_THAN -> Values.TRUE;
            case Comparison.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value lessThanOrEqual(AnyValue lhs, AnyValue rhs) {
        if (AnyValue.isNanAndNumber((AnyValue)lhs, (AnyValue)rhs)) {
            return Values.FALSE;
        }
        Comparison comparison = AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs);
        return switch (comparison) {
            default -> throw new IncompatibleClassChangeError();
            case Comparison.GREATER_THAN -> Values.FALSE;
            case Comparison.EQUAL, Comparison.SMALLER_THAN -> Values.TRUE;
            case Comparison.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value greaterThan(AnyValue lhs, AnyValue rhs) {
        if (AnyValue.isNanAndNumber((AnyValue)lhs, (AnyValue)rhs)) {
            return Values.FALSE;
        }
        Comparison comparison = AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs);
        return switch (comparison) {
            default -> throw new IncompatibleClassChangeError();
            case Comparison.GREATER_THAN -> Values.TRUE;
            case Comparison.EQUAL -> {
                if (lhs.isIncomparableType()) {
                    yield Values.NO_VALUE;
                }
                yield Values.FALSE;
            }
            case Comparison.SMALLER_THAN -> Values.FALSE;
            case Comparison.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value greaterThanOrEqual(AnyValue lhs, AnyValue rhs) {
        if (AnyValue.isNanAndNumber((AnyValue)lhs, (AnyValue)rhs)) {
            return Values.FALSE;
        }
        Comparison comparison = AnyValues.TERNARY_COMPARATOR.ternaryCompare((Object)lhs, (Object)rhs);
        return switch (comparison) {
            default -> throw new IncompatibleClassChangeError();
            case Comparison.EQUAL, Comparison.GREATER_THAN -> Values.TRUE;
            case Comparison.SMALLER_THAN -> Values.FALSE;
            case Comparison.UNDEFINED -> Values.NO_VALUE;
        };
    }

    public static Value coerceToBoolean(AnyValue value) {
        return (Value)value.map((ValueMapper)BOOLEAN_MAPPER);
    }

    public static Value in(AnyValue lhs, AnyValue rhs) {
        assert (rhs != Values.NO_VALUE);
        ListValue anyValues = CypherFunctions.asList(rhs);
        boolean seenUndefined = false;
        block5: for (AnyValue value : anyValues) {
            switch (lhs.ternaryEquals(value)) {
                case TRUE: {
                    return Values.TRUE;
                }
                case UNDEFINED: {
                    seenUndefined = true;
                }
                case FALSE: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown state");
        }
        return seenUndefined ? Values.NO_VALUE : Values.FALSE;
    }

    private static final class BooleanMapper
    implements ValueMapper<Value> {
        private BooleanMapper() {
        }

        public Value mapPath(VirtualPathValue value) {
            return value.size() > 0 ? Values.TRUE : Values.FALSE;
        }

        public Value mapNode(VirtualNodeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapRelationship(VirtualRelationshipValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapMap(MapValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapNoValue() {
            return Values.NO_VALUE;
        }

        public Value mapSequence(SequenceValue value) {
            return value.length() > 0 ? Values.TRUE : Values.FALSE;
        }

        public Value mapText(TextValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapBoolean(BooleanValue value) {
            return value;
        }

        public Value mapNumber(NumberValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapDateTime(DateTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapLocalDateTime(LocalDateTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapDate(DateValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapTime(TimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapLocalTime(LocalTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapDuration(DurationValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }

        public Value mapPoint(PointValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value);
        }
    }
}

