/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.function.LongPredicate;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.NodeJuxtaposition;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;

public final class State {
    private final boolean isStartState;
    private final boolean isFinalState;
    private final int id;
    private final SlotOrName slotOrName;
    private final LongPredicate predicate;
    private NodeJuxtaposition[] nodeJuxtapositions;
    private RelationshipExpansion[] relationshipExpansions;
    private NodeJuxtaposition[] reverseNodeJuxtapositions;
    private RelationshipExpansion[] reverseRelationshipExpansions;

    public State(int id, SlotOrName slotOrName, LongPredicate predicate, boolean isStartState, boolean isFinalState) {
        this.id = id;
        this.slotOrName = slotOrName;
        this.predicate = predicate;
        this.isStartState = isStartState;
        this.isFinalState = isFinalState;
        this.nodeJuxtapositions = new NodeJuxtaposition[0];
        this.relationshipExpansions = new RelationshipExpansion[0];
        this.reverseNodeJuxtapositions = new NodeJuxtaposition[0];
        this.reverseRelationshipExpansions = new RelationshipExpansion[0];
    }

    public boolean test(long nodeId) {
        return this.predicate.test(nodeId);
    }

    public void setNodeJuxtapositions(NodeJuxtaposition[] nodeJuxtapositions) {
        this.nodeJuxtapositions = nodeJuxtapositions;
    }

    public void setRelationshipExpansions(RelationshipExpansion[] relationshipExpansions) {
        this.relationshipExpansions = relationshipExpansions;
    }

    public void setReverseNodeJuxtapositions(NodeJuxtaposition[] reverseNodeJuxtapositions) {
        this.reverseNodeJuxtapositions = reverseNodeJuxtapositions;
    }

    public void setReverseRelationshipExpansions(RelationshipExpansion[] reverseRelationshipExpansions) {
        this.reverseRelationshipExpansions = reverseRelationshipExpansions;
    }

    public NodeJuxtaposition[] getNodeJuxtapositions() {
        return this.nodeJuxtapositions;
    }

    public RelationshipExpansion[] getRelationshipExpansions() {
        return this.relationshipExpansions;
    }

    public NodeJuxtaposition[] getReverseNodeJuxtapositions() {
        return this.reverseNodeJuxtapositions;
    }

    public RelationshipExpansion[] getReverseRelationshipExpansions() {
        return this.reverseRelationshipExpansions;
    }

    public NodeJuxtaposition[] getNodeJuxtapositions(TraversalDirection direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case TraversalDirection.Forward -> this.nodeJuxtapositions;
            case TraversalDirection.Backward -> this.reverseNodeJuxtapositions;
        };
    }

    public RelationshipExpansion[] getRelationshipExpansions(TraversalDirection direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case TraversalDirection.Forward -> this.relationshipExpansions;
            case TraversalDirection.Backward -> this.reverseRelationshipExpansions;
        };
    }

    public boolean isStartState() {
        return this.isStartState;
    }

    public boolean isFinalState() {
        return this.isFinalState;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return "State(id=" + this.id + ", slotOrName=" + this.slotOrName + ")";
    }

    public SlotOrName slotOrName() {
        return this.slotOrName;
    }
}

