/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Propagator;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SearchMode;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TargetTracker;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;

public class GlobalState {
    private final Propagator propagator;
    private final TargetTracker targetTracker;
    public final SearchMode searchMode;
    public final MemoryTracker mt;
    public final PPBFSHooks hooks;
    public final long initialCountForTargetNodes;
    private int depth = 0;

    public GlobalState(Propagator propagator, TargetTracker targetTracker, SearchMode searchMode, MemoryTracker memoryTracker, PPBFSHooks hooks, int initialCountForTargetNodes) {
        this.propagator = propagator;
        this.targetTracker = targetTracker;
        this.searchMode = searchMode;
        this.mt = memoryTracker;
        this.hooks = hooks;
        this.initialCountForTargetNodes = initialCountForTargetNodes;
    }

    public void schedule(NodeState nodeState, int lengthFromSource, int lengthToTarget, ScheduleSource source) {
        this.propagator.schedule(nodeState, lengthFromSource, lengthToTarget, source);
    }

    public void incrementUnsaturatedTargets() {
        this.targetTracker.incrementUnsaturatedCount();
    }

    public void decrementUnsaturatedTargets() {
        this.targetTracker.decrementUnsaturatedCount();
    }

    public void addTarget(NodeState nodeState) {
        this.targetTracker.addTarget(nodeState);
    }

    public int depth() {
        return this.depth;
    }

    public void nextDepth() {
        ++this.depth;
    }

    public static enum ScheduleSource {
        SourceSignpost,
        Propagated,
        TargetSignpost,
        Validation;

    }
}

