/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import java.util.function.Function;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SignpostStack;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class PathTracer<Row>
extends PrefetchingIterator<Row> {
    private final PPBFSHooks hooks;
    private final SignpostStack stack;
    private NodeState sourceNode;
    private int dgLength;
    private final BitSet protectFromPruning = new BitSet();
    private Function<SignpostStack, Row> toRow;
    private boolean shouldReturnSingleNodePath;
    private boolean ready = false;

    public boolean isSaturated() {
        return this.stack.target().isSaturated();
    }

    public PathTracer(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.hooks = hooks;
        this.stack = new SignpostStack(memoryTracker, hooks);
    }

    public void reset() {
        super.reset();
        this.ready = false;
        this.sourceNode = null;
        this.stack.reset();
    }

    public void initialize(Function<SignpostStack, Row> toRow, NodeState sourceNode, NodeState targetNode, int dgLength) {
        this.toRow = toRow;
        Preconditions.checkState((!this.ready ? 1 : 0) != 0, (String)"PathTracer was not reset before initializing");
        this.ready = true;
        this.sourceNode = sourceNode;
        this.stack.initialize(targetNode, dgLength);
        this.dgLength = dgLength;
        this.shouldReturnSingleNodePath = targetNode == sourceNode && dgLength == 0;
    }

    public boolean ready() {
        return this.ready;
    }

    private void popAndPrune() {
        TwoWaySignpost popped = this.stack.pop();
        if (popped == null) {
            return;
        }
        int sourceLength = this.stack.lengthFromSource();
        if (!popped.isVerifiedAtLength(sourceLength) && !this.protectFromPruning.get(this.stack.size())) {
            popped.pruneSourceLength(sourceLength);
        }
    }

    protected Row fetchNextOrNull() {
        if (!this.ready) {
            throw new IllegalStateException("PathTracer attempted to iterate without initializing.");
        }
        if (this.shouldReturnSingleNodePath && !this.isSaturated()) {
            this.shouldReturnSingleNodePath = false;
            Preconditions.checkState((this.stack.lengthFromSource() == 0 ? 1 : 0) != 0, (String)"Attempting to return a path that does not reach the source");
            return this.toRow.apply(this.stack);
        }
        while (this.stack.hasNext()) {
            if (!this.stack.pushNext()) {
                this.popAndPrune();
                continue;
            }
            TwoWaySignpost sourceSignpost = this.stack.headSignpost();
            this.protectFromPruning.set(this.stack.size() - 1, false);
            if (this.stack.isTargetTrail() && !sourceSignpost.hasBeenTraced()) {
                sourceSignpost.setMinTargetDistance(this.stack.lengthToTarget(), PGPathPropagatingBFS.Phase.Tracing);
            }
            if (this.allNodesAreValidatedBetweenDuplicates()) {
                this.hooks.skippingDuplicateRelationship(this.stack);
                this.stack.pop();
                continue;
            }
            if (sourceSignpost.prevNode != this.sourceNode || !this.validateTrail() || this.isSaturated()) continue;
            Preconditions.checkState((this.stack.lengthFromSource() == 0 ? 1 : 0) != 0, (String)"Attempting to return a path that does not reach the source");
            this.hooks.returnPath(this.stack);
            return this.toRow.apply(this.stack);
        }
        return null;
    }

    private boolean allNodesAreValidatedBetweenDuplicates() {
        int dup = this.stack.distanceToDuplicate();
        if (dup == 0) {
            return false;
        }
        int sourceLength = this.stack.lengthFromSource();
        for (int i = 0; i <= dup; ++i) {
            TwoWaySignpost candidate = this.stack.signpost(this.stack.size() - 1 - i);
            if (!candidate.prevNode.validatedAtLength(sourceLength)) {
                return false;
            }
            sourceLength += candidate.dataGraphLength();
        }
        this.protectFromPruning.set(this.stack.size() - 1 - dup, this.stack.size() - 1, true);
        return true;
    }

    private boolean validateTrail() {
        int sourceLength = 0;
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            TwoWaySignpost signpost = this.stack.signpost(i);
            sourceLength += signpost.dataGraphLength();
            if (signpost instanceof TwoWaySignpost.RelSignpost) {
                TwoWaySignpost.RelSignpost rel = (TwoWaySignpost.RelSignpost)signpost;
                BitSet bitset = (BitSet)this.stack.relationshipPresenceAtDepth.get(rel.relId);
                assert (bitset.get(i));
                if (bitset.length() > i + 1) {
                    this.hooks.invalidTrail(this.stack);
                    return false;
                }
            } else if (signpost instanceof TwoWaySignpost.MultiRelSignpost) {
                TwoWaySignpost.MultiRelSignpost rels = (TwoWaySignpost.MultiRelSignpost)signpost;
                for (int j = 0; j < rels.rels.length; ++j) {
                    long relId = rels.rels[j];
                    BitSet bitset = (BitSet)this.stack.relationshipPresenceAtDepth.get(relId);
                    assert (bitset.get(i));
                    if (bitset.length() <= i + 1) continue;
                    this.hooks.invalidTrail(this.stack);
                    return false;
                }
            }
            if (signpost.isVerifiedAtLength(sourceLength)) continue;
            signpost.setVerified(sourceLength);
            if (signpost.forwardNode.validatedAtLength(sourceLength)) continue;
            signpost.forwardNode.validateSourceLength(sourceLength, this.dgLength - sourceLength);
        }
        return true;
    }

    public void decrementTargetCount() {
        this.stack.target().decrementTargetCount();
    }
}

