/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public class PathValueBuilder
implements Consumer<RelationshipVisitor> {
    private boolean hasBeenBuilt = false;
    private final ArrayList<VirtualNodeValue> nodes = new ArrayList();
    private final ArrayList<VirtualRelationshipValue> rels = new ArrayList();
    private final DbAccess dbAccess;
    private final RelationshipScanCursor cursor;
    private boolean seenNoValue;

    public PathValueBuilder(DbAccess dbAccess, RelationshipScanCursor cursor) {
        this.dbAccess = dbAccess;
        this.cursor = cursor;
    }

    public AnyValue build() {
        if (this.hasBeenBuilt) {
            throw new IllegalStateException("This PathValueBuilder has already been used and reuse is not allowed.");
        }
        this.hasBeenBuilt = true;
        return this.seenNoValue ? Values.NO_VALUE : VirtualValues.pathReference(this.nodes, this.rels);
    }

    public void addNodeFromList(AnyValue value, int offset) {
        if (this.notNoValue(value)) {
            if (value instanceof ListValue) {
                ListValue listValue = (ListValue)value;
                this.addNode(listValue.value((long)offset));
            } else {
                if (value instanceof Value) {
                    Value v = (Value)value;
                    throw CypherTypeException.expectedListFound((String)String.valueOf(v), (String)v.prettyPrint(), (String)CypherTypeValueMapper.valueType(value));
                }
                throw CypherTypeException.expectedListFound((String)String.valueOf(value), (String)String.valueOf(value), (String)CypherTypeValueMapper.valueType(value));
            }
        }
    }

    public void addNode(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addNode((VirtualNodeValue)value);
        }
    }

    public void addRelationshipFromList(AnyValue value, int offset) {
        if (this.notNoValue(value)) {
            if (value instanceof ListValue) {
                ListValue listValue = (ListValue)value;
                this.addRelationship(listValue.value((long)offset));
            } else {
                if (value instanceof Value) {
                    Value v = (Value)value;
                    throw CypherTypeException.expectedListFound((String)String.valueOf(v), (String)v.prettyPrint(), (String)CypherTypeValueMapper.valueType(value));
                }
                throw CypherTypeException.expectedListFound((String)String.valueOf(value), (String)String.valueOf(value), (String)CypherTypeValueMapper.valueType(value));
            }
        }
    }

    public void addRelationship(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addRelationship((VirtualRelationshipValue)value);
        }
    }

    public void addRelationship(VirtualRelationshipValue value) {
        this.rels.add(value);
    }

    public void addNode(VirtualNodeValue nodeValue) {
        this.nodes.add(nodeValue);
    }

    public void addIncoming(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addIncoming((VirtualRelationshipValue)value);
        }
    }

    public void addIncoming(VirtualRelationshipValue relationship) {
        this.nodes.add((VirtualNodeValue)VirtualValues.node((long)relationship.startNodeId((Consumer)this)));
        this.rels.add(relationship);
    }

    public void addOutgoing(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addOutgoing((VirtualRelationshipValue)value);
        }
    }

    public void addOutgoing(VirtualRelationshipValue relationship) {
        this.nodes.add((VirtualNodeValue)VirtualValues.node((long)relationship.endNodeId((Consumer)this)));
        this.rels.add(relationship);
    }

    private void add(VirtualRelationshipValue relationship, VirtualNodeValue nextNode) {
        this.rels.add(relationship);
        this.nodes.add(nextNode);
    }

    public void addUndirected(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addUndirected((VirtualRelationshipValue)value);
        }
    }

    public void addUndirected(VirtualRelationshipValue relationship) {
        VirtualNodeValue previous = this.nodes.get(this.nodes.size() - 1);
        long start = relationship.startNodeId((Consumer)this);
        long end = relationship.endNodeId((Consumer)this);
        if (previous.id() == start) {
            this.add(relationship, (VirtualNodeValue)VirtualValues.node((long)end));
        } else {
            this.add(relationship, (VirtualNodeValue)VirtualValues.node((long)start));
        }
    }

    public void addMultipleIncoming(AnyValue value, AnyValue target) {
        if (this.notNoValue(value) && this.notNoValue(target)) {
            this.addMultipleIncoming((ListValue)value, (VirtualNodeValue)target);
        }
    }

    public void addMultipleIncoming(ListValue relationships, VirtualNodeValue target) {
        if (relationships.isEmpty()) {
            return;
        }
        AnyValue last = relationships.last();
        relationships.forEach(r -> {
            if (r == last) {
                if (this.notNoValue(last)) {
                    this.nodes.add(target);
                    this.rels.add((VirtualRelationshipValue)last);
                }
            } else {
                this.addIncoming((AnyValue)r);
            }
        });
    }

    public void addMultipleIncoming(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addMultipleIncoming((ListValue)value);
        }
    }

    public void addMultipleIncoming(ListValue relationships) {
        if (relationships.isEmpty()) {
            return;
        }
        relationships.forEach(this::addIncoming);
    }

    public void addMultipleOutgoing(AnyValue value, AnyValue target) {
        if (this.notNoValue(value) && this.notNoValue(target)) {
            this.addMultipleOutgoing((ListValue)value, (VirtualNodeValue)target);
        }
    }

    public void addMultipleOutgoing(ListValue relationships, VirtualNodeValue target) {
        if (relationships.isEmpty()) {
            return;
        }
        AnyValue last = relationships.last();
        relationships.forEach(r -> {
            if (r == last) {
                if (this.notNoValue(last)) {
                    this.rels.add((VirtualRelationshipValue)last);
                    this.nodes.add(target);
                }
            } else {
                this.addOutgoing((AnyValue)r);
            }
        });
    }

    public void addMultipleOutgoing(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addMultipleOutgoing((ListValue)value);
        }
    }

    public void addMultipleOutgoing(ListValue relationships) {
        if (relationships.isEmpty()) {
            return;
        }
        relationships.forEach(this::addOutgoing);
    }

    public void addMultipleUndirected(AnyValue value, AnyValue target) {
        if (this.notNoValue(value) && this.notNoValue(target)) {
            this.addMultipleUndirected((ListValue)value, (VirtualNodeValue)target);
        }
    }

    public void addMultipleUndirected(ListValue relationships, VirtualNodeValue target) {
        if (relationships.isEmpty()) {
            return;
        }
        AnyValue last = relationships.value(relationships.actualSize() - 1L);
        relationships.forEach(r -> {
            if (r == last) {
                if (this.notNoValue(last)) {
                    this.rels.add((VirtualRelationshipValue)last);
                    this.nodes.add(target);
                }
            } else {
                this.addUndirected((AnyValue)r);
            }
        });
    }

    public void addMultipleUndirected(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addMultipleUndirected((ListValue)value);
        }
    }

    public void addMultipleUndirected(ListValue relationships) {
        if (relationships.isEmpty()) {
            return;
        }
        relationships.forEach(this::addUndirected);
    }

    public void addNoValue() {
        this.seenNoValue = true;
    }

    @Override
    public void accept(RelationshipVisitor relationshipVisitor) {
        this.dbAccess.singleRelationship(relationshipVisitor.id(), this.cursor);
        this.cursor.next();
        relationshipVisitor.visit(this.cursor.sourceNodeReference(), this.cursor.targetNodeReference(), this.cursor.type());
    }

    private boolean notNoValue(AnyValue value) {
        if (!this.seenNoValue && value == Values.NO_VALUE) {
            this.seenNoValue = true;
        }
        return !this.seenNoValue;
    }
}

