/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.ReadAndDeleteTransactionConflictException;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.FullNodeReference;
import org.neo4j.values.virtual.HeapTrackingListValueBuilder;
import org.neo4j.values.virtual.HeapTrackingMapValueBuilder;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class ValuePopulation {
    public static final NodeValue MISSING_NODE = VirtualValues.nodeValue((long)-1L, (String)"", (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP, (boolean)false);

    private ValuePopulation() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static AnyValue populate(AnyValue value, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor, MemoryTracker memoryTracker) {
        ListValue list;
        if (value instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)value;
            return ValuePopulation.populate(node, dbAccess, nodeCursor, propertyCursor);
        }
        if (value instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)value;
            return ValuePopulation.populate(relationship, dbAccess, relCursor, propertyCursor);
        }
        if (value instanceof VirtualPathValue) {
            VirtualPathValue path = (VirtualPathValue)value;
            return ValuePopulation.populate(path, dbAccess, nodeCursor, relCursor, propertyCursor);
        }
        if (value instanceof ListValue && ValuePopulation.needsPopulation(list = (ListValue)value)) {
            return ValuePopulation.populate(list, dbAccess, nodeCursor, relCursor, propertyCursor, memoryTracker);
        }
        if (value instanceof MapValue) {
            MapValue map = (MapValue)value;
            return ValuePopulation.populate(map, dbAccess, nodeCursor, relCursor, propertyCursor, memoryTracker);
        }
        return value;
    }

    private static boolean needsPopulation(ListValue list) {
        ValueRepresentation itemType = list.itemValueRepresentation();
        return itemType == ValueRepresentation.UNKNOWN || itemType == ValueRepresentation.ANYTHING;
    }

    public static NodeValue populate(VirtualNodeValue value, DbAccess dbAccess, NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        NodeEntityWrappingNodeValue wrappingNodeValue;
        if (value instanceof NodeEntityWrappingNodeValue && !(wrappingNodeValue = (NodeEntityWrappingNodeValue)value).isPopulated()) {
            if (wrappingNodeValue.canPopulate()) {
                wrappingNodeValue.populate(nodeCursor, propertyCursor);
                return wrappingNodeValue;
            }
            return ValuePopulation.nodeValue(value.id(), dbAccess, nodeCursor, propertyCursor);
        }
        if (value instanceof NodeValue) {
            return (NodeValue)value;
        }
        return ValuePopulation.nodeValue(value.id(), dbAccess, nodeCursor, propertyCursor);
    }

    public static RelationshipValue populate(VirtualRelationshipValue value, DbAccess dbAccess, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        RelationshipEntityWrappingValue wrappingValue;
        if (value instanceof RelationshipEntityWrappingValue && !(wrappingValue = (RelationshipEntityWrappingValue)value).isPopulated()) {
            if (wrappingValue.canPopulate()) {
                wrappingValue.populate(relCursor, propertyCursor);
                return wrappingValue;
            }
            return ValuePopulation.relationshipValue(value.id(), dbAccess, relCursor, propertyCursor);
        }
        if (value instanceof RelationshipValue) {
            return (RelationshipValue)value;
        }
        return ValuePopulation.relationshipValue(value.id(), dbAccess, relCursor, propertyCursor);
    }

    private static PathValue populate(VirtualPathValue value, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        NodeValue nodeValue;
        int i;
        if (value instanceof PathValue) {
            return (PathValue)value;
        }
        long[] nodeIds = value.nodeIds();
        long[] relIds = value.relationshipIds();
        NodeValue[] nodes = new NodeValue[nodeIds.length];
        RelationshipValue[] rels = new RelationshipValue[relIds.length];
        long payloadSize = 0L;
        for (i = 0; i < rels.length; ++i) {
            nodeValue = ValuePopulation.nodeValue(nodeIds[i], dbAccess, nodeCursor, propertyCursor);
            RelationshipValue relationshipValue = ValuePopulation.relationshipValue(relIds[i], dbAccess, relCursor, propertyCursor);
            payloadSize += nodeValue.estimatedHeapUsage() + relationshipValue.estimatedHeapUsage();
            nodes[i] = nodeValue;
            rels[i] = relationshipValue;
        }
        nodeValue = ValuePopulation.nodeValue(nodeIds[i], dbAccess, nodeCursor, propertyCursor);
        nodes[i] = nodeValue;
        return VirtualValues.path((NodeValue[])nodes, (RelationshipValue[])rels, (long)(payloadSize += nodeValue.estimatedHeapUsage()));
    }

    private static MapValue populate(MapValue value, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor, MemoryTracker memoryTracker) {
        HeapTrackingMapValueBuilder builder = HeapTrackingMapValueBuilder.newHeapTrackingMapValueBuilder((MemoryTracker)memoryTracker);
        value.foreach((key, anyValue) -> builder.put(key, ValuePopulation.populate(anyValue, dbAccess, nodeCursor, relCursor, propertyCursor, memoryTracker)));
        return builder.buildAndClose();
    }

    private static ListValue populate(ListValue value, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor, MemoryTracker memoryTracker) {
        HeapTrackingListValueBuilder builder = HeapTrackingListValueBuilder.newHeapTrackingListBuilder((MemoryTracker)memoryTracker);
        for (AnyValue v : value) {
            builder.add(ValuePopulation.populate(v, dbAccess, nodeCursor, relCursor, propertyCursor, memoryTracker));
        }
        return builder.buildAndClose();
    }

    public static NodeValue nodeValue(long id, DbAccess dbAccess, NodeCursor nodeCursor, PropertyCursor propertyCursor, MapValueBuilder readProperties, IntSet readPropertyTokens) {
        dbAccess.singleNode(id, nodeCursor);
        String elementId = dbAccess.elementIdMapper().nodeElementId(id);
        if (!nodeCursor.next()) {
            return VirtualValues.nodeValue((long)id, (String)elementId, (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP, (boolean)true);
        }
        nodeCursor.properties(propertyCursor, PropertySelection.ALL_PROPERTIES.excluding(arg_0 -> ((IntSet)readPropertyTokens).contains(arg_0)));
        return VirtualValues.nodeValue((long)id, (String)elementId, (TextArray)ValuePopulation.labels(dbAccess, nodeCursor.labels()), (MapValue)ValuePopulation.properties(propertyCursor, dbAccess, readProperties));
    }

    private static NodeValue nodeValue(long id, DbAccess dbAccess, NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        dbAccess.singleNode(id, nodeCursor);
        String elementId = dbAccess.elementIdMapper().nodeElementId(id);
        if (!nodeCursor.next()) {
            if (!dbAccess.nodeDeletedInThisTransaction(id)) {
                ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
                throw new ReadAndDeleteTransactionConflictException(gql, false);
            }
            return VirtualValues.nodeValue((long)id, (String)elementId, (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP, (boolean)true);
        }
        nodeCursor.properties(propertyCursor);
        return VirtualValues.nodeValue((long)id, (String)elementId, (TextArray)ValuePopulation.labels(dbAccess, nodeCursor.labels()), (MapValue)ValuePopulation.properties(propertyCursor, dbAccess));
    }

    public static RelationshipValue relationshipValue(long id, DbAccess dbAccess, RelationshipScanCursor relCursor, PropertyCursor propertyCursor, MapValueBuilder readProperties, IntSet readPropertyTokens) {
        dbAccess.singleRelationship(id, relCursor);
        ElementIdMapper idMapper = dbAccess.elementIdMapper();
        String elementId = idMapper.relationshipElementId(id);
        if (!relCursor.next()) {
            return VirtualValues.relationshipValue((long)id, (String)elementId, (VirtualNodeReference)MISSING_NODE, (VirtualNodeReference)MISSING_NODE, (TextValue)Values.EMPTY_STRING, (MapValue)VirtualValues.EMPTY_MAP, (boolean)true);
        }
        FullNodeReference start = VirtualValues.node((long)relCursor.sourceNodeReference(), (ElementIdMapper)idMapper);
        FullNodeReference end = VirtualValues.node((long)relCursor.targetNodeReference(), (ElementIdMapper)idMapper);
        relCursor.properties(propertyCursor, PropertySelection.ALL_PROPERTIES.excluding(arg_0 -> ((IntSet)readPropertyTokens).contains(arg_0)));
        return VirtualValues.relationshipValue((long)id, (String)elementId, (VirtualNodeReference)start, (VirtualNodeReference)end, (TextValue)Values.stringValue((String)dbAccess.relationshipTypeName(relCursor.type())), (MapValue)ValuePopulation.properties(propertyCursor, dbAccess, readProperties));
    }

    private static RelationshipValue relationshipValue(long id, DbAccess dbAccess, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        dbAccess.singleRelationship(id, relCursor);
        ElementIdMapper idMapper = dbAccess.elementIdMapper();
        String elementId = idMapper.relationshipElementId(id);
        if (!relCursor.next()) {
            if (!dbAccess.relationshipDeletedInThisTransaction(id)) {
                ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
                throw new ReadAndDeleteTransactionConflictException(gql, false);
            }
            return VirtualValues.relationshipValue((long)id, (String)elementId, (VirtualNodeReference)MISSING_NODE, (VirtualNodeReference)MISSING_NODE, (TextValue)Values.EMPTY_STRING, (MapValue)VirtualValues.EMPTY_MAP, (boolean)true);
        }
        FullNodeReference start = VirtualValues.node((long)relCursor.sourceNodeReference(), (ElementIdMapper)idMapper);
        FullNodeReference end = VirtualValues.node((long)relCursor.targetNodeReference(), (ElementIdMapper)idMapper);
        relCursor.properties(propertyCursor);
        return VirtualValues.relationshipValue((long)id, (String)elementId, (VirtualNodeReference)start, (VirtualNodeReference)end, (TextValue)Values.stringValue((String)dbAccess.relationshipTypeName(relCursor.type())), (MapValue)ValuePopulation.properties(propertyCursor, dbAccess));
    }

    public static TextArray labels(DbAccess dbAccess, TokenSet labelsTokens) {
        String[] labels = new String[labelsTokens.numberOfTokens()];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = dbAccess.nodeLabelName(labelsTokens.token(i));
        }
        return Values.stringArray((String[])labels);
    }

    public static MapValue properties(PropertyCursor propertyCursor, DbAccess dbAccess) {
        return ValuePopulation.properties(propertyCursor, dbAccess, new MapValueBuilder());
    }

    public static MapValue properties(PropertyCursor propertyCursor, DbAccess dbAccess, MapValueBuilder builder) {
        while (propertyCursor.next()) {
            builder.add(dbAccess.propertyKeyName(propertyCursor.propertyKey()), (AnyValue)propertyCursor.propertyValue());
        }
        return builder.build();
    }
}

