/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.cypher.internal.runtime.ResourceMonitor;
import org.neo4j.cypher.internal.runtime.ResourcePool;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import scala.collection.Iterator;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e3A!\u0003\u0006\u0001+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0004)\u0001\t\u0007I\u0011A\u0015\t\rm\u0002\u0001\u0015!\u0003+\u0011\u0015a\u0004\u0001\"\u0011>\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u00159\u0006\u0001\"\u0011Y\u0005Y!\u0006N]3bIN\u000bg-\u001a*fg>,(oY3Q_>d'BA\u0006\r\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0004\b\u0002\u0011%tG/\u001a:oC2T!a\u0004\t\u0002\r\rL\b\u000f[3s\u0015\t\t\"#A\u0003oK>$$NC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005uqR\"\u0001\u0006\n\u0005}Q!\u0001\u0004*fg>,(oY3Q_>d\u0017aB7p]&$xN\u001d\t\u0003;\tJ!a\t\u0006\u0003\u001fI+7o\\;sG\u0016luN\\5u_J\fa\u0001P5oSRtDC\u0001\u0014(!\ti\u0002\u0001C\u0003!\u0005\u0001\u0007\u0011%A\u0005sKN|WO]2fgV\t!\u0006E\u0002,aIj\u0011\u0001\f\u0006\u0003[9\nA!\u001e;jY*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0003gej\u0011\u0001\u000e\u0006\u0003kY\n1!\u00199j\u0015\t9\u0004(\u0001\u0004lKJtW\r\u001c\u0006\u0003\u001bAI!A\u000f\u001b\u0003#\u0005+Ho\\\"m_N,\u0017M\u00197f!2,8/\u0001\u0006sKN|WO]2fg\u0002\n1!\u00193e)\tq\u0014\t\u0005\u0002\u0018\u007f%\u0011\u0001\t\u0007\u0002\u0005+:LG\u000fC\u0003C\u000b\u0001\u0007!'\u0001\u0005sKN|WO]2f\u0003\u0019\u0011X-\\8wKR\u0011Q\t\u0013\t\u0003/\u0019K!a\u0012\r\u0003\u000f\t{w\u000e\\3b]\")!I\u0002a\u0001e\u0005\u0019\u0011\r\u001c7\u0015\u0003-\u00032\u0001\u0014+3\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002Q)\u00051AH]8pizJ\u0011!G\u0005\u0003'b\tq\u0001]1dW\u0006<W-\u0003\u0002V-\nA\u0011\n^3sCR|'O\u0003\u0002T1\u0005A1\r\\8tK\u0006cG\u000eF\u0001?\u0001")
public class ThreadSafeResourcePool
implements ResourcePool {
    private final ResourceMonitor monitor;
    private final Collection<AutoCloseablePlus> resources;

    @Override
    public String toString() {
        return ResourcePool.toString$(this);
    }

    public Collection<AutoCloseablePlus> resources() {
        return this.resources;
    }

    @Override
    public void add(AutoCloseablePlus resource) {
        this.resources().add(resource);
    }

    @Override
    public boolean remove(AutoCloseablePlus resource) {
        return this.resources().remove(resource);
    }

    @Override
    public Iterator<AutoCloseablePlus> all() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.resources().iterator()).asScala();
    }

    @Override
    public void closeAll() {
        java.util.Iterator<AutoCloseablePlus> iterator = this.resources().iterator();
        Throwable error = null;
        while (iterator.hasNext()) {
            try {
                AutoCloseablePlus resource = iterator.next();
                this.monitor.close(resource);
                resource.setCloseListener(null);
                resource.close();
            }
            catch (Throwable t) {
                error = Exceptions.chain(error, (Throwable)t);
            }
        }
        if (error != null) {
            throw error;
        }
        this.resources().clear();
    }

    public ThreadSafeResourcePool(ResourceMonitor monitor) {
        this.monitor = monitor;
        ResourcePool.$init$(this);
        this.resources = new ConcurrentLinkedQueue<AutoCloseablePlus>();
    }
}

