/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.helpers.BiDirectionalBFS;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualValues;

public class PathTracingIterator
extends PrefetchingIterator<PathReference> {
    private final int pathLength;
    private final int intersectionNodeIndex;
    private final LongIterator intersectionIterator;
    private final Predicate<PathReference> pathFilter;
    private final PathIteratorPart innerLoopPathPart;
    private final PathIteratorPart outerLoopPathPart;
    private final long[] internalNodes;
    private final long[] internalRels;
    private boolean consumedFirstPath = false;
    private boolean finished = false;

    public PathTracingIterator(LongIterator intersectionIterator, int sourceBFSDepth, int targetBFSDepth, HeapTrackingLongObjectHashMap<HeapTrackingArrayList<BiDirectionalBFS.PathTraceStep>> sourcePathTraceData, HeapTrackingLongObjectHashMap<HeapTrackingArrayList<BiDirectionalBFS.PathTraceStep>> targetPathTraceData, Predicate<PathReference> pathFilter) {
        this.intersectionIterator = intersectionIterator;
        this.pathFilter = pathFilter;
        this.pathLength = sourceBFSDepth + targetBFSDepth;
        this.intersectionNodeIndex = sourceBFSDepth;
        this.internalNodes = new long[this.pathLength + 1];
        this.internalRels = new long[this.pathLength];
        PathIteratorPart sourcePathPart = new PathIteratorPart(sourcePathTraceData, sourceBFSDepth, false);
        PathIteratorPart targetPathPart = new PathIteratorPart(targetPathTraceData, targetBFSDepth, true);
        this.setNextIntersectionNode();
        sourcePathPart.resetPathPartToIntersection();
        targetPathPart.resetPathPartToIntersection();
        if (sourceBFSDepth > targetBFSDepth) {
            this.innerLoopPathPart = targetPathPart;
            this.outerLoopPathPart = sourcePathPart;
        } else {
            this.innerLoopPathPart = sourcePathPart;
            this.outerLoopPathPart = targetPathPart;
        }
    }

    protected PathReference fetchNextOrNull() {
        while (this.viewNextPath()) {
            if (!this.pathFilter.test(VirtualValues.pathReference((long[])this.internalNodes, (long[])this.internalRels))) continue;
            return this.currentPath();
        }
        return null;
    }

    private boolean viewNextPath() {
        if (this.finished) {
            return false;
        }
        if (!this.consumedFirstPath) {
            this.consumedFirstPath = true;
            return true;
        }
        if (this.innerLoopPathPart.viewNextPath()) {
            return true;
        }
        if (this.outerLoopPathPart.viewNextPath()) {
            this.innerLoopPathPart.resetPathPartToIntersection();
            return true;
        }
        if (this.setNextIntersectionNode()) {
            this.innerLoopPathPart.resetPathPartToIntersection();
            this.outerLoopPathPart.resetPathPartToIntersection();
            return true;
        }
        this.finished = true;
        return false;
    }

    private boolean setNextIntersectionNode() {
        if (!this.intersectionIterator.hasNext()) {
            return false;
        }
        this.internalNodes[this.intersectionNodeIndex] = this.intersectionIterator.next();
        return true;
    }

    private PathReference currentPath() {
        return VirtualValues.pathReference((long[])((long[])this.internalNodes.clone()), (long[])((long[])this.internalRels.clone()));
    }

    private class PathIteratorPart {
        private final int pathPartLength;
        private final HeapTrackingLongObjectHashMap<HeapTrackingArrayList<BiDirectionalBFS.PathTraceStep>> pathTraceData;
        private final boolean reversed;
        private final int[] pathsToHereActiveIndices;

        public PathIteratorPart(HeapTrackingLongObjectHashMap<HeapTrackingArrayList<BiDirectionalBFS.PathTraceStep>> pathTraceData, int pathPartLength, boolean reversed) {
            this.pathTraceData = pathTraceData;
            this.reversed = reversed;
            this.pathPartLength = pathPartLength;
            this.pathsToHereActiveIndices = new int[pathPartLength];
        }

        private void updateInternalNodes(long nodeId, int pathPartIndexOfNode) {
            int internalNodesIndex = this.reversed ? PathTracingIterator.this.pathLength - pathPartIndexOfNode : pathPartIndexOfNode;
            PathTracingIterator.this.internalNodes[internalNodesIndex] = nodeId;
        }

        private long getInternalNode(int pathPartIndexOfNode) {
            int internalNodesIndex = this.reversed ? PathTracingIterator.this.pathLength - pathPartIndexOfNode : pathPartIndexOfNode;
            return PathTracingIterator.this.internalNodes[internalNodesIndex];
        }

        private void updateInternalRelsToNode(long relId, int pathPartIndexOfNode) {
            int internalRelsIndex = this.reversed ? PathTracingIterator.this.pathLength - 1 - (pathPartIndexOfNode - 1) : pathPartIndexOfNode - 1;
            PathTracingIterator.this.internalRels[internalRelsIndex] = relId;
        }

        private BiDirectionalBFS.PathTraceStep getActivePathToNode(int pathPartIndexOfNode) {
            long node = this.getInternalNode(pathPartIndexOfNode);
            return (BiDirectionalBFS.PathTraceStep)((HeapTrackingArrayList)this.pathTraceData.get(node)).get(this.pathsToHereActiveIndices[pathPartIndexOfNode - 1]);
        }

        private boolean activateNextPathPartToNode(int pathPartIndexOfNode) {
            long node = this.getInternalNode(pathPartIndexOfNode);
            HeapTrackingArrayList pathsToNode = (HeapTrackingArrayList)this.pathTraceData.get(node);
            if (this.pathsToHereActiveIndices[pathPartIndexOfNode - 1] == pathsToNode.size() - 1) {
                return false;
            }
            int n = pathPartIndexOfNode - 1;
            this.pathsToHereActiveIndices[n] = this.pathsToHereActiveIndices[n] + 1;
            BiDirectionalBFS.PathTraceStep pathToHere = this.getActivePathToNode(pathPartIndexOfNode);
            this.updateInternalRelsToNode(pathToHere.relId, pathPartIndexOfNode);
            this.updateInternalNodes(pathToHere.prevNodeId, pathPartIndexOfNode - 1);
            return true;
        }

        private void activateFirstPathStepToNode(int pathPartIndexOfNode) {
            this.pathsToHereActiveIndices[pathPartIndexOfNode - 1] = 0;
            BiDirectionalBFS.PathTraceStep pathToHere = this.getActivePathToNode(pathPartIndexOfNode);
            this.updateInternalRelsToNode(pathToHere.relId, pathPartIndexOfNode);
            this.updateInternalNodes(pathToHere.prevNodeId, pathPartIndexOfNode - 1);
        }

        public void resetPathPartToIntersection() {
            this.resetPathPartToNodeAtIndex(this.pathPartLength);
        }

        public void resetPathPartToNodeAtIndex(int nodeIndex) {
            assert (nodeIndex <= this.pathPartLength);
            while (nodeIndex > 0) {
                this.activateFirstPathStepToNode(nodeIndex);
                --nodeIndex;
            }
        }

        public boolean viewNextPath() {
            if (this.pathPartLength == 0) {
                return false;
            }
            int indexToIterate = 1;
            while (!this.activateNextPathPartToNode(indexToIterate)) {
                if (++indexToIterate <= this.pathPartLength) continue;
                return false;
            }
            this.resetPathPartToNodeAtIndex(indexToIterate - 1);
            return true;
        }
    }
}

