/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.cypher.internal.runtime.ResourceMonitor;
import org.neo4j.cypher.internal.runtime.ResourcePool;
import org.neo4j.cypher.internal.runtime.SingleThreadedResourcePool$;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001B\f\u0019\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003>\u0001\u0011\u0005a\b\u0003\u0004D\u0001\u0001\u0006Ka\f\u0005\u0007\t\u0002\u0001\u000b\u0015B#\t\rE\u0003\u0001\u0015)\u0003S\u0011\u0019)\u0006\u0001)Q\u0005-\")\u0011\f\u0001C\u00015\")\u0001\r\u0001C\u0001C\")1\r\u0001C\u0001I\")\u0011\u000f\u0001C\u0005e\")1\u000f\u0001C\u0001i\")q\u0010\u0001C\u0001e\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001BBA\u0003\u0001\u0011%!\u000fC\u0004\u0002\b\u0001!\t!!\u0003\b\u000f\u0005E\u0001\u0004#\u0001\u0002\u0014\u00191q\u0003\u0007E\u0001\u0003+Aa!P\n\u0005\u0002\u0005]\u0001\"CA\r'\t\u0007I\u0011BA\u000e\u0011\u001d\tib\u0005Q\u0001\nI\u0013!dU5oO2,G\u000b\u001b:fC\u0012,GMU3t_V\u00148-\u001a)p_2T!!\u0007\u000e\u0002\u000fI,h\u000e^5nK*\u00111\u0004H\u0001\tS:$XM\u001d8bY*\u0011QDH\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005}\u0001\u0013!\u00028f_RR'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VM\u001a\t\u0003W1j\u0011\u0001G\u0005\u0003[a\u0011ABU3t_V\u00148-\u001a)p_2\f\u0001bY1qC\u000eLG/\u001f\t\u0003KAJ!!\r\u0014\u0003\u0007%sG/A\u0004n_:LGo\u001c:\u0011\u0005-\"\u0014BA\u001b\u0019\u0005=\u0011Vm]8ve\u000e,Wj\u001c8ji>\u0014\u0018!D7f[>\u0014\u0018\u0010\u0016:bG.,'\u000f\u0005\u00029w5\t\u0011H\u0003\u0002;=\u00051Q.Z7pefL!\u0001P\u001d\u0003\u001b5+Wn\u001c:z)J\f7m[3s\u0003\u0019a\u0014N\\5u}Q!q\bQ!C!\tY\u0003\u0001C\u0003/\t\u0001\u0007q\u0006C\u00033\t\u0001\u00071\u0007C\u00037\t\u0001\u0007q'\u0001\u0005iS\u001eDW*\u0019:l\u0003)\u0019Gn\\:fC\ndWm\u001d\t\u0004K\u0019C\u0015BA$'\u0005\u0015\t%O]1z!\tIu*D\u0001K\u0015\tYE*A\u0002ba&T!!\u0014(\u0002\r-,'O\\3m\u0015\tYb$\u0003\u0002Q\u0015\n\t\u0012)\u001e;p\u00072|7/Z1cY\u0016\u0004F.^:\u0002\u0017Q\u0014\u0018mY6fINK'0\u001a\t\u0003KMK!\u0001\u0016\u0014\u0003\t1{gnZ\u0001\n?&\u001c8\t\\8tK\u0012\u0004\"!J,\n\u0005a3#a\u0002\"p_2,\u0017M\\\u0001\u0004C\u0012$GCA._!\t)C,\u0003\u0002^M\t!QK\\5u\u0011\u0015y\u0016\u00021\u0001I\u0003!\u0011Xm]8ve\u000e,\u0017A\u0002:f[>4X\r\u0006\u0002WE\")qL\u0003a\u0001\u0011\u0006\u0019\u0011\r\u001c7\u0015\u0003\u0015\u00042A\u001a8I\u001d\t9GN\u0004\u0002iW6\t\u0011N\u0003\u0002kE\u00051AH]8pizJ\u0011aJ\u0005\u0003[\u001a\nq\u0001]1dW\u0006<W-\u0003\u0002pa\nA\u0011\n^3sCR|'O\u0003\u0002nM\u0005)1\r\\3beR\t1,\u0001\fbY2Len\u00197vI&twMT;mYZ\u000bG.^3t+\u0005)\bc\u00014w\u0011&\u0011q\u000f\u001d\u0002\u0004'\u0016\f\bFA\u0007z!\tQX0D\u0001|\u0015\tah$\u0001\u0003vi&d\u0017B\u0001@|\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\tG2|7/Z!mY\u0006A\u0011n]\"m_N,G-F\u0001W\u00039)gn];sK\u000e\u000b\u0007/Y2jif\fabY8naV$XMT3x'&TX\rF\u00020\u0003\u0017Aa!!\u0004\u0012\u0001\u0004y\u0013aB8mINK'0\u001a\u0015\u0003#e\f!dU5oO2,G\u000b\u001b:fC\u0012,GMU3t_V\u00148-\u001a)p_2\u0004\"aK\n\u0014\u0005M!CCAA\n\u00031\u0019\u0006*\u0011'M\u001f^{6+\u0013.F+\u0005\u0011\u0016!D*I\u00032cujV0T\u0013j+\u0005\u0005")
public class SingleThreadedResourcePool
implements ResourcePool {
    private final ResourceMonitor monitor;
    private final MemoryTracker memoryTracker;
    public int org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark;
    public AutoCloseablePlus[] org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables;
    private long trackedSize;
    private boolean _isClosed;

    @Override
    public String toString() {
        return ResourcePool.toString$(this);
    }

    @Override
    public void add(AutoCloseablePlus resource) {
        int i = resource.getToken();
        if (i == -1) {
            this.ensureCapacity();
            this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark] = resource;
            resource.setToken(this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark);
            ++this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark;
            return;
        }
        if (this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i] != resource) {
            throw new IllegalStateException(resource + " does not match " + this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i]);
        }
    }

    @Override
    public boolean remove(AutoCloseablePlus resource) {
        int i = resource.getToken();
        if (i < this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark && i != -1) {
            if (this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i] != resource) {
                throw new IllegalStateException(resource + " does not match " + this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i]);
            }
            resource.setToken(-1);
            this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i] = null;
            if (i == this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark - 1) {
                int j;
                for (j = i; j >= 0 && this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[j] == null; --j) {
                }
                this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark -= i - j;
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterator<AutoCloseablePlus> all() {
        return new Iterator<AutoCloseablePlus>(this){
            private int offset;
            private final /* synthetic */ SingleThreadedResourcePool $outer;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<AutoCloseablePlus> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<AutoCloseablePlus> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<AutoCloseablePlus> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<AutoCloseablePlus>, Iterator<AutoCloseablePlus>> partition(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, AutoCloseablePlus, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<AutoCloseablePlus, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<AutoCloseablePlus, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<AutoCloseablePlus> filter(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<AutoCloseablePlus> filterNot(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<AutoCloseablePlus> filterImpl(Function1<AutoCloseablePlus, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<AutoCloseablePlus> withFilter(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<AutoCloseablePlus, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<AutoCloseablePlus> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<AutoCloseablePlus> distinctBy(Function1<AutoCloseablePlus, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<AutoCloseablePlus, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<AutoCloseablePlus, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<AutoCloseablePlus, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<AutoCloseablePlus> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<AutoCloseablePlus> takeWhile(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<AutoCloseablePlus> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<AutoCloseablePlus> dropWhile(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<AutoCloseablePlus>, Iterator<AutoCloseablePlus>> span(Function1<AutoCloseablePlus, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<AutoCloseablePlus> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<AutoCloseablePlus> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<AutoCloseablePlus, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<AutoCloseablePlus, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<AutoCloseablePlus>, Iterator<AutoCloseablePlus>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<AutoCloseablePlus> tapEach(Function1<AutoCloseablePlus, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<AutoCloseablePlus> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<AutoCloseablePlus>, Iterator<AutoCloseablePlus>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<AutoCloseablePlus, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<AutoCloseablePlus, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<AutoCloseablePlus, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<AutoCloseablePlus, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<AutoCloseablePlus> find(Function1<AutoCloseablePlus, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, AutoCloseablePlus, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<AutoCloseablePlus, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, AutoCloseablePlus, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<AutoCloseablePlus, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, AutoCloseablePlus, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<AutoCloseablePlus, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, AutoCloseablePlus, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<AutoCloseablePlus, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<AutoCloseablePlus> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<AutoCloseablePlus> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<AutoCloseablePlus> maxByOption(Function1<AutoCloseablePlus, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<AutoCloseablePlus> minByOption(Function1<AutoCloseablePlus, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<AutoCloseablePlus, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, AutoCloseablePlus, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<AutoCloseablePlus, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<AutoCloseablePlus, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<AutoCloseablePlus> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<AutoCloseablePlus> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<AutoCloseablePlus> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K$, V$> Map<K$, V$> toMap(.less.colon.less<AutoCloseablePlus, Tuple2<K$, V$>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<AutoCloseablePlus> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<AutoCloseablePlus> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<AutoCloseablePlus> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<AutoCloseablePlus> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<AutoCloseablePlus, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private int offset() {
                return this.offset;
            }

            private void offset_$eq(int x$1) {
                this.offset = x$1;
            }

            public boolean hasNext() {
                while (this.offset() < this.$outer.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark && this.$outer.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[this.offset()] == null) {
                    this.offset_$eq(this.offset() + 1);
                }
                return this.offset() < this.$outer.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark;
            }

            public AutoCloseablePlus next() {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException();
                }
                AutoCloseablePlus closeable = this.$outer.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[this.offset()];
                this.offset_$eq(this.offset() + 1);
                return closeable;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.offset = 0;
            }
        };
    }

    private void clear() {
        this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark = 0;
    }

    @VisibleForTesting
    public Seq<AutoCloseablePlus> allIncludingNullValues() {
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables));
    }

    @Override
    public void closeAll() {
        if (!this._isClosed) {
            Throwable error = null;
            for (int i = 0; i < this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark; ++i) {
                try {
                    AutoCloseablePlus resource = this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables[i];
                    if (resource == null) continue;
                    this.monitor.close(resource);
                    resource.setToken(-1);
                    resource.setCloseListener(null);
                    resource.close();
                    continue;
                }
                catch (Throwable t) {
                    error = Exceptions.chain(error, (Throwable)t);
                }
            }
            if (error != null) {
                throw error;
            }
            this.clear();
            this.memoryTracker.releaseHeap(this.trackedSize + SingleThreadedResourcePool$.MODULE$.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$SHALLOW_SIZE());
            this._isClosed = true;
            return;
        }
    }

    @Override
    public boolean isClosed() {
        return this._isClosed;
    }

    private void ensureCapacity() {
        if (this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables.length <= this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark) {
            AutoCloseablePlus[] temp = this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables;
            long oldHeapUsage = this.trackedSize;
            int newSize = this.computeNewSize(this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables.length);
            this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)newSize);
            this.memoryTracker.allocateHeap(this.trackedSize);
            this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables = new AutoCloseablePlus[newSize];
            System.arraycopy(temp, 0, this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables, 0, temp.length);
            this.memoryTracker.releaseHeap(oldHeapUsage);
            return;
        }
    }

    @VisibleForTesting
    public int computeNewSize(int oldSize) {
        int minSize = oldSize + 1;
        if (minSize < 0) {
            return Integer.MAX_VALUE;
        }
        int newSize = oldSize * 2;
        if (newSize < 0) {
            return minSize;
        }
        return newSize;
    }

    public SingleThreadedResourcePool(int capacity, ResourceMonitor monitor, MemoryTracker memoryTracker) {
        this.monitor = monitor;
        this.memoryTracker = memoryTracker;
        ResourcePool.$init$(this);
        this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$highMark = 0;
        this.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$closeables = new AutoCloseablePlus[capacity];
        this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)capacity);
        this._isClosed = false;
        memoryTracker.allocateHeap(SingleThreadedResourcePool$.MODULE$.org$neo4j$cypher$internal$runtime$SingleThreadedResourcePool$$SHALLOW_SIZE() + this.trackedSize);
    }
}

