/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted.pipes;

import java.io.Serializable;
import org.neo4j.cypher.internal.physicalplanning.SlotConfiguration;
import org.neo4j.cypher.internal.runtime.ReadQueryContext;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.WritableRow;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.slotted.SlottedPipeMapper;
import org.neo4j.cypher.internal.runtime.slotted.SlottedRow$;
import org.neo4j.cypher.internal.runtime.slotted.helpers.NullChecker$;
import org.neo4j.cypher.internal.runtime.slotted.pipes.NodeHashJoinSlottedPipe;
import org.neo4j.cypher.internal.util.attribution.Id$;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class NodeHashJoinSlottedPipe$
implements Serializable {
    public static final NodeHashJoinSlottedPipe$ MODULE$ = new NodeHashJoinSlottedPipe$();

    public int $lessinit$greater$default$7(NodeHashJoinSlottedPipe.KeyOffsets lhsKeyOffsets, NodeHashJoinSlottedPipe.KeyOffsets rhsKeyOffsets, Pipe left, Pipe right, SlotConfiguration slots, SlottedPipeMapper.SlotMappings rhsSlotMappings) {
        return Id$.MODULE$.INVALID_ID();
    }

    public void copyDataFromRow(NodeHashJoinSlottedPipe.SlotMapping[] slotMappings, Tuple2<Object, Object>[] cachedPropertyMappings, WritableRow target, ReadableRow source, ReadQueryContext queryContext) {
        int i;
        for (i = 0; i < slotMappings.length; ++i) {
            BoxedUnit boxedUnit;
            NodeHashJoinSlottedPipe.SlotMapping slotMapping = slotMappings[i];
            if (slotMapping != null) {
                int fromOffset = slotMapping.fromOffset();
                int toOffset = slotMapping.toOffset();
                boolean bl = slotMapping.fromIsLongSlot();
                boolean bl2 = slotMapping.toIsLongSlot();
                if (bl && bl2) {
                    target.setLongAt(toOffset, source.getLongAt(fromOffset));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (slotMapping != null) {
                int fromOffset = slotMapping.fromOffset();
                int toOffset = slotMapping.toOffset();
                boolean bl = slotMapping.fromIsLongSlot();
                boolean bl3 = slotMapping.toIsLongSlot();
                if (!bl && !bl3) {
                    target.setRefAt(toOffset, source.getRefAt(fromOffset));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (slotMapping != null) {
                int fromOffset = slotMapping.fromOffset();
                int toOffset = slotMapping.toOffset();
                boolean bl = slotMapping.fromIsLongSlot();
                boolean bl4 = slotMapping.toIsLongSlot();
                if (!bl && bl4) {
                    long l;
                    AnyValue anyValue = source.getRefAt(fromOffset);
                    if (anyValue instanceof VirtualNodeValue) {
                        VirtualNodeValue virtualNodeValue = (VirtualNodeValue)anyValue;
                        l = virtualNodeValue.id();
                    } else if (anyValue instanceof RelationshipValue) {
                        RelationshipValue relationshipValue = (RelationshipValue)anyValue;
                        l = relationshipValue.id();
                    } else {
                        throw new MatchError((Object)anyValue);
                    }
                    target.setLongAt(toOffset, l);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (slotMapping != null) {
                int fromOffset = slotMapping.fromOffset();
                int toOffset = slotMapping.toOffset();
                boolean bl = slotMapping.fromIsLongSlot();
                boolean bl5 = slotMapping.toIsLongSlot();
                if (bl && !bl5) {
                    target.setRefAt(toOffset, (AnyValue)queryContext.nodeById(source.getLongAt(fromOffset)));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            throw new MatchError((Object)slotMapping);
        }
        for (i = 0; i < cachedPropertyMappings.length; ++i) {
            Tuple2<Object, Object> tuple2 = cachedPropertyMappings[i];
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int from = tuple2._1$mcI$sp();
            int to = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(from, to);
            Tuple2.mcII.sp sp3 = sp2;
            int from2 = sp3._1$mcI$sp();
            int to2 = sp3._2$mcI$sp();
            target.setCachedPropertyAt(to2, source.getCachedPropertyAt(from2));
        }
    }

    public void fillKeyArray(ReadableRow current, long[] key, int[] offsets, boolean[] isReference) {
        for (int i = 0; i < offsets.length; ++i) {
            long thisId;
            key[i] = thisId = SlottedRow$.MODULE$.getNodeId(current, offsets[i], isReference[i]);
            if (!NullChecker$.MODULE$.entityIsNull(thisId)) continue;
            key[0] = NullChecker$.MODULE$.NULL_ENTITY();
            return;
        }
    }

    public NodeHashJoinSlottedPipe apply(NodeHashJoinSlottedPipe.KeyOffsets lhsKeyOffsets, NodeHashJoinSlottedPipe.KeyOffsets rhsKeyOffsets, Pipe left, Pipe right, SlotConfiguration slots, SlottedPipeMapper.SlotMappings rhsSlotMappings, int id) {
        return new NodeHashJoinSlottedPipe(lhsKeyOffsets, rhsKeyOffsets, left, right, slots, rhsSlotMappings, id);
    }

    public int apply$default$7(NodeHashJoinSlottedPipe.KeyOffsets lhsKeyOffsets, NodeHashJoinSlottedPipe.KeyOffsets rhsKeyOffsets, Pipe left, Pipe right, SlotConfiguration slots, SlottedPipeMapper.SlotMappings rhsSlotMappings) {
        return Id$.MODULE$.INVALID_ID();
    }

    public Option<Tuple6<NodeHashJoinSlottedPipe.KeyOffsets, NodeHashJoinSlottedPipe.KeyOffsets, Pipe, Pipe, SlotConfiguration, SlottedPipeMapper.SlotMappings>> unapply(NodeHashJoinSlottedPipe x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.lhsKeyOffsets(), (Object)x$0.rhsKeyOffsets(), (Object)x$0.left(), (Object)x$0.right(), (Object)x$0.slots(), (Object)x$0.rhsSlotMappings()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NodeHashJoinSlottedPipe$.class);
    }

    private NodeHashJoinSlottedPipe$() {
    }
}

