/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.ASTCachedProperty;
import org.neo4j.cypher.internal.physicalplanning.LongSlot;
import org.neo4j.cypher.internal.physicalplanning.RefSlot;
import org.neo4j.cypher.internal.physicalplanning.Slot;
import org.neo4j.cypher.internal.physicalplanning.SlotConfiguration;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.EntityById;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.ResourceLinenumber;
import org.neo4j.cypher.internal.runtime.slotted.SlottedCompatible;
import org.neo4j.cypher.internal.runtime.slotted.SlottedRow$;
import org.neo4j.cypher.internal.runtime.slotted.helpers.NullChecker$;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.NodeType;
import org.neo4j.cypher.internal.util.symbols.RelationshipType;
import org.neo4j.exceptions.InternalException;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0015w!B&M\u0011\u0003If!B.M\u0011\u0003a\u0006\"B6\u0002\t\u0003a\u0007bB7\u0002\u0005\u0004%)A\u001c\u0005\u0007e\u0006\u0001\u000bQB8\t\u000bM\fA\u0011\u0001;\t\u0013\r5\u0015A1A\u0005\u0006\r=\u0005\u0002CBK\u0003\u0001\u0006ia!%\t\u000f\r]\u0015\u0001\"\u0001\u0004\u001a\"9!1O\u0001\u0005\u0002\r\u0015\u0006\"CBV\u0003\u0005\u0005I\u0011QBW\u0011%\u0019\t,AA\u0001\n\u0003\u001b\u0019\fC\u0005\u0004<\u0006\t\t\u0011\"\u0003\u0004>\u001a!1\f\u0014!w\u0011)\t\u0019\"\u0004BK\u0002\u0013\u0005\u0011Q\u0003\u0005\u000b\u0003Gi!\u0011#Q\u0001\n\u0005]\u0001BB6\u000e\t\u0003\t)\u0003C\u0005\u0002*5\u0011\r\u0011\"\u0001\u0002,!A\u00111G\u0007!\u0002\u0013\ti\u0003C\u0005\u000265\u0011\r\u0011\"\u0001\u00028!A\u0011qI\u0007!\u0002\u0013\tI\u0004C\u0004\u0002J5!\t%a\u0013\t\u000f\u0005uS\u0002\"\u0011\u0002`!9\u0011\u0011O\u0007\u0005B\u0005M\u0004bBAC\u001b\u0011\u0005\u0011q\u0011\u0005\b\u0003'kA\u0011BAK\u0011\u001d\tI*\u0004C!\u00037Cq!a,\u000e\t\u0013\t\t\fC\u0004\u0002@6!\t%!1\t\u000f\u0005-W\u0002\"\u0011\u0002N\"9\u0011\u0011[\u0007\u0005B\u0005M\u0007bBAm\u001b\u0011\u0005\u00131\u001c\u0005\b\u0003?lA\u0011IAq\u0011\u001d\t9/\u0004C!\u0003SDq!a;\u000e\t\u0003\ni\u000fC\u0004\u0002x6!\t%!?\t\u000f\t-Q\u0002\"\u0011\u0003\u000e!9!qB\u0007\u0005B\tE\u0001b\u0002B\f\u001b\u0011\u0005#\u0011\u0004\u0005\b\u0005?iA\u0011\tB\u0011\u0011\u001d\u0011i$\u0004C!\u0005\u007fAqAa\u0011\u000e\t\u0003\u0012)\u0005C\u0004\u0003J5!\tEa\u0013\t\u000f\t5S\u0002\"\u0011\u0003P!9!QK\u0007\u0005\n\t]\u0003b\u0002B0\u001b\u0011\u0005#\u0011\r\u0005\b\u0005gjA\u0011\tB;\u0011\u001d\u00119(\u0004C!\u0005sBqAa\u001e\u000e\t\u0003\u0012\t\nC\u0004\u0003x5!\tEa'\t\u000f\t]T\u0002\"\u0011\u0003*\"9!1X\u0007\u0005B\tu\u0006b\u0002B^\u001b\u0011\u0005#1\u0019\u0005\b\u0005wkA\u0011\tBg\u0011\u001d\u0011Y,\u0004C!\u00057DqAa8\u000e\t\u0013\u0011\t\u000fC\u0004\u0003h6!\tA!;\t\u000f\t5X\u0002\"\u0001\u0003p\"9!1_\u0007\u0005B\tU\b\"CB\u0004\u001bE\u0005I\u0011AB\u0005\u0011\u001d\u0019y\"\u0004C\u0005\u0007CAqaa\f\u000e\t\u0003\u001a\t\u0004C\u0004\u000445!\te!\u000e\t\u000f\reR\u0002\"\u0003\u0004<!911I\u0007\u0005B\t5\u0001\"CB#\u001b\u0005\u0005I\u0011AB$\u0011%\u0019Y%DI\u0001\n\u0003\u0019i\u0005C\u0005\u0004R5\t\t\u0011\"\u0011\u0004T!I1qL\u0007\u0002\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0007Cj\u0011\u0011!C\u0001\u0007GB\u0011ba\u001c\u000e\u0003\u0003%\te!\u001d\t\u0013\r]T\"!A\u0005\u0002\re\u0004\"CB?\u001b\u0005\u0005I\u0011IB@\u0011%\u0019\u0019)DA\u0001\n\u0003\u001a)\tC\u0005\u0004\b6\t\t\u0011\"\u0011\u0004\n\u0006Q1\u000b\\8ui\u0016$'k\\<\u000b\u00055s\u0015aB:m_R$X\r\u001a\u0006\u0003\u001fB\u000bqA];oi&lWM\u0003\u0002R%\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002T)\u000611-\u001f9iKJT!!\u0016,\u0002\u000b9,w\u000e\u000e6\u000b\u0003]\u000b1a\u001c:h\u0007\u0001\u0001\"AW\u0001\u000e\u00031\u0013!b\u00157piR,GMU8x'\r\tQl\u0019\t\u0003=\u0006l\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!m\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017AA5p\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A[3\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005I\u0016!D%O'R\u000bejQ#`'&SV)F\u0001p!\tq\u0006/\u0003\u0002r?\n!Aj\u001c8h\u00039Iej\u0015+B\u001d\u000e+ulU%[\u000b\u0002\nQ!Z7qif,\u0012!\u001e\t\u000356\u0019R!D/xwz\u0004\"\u0001_=\u000e\u00039K!A\u001f(\u0003\u0013\rK\b\u000f[3s%><\bC\u00010}\u0013\tixLA\u0004Qe>$Wo\u0019;\u0011\u0007}\fyA\u0004\u0003\u0002\u0002\u0005-a\u0002BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u0001,\u0001\u0004=e>|GOP\u0005\u0002A&\u0019\u0011QB0\u0002\u000fA\f7m[1hK&\u0019!.!\u0005\u000b\u0007\u00055q,A\u0003tY>$8/\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001eA\u000b\u0001\u0003\u001d5zg&\u001c\u0017\r\u001c9mC:t\u0017N\\4\n\t\u0005\u0005\u00121\u0004\u0002\u0012'2|GoQ8oM&<WO]1uS>t\u0017AB:m_R\u001c\b\u0005F\u0002v\u0003OAq!a\u0005\u0011\u0001\u0004\t9\"A\u0003m_:<7/\u0006\u0002\u0002.A!a,a\fp\u0013\r\t\td\u0018\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0007Y>twm\u001d\u0011\u0002\tI,gm]\u000b\u0003\u0003s\u0001RAXA\u0018\u0003w\u0001B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003\"\u0016A\u0002<bYV,7/\u0003\u0003\u0002F\u0005}\"\u0001C!osZ\u000bG.^3\u0002\u000bI,gm\u001d\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0014\u0011\t\u0005=\u0013q\u000b\b\u0005\u0003#\n\u0019\u0006E\u0002\u0002\u0004}K1!!\u0016`\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011LA.\u0005\u0019\u0019FO]5oO*\u0019\u0011QK0\u0002\u0017\r|\u0007/_!mY\u001a\u0013x.\u001c\u000b\u0005\u0003C\n9\u0007E\u0002_\u0003GJ1!!\u001a`\u0005\u0011)f.\u001b;\t\u000f\u0005%d\u00031\u0001\u0002l\u0005)\u0011N\u001c9viB\u0019\u00010!\u001c\n\u0007\u0005=dJA\u0006SK\u0006$\u0017M\u00197f%><\u0018\u0001C2paf4%o\\7\u0015\u0011\u0005\u0005\u0014QOA<\u0003\u0003Cq!!\u001b\u0018\u0001\u0004\tY\u0007C\u0004\u0002z]\u0001\r!a\u001f\u0002\r9duN\\4t!\rq\u0016QP\u0005\u0004\u0003\u007fz&aA%oi\"9\u00111Q\fA\u0002\u0005m\u0014!\u00028SK\u001a\u001c\u0018AC2pafl\u0015\r\u001d9fIR\u0019q/!#\t\u000f\u0005-\u0005\u00041\u0001\u0002\u000e\u0006!a-\u001e8d!\u001dq\u0016qRA\u001e\u0003wI1!!%`\u0005%1UO\\2uS>t\u0017'A\u0007ue\u0006t7OZ8s[J+gm\u001d\u000b\u0005\u0003C\n9\nC\u0004\u0002\ff\u0001\r!!$\u0002\u001d\r|\u0007/\u001f$s_6|eMZ:fiRa\u0011\u0011MAO\u0003?\u000b\u0019+a*\u0002,\"9\u0011\u0011\u000e\u000eA\u0002\u0005-\u0004bBAQ5\u0001\u0007\u00111P\u0001\u0011g>,(oY3M_:<wJ\u001a4tKRDq!!*\u001b\u0001\u0004\tY(A\bt_V\u00148-\u001a*fM>3gm]3u\u0011\u001d\tIK\u0007a\u0001\u0003w\n\u0001\u0003^1sO\u0016$Hj\u001c8h\u001f\u001a47/\u001a;\t\u000f\u00055&\u00041\u0001\u0002|\u0005yA/\u0019:hKR\u0014VMZ(gMN,G/A\bd_BLhI]8n'2|G\u000f^3e)1\t\t'a-\u00028\u0006e\u00161XA_\u0011\u0019\t)l\u0007a\u0001k\u0006)q\u000e\u001e5fe\"9\u0011\u0011U\u000eA\u0002\u0005m\u0004bBAS7\u0001\u0007\u00111\u0010\u0005\b\u0003S[\u0002\u0019AA>\u0011\u001d\tik\u0007a\u0001\u0003w\n\u0011b]3u\u0019>tw-\u0011;\u0015\r\u0005\u0005\u00141YAd\u0011\u001d\t)\r\ba\u0001\u0003w\naa\u001c4gg\u0016$\bBBAe9\u0001\u0007q.A\u0003wC2,X-A\u0005hKRduN\\4BiR\u0019q.a4\t\u000f\u0005\u0015W\u00041\u0001\u0002|\u0005A1/\u001a;SK\u001a\fE\u000f\u0006\u0004\u0002b\u0005U\u0017q\u001b\u0005\b\u0003\u000bt\u0002\u0019AA>\u0011\u001d\tIM\ba\u0001\u0003w\t\u0001bZ3u%\u00164\u0017\t\u001e\u000b\u0005\u0003w\ti\u000eC\u0004\u0002F~\u0001\r!a\u001f\u0002\u0013\u001d,GOQ=OC6,G\u0003BA\u001e\u0003GDq!!:!\u0001\u0004\ti%\u0001\u0003oC6,\u0017a\u00048v[\n,'o\u00144D_2,XN\\:\u0016\u0005\u0005m\u0014\u0001D2p]R\f\u0017N\\:OC6,G\u0003BAx\u0003k\u00042AXAy\u0013\r\t\u0019p\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\t)O\ta\u0001\u0003\u001b\n1c]3u\u0007\u0006\u001c\u0007.\u001a3Qe>\u0004XM\u001d;z\u0003R$b!!\u0019\u0002|\u0006u\bbBAcG\u0001\u0007\u00111\u0010\u0005\b\u0003\u0013\u001c\u0003\u0019AA\u0000!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!\u0002\u0002B\u0003\u0003\u007f\t\u0001b\u001d;pe\u0006\u0014G.Z\u0005\u0005\u0005\u0013\u0011\u0019AA\u0003WC2,X-\u0001\u000ej]Z\fG.\u001b3bi\u0016\u001c\u0015m\u00195fIB\u0013x\u000e]3si&,7\u000f\u0006\u0002\u0002b\u0005q\u0012N\u001c<bY&$\u0017\r^3DC\u000eDW\r\u001a(pI\u0016\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003C\u0012\u0019\u0002\u0003\u0004\u0003\u0016\u0015\u0002\ra\\\u0001\u0005]>$W-\u0001\u0014j]Z\fG.\u001b3bi\u0016\u001c\u0015m\u00195fIJ+G.\u0019;j_:\u001c\b.\u001b9Qe>\u0004XM\u001d;jKN$B!!\u0019\u0003\u001c!1!Q\u0004\u0014A\u0002=\f1A]3m\u0003E\u0019X\r^\"bG\",G\r\u0015:pa\u0016\u0014H/\u001f\u000b\u0007\u0003C\u0012\u0019Ca\u000f\t\u000f\t\u0015r\u00051\u0001\u0003(\u0005\u00191.Z=\u0011\t\t%\"Q\u0007\b\u0005\u0005W\u0011\t$\u0004\u0002\u0003.)\u0019!q\u0006)\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0005g\u0011i#A\tB'R\u001b\u0015m\u00195fIB\u0013x\u000e]3sifLAAa\u000e\u0003:\tQ!+\u001e8uS6,7*Z=\u000b\t\tM\"Q\u0006\u0005\b\u0003\u0013<\u0003\u0019AA\u0000\u0003M9W\r^\"bG\",G\r\u0015:pa\u0016\u0014H/_!u)\u0011\tyP!\u0011\t\u000f\u0005\u0015\u0007\u00061\u0001\u0002|\u0005\tr-\u001a;DC\u000eDW\r\u001a)s_B,'\u000f^=\u0015\t\u0005}(q\t\u0005\b\u0005KI\u0003\u0019\u0001B\u0014\u0003I)7\u000f^5nCR,G\rS3baV\u001b\u0018mZ3\u0015\u0003=\fa\u0004Z3ekBd\u0017nY1uK\u0012,5\u000f^5nCR,G\rS3baV\u001b\u0018mZ3\u0015\u0007=\u0014\t\u0006\u0003\u0004\u0003T-\u0002\ra^\u0001\taJ,g/[8vg\u0006!a-Y5m)\t\u0011I\u0006E\u0002_\u00057J1A!\u0018`\u0005\u001dqu\u000e\u001e5j]\u001e\fQb]3u\u0019&tWM\\;nE\u0016\u0014H\u0003BA1\u0005GBqA!\u001a.\u0001\u0004\u00119'\u0001\u0003mS:,\u0007#\u00020\u0003j\t5\u0014b\u0001B6?\n1q\n\u001d;j_:\u00042\u0001\u001fB8\u0013\r\u0011\tH\u0014\u0002\u0013%\u0016\u001cx.\u001e:dK2Kg.\u001a8v[\n,'/A\u0007hKRd\u0015N\\3ok6\u0014WM]\u000b\u0003\u0005O\n1a]3u)\u0011\t\tGa\u001f\t\u000f\tut\u00061\u0001\u0003\u0000\u0005Qa.Z<F]R\u0014\u0018.Z:\u0011\r\t\u0005%q\u0011BF\u001b\t\u0011\u0019IC\u0002\u0003\u0006~\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IIa!\u0003\u0007M+\u0017\u000fE\u0004_\u0005\u001b\u000bi%a\u000f\n\u0007\t=uL\u0001\u0004UkBdWM\r\u000b\u0007\u0003C\u0012\u0019Ja&\t\u000f\tU\u0005\u00071\u0001\u0002N\u0005!1.Z=2\u0011\u001d\u0011I\n\ra\u0001\u0003w\taA^1mk\u0016\fDCCA1\u0005;\u0013yJ!)\u0003&\"9!QS\u0019A\u0002\u00055\u0003b\u0002BMc\u0001\u0007\u00111\b\u0005\b\u0005G\u000b\u0004\u0019AA'\u0003\u0011YW-\u001f\u001a\t\u000f\t\u001d\u0016\u00071\u0001\u0002<\u00051a/\u00197vKJ\"b\"!\u0019\u0003,\n5&q\u0016BY\u0005g\u00139\fC\u0004\u0003\u0016J\u0002\r!!\u0014\t\u000f\te%\u00071\u0001\u0002<!9!1\u0015\u001aA\u0002\u00055\u0003b\u0002BTe\u0001\u0007\u00111\b\u0005\b\u0005k\u0013\u0004\u0019AA'\u0003\u0011YW-_\u001a\t\u000f\te&\u00071\u0001\u0002<\u00051a/\u00197vKN\n\u0001bY8qs^KG\u000f\u001b\u000b\u0006o\n}&\u0011\u0019\u0005\b\u0005+\u001b\u0004\u0019AA'\u0011\u001d\u0011Ij\ra\u0001\u0003w!\u0012b\u001eBc\u0005\u000f\u0014IMa3\t\u000f\tUE\u00071\u0001\u0002N!9!\u0011\u0014\u001bA\u0002\u0005m\u0002b\u0002BRi\u0001\u0007\u0011Q\n\u0005\b\u0005O#\u0004\u0019AA\u001e)59(q\u001aBi\u0005'\u0014)Na6\u0003Z\"9!QS\u001bA\u0002\u00055\u0003b\u0002BMk\u0001\u0007\u00111\b\u0005\b\u0005G+\u0004\u0019AA'\u0011\u001d\u00119+\u000ea\u0001\u0003wAqA!.6\u0001\u0004\ti\u0005C\u0004\u0003:V\u0002\r!a\u000f\u0015\u0007]\u0014i\u000eC\u0004\u0003~Y\u0002\rAa \u0002\u0011M,GOV1mk\u0016$b!!\u0019\u0003d\n\u0015\bb\u0002BKo\u0001\u0007\u0011Q\n\u0005\b\u00053;\u0004\u0019AA\u001e\u0003AI7OU3g\u0013:LG/[1mSj,G\r\u0006\u0003\u0002p\n-\bbBAcq\u0001\u0007\u00111P\u0001#O\u0016$(+\u001a4Bi^KG\u000f[8vi\u000eCWmY6j]\u001eLe.\u001b;jC2L'0\u001a3\u0015\t\u0005m\"\u0011\u001f\u0005\b\u0003\u000bL\u0004\u0019AA>\u0003%iWM]4f/&$\b\u000e\u0006\u0005\u0002b\t](\u0011`B\u0002\u0011\u001d\t)L\u000fa\u0001\u0003WBqAa?;\u0001\u0004\u0011i0\u0001\u0006f]RLG/\u001f\"z\u0013\u0012\u00042\u0001\u001fB\u0000\u0013\r\u0019\tA\u0014\u0002\u000b\u000b:$\u0018\u000e^=Cs&#\u0007\"CB\u0003uA\u0005\t\u0019AAx\u0003A\u0019\u0007.Z2l\u001dVdG.\u00192jY&$\u00180A\nnKJ<WmV5uQ\u0012\"WMZ1vYR$3'\u0006\u0002\u0004\f)\"\u0011q^B\u0007W\t\u0019y\u0001\u0005\u0003\u0004\u0012\rmQBAB\n\u0015\u0011\u0019)ba\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAB\r?\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\ru11\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aG2iK\u000e\\7i\\7qCRL'\r\\3Ok2d\u0017M\u00197jY&$\u0018\u0010\u0006\u0004\u0002p\u000e\r2Q\u0005\u0005\b\u0005Ka\u0004\u0019AA'\u0011\u001d\u00199\u0003\u0010a\u0001\u0007S\t\u0011b\u001c;iKJ\u001cFn\u001c;\u0011\t\u0005e11F\u0005\u0005\u0007[\tYBA\u0004SK\u001a\u001cFn\u001c;\u0002\u0017\r\u0014X-\u0019;f\u00072|g.\u001a\u000b\u0002o\u00061\u0011n\u001d(vY2$B!a<\u00048!9!Q\u0005 A\u0002\u00055\u0013\u0001C5uKJ\fGo\u001c:\u0016\u0005\ru\u0002#B@\u0004@\t-\u0015\u0002BB!\u0003#\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\bG>l\u0007/Y2u\u0003\u0011\u0019w\u000e]=\u0015\u0007U\u001cI\u0005C\u0005\u0002\u0014\u0005\u0003\n\u00111\u0001\u0002\u0018\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB(U\u0011\t9b!\u0004\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019)\u0006\u0005\u0003\u0004X\ruSBAB-\u0015\r\u0019YfZ\u0001\u0005Y\u0006tw-\u0003\u0003\u0002Z\re\u0013\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007K\u001aY\u0007E\u0002_\u0007OJ1a!\u001b`\u0005\r\te.\u001f\u0005\n\u0007[*\u0015\u0011!a\u0001\u0003w\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB:!\u0019\u0011\ti!\u001e\u0004f%!1\u0011\tBB\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAx\u0007wB\u0011b!\u001cH\u0003\u0003\u0005\ra!\u001a\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0007+\u001a\t\tC\u0005\u0004n!\u000b\t\u00111\u0001\u0002|\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002|\u00051Q-];bYN$B!a<\u0004\f\"I1Q\u000e&\u0002\u0002\u0003\u00071QM\u0001\u0006\t\u0016\u0013UkR\u000b\u0003\u0007#{!aa%\u001a\u0003\u0001\ta\u0001R#C+\u001e\u0003\u0013!C4fi:{G-Z%e)\u001dy71TBP\u0007CCqa!(\t\u0001\u0004\tY'A\u0002s_^Dq!!2\t\u0001\u0004\tY\bC\u0004\u0004$\"\u0001\r!a<\u0002\u0017%\u001c(+\u001a4fe\u0016t7-\u001a\u000b\u0007\u0005O\u001a9k!+\t\u000f\ru\u0015\u00021\u0001\u0002l!9\u00111C\u0005A\u0002\u0005]\u0011!B1qa2LHcA;\u00040\"9\u00111\u0003\u0006A\u0002\u0005]\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0007k\u001b9\fE\u0003_\u0005S\n9\u0002\u0003\u0005\u0004:.\t\t\u00111\u0001v\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007\u007f\u0003Baa\u0016\u0004B&!11YB-\u0005\u0019y%M[3di\u0002")
public class SlottedRow
implements CypherRow,
Product,
Serializable {
    private final SlotConfiguration slots;
    private final long[] longs;
    private final AnyValue[] refs;

    public static Option<SlotConfiguration> unapply(SlottedRow x$0) {
        return SlottedRow$.MODULE$.unapply(x$0);
    }

    public static SlottedRow apply(SlotConfiguration slots) {
        return SlottedRow$.MODULE$.apply(slots);
    }

    public static long getNodeId(ReadableRow row, int offset, boolean isReference) {
        return SlottedRow$.MODULE$.getNodeId(row, offset, isReference);
    }

    public static boolean DEBUG() {
        return SlottedRow$.MODULE$.DEBUG();
    }

    public static SlottedRow empty() {
        return SlottedRow$.MODULE$.empty();
    }

    public static long INSTANCE_SIZE() {
        return SlottedRow$.MODULE$.INSTANCE_SIZE();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SlotConfiguration slots() {
        return this.slots;
    }

    public long[] longs() {
        return this.longs;
    }

    public AnyValue[] refs() {
        return this.refs;
    }

    public String toString() {
        Iterator<Tuple2<String, AnyValue>> iter = this.iterator();
        StringBuilder s = package$.MODULE$.StringBuilder().newBuilder();
        s.$plus$plus$eq("\nSlottedExecutionContext {\n    " + this.slots());
        while (iter.hasNext()) {
            Tuple2 slotValue = (Tuple2)iter.next();
            s.$plus$plus$eq(StringOps$.MODULE$.format$extension("\n    %-40s = %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{slotValue._1(), slotValue._2()})));
        }
        s.$plus$plus$eq("\n}\n");
        return s.result();
    }

    public void copyAllFrom(ReadableRow input) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            this.copyFromSlotted(slottedRow, 0, 0, 0, 0);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyAllToSlottedRow(this);
            return;
        }
        throw this.fail();
    }

    public void copyFrom(ReadableRow input, int nLongs, int nRefs) {
        if (nLongs > this.slots().numberOfLongs() || nRefs > this.slots().numberOfReferences()) {
            throw new InternalException("A bug has occurred in the slotted runtime: The target slotted execution context cannot hold the data to copy.");
        }
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            System.arraycopy(slottedRow.longs(), 0, this.longs(), 0, nLongs);
            System.arraycopy(slottedRow.refs(), 0, this.refs(), 0, nRefs);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyToSlottedRow(this, nLongs, nRefs);
            return;
        }
        throw this.fail();
    }

    public CypherRow copyMapped(Function1<AnyValue, AnyValue> func) {
        SlottedRow clone = new SlottedRow(this.slots());
        clone.copyAllFrom((ReadableRow)this);
        clone.transformRefs(func);
        return clone;
    }

    private void transformRefs(Function1<AnyValue, AnyValue> func) {
        this.slots().foreachSlot((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$transformRefs$1(this, func, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void copyFromOffset(ReadableRow input, int sourceLongOffset, int sourceRefOffset, int targetLongOffset, int targetRefOffset) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            this.copyFromSlotted(slottedRow, sourceLongOffset, sourceRefOffset, targetLongOffset, targetRefOffset);
            return;
        }
        throw this.fail();
    }

    private void copyFromSlotted(SlottedRow other, int sourceLongOffset, int sourceRefOffset, int targetLongOffset, int targetRefOffset) {
        SlotConfiguration otherPipeline = other.slots();
        if (otherPipeline.numberOfLongs() > this.slots().numberOfLongs() || otherPipeline.numberOfReferences() > this.slots().numberOfReferences()) {
            throw new InternalException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A bug has occurred in the slotted runtime: The target slotted execution context cannot hold the data to copy\n           |From : " + otherPipeline + "\n           |To :   " + this.slots())));
        }
        System.arraycopy(other.longs(), sourceLongOffset, this.longs(), targetLongOffset, other.slots().numberOfLongs() - sourceLongOffset);
        System.arraycopy(other.refs(), sourceRefOffset, this.refs(), targetRefOffset, other.slots().numberOfReferences() - sourceRefOffset);
    }

    public void setLongAt(int offset, long value) {
        this.longs()[offset] = value;
    }

    public long getLongAt(int offset) {
        return this.longs()[offset];
    }

    public void setRefAt(int offset, AnyValue value) {
        this.refs()[offset] = value;
    }

    public AnyValue getRefAt(int offset) {
        AnyValue value = this.refs()[offset];
        if (false && value == null) {
            throw new InternalException("Reference value not initialised at offset " + offset + " in " + this);
        }
        return value;
    }

    public AnyValue getByName(String name) {
        return (AnyValue)this.slots().maybeGetter(name).map((Function1 & Serializable)g -> (AnyValue)g.apply((Object)this)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Unknown variable `" + name + "`.");
        });
    }

    public int numberOfColumns() {
        return this.refs().length + this.longs().length;
    }

    public boolean containsName(String name) {
        return this.slots().maybeGetter(name).map((Function1 & Serializable)g -> (AnyValue)g.apply((Object)this)).isDefined();
    }

    public void setCachedPropertyAt(int offset, Value value) {
        this.refs()[offset] = value;
    }

    public void invalidateCachedProperties() {
        this.slots().foreachCachedSlot((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$invalidateCachedProperties$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void invalidateCachedNodeProperties(long node) {
        this.slots().foreachCachedSlot((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$invalidateCachedNodeProperties$1(this, node, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void invalidateCachedRelationshipProperties(long rel) {
        this.slots().foreachCachedSlot((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$invalidateCachedRelationshipProperties$1(this, rel, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setCachedProperty(ASTCachedProperty.RuntimeKey key, Value value) {
        this.setCachedPropertyAt(this.slots().getCachedPropertyOffsetFor(key), value);
    }

    public Value getCachedPropertyAt(int offset) {
        return (Value)this.refs()[offset];
    }

    public Value getCachedProperty(ASTCachedProperty.RuntimeKey key) {
        throw this.fail();
    }

    public long estimatedHeapUsage() {
        long usage = SlottedRow$.MODULE$.INSTANCE_SIZE() + HeapEstimator.sizeOf((long[])this.longs()) + HeapEstimator.shallowSizeOf((Object[])this.refs());
        for (int i = 0; i < this.refs().length; ++i) {
            AnyValue ref = this.refs()[i];
            if (ref == null) continue;
            usage += ref.estimatedHeapUsage();
        }
        return usage;
    }

    public long deduplicatedEstimatedHeapUsage(CypherRow previous) {
        if (previous == null) {
            return this.estimatedHeapUsage();
        }
        long usage = SlottedRow$.MODULE$.INSTANCE_SIZE() + HeapEstimator.sizeOf((long[])this.longs()) + HeapEstimator.shallowSizeOf((Object[])this.refs());
        for (int i = 0; i < this.refs().length; ++i) {
            AnyValue ref = this.refs()[i];
            if (ref == null || ref == previous.getRefAt(i)) continue;
            usage += ref.estimatedHeapUsage();
        }
        return usage;
    }

    private Nothing$ fail() {
        throw new InternalException("Tried using a slotted context as a map");
    }

    public void setLinenumber(Option<ResourceLinenumber> line) {
        throw this.fail();
    }

    public Option<ResourceLinenumber> getLinenumber() {
        return SlottedRow$.MODULE$.getLinenumber((ReadableRow)this, this.slots());
    }

    public void set(Seq<Tuple2<String, AnyValue>> newEntries) {
        newEntries.foreach((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$set$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void set(String key1, AnyValue value1) {
        this.setValue(key1, value1);
    }

    public void set(String key1, AnyValue value1, String key2, AnyValue value2) {
        this.setValue(key1, value1);
        this.setValue(key2, value2);
    }

    public void set(String key1, AnyValue value1, String key2, AnyValue value2, String key3, AnyValue value3) {
        this.setValue(key1, value1);
        this.setValue(key2, value2);
        this.setValue(key3, value3);
    }

    public CypherRow copyWith(String key1, AnyValue value1) {
        SlottedRow newCopy = new SlottedRow(this.slots());
        newCopy.copyAllFrom((ReadableRow)this);
        newCopy.setValue(key1, value1);
        return newCopy;
    }

    public CypherRow copyWith(String key1, AnyValue value1, String key2, AnyValue value2) {
        throw new UnsupportedOperationException("Use ExecutionContextFactory.copyWith instead to get the correct slot configuration");
    }

    public CypherRow copyWith(String key1, AnyValue value1, String key2, AnyValue value2, String key3, AnyValue value3) {
        throw new UnsupportedOperationException("Use ExecutionContextFactory.copyWith instead to get the correct slot configuration");
    }

    public CypherRow copyWith(Seq<Tuple2<String, AnyValue>> newEntries) {
        throw new UnsupportedOperationException("Use ExecutionContextFactory.copyWith instead to get the correct slot configuration");
    }

    private void setValue(String key1, AnyValue value1) {
        ((Function2)this.slots().maybeSetter(key1).getOrElse((Function0 & Serializable)() -> {
            throw new InternalException("Ouch, no suitable slot for key " + key1 + " = " + value1 + "\nSlots: " + this.slots());
        })).apply((Object)this, (Object)value1);
    }

    public boolean isRefInitialized(int offset) {
        return this.refs()[offset] != null;
    }

    public AnyValue getRefAtWithoutCheckingInitialized(int offset) {
        return this.refs()[offset];
    }

    public void mergeWith(ReadableRow other, EntityById entityById, boolean checkNullability) {
        ReadableRow readableRow = other;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            slottedRow.slots().foreachSlot((Function1 & Serializable)x0$1 -> {
                SlottedRow.$anonfun$mergeWith$1(this, other, entityById, slottedRow, checkNullability, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new InternalException("Well well, isn't this a delicate situation?");
    }

    public boolean mergeWith$default$3() {
        return true;
    }

    private boolean checkCompatibleNullablility(String key, RefSlot otherSlot) {
        Slot thisSlot = (Slot)this.slots().get(key).get();
        if (!thisSlot.nullable() && otherSlot.nullable()) {
            throw new InternalException("Tried to merge slot " + otherSlot + " into " + thisSlot + " but its nullability is incompatible");
        }
        return true;
    }

    public CypherRow createClone() {
        SlottedRow clone = new SlottedRow(this.slots());
        clone.copyAllFrom((ReadableRow)this);
        return clone;
    }

    public boolean isNull(String key) {
        Slot slot;
        Slot slot2;
        boolean bl = false;
        Some some = null;
        Option option = this.slots().get(key);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Slot slot3 = (Slot)some.value();
            if (slot3 instanceof RefSlot) {
                RefSlot refSlot = (RefSlot)slot3;
                int offset = refSlot.offset();
                boolean bl2 = refSlot.nullable();
                if (bl2 && this.isRefInitialized(offset)) {
                    return this.getRefAtWithoutCheckingInitialized(offset) == Values.NO_VALUE;
                }
            }
        }
        if (bl && (slot2 = (Slot)some.value()) instanceof LongSlot) {
            LongSlot longSlot = (LongSlot)slot2;
            int offset = longSlot.offset();
            boolean bl3 = longSlot.nullable();
            CypherType cypherType = longSlot.typ();
            if (bl3) {
                NodeType nodeType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode();
                CypherType cypherType2 = cypherType;
                if (!(nodeType != null ? !nodeType.equals(cypherType2) : cypherType2 != null)) {
                    return NullChecker$.MODULE$.entityIsNull(this.getLongAt(offset));
                }
            }
        }
        if (bl && (slot = (Slot)some.value()) instanceof LongSlot) {
            LongSlot longSlot = (LongSlot)slot;
            int offset = longSlot.offset();
            boolean bl4 = longSlot.nullable();
            CypherType cypherType = longSlot.typ();
            if (bl4) {
                RelationshipType relationshipType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship();
                CypherType cypherType3 = cypherType;
                if (!(relationshipType != null ? !relationshipType.equals(cypherType3) : cypherType3 != null)) {
                    return NullChecker$.MODULE$.entityIsNull(this.getLongAt(offset));
                }
            }
        }
        return false;
    }

    private Iterator<Tuple2<String, AnyValue>> iterator() {
        ObjectRef tuples = ObjectRef.create((Object)Nil$.MODULE$);
        this.slots().foreachSlotAndAliasesOrdered((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$iterator$1(this, tuples, x0$1);
            return BoxedUnit.UNIT;
        }, this.slots().foreachSlotAndAliasesOrdered$default$2());
        return ((List)tuples.elem).iterator();
    }

    public void compact() {
        if (this.refs().length > 0 && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.intArrayOps(this.slots().discardedRefSlotOffsets()))) {
            int[] discard = this.slots().discardedRefSlotOffsets();
            for (int i = 0; i < discard.length; ++i) {
                this.refs()[discard[i]] = null;
            }
            return;
        }
    }

    public SlottedRow copy(SlotConfiguration slots) {
        return new SlottedRow(slots);
    }

    public SlotConfiguration copy$default$1() {
        return this.slots();
    }

    public String productPrefix() {
        return "SlottedRow";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.slots();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SlottedRow;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "slots";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SlottedRow)) return false;
        boolean bl = true;
        if (!bl) return false;
        SlottedRow slottedRow = (SlottedRow)x$1;
        SlotConfiguration slotConfiguration = this.slots();
        SlotConfiguration slotConfiguration2 = slottedRow.slots();
        if (slotConfiguration == null) {
            if (slotConfiguration2 != null) {
                return false;
            }
        } else if (!slotConfiguration.equals(slotConfiguration2)) return false;
        if (!slottedRow.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$transformRefs$1(SlottedRow $this, Function1 func$1, Tuple2 x0$1) {
        Slot slot;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (slot = (Slot)tuple2._2()) instanceof RefSlot) {
            RefSlot refSlot = (RefSlot)slot;
            AnyValue refValue = $this.getRefAt(refSlot.offset());
            AnyValue newRefValue = (AnyValue)func$1.apply((Object)refValue);
            $this.setRefAt(refSlot.offset(), newRefValue);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$invalidateCachedProperties$1(SlottedRow $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            RefSlot propertyRefSLot = (RefSlot)tuple2._2();
            $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$invalidateCachedNodeProperties$1(SlottedRow $this, long node$1, Tuple2 x0$1) {
        Slot refSlot;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ASTCachedProperty.RuntimeKey cnp = (ASTCachedProperty.RuntimeKey)tuple2._1();
        RefSlot propertyRefSLot = (RefSlot)tuple2._2();
        boolean bl = false;
        Some some = null;
        Option option = $this.slots().get(cnp.entityName());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Slot longSlot = (Slot)some.value();
            if (longSlot instanceof LongSlot) {
                LongSlot longSlot2 = (LongSlot)longSlot;
                CypherType cypherType = longSlot2.typ();
                NodeType nodeType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode();
                if (cypherType == null) {
                    if (nodeType != null) {
                        return;
                    }
                } else if (!cypherType.equals(nodeType)) return;
                if ($this.getLongAt(longSlot2.offset()) != node$1) return;
                $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
                return;
            }
        }
        if (bl && (refSlot = (Slot)some.value()) instanceof RefSlot) {
            RefSlot refSlot2 = (RefSlot)refSlot;
            CypherType cypherType = refSlot2.typ();
            NodeType nodeType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode();
            if (cypherType == null) {
                if (nodeType != null) {
                    return;
                }
            } else if (!cypherType.equals(nodeType)) return;
            if (((VirtualNodeValue)$this.getRefAt(refSlot2.offset())).id() != node$1) return;
            $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
            return;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$invalidateCachedRelationshipProperties$1(SlottedRow $this, long rel$1, Tuple2 x0$1) {
        Slot refSlot;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ASTCachedProperty.RuntimeKey crp = (ASTCachedProperty.RuntimeKey)tuple2._1();
        RefSlot propertyRefSLot = (RefSlot)tuple2._2();
        boolean bl = false;
        Some some = null;
        Option option = $this.slots().get(crp.entityName());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Slot longSlot = (Slot)some.value();
            if (longSlot instanceof LongSlot) {
                LongSlot longSlot2 = (LongSlot)longSlot;
                CypherType cypherType = longSlot2.typ();
                RelationshipType relationshipType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship();
                if (cypherType == null) {
                    if (relationshipType != null) {
                        return;
                    }
                } else if (!cypherType.equals(relationshipType)) return;
                if ($this.getLongAt(longSlot2.offset()) != rel$1) return;
                $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
                return;
            }
        }
        if (bl && (refSlot = (Slot)some.value()) instanceof RefSlot) {
            RefSlot refSlot2 = (RefSlot)refSlot;
            CypherType cypherType = refSlot2.typ();
            RelationshipType relationshipType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship();
            if (cypherType == null) {
                if (relationshipType != null) {
                    return;
                }
            } else if (!cypherType.equals(relationshipType)) return;
            if (((VirtualRelationshipValue)$this.getRefAt(refSlot2.offset())).id() != rel$1) return;
            $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
            return;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$set$1(SlottedRow $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            AnyValue v = (AnyValue)tuple2._2();
            $this.setValue(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$mergeWith$1(SlottedRow $this, ReadableRow other$1, EntityById entityById$1, SlottedRow x2$1, boolean checkNullability$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SlotConfiguration.SlotKey slotKey = (SlotConfiguration.SlotKey)tuple2._1();
            Slot otherSlot = (Slot)tuple2._2();
            if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
                String key = variableSlotKey.name();
                if (otherSlot instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)otherSlot;
                    int offset = longSlot.offset();
                    CypherType cypherType = longSlot.typ();
                    NodeType nodeType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode();
                    CypherType cypherType2 = cypherType;
                    if (!(nodeType != null ? !nodeType.equals(cypherType2) : cypherType2 != null)) {
                        Function3 thisSlotSetter = (Function3)$this.slots().maybePrimitiveNodeSetter(key).getOrElse((Function0 & Serializable)() -> {
                            throw new InternalException("Tried to merge primitive node slot " + longSlot + " from " + other$1 + " but it is missing from " + $this + ".Looks like something needs to be fixed in slot allocation.");
                        });
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)thisSlotSetter.apply((Object)$this, (Object)BoxesRunTime.boxToLong((long)other$1.getLongAt(offset)), (Object)entityById$1);
                        return;
                    }
                }
            }
        }
        if (tuple2 != null) {
            SlotConfiguration.SlotKey slotKey = (SlotConfiguration.SlotKey)tuple2._1();
            Slot otherSlot = (Slot)tuple2._2();
            if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
                String key = variableSlotKey.name();
                if (otherSlot instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)otherSlot;
                    int offset = longSlot.offset();
                    CypherType cypherType = longSlot.typ();
                    RelationshipType relationshipType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship();
                    CypherType cypherType3 = cypherType;
                    if (!(relationshipType != null ? !relationshipType.equals(cypherType3) : cypherType3 != null)) {
                        Function3 thisSlotSetter = (Function3)$this.slots().maybePrimitiveRelationshipSetter(key).getOrElse((Function0 & Serializable)() -> {
                            throw new InternalException("Tried to merge primitive relationship slot " + longSlot + " from " + other$1 + " but it is missing from " + $this + ".Looks like something needs to be fixed in slot allocation.");
                        });
                        BoxedUnit cfr_ignored_1 = (BoxedUnit)thisSlotSetter.apply((Object)$this, (Object)BoxesRunTime.boxToLong((long)other$1.getLongAt(offset)), (Object)entityById$1);
                        return;
                    }
                }
            }
        }
        if (tuple2 != null) {
            SlotConfiguration.SlotKey slotKey = (SlotConfiguration.SlotKey)tuple2._1();
            Slot otherSlot = (Slot)tuple2._2();
            if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                RefSlot refSlot;
                int offset;
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
                String key = variableSlotKey.name();
                if (otherSlot instanceof RefSlot && x2$1.isRefInitialized(offset = (refSlot = (RefSlot)otherSlot).offset())) {
                    Function2 thisSlotSetter = (Function2)$this.slots().maybeSetter(key).getOrElse((Function0 & Serializable)() -> {
                        throw new InternalException("Tried to merge slot " + refSlot + " from " + other$1 + " but it is missing from " + $this + ".Looks like something needs to be fixed in slot allocation.");
                    });
                    if (AssertionRunner.ASSERTIONS_ENABLED && checkNullability$1 && !$this.checkCompatibleNullablility(key, refSlot)) {
                        throw new AssertionError((Object)"assertion failed");
                    }
                    AnyValue otherValue = x2$1.getRefAtWithoutCheckingInitialized(offset);
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)thisSlotSetter.apply((Object)$this, (Object)otherValue);
                    return;
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof SlotConfiguration.VariableSlotKey) {
            return;
        }
        if (tuple2 != null) {
            SlotConfiguration.SlotKey slotKey = (SlotConfiguration.SlotKey)tuple2._1();
            Slot refSlot = (Slot)tuple2._2();
            if (slotKey instanceof SlotConfiguration.CachedPropertySlotKey) {
                SlotConfiguration.CachedPropertySlotKey cachedPropertySlotKey = (SlotConfiguration.CachedPropertySlotKey)slotKey;
                ASTCachedProperty.RuntimeKey property = cachedPropertySlotKey.property();
                $this.setCachedProperty(property, other$1.getCachedPropertyAt(refSlot.offset()));
                return;
            }
        }
        if (tuple2 != null) {
            SlotConfiguration.SlotKey slotKey = (SlotConfiguration.SlotKey)tuple2._1();
            Slot refSlot = (Slot)tuple2._2();
            if (slotKey instanceof SlotConfiguration.MetaDataSlotKey) {
                SlotConfiguration.MetaDataSlotKey metaDataSlotKey = (SlotConfiguration.MetaDataSlotKey)slotKey;
                String key = metaDataSlotKey.name();
                int thisOffset = $this.slots().getMetaDataOffsetFor(key);
                if (!$this.isRefInitialized(thisOffset) || $this.getRefAtWithoutCheckingInitialized(thisOffset) == Values.NO_VALUE) {
                    $this.setRefAt(thisOffset, other$1.getRefAt(refSlot.offset()));
                    return;
                }
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String prettyKey$1(String key, Set aliases) {
        String string = key;
        return ((IterableOnceOps)aliases.toSeq().$plus$colon((Object)string)).mkString(",");
    }

    public static final /* synthetic */ void $anonfun$iterator$1(SlottedRow $this, ObjectRef tuples$1, SlotConfiguration.SlotWithKeyAndAliases x0$1) {
        SlotConfiguration.SlotWithKeyAndAliases slotWithKeyAndAliases = x0$1;
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            Set aliases = slotWithKeyAndAliases.aliases();
            if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
                String key = variableSlotKey.name();
                if (slot instanceof RefSlot) {
                    RefSlot refSlot = (RefSlot)slot;
                    int offset = refSlot.offset();
                    tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)SlottedRow.prettyKey$1(key, aliases), (Object)$this.refs()[offset]));
                    return;
                }
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            Set aliases = slotWithKeyAndAliases.aliases();
            if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
                String key = variableSlotKey.name();
                if (slot instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)slot;
                    int offset = longSlot.offset();
                    tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)SlottedRow.prettyKey$1(key, aliases), (Object)Values.longValue((long)$this.longs()[offset])));
                    return;
                }
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            if (slotKey instanceof SlotConfiguration.CachedPropertySlotKey) {
                SlotConfiguration.CachedPropertySlotKey cachedPropertySlotKey = (SlotConfiguration.CachedPropertySlotKey)slotKey;
                ASTCachedProperty.RuntimeKey cachedProperty = cachedPropertySlotKey.property();
                tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)cachedProperty.asCanonicalStringVal(), (Object)$this.refs()[slot.offset()]));
                return;
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            if (slotKey instanceof SlotConfiguration.MetaDataSlotKey) {
                SlotConfiguration.MetaDataSlotKey metaDataSlotKey = (SlotConfiguration.MetaDataSlotKey)slotKey;
                String key = metaDataSlotKey.name();
                tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)("MetaData(" + key + ")"), (Object)$this.refs()[slot.offset()]));
                return;
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            if (slotKey instanceof SlotConfiguration.ApplyPlanSlotKey) {
                SlotConfiguration.ApplyPlanSlotKey applyPlanSlotKey = (SlotConfiguration.ApplyPlanSlotKey)slotKey;
                int id = applyPlanSlotKey.applyPlanId();
                tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)("Apply-Plan(" + new Id(id) + ")"), (Object)Values.longValue((long)$this.longs()[slot.offset()])));
                return;
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            if (slotKey instanceof SlotConfiguration.OuterNestedApplyPlanSlotKey) {
                SlotConfiguration.OuterNestedApplyPlanSlotKey outerNestedApplyPlanSlotKey = (SlotConfiguration.OuterNestedApplyPlanSlotKey)slotKey;
                int id = outerNestedApplyPlanSlotKey.applyPlanId();
                tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)("Nested-Apply-Plan(" + new Id(id) + ")"), (Object)Values.longValue((long)$this.longs()[slot.offset()])));
                return;
            }
        }
        throw new MatchError((Object)slotWithKeyAndAliases);
    }

    public SlottedRow(SlotConfiguration slots) {
        this.slots = slots;
        CypherRow.$init$((CypherRow)this);
        Product.$init$((Product)this);
        this.longs = new long[slots.numberOfLongs()];
        this.refs = new AnyValue[slots.numberOfReferences()];
    }
}

