/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.time.Clock;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.cypher.internal.CachingPreParser;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.planning.CompilationException$;
import org.neo4j.cypher.internal.preparser.FullyParsedQuery;
import org.neo4j.cypher.internal.preparser.InputQuery;
import org.neo4j.cypher.internal.preparser.PreParsedQuery;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.runtime.QueryRuntimeConfig;
import org.neo4j.cypher.internal.runtime.QueryRuntimeConfig$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rEe!\u0002\u00192\u0003\u0003Q\u0004\u0002C!\u0001\u0005\u000b\u0007I\u0011\u0001\"\t\u0011%\u0003!\u0011!Q\u0001\n\rC\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0019\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003V\u0011!a\u0006A!b\u0001\n\u0003i\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u0011\u0004!Q1A\u0005\u0002\u0015D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tW\u0002\u0011)\u0019!C\u0001Y\"A1\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005u\u0001\t\u0015\r\u0011\"\u0001v\u0011!a\bA!A!\u0002\u00131\b\u0002C?\u0001\u0005\u000b\u0007I\u0011\u0001@\t\u0013\u0005=\u0001A!A!\u0002\u0013y\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0005\n\u0003O\u0001!\u0019!C\t\u0003SA\u0001\"a\u000f\u0001A\u0003%\u00111\u0006\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003\u0017B\u0001\"a$\u0001A\u0003%\u0011Q\n\u0005\n\u0003#\u0003!\u0019!C\u0005\u0003'C\u0001\"a'\u0001A\u0003%\u0011Q\u0013\u0005\b\u0003;\u0003A\u0011AAP\u0011%\t\u0019\u0010AI\u0001\n\u0003\t)\u0010C\u0004\u0002\u001e\u0002!\tAa\u0003\t\u000f\tE\u0002\u0001\"\u0001\u00034!I!q\t\u0001\u0012\u0002\u0013\u0005\u0011Q\u001f\u0005\b\u0005\u0013\u0002A\u0011\u0002B&\u0011\u001d\u0011I\t\u0001C\u0005\u0005\u0017CqA!.\u0001\t\u0013\u00119\fC\u0004\u0003^\u0002!IAa8\t\u000f\t5\b\u0001\"\u0001\u0003p\"9!q\u001f\u0001\u0005\u0002\t=\bb\u0002B}\u0001\u0011\u0005!q\u001e\u0005\b\u0005w\u0004A\u0011\u0001Bx\u0011\u001d\u0011i\u0010\u0001C\u0001\u0005\u007fDqaa\u000e\u0001\t\u0003\u0019I\u0004C\u0004\u0004L\u0001!Ia!\u0014\b\u000f\r]\u0014\u0007#\u0001\u0004z\u00191\u0001'\rE\u0001\u0007wBq!!\u0005,\t\u0003\u0019i\bC\u0005\u0004\u0000-\u0012\r\u0011\"\u0001\u0004\u0002\"A1\u0011R\u0016!\u0002\u0013\u0019\u0019\tC\u0005\u0004\f.\n\n\u0011\"\u0001\u0004\u000e\nyQ\t_3dkRLwN\\#oO&tWM\u0003\u00023g\u0005A\u0011N\u001c;fe:\fGN\u0003\u00025k\u000511-\u001f9iKJT!AN\u001c\u0002\u000b9,w\u000e\u000e6\u000b\u0003a\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\r\u0005s\u0017PU3g\u00031\tX/\u001a:z'\u0016\u0014h/[2f+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%B\u0001$6\u0003\u0019YWM\u001d8fY&\u0011\u0001*\u0012\u0002\u001a\u000fJ\f\u0007\u000f\u001b#bi\u0006\u0014\u0017m]3Rk\u0016\u0014\u0018pU3sm&\u001cW-A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\rI\u0001\u000fW\u0016\u0014h.\u001a7N_:LGo\u001c:t+\u0005a\u0005CA'Q\u001b\u0005q%BA(6\u0003)iwN\\5u_JLgnZ\u0005\u0003#:\u0013\u0001\"T8oSR|'o]\u0001\u0010W\u0016\u0014h.\u001a7N_:LGo\u001c:tA\u00051AO]1dKJ,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031F\nq\u0001\u001e:bG&tw-\u0003\u0002[/\n\t2i\\7qS2\fG/[8o)J\f7-\u001a:\u0002\u000fQ\u0014\u0018mY3sA\u000511m\u001c8gS\u001e,\u0012A\u0018\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u00039FJ!A\u00191\u0003'\rK\b\u000f[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000f\r|gNZ5hA\u0005qQ.Y:uKJ\u001cu.\u001c9jY\u0016\u0014X#\u00014\u0011\u0005\u001dDW\"A\u0019\n\u0005%\f$AD'bgR,'oQ8na&dWM]\u0001\u0010[\u0006\u001cH/\u001a:D_6\u0004\u0018\u000e\\3sA\u0005Y\u0011/^3ss\u000e\u000b7\r[3t+\u0005i\u0007C\u00018r\u001b\u0005y'B\u000192\u0003\u0015\u0019\u0017m\u00195f\u0013\t\u0011xNA\tDsBDWM])vKJL8)Y2iKN\fA\"];fef\u001c\u0015m\u00195fg\u0002\n1\u0002\\8h!J|g/\u001b3feV\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002zk\u00059An\\4hS:<\u0017BA>y\u0005MIe\u000e^3s]\u0006dGj\\4Qe>4\u0018\u000eZ3s\u00031awn\u001a)s_ZLG-\u001a:!\u0003\u0015\u0019Gn\\2l+\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005i&lWM\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u0003\u0019a\u0014N\\5u}Q\u0011\u0012QCA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121EA\u0013!\t9\u0007\u0001C\u0003B#\u0001\u00071\tC\u0003K#\u0001\u0007A\nC\u0003T#\u0001\u0007Q\u000bC\u0003]#\u0001\u0007a\fC\u0003e#\u0001\u0007a\rC\u0003l#\u0001\u0007Q\u000eC\u0003u#\u0001\u0007a\u000fC\u0004~#A\u0005\t\u0019A@\u00029\u0011,g-Y;miF+XM]=Fq\u0016\u001cW\u000f^5p]6{g.\u001b;peV\u0011\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\u0015\tX/\u001a:z\u0015\r\t)$R\u0001\u0005S6\u0004H.\u0003\u0003\u0002:\u0005=\"!F)vKJLX\t_3dkRLwN\\'p]&$xN]\u0001\u001eI\u00164\u0017-\u001e7u#V,'/_#yK\u000e,H/[8o\u001b>t\u0017\u000e^8sA\u0005I\u0001O]3QCJ\u001cXM]\u000b\u0003\u0003\u0003\u00022aZA\"\u0013\r\t)%\r\u0002\u0011\u0007\u0006\u001c\u0007.\u001b8h!J,\u0007+\u0019:tKJ\f!\u0002\u001d:f!\u0006\u00148/\u001a:!\u0003)\tX/\u001a:z\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003\u001b\u0002raZA(\u0003'\nI)C\u0002\u0002RE\u0012!\"U;fef\u001c\u0015m\u00195f!\u0019\t)&!\u001d\u0002x9!\u0011qKA7\u001d\u0011\tI&a\u001b\u000f\t\u0005m\u0013\u0011\u000e\b\u0005\u0003;\n9G\u0004\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019'O\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!AN\u001c\n\u0005Q*\u0014B\u0001\u001a4\u0013\r\ty'M\u0001\u000b#V,'/_\"bG\",\u0017\u0002BA:\u0003k\u0012\u0001bQ1dQ\u0016\\U-\u001f\u0006\u0004\u0003_\n\u0004\u0003BA=\u0003\u000bsA!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007f\n\u0014!\u00039sKB\f'o]3s\u0013\u0011\t\u0019)! \u0002\u0015%s\u0007/\u001e;Rk\u0016\u0014\u00180\u0003\u0003\u0002t\u0005\u001d%\u0002BAB\u0003{\u00022aZAF\u0013\r\ti)\r\u0002\u0010\u000bb,7-\u001e;bE2,\u0017+^3ss\u0006Y\u0011/^3ss\u000e\u000b7\r[3!\u00031\u00198\r[3nC\"+G\u000e]3s+\t\t)\nE\u0002h\u0003/K1!!'2\u00051\u00196\r[3nC\"+G\u000e]3s\u00035\u00198\r[3nC\"+G\u000e]3sA\u00059Q\r_3dkR,G\u0003EAQ\u0003O\u000bI,!4\u0002X\u0006\u0005\u0018Q]Ax!\u0011\ti#a)\n\t\u0005\u0015\u0016q\u0006\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0011\u001d\t\tD\u0007a\u0001\u0003S\u0003B!a+\u00024:!\u0011QVAX!\r\ty&P\u0005\u0004\u0003ck\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00026\u0006]&AB*ue&twMC\u0002\u00022vBq!a/\u001b\u0001\u0004\ti,\u0001\u0004qCJ\fWn\u001d\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003\u001d1\u0018N\u001d;vC2T1!a26\u0003\u00191\u0018\r\\;fg&!\u00111ZAa\u0005!i\u0015\r\u001d,bYV,\u0007bBAh5\u0001\u0007\u0011\u0011[\u0001\bG>tG/\u001a=u!\u0011\ti#a5\n\t\u0005U\u0017q\u0006\u0002\u0015)J\fgn]1di&|g.\u00197D_:$X\r\u001f;\t\u000f\u0005e'\u00041\u0001\u0002\\\u00069\u0001O]8gS2,\u0007c\u0001\u001f\u0002^&\u0019\u0011q\\\u001f\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u001d\u000eA\u0002\u0005m\u0017a\u00039sKB{\u0007/\u001e7bi\u0016Dq!a:\u001b\u0001\u0004\tI/\u0001\u0006tk\n\u001c8M]5cKJ\u0004B!!\f\u0002l&!\u0011Q^A\u0018\u0005=\tV/\u001a:z'V\u00147o\u0019:jE\u0016\u0014\b\"CAy5A\u0005\t\u0019AA\u0016\u0003\u001diwN\\5u_J\f\u0011#\u001a=fGV$X\r\n3fM\u0006,H\u000e\u001e\u00138+\t\t9P\u000b\u0003\u0002,\u0005e8FAA~!\u0011\tiPa\u0002\u000e\u0005\u0005}(\u0002\u0002B\u0001\u0005\u0007\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015Q(\u0001\u0006b]:|G/\u0019;j_:LAA!\u0003\u0002\u0000\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0015!\u0005\u0005&Q\u0002B\u000b\u0005/\u0011IBa\u0007\u0003,\t=\u0002bBA\u00199\u0001\u0007!q\u0002\t\u0005\u0003w\u0012\t\"\u0003\u0003\u0003\u0014\u0005u$\u0001\u0005$vY2L\b+\u0019:tK\u0012\fV/\u001a:z\u0011\u001d\tY\f\ba\u0001\u0003{Cq!a4\u001d\u0001\u0004\t\t\u000eC\u0004\u0002dr\u0001\r!a7\t\u000f\tuA\u00041\u0001\u0003 \u0005)\u0011N\u001c9viB!!\u0011\u0005B\u0014\u001b\t\u0011\u0019CC\u0002\u0003&E\nqA];oi&lW-\u0003\u0003\u0003*\t\r\"aD%oaV$H)\u0019;b'R\u0014X-Y7\t\u000f\t5B\u00041\u0001\u0002,\u0005a\u0011/^3ss6{g.\u001b;pe\"9\u0011q\u001d\u000fA\u0002\u0005%\u0018aD3yK\u000e,H/Z*vEF,XM]=\u0015%\u0005\u0005&Q\u0007B\u001c\u0005s\u0011YDa\u0010\u0003B\t\r#Q\t\u0005\b\u0003ci\u0002\u0019AAU\u0011\u001d\tY,\ba\u0001\u0003{Cq!a4\u001e\u0001\u0004\t\t\u000eC\u0004\u0003>u\u0001\r!a7\u0002!%\u001cx*\u001e;fe6|7\u000f^)vKJL\bbBAm;\u0001\u0007\u00111\u001c\u0005\b\u0003Gl\u0002\u0019AAn\u0011\u001d\t9/\ba\u0001\u0003SD\u0011\"!=\u001e!\u0003\u0005\r!a\u000b\u00023\u0015DXmY;uKN+(-];fef$C-\u001a4bk2$H\u0005O\u0001\bG2|7/\u001b8h+\u0011\u0011iE!\u0016\u0015\r\t=#\u0011\u000fB:)\u0011\u0011\tFa\u001a\u0011\t\tM#Q\u000b\u0007\u0001\t\u001d\u00119f\bb\u0001\u00053\u0012\u0011\u0001V\t\u0005\u00057\u0012\t\u0007E\u0002=\u0005;J1Aa\u0018>\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001\u0010B2\u0013\r\u0011)'\u0010\u0002\u0004\u0003:L\b\u0002\u0003B5?\u0011\u0005\rAa\u001b\u0002\t\r|G-\u001a\t\u0006y\t5$\u0011K\u0005\u0004\u0005_j$\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005=w\u00041\u0001\u0002R\"9!QO\u0010A\u0002\t]\u0014A\u0003;sC\u000e,WI^3oiB!!\u0011\u0010BB\u001d\u0011\u0011YHa \u000f\t\u0005]#QP\u0005\u00031FJ1A!!X\u0003E\u0019u.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM]\u0005\u0005\u0005\u000b\u00139IA\u000bRk\u0016\u0014\u0018pQ8na&d\u0017\r^5p]\u00163XM\u001c;\u000b\u0007\t\u0005u+A\u0005e_\u0016CXmY;uKR1\u0012\u0011\u0015BG\u0005+\u00139J!'\u0003\u001c\nu%q\u0014BQ\u0005G\u0013)\u000bC\u0004\u00022\u0001\u0002\rAa$\u0011\t\u0005m$\u0011S\u0005\u0005\u0005'\u000biH\u0001\u0006J]B,H/U;fefDq!a/!\u0001\u0004\ti\fC\u0004\u0002P\u0002\u0002\r!!5\t\u000f\tu\u0002\u00051\u0001\u0002\\\"9\u00111\u001d\u0011A\u0002\u0005m\u0007b\u0002B\u000fA\u0001\u0007!q\u0004\u0005\b\u0005[\u0001\u0003\u0019AA\u0016\u0011\u0019\u0019\u0006\u00051\u0001\u0003x!9\u0011q\u001d\u0011A\u0002\u0005%\bb\u0002BTA\u0001\u0007!\u0011V\u0001\u0013]>$\u0018NZ5dCRLwN\u001c'pO\u001e,'\u000f\u0005\u0003\u0003,\nEVB\u0001BW\u0015\r\u0011y+M\u0001\u0005kRLG.\u0003\u0003\u00034\n5&AG%oi\u0016\u0014h.\u00197O_RLg-[2bi&|g\u000eT8hO\u0016\u0014\u0018aI2p[BLG.\u001a:XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8PaRLwN\u001c\u000b\u000f\u0005s\u0013yLa1\u0003F\n%'1\u001aBg!\u00159'1XAE\u0013\r\u0011i,\r\u0002$\u0007>l\u0007/\u001b7fe^KG\u000f[#yaJ,7o]5p]\u000e{G-Z$f]>\u0003H/[8o\u0011\u001d\u0011\t-\ta\u0001\u0005\u001f\u000b!\"\u001b8qkR\fV/\u001a:z\u0011\u0019\u0019\u0016\u00051\u0001\u0003x!9!qY\u0011A\u0002\u0005E\u0017\u0001\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0004\u0002<\u0006\u0002\r!!0\t\u000f\t\u001d\u0016\u00051\u0001\u0003*\"9!qZ\u0011A\u0002\tE\u0017aD:fgNLwN\u001c#bi\u0006\u0014\u0017m]3\u0011\t\tM'\u0011\\\u0007\u0003\u0005+T1Aa6F\u0003!!\u0017\r^1cCN,\u0017\u0002\u0002Bn\u0005+\u0014\u0011\u0003R1uC\n\f7/\u001a*fM\u0016\u0014XM\\2f\u000319W\r^(s\u0007>l\u0007/\u001b7f)1\tII!9\u0003d\n\u001d(\u0011\u001eBv\u0011\u001d\tyM\ta\u0001\u0003#DqA!:#\u0001\u0004\u0011y)A\tj]&$\u0018.\u00197J]B,H/U;fefDaa\u0015\u0012A\u0002\t]\u0004bBA^E\u0001\u0007\u0011Q\u0018\u0005\b\u0005O\u0013\u0003\u0019\u0001BU\u0003A\u0019G.Z1s#V,'/_\"bG\",7\u000f\u0006\u0002\u0003rB\u0019AHa=\n\u0007\tUXH\u0001\u0003M_:<\u0017aE2mK\u0006\u0014\bK]3QCJ\u001cXM]\"bG\",\u0017!G2mK\u0006\u0014X\t_3dkR\f'\r\\3Rk\u0016\u0014\u0018pQ1dQ\u0016\f1c\u00197fCJ\u001cu.\u001c9jY\u0016\u00148)Y2iKN\fq\"\u001b8tKJ$\u0018J\u001c;p\u0007\u0006\u001c\u0007.\u001a\u000b\u000b\u0007\u0003\u00199a!\u0005\u0004\u0014\r\u001d\u0002c\u0001\u001f\u0004\u0004%\u00191QA\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007\u00139\u0003\u0019AB\u0006\u00039\u0001(/\u001a)beN,G-U;fef\u0004B!a\u001f\u0004\u000e%!1qBA?\u00059\u0001&/\u001a)beN,G-U;fefDq!a/(\u0001\u0004\ti\fC\u0004\u0004\u0016\u001d\u0002\raa\u0006\u0002\u0017A\f'o]3e#V,'/\u001f\t\u0005\u00073\u0019\u0019#\u0004\u0002\u0004\u001c)!1QDB\u0010\u0003\u0019\u0001\b.Y:fg*\u00191\u0011E\u0019\u0002\u0011\u0019\u0014xN\u001c;f]\u0012LAa!\n\u0004\u001c\tI!)Y:f'R\fG/\u001a\u0005\b\u0007S9\u0003\u0019AB\u0016\u0003Q\u0001\u0018M]:j]\u001etu\u000e^5gS\u000e\fG/[8ogB1\u00111VB\u0017\u0007cIAaa\f\u00028\n\u00191+\u001a;\u0011\t\t-61G\u0005\u0005\u0007k\u0011iK\u0001\u000bJ]R,'O\\1m\u001d>$\u0018NZ5dCRLwN\\\u0001\u0013O\u0016$8)\u001f9iKJ4UO\\2uS>t7/\u0006\u0002\u0004<A11QHB!\u0007\u000bj!aa\u0010\u000b\t\t=\u0016qA\u0005\u0005\u0007\u0007\u001ayD\u0001\u0003MSN$\b\u0003BA\u0017\u0007\u000fJAa!\u0013\u00020\t\u0019b)\u001e8di&|g.\u00138g_Jl\u0017\r^5p]\u0006y1\r[3dWB\u000b'/Y7fi\u0016\u00148\u000f\u0006\u0005\u0004\u0002\r=3\u0011LB/\u0011\u001d\u0019\t&\u000ba\u0001\u0007'\n1\"];fef\u0004\u0016M]1ngB)Ah!\u0016\u0002*&\u00191qK\u001f\u0003\u000b\u0005\u0013(/Y=\t\u000f\rm\u0013\u00061\u0001\u0002>\u0006Yq-\u001b<f]B\u000b'/Y7t\u0011\u001d\u0019y&\u000ba\u0001\u0003{\u000bq\"\u001a=ue\u0006\u001cG/\u001a3QCJ\fWn\u001d\u0015\u0006S\r\r4Q\u000f\t\u0006y\r\u00154\u0011N\u0005\u0004\u0007Oj$A\u0002;ie><8\u000f\u0005\u0003\u0004l\rETBAB7\u0015\r\u0019y'N\u0001\u000bKb\u001cW\r\u001d;j_:\u001c\u0018\u0002BB:\u0007[\u0012!\u0004U1sC6,G/\u001a:O_R4u.\u001e8e\u000bb\u001cW\r\u001d;j_:\u001c#a!\u001b\u0002\u001f\u0015CXmY;uS>tWI\\4j]\u0016\u0004\"aZ\u0016\u0014\u0005-ZDCAB=\u0003M\u0001F*\u0011(`\u0005VKE\nR%O\u000f~#&+S#T+\t\u0019\u0019\tE\u0002=\u0007\u000bK1aa\">\u0005\rIe\u000e^\u0001\u0015!2\u000bej\u0018\"V\u00132#\u0015JT$`)JKUi\u0015\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0019yIK\u0002\u0000\u0003s\u0004")
public abstract class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CypherConfiguration config;
    private final MasterCompiler masterCompiler;
    private final CypherQueryCaches queryCaches;
    private final InternalLogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final CachingPreParser preParser;
    private final QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    public CypherQueryCaches queryCaches() {
        return this.queryCaches;
    }

    public InternalLogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    public QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private CachingPreParser preParser() {
        return this.preParser;
    }

    private QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        monitor.startProcessing(context.executingQuery());
        return this.executeSubquery(query, params, context, true, profile, prePopulate, subscriber, monitor);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger));
    }

    public QueryExecutionMonitor execute$default$7() {
        return this.defaultQueryExecutionMonitor();
    }

    public QueryExecution executeSubquery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.masterCompiler().supportsAdministrativeCommands();
            RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, (InternalNotificationLogger)notificationLogger, this.config().systemDefaultLanguage(), profile, couldContainSensitiveFields, TransactionalContext.DatabaseMode.COMPOSITE.equals((Object)context.databaseMode()));
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, monitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger);
        });
    }

    public QueryExecutionMonitor executeSubquery$default$8() {
        return this.defaultQueryExecutionMonitor();
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof Status.HasStatus) {
                    Throwable throwable3 = throwable2;
                    context.kernelTransaction().markForTermination(((Status.HasStatus)throwable3).status());
                    context.close();
                    throw throwable3;
                }
                if (throwable2 != null) {
                    Throwable throwable4 = throwable2;
                    context.kernelTransaction().markForTermination((Status)Status.Transaction.QueryExecutionFailedOnTransaction);
                    context.close();
                    throw throwable4;
                }
                throw throwable;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber, InternalNotificationLogger notificationLogger) {
        ExecutableQuery executableQuery;
        context.executingQuery().onPreparseReady(query.resolvedLanguage());
        try {
            executableQuery = this.getOrCompile(context, query, tracer, params, notificationLogger);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ErrorGqlStatusObject) {
                Throwable throwable3 = throwable2;
                if (isOutermostQuery) {
                    Status status;
                    Throwable throwable4 = throwable3;
                    if (throwable4 instanceof Status.HasStatus) {
                        Throwable throwable5 = throwable4;
                        status = ((Status.HasStatus)throwable5).status();
                    } else {
                        status = null;
                    }
                    Status status2 = status;
                    queryMonitor.endFailure(context.executingQuery(), throwable3.getMessage(), status2, (ErrorGqlStatusObject)throwable3);
                }
                throw throwable3;
            }
            if (throwable2 != null) {
                Throwable throwable6 = throwable2;
                if (isOutermostQuery) {
                    Status status;
                    Throwable throwable7 = throwable6;
                    if (throwable7 instanceof Status.HasStatus) {
                        Throwable throwable8 = throwable7;
                        status = ((Status.HasStatus)throwable8).status();
                    } else {
                        status = null;
                    }
                    Status status3 = status;
                    queryMonitor.endFailure(context.executingQuery(), throwable6.getMessage(), status3, null);
                }
                throw throwable6;
            }
            throw throwable;
        }
        ExecutableQuery executableQuery2 = executableQuery;
        String string = query.options().queryOptions().executionMode().name();
        String string2 = "explain";
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkParameters(executableQuery2.paramNames(), params, executableQuery2.extractedParams());
        }
        MapValue combinedParams = params.updatedWith(executableQuery2.extractedParams());
        if (isOutermostQuery) {
            context.executingQuery().onObfuscatorReady(executableQuery2.queryObfuscator(), query.options().offset().offset());
            context.executingQuery().onCompilationCompleted(executableQuery2.compilerInfo(), executableQuery2.planDescriptionSupplier(), executableQuery2.deprecationNotificationsProvider(query.options().offset()), executableQuery2.executionPlanCacheKeyHash());
        }
        QueryRuntimeConfig queryConfig = QueryRuntimeConfig$.MODULE$.createFrom(query.options().queryOptions(), this.config());
        return executableQuery2.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber, queryConfig);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params, InternalNotificationLogger notificationLogger, DatabaseReference sessionDatabase) {
        Function0 & Serializable compiledExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        Function0 & Serializable interpretedExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0) {
                    return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
                }
                return (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount, Function0<Object> shouldRecompile) {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() && shouldRecompile.apply$mcZ$sp()) {
                    return new Some(this.compiledExpressionCompiler$1.apply());
                }
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery initialInputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params, InternalNotificationLogger notificationLogger) {
        block7: {
            ExecutableQuery executableQuery;
            block6: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));
                boolean forceReplan = false;
                InputQuery inputQuery = initialInputQuery;
                QueryCache.CacheKey<InputQuery.CacheKey> cacheKey = new QueryCache.CacheKey<InputQuery.CacheKey>(inputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params, this.config().useParameterSizeHint()), tc.kernelTransaction().dataRead().transactionStateHasChanges(), inputQuery.resolvedLanguage());
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        if (forceReplan) {
                            forceReplan = false;
                            inputQuery = inputQuery.withReplanOption((CypherReplanOption)CypherReplanOption.force$.MODULE$);
                        }
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params, notificationLogger, new DatabaseReference(null, context){
                            private final TransactionalContext context$3;

                            public String name() {
                                return super.name();
                            }

                            public NormalizedDatabaseName alias() {
                                throw new NotImplementedError();
                            }

                            public Optional<NormalizedDatabaseName> namespace() {
                                throw new NotImplementedError();
                            }

                            public boolean isPrimary() {
                                throw new NotImplementedError();
                            }

                            public UUID id() {
                                throw new NotImplementedError();
                            }

                            public String toPrettyString() {
                                throw new NotImplementedError();
                            }

                            public NormalizedDatabaseName fullName() {
                                return this.context$3.databaseId().normalizedName();
                            }

                            public boolean isComposite() {
                                return this.context$3.databaseMode().equals((Object)TransactionalContext.DatabaseMode.COMPOSITE);
                            }

                            public int compareTo(DatabaseReference o) {
                                throw new NotImplementedError();
                            }

                            public String owningDatabaseName() {
                                return this.fullName().name();
                            }

                            public NormalizedCatalogEntry catalogEntry() {
                                throw new NotImplementedError();
                            }

                            public boolean isShard() {
                                return false;
                            }
                            {
                                this.context$3 = context$3;
                            }
                        });
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().queryOptions().replan(), context.executingQuery().id());
                        SchemaHelper.LockedEntities lockedEntities = this.schemaHelper().lockEntities(schemaToken, executableQuery2, tc);
                        if (lockedEntities.successful()) {
                            executableQuery = executableQuery2;
                            break block6;
                        }
                        forceReplan = lockedEntities.needsReplan();
                    }
                    break block7;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw CompilationException$.MODULE$.tooFrequentSchemaChanges();
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()}))).max((Ordering)Ordering.Long$.MODULE$));
    }

    public long clearPreParserCache() {
        return this.preParser().clearCache();
    }

    public long clearExecutableQueryCache() {
        return this.queryCache().clear();
    }

    public long clearCompilerCaches() {
        return this.masterCompiler().clearCaches();
    }

    public void insertIntoCache(PreParsedQuery preParsedQuery, MapValue params, BaseState parsedQuery, Set<InternalNotification> parsingNotifications) {
        this.preParser().insertIntoCache(preParsedQuery);
        this.masterCompiler().insertIntoCache(preParsedQuery, params, parsedQuery, parsingNotifications);
    }

    public java.util.List<FunctionInformation> getCypherFunctions() {
        List informations = Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        scala.collection.immutable.Seq predicateInformations = (scala.collection.immutable.Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)informations.$plus$plus((IterableOnce)predicateInformations)).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])queryParams), (Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key)))));
            throw ParameterNotFoundException.expectedParam((String)Predef$.MODULE$.wrapRefArray((Object[])missingKeys).mkString(", "), (Iterable)givenParams.keySet());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CypherConfiguration config, MasterCompiler masterCompiler, CypherQueryCaches queryCaches, InternalLogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.config = config;
        this.masterCompiler = masterCompiler;
        this.queryCaches = queryCaches;
        this.logProvider = logProvider;
        this.clock = clock;
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new CachingPreParser(config, queryCaches.preParserCache());
        this.queryCache = queryCaches.executableQueryCache();
        this.schemaHelper = new SchemaHelper(this.queryCache(), masterCompiler);
    }
}

