/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.preparser.javacc;

import java.io.IOException;
import org.neo4j.cypher.internal.parser.common.InvalidUnicodeLiteral;
import org.neo4j.cypher.internal.preparser.javacc.CharStream;

public final class PreParserCharStream
implements CharStream {
    private static final char BACKSLASH = '\\';
    private static final IOException END_OF_INPUT = new IOException("End of input");
    private final String query;
    private int queryCursor = -1;
    private int queryCursorColumn;
    private int queryCursorLine = 1;
    private boolean queryCursorIsCR;
    private boolean queryCursorIsLF;
    private char[] result;
    private int resultCursor = -1;
    private int resultHighMark;
    private final int[] lines;
    private final int[] columns;
    private final int[] offsets;
    private int beginOffset;
    private int tabSize = 1;

    public PreParserCharStream(String query) {
        this.query = query;
        this.result = new char[query.length()];
        this.lines = new int[query.length()];
        this.columns = new int[query.length()];
        this.offsets = new int[query.length()];
    }

    @Override
    public char readChar() throws IOException {
        if (this.resultCursor + 1 == this.resultHighMark) {
            this.convertChar();
        }
        ++this.resultCursor;
        return this.result[this.resultCursor];
    }

    private void convertChar() throws IOException {
        char c = this.nextQueryChar();
        if (c == '\\') {
            char c2 = this.nextQueryChar();
            if (c2 == 'u') {
                c = this.convertUnicode(c2);
            } else {
                this.appendToResult(c);
                c = c2;
            }
        }
        this.appendToResult(c);
    }

    private void appendToResult(char c) {
        this.result[this.resultHighMark] = c;
        this.lines[this.resultHighMark] = this.queryCursorLine;
        this.columns[this.resultHighMark] = this.queryCursorColumn;
        this.offsets[this.resultHighMark] = this.queryCursor;
        ++this.resultHighMark;
    }

    private char nextQueryChar() throws IOException {
        if (this.queryCursor + 1 >= this.query.length()) {
            throw END_OF_INPUT;
        }
        ++this.queryCursor;
        char c = this.query.charAt(this.queryCursor);
        this.updateLineColumn(c);
        return c;
    }

    private void updateLineColumn(char c) {
        ++this.queryCursorColumn;
        if (this.queryCursorIsLF) {
            this.queryCursorIsLF = false;
            this.queryCursorColumn = 1;
            ++this.queryCursorLine;
        } else if (this.queryCursorIsCR) {
            this.queryCursorIsCR = false;
            if (c == '\n') {
                this.queryCursorIsLF = true;
            } else {
                this.queryCursorColumn = 1;
                ++this.queryCursorLine;
            }
        }
        switch (c) {
            case '\r': {
                this.queryCursorIsCR = true;
                break;
            }
            case '\n': {
                this.queryCursorIsLF = true;
                break;
            }
            case '\t': {
                --this.queryCursorColumn;
                this.queryCursorColumn += this.tabSize - this.queryCursorColumn % this.tabSize;
                break;
            }
        }
    }

    private char convertUnicode(char c) {
        try {
            while (c == 'u') {
                c = this.nextQueryChar();
            }
            return (char)(PreParserCharStream.hexval(c) << 12 | PreParserCharStream.hexval(this.nextQueryChar()) << 8 | PreParserCharStream.hexval(this.nextQueryChar()) << 4 | PreParserCharStream.hexval(this.nextQueryChar()));
        }
        catch (IOException e) {
            throw new InvalidUnicodeLiteral(e.getMessage(), this.queryCursor, this.queryCursorLine, this.queryCursorColumn);
        }
    }

    @Override
    public void backup(int amount) {
        this.resultCursor -= amount;
    }

    @Override
    public int getBeginColumn() {
        return this.columns[this.beginOffset];
    }

    @Override
    public int getBeginLine() {
        return this.lines[this.beginOffset];
    }

    public int getBeginOffset() {
        return this.offsets[this.beginOffset];
    }

    @Override
    public int getEndColumn() {
        return this.columns[this.resultCursor];
    }

    @Override
    public int getEndLine() {
        return this.lines[this.resultCursor];
    }

    public int getEndOffset() {
        return this.offsets[this.resultCursor];
    }

    @Override
    public char beginToken() throws IOException {
        char c = this.readChar();
        this.beginOffset = this.resultCursor;
        return c;
    }

    @Override
    public String getImage() {
        return new String(this.result, this.beginOffset, this.nextOffset() - this.beginOffset);
    }

    private int nextOffset() {
        return this.resultCursor + 1;
    }

    @Override
    public char[] getSuffix(int len) {
        char[] suffix = new char[len];
        int endOffset = this.nextOffset();
        System.arraycopy(this.result, endOffset - len, suffix, 0, len);
        return suffix;
    }

    @Override
    public void done() {
    }

    @Override
    public void setTabSize(int i) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public int getTabSize() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void setTrackLineColumn(boolean trackLineColumn) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean isTrackLineColumn() {
        return true;
    }

    static int hexval(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException("Invalid input '" + c + "': expected four hexadecimal digits specifying a unicode character");
    }
}

