/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.ast.CreateConstraintType;
import org.neo4j.cypher.internal.ast.NodeKey;
import org.neo4j.cypher.internal.ast.NodePropertyExistence$;
import org.neo4j.cypher.internal.ast.NodePropertyType;
import org.neo4j.cypher.internal.ast.NodePropertyUniqueness;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.RelationshipKey;
import org.neo4j.cypher.internal.ast.RelationshipPropertyExistence$;
import org.neo4j.cypher.internal.ast.RelationshipPropertyType;
import org.neo4j.cypher.internal.ast.RelationshipPropertyUniqueness;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.constraint.ConstraintCommandPlanner$;
import org.neo4j.cypher.internal.expressions.DynamicLabelExpression;
import org.neo4j.cypher.internal.expressions.DynamicRelTypeExpression;
import org.neo4j.cypher.internal.expressions.ElementTypeName;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.SymbolicName;
import org.neo4j.cypher.internal.expressions.functions.Labels$;
import org.neo4j.cypher.internal.expressions.functions.Type$;
import org.neo4j.cypher.internal.index.IndexCommandPlanner$;
import org.neo4j.cypher.internal.logical.plans.AlterCurrentGraphType;
import org.neo4j.cypher.internal.logical.plans.CreateConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateFulltextIndex;
import org.neo4j.cypher.internal.logical.plans.CreateIndex;
import org.neo4j.cypher.internal.logical.plans.CreateLookupIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForFulltextIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForLookupIndex;
import org.neo4j.cypher.internal.logical.plans.DropConstraintOnName;
import org.neo4j.cypher.internal.logical.plans.DropIndexOnName;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.plandescription.LogicalPlan2PlanDescription$;
import org.neo4j.cypher.internal.plandescription.PrettyString;
import org.neo4j.cypher.internal.plandescription.asPrettyString$;
import org.neo4j.cypher.internal.plandescription.asPrettyString$PrettyStringInterpolator$;
import org.neo4j.cypher.internal.procs.PropertyTypeMapper$;
import org.neo4j.cypher.internal.procs.SchemaExecutionPlan;
import org.neo4j.cypher.internal.procs.SchemaExecutionPlan$;
import org.neo4j.cypher.internal.runtime.ConstraintInformation;
import org.neo4j.cypher.internal.runtime.IndexInformation;
import org.neo4j.cypher.internal.runtime.IndexProviderContext;
import org.neo4j.cypher.internal.runtime.InternalQueryType;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.SCHEMA_WRITE$;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.exceptions.ParameterWrongTypeException;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SchemaCommandRuntime$
implements CypherRuntime<RuntimeContext> {
    public static final SchemaCommandRuntime$ MODULE$ = new SchemaCommandRuntime$();
    private static final PartialFunction<LogicalPlan, Function1<RuntimeContext, ExecutionPlan>> logicalToExecutable = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            boolean bl = false;
            CreateConstraint createConstraint = null;
            boolean bl2 = false;
            CreateIndex createIndex = null;
            A1 A1 = x1;
            if (A1 instanceof CreateConstraint) {
                bl = true;
                createConstraint = (CreateConstraint)A1;
                Option source = createConstraint.source();
                CreateConstraintType nodeKey = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                Seq props = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (nodeKey instanceof NodeKey) {
                    NodeKey nodeKey2 = (NodeKey)nodeKey;
                    if (label instanceof LabelName) {
                        LabelName labelName = (LabelName)label;
                        return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodeKeyConstraint", ConstraintCommandPlanner$.MODULE$.createNodeKeyConstraint(nodeKey2, labelName, (Seq<Property>)props, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$1 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$1, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                    }
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType relKey = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                Seq props = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (relKey instanceof RelationshipKey) {
                    RelationshipKey relationshipKey = (RelationshipKey)relKey;
                    if (relType instanceof RelTypeName) {
                        RelTypeName relTypeName = (RelTypeName)relType;
                        return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipKeyConstraint", ConstraintCommandPlanner$.MODULE$.createRelationshipKeyConstraint(relationshipKey, relTypeName, (Seq<Property>)props, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$2 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$2, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                    }
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType nodePropUnique = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                Seq props = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (nodePropUnique instanceof NodePropertyUniqueness) {
                    NodePropertyUniqueness nodePropertyUniqueness = (NodePropertyUniqueness)nodePropUnique;
                    if (label instanceof LabelName) {
                        LabelName labelName = (LabelName)label;
                        return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodePropertyUniquenessConstraint", ConstraintCommandPlanner$.MODULE$.createNodePropertyUniquenessConstraint(nodePropertyUniqueness, labelName, (Seq<Property>)props, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$3 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$3, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                    }
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType relPropUnique = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                Seq props = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (relPropUnique instanceof RelationshipPropertyUniqueness) {
                    RelationshipPropertyUniqueness relationshipPropertyUniqueness = (RelationshipPropertyUniqueness)relPropUnique;
                    if (relType instanceof RelTypeName) {
                        RelTypeName relTypeName = (RelTypeName)relType;
                        return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipPropertyUniquenessConstraint", ConstraintCommandPlanner$.MODULE$.createRelationshipPropertyUniquenessConstraint(relationshipPropertyUniqueness, relTypeName, (Seq<Property>)props, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$4 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$4, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                    }
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                Seq prop = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (NodePropertyExistence$.MODULE$.equals(createConstraintType) && label instanceof LabelName) {
                    LabelName labelName = (LabelName)label;
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodePropertyExistenceConstraint", ConstraintCommandPlanner$.MODULE$.createNodePropertyExistenceConstraint(labelName, (Seq<Property>)prop, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$5 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$5, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                Seq prop = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType) && relType instanceof RelTypeName) {
                    RelTypeName relTypeName = (RelTypeName)relType;
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipPropertyExistenceConstraint", ConstraintCommandPlanner$.MODULE$.createRelationshipPropertyExistenceConstraint(relTypeName, (Seq<Property>)prop, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$6 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$6, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                Seq prop = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (createConstraintType instanceof NodePropertyType) {
                    NodePropertyType nodePropertyType = (NodePropertyType)createConstraintType;
                    CypherType propertyType = nodePropertyType.propType();
                    if (label instanceof LabelName) {
                        LabelName labelName = (LabelName)label;
                        return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodePropertyTypeConstraint", ConstraintCommandPlanner$.MODULE$.createNodePropertyTypeConstraint(propertyType, labelName, (Seq<Property>)prop, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$7 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$7, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                    }
                }
            }
            if (bl) {
                Option source = createConstraint.source();
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                Seq prop = createConstraint.props();
                Option name = createConstraint.name();
                Options options = createConstraint.options();
                if (createConstraintType instanceof RelationshipPropertyType) {
                    RelationshipPropertyType relationshipPropertyType = (RelationshipPropertyType)createConstraintType;
                    CypherType propertyType = relationshipPropertyType.propType();
                    if (relType instanceof RelTypeName) {
                        RelTypeName relTypeName = (RelTypeName)relType;
                        return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipPropertyTypeConstraint", ConstraintCommandPlanner$.MODULE$.createRelationshipPropertyTypeConstraint(propertyType, relTypeName, (Seq<Property>)prop, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$8 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$8, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                    }
                }
            }
            if (A1 instanceof DropConstraintOnName) {
                DropConstraintOnName dropConstraintOnName = (DropConstraintOnName)A1;
                Either name = dropConstraintOnName.name();
                boolean ifExists = dropConstraintOnName.ifExists();
                return (B1)(Function1 & Serializable)x$9 -> new SchemaExecutionPlan("DropConstraint", ConstraintCommandPlanner$.MODULE$.dropConstraint((Either<String, Parameter>)name, ifExists), SchemaExecutionPlan$.MODULE$.apply$default$3());
            }
            if (A1 instanceof CreateIndex) {
                bl2 = true;
                createIndex = (CreateIndex)A1;
                Option source = createIndex.source();
                org.neo4j.graphdb.schema.IndexType indexType = createIndex.indexType();
                ElementTypeName entityName = createIndex.entityName();
                List props = createIndex.propertyKeyNames();
                Option name = createIndex.name();
                Options options = createIndex.options();
                if (org.neo4j.graphdb.schema.IndexType.RANGE.equals(indexType)) {
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", IndexCommandPlanner$.MODULE$.createRangeIndex(entityName, (List<PropertyKeyName>)props, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$10 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$10, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (A1 instanceof CreateLookupIndex) {
                CreateLookupIndex createLookupIndex = (CreateLookupIndex)A1;
                Option source = createLookupIndex.source();
                EntityType entityType = createLookupIndex.entityType();
                Option name = createLookupIndex.name();
                Options options = createLookupIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", IndexCommandPlanner$.MODULE$.createLookupIndex(entityType, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$11 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$11, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateFulltextIndex) {
                CreateFulltextIndex createFulltextIndex = (CreateFulltextIndex)A1;
                Option source = createFulltextIndex.source();
                Either entityNames = createFulltextIndex.entityNames();
                List props = createFulltextIndex.propertyKeyNames();
                Option name = createFulltextIndex.name();
                Options options = createFulltextIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", IndexCommandPlanner$.MODULE$.createFulltextIndex((Either<List<LabelName>, List<RelTypeName>>)entityNames, (List<PropertyKeyName>)props, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$12 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$12, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (bl2) {
                Option source = createIndex.source();
                org.neo4j.graphdb.schema.IndexType indexType = createIndex.indexType();
                ElementTypeName entityName = createIndex.entityName();
                List props = createIndex.propertyKeyNames();
                Option name = createIndex.name();
                Options options = createIndex.options();
                if (org.neo4j.graphdb.schema.IndexType.TEXT.equals(indexType)) {
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", IndexCommandPlanner$.MODULE$.createTextIndex(entityName, (List<PropertyKeyName>)props, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$13 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$13, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl2) {
                Option source = createIndex.source();
                org.neo4j.graphdb.schema.IndexType indexType = createIndex.indexType();
                ElementTypeName entityName = createIndex.entityName();
                List props = createIndex.propertyKeyNames();
                Option name = createIndex.name();
                Options options = createIndex.options();
                if (org.neo4j.graphdb.schema.IndexType.POINT.equals(indexType)) {
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", IndexCommandPlanner$.MODULE$.createPointIndex(entityName, (List<PropertyKeyName>)props, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$14 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$14, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (bl2) {
                Option source = createIndex.source();
                org.neo4j.graphdb.schema.IndexType indexType = createIndex.indexType();
                ElementTypeName entityName = createIndex.entityName();
                List props = createIndex.propertyKeyNames();
                Option name = createIndex.name();
                Options options = createIndex.options();
                if (org.neo4j.graphdb.schema.IndexType.VECTOR.equals(indexType)) {
                    return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", IndexCommandPlanner$.MODULE$.createVectorIndex(entityName, (List<PropertyKeyName>)props, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$15 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$15, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                }
            }
            if (A1 instanceof DropIndexOnName) {
                DropIndexOnName dropIndexOnName = (DropIndexOnName)A1;
                Either name = dropIndexOnName.name();
                boolean ifExists = dropIndexOnName.ifExists();
                return (B1)(Function1 & Serializable)x$16 -> new SchemaExecutionPlan("DropIndex", IndexCommandPlanner$.MODULE$.dropIndex((Either<String, Parameter>)name, ifExists), SchemaExecutionPlan$.MODULE$.apply$default$3());
            }
            if (A1 instanceof DoNothingIfExistsForIndex) {
                DoNothingIfExistsForIndex doNothingIfExistsForIndex = (DoNothingIfExistsForIndex)A1;
                ElementTypeName entityName = doNothingIfExistsForIndex.entityName();
                List propertyKeyNames = doNothingIfExistsForIndex.propertyKeyNames();
                org.neo4j.graphdb.schema.IndexType indexType = doNothingIfExistsForIndex.indexType();
                Option name = doNothingIfExistsForIndex.name();
                Options options = doNothingIfExistsForIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("DoNothingIfExist", IndexCommandPlanner$.MODULE$.doNothingIfExists(entityName, (List<PropertyKeyName>)propertyKeyNames, indexType, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)None$.MODULE$);
            }
            if (A1 instanceof DoNothingIfExistsForLookupIndex) {
                DoNothingIfExistsForLookupIndex doNothingIfExistsForLookupIndex = (DoNothingIfExistsForLookupIndex)A1;
                EntityType entityType = doNothingIfExistsForLookupIndex.entityType();
                Option name = doNothingIfExistsForLookupIndex.name();
                Options options = doNothingIfExistsForLookupIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("DoNothingIfExist", IndexCommandPlanner$.MODULE$.doNothingIfExistsForLookup(entityType, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)None$.MODULE$);
            }
            if (A1 instanceof DoNothingIfExistsForFulltextIndex) {
                DoNothingIfExistsForFulltextIndex doNothingIfExistsForFulltextIndex = (DoNothingIfExistsForFulltextIndex)A1;
                Either entityNames = doNothingIfExistsForFulltextIndex.entityNames();
                List propertyKeyNames = doNothingIfExistsForFulltextIndex.propertyKeyNames();
                Option name = doNothingIfExistsForFulltextIndex.name();
                Options options = doNothingIfExistsForFulltextIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("DoNothingIfExist", IndexCommandPlanner$.MODULE$.doNothingIfExistsForFulltext((Either<List<LabelName>, List<RelTypeName>>)entityNames, (List<PropertyKeyName>)propertyKeyNames, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)None$.MODULE$);
            }
            if (A1 instanceof DoNothingIfExistsForConstraint) {
                DoNothingIfExistsForConstraint doNothingIfExistsForConstraint = (DoNothingIfExistsForConstraint)A1;
                ElementTypeName entityName = doNothingIfExistsForConstraint.entityName();
                Seq props = doNothingIfExistsForConstraint.props();
                CreateConstraintType assertion = doNothingIfExistsForConstraint.assertion();
                Option name = doNothingIfExistsForConstraint.name();
                Options options = doNothingIfExistsForConstraint.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("DoNothingIfExist", ConstraintCommandPlanner$.MODULE$.doNothingIfExists(entityName, (Seq<Property>)props, assertion, (Option<Either<String, Parameter>>)name, options, context.cypherVersion()), (Option<ExecutionPlan>)None$.MODULE$);
            }
            if (A1 instanceof AlterCurrentGraphType) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
            return (B1)function1.apply(x1);
        }

        public final boolean isDefinedAt(LogicalPlan x1) {
            org.neo4j.graphdb.schema.IndexType indexType;
            org.neo4j.graphdb.schema.IndexType indexType2;
            org.neo4j.graphdb.schema.IndexType indexType3;
            boolean bl = false;
            CreateConstraint createConstraint = null;
            boolean bl2 = false;
            CreateIndex createIndex = null;
            LogicalPlan logicalPlan = x1;
            if (logicalPlan instanceof CreateConstraint) {
                bl = true;
                createConstraint = (CreateConstraint)logicalPlan;
                CreateConstraintType nodeKey = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                if (nodeKey instanceof NodeKey && label instanceof LabelName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType relKey = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                if (relKey instanceof RelationshipKey && relType instanceof RelTypeName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType nodePropUnique = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                if (nodePropUnique instanceof NodePropertyUniqueness && label instanceof LabelName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType relPropUnique = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                if (relPropUnique instanceof RelationshipPropertyUniqueness && relType instanceof RelTypeName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                if (NodePropertyExistence$.MODULE$.equals(createConstraintType) && label instanceof LabelName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType) && relType instanceof RelTypeName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName label = createConstraint.entityName();
                if (createConstraintType instanceof NodePropertyType && label instanceof LabelName) {
                    return true;
                }
            }
            if (bl) {
                CreateConstraintType createConstraintType = createConstraint.constraintType();
                ElementTypeName relType = createConstraint.entityName();
                if (createConstraintType instanceof RelationshipPropertyType && relType instanceof RelTypeName) {
                    return true;
                }
            }
            if (logicalPlan instanceof DropConstraintOnName) {
                return true;
            }
            if (logicalPlan instanceof CreateIndex) {
                bl2 = true;
                createIndex = (CreateIndex)logicalPlan;
                org.neo4j.graphdb.schema.IndexType indexType4 = createIndex.indexType();
                if (org.neo4j.graphdb.schema.IndexType.RANGE.equals(indexType4)) {
                    return true;
                }
            }
            if (logicalPlan instanceof CreateLookupIndex) {
                return true;
            }
            if (logicalPlan instanceof CreateFulltextIndex) {
                return true;
            }
            if (bl2 && org.neo4j.graphdb.schema.IndexType.TEXT.equals(indexType3 = createIndex.indexType())) {
                return true;
            }
            if (bl2 && org.neo4j.graphdb.schema.IndexType.POINT.equals(indexType2 = createIndex.indexType())) {
                return true;
            }
            if (bl2 && org.neo4j.graphdb.schema.IndexType.VECTOR.equals(indexType = createIndex.indexType())) {
                return true;
            }
            if (logicalPlan instanceof DropIndexOnName) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForIndex) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForLookupIndex) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForFulltextIndex) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForConstraint) {
                return true;
            }
            return logicalPlan instanceof AlterCurrentGraphType;
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.ast.NodeKey org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$10(org.neo4j.cypher.internal.ast.RelationshipPropertyUniqueness org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$11(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$12(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$13(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$14(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$15(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$16(org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$17(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$18(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$19(org.neo4j.cypher.internal.util.symbols.CypherType org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$20(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$21(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$22(org.neo4j.cypher.internal.util.symbols.CypherType org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$23(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$24(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$25(scala.util.Either boolean org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$26(org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$27(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$28(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$29(org.neo4j.common.EntityType scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$3(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$30(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForLookupIndex ), $anonfun$applyOrElse$31(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$32(scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$33(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForFulltextIndex ), $anonfun$applyOrElse$34(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$35(org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$36(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$37(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$38(org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$39(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$4(org.neo4j.cypher.internal.ast.RelationshipKey org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$40(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$41(org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$42(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$43(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$44(scala.util.Either boolean org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$45(org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.List org.neo4j.graphdb.schema.IndexType scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$46(org.neo4j.common.EntityType scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$47(scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$48(org.neo4j.cypher.internal.expressions.ElementTypeName scala.collection.immutable.Seq org.neo4j.cypher.internal.ast.CreateConstraintType scala.Option org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$6(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$7(org.neo4j.cypher.internal.ast.NodePropertyUniqueness org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.ast.Options scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$8(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$9(org.neo4j.cypher.internal.logical.plans.LogicalPlan )}, serializedLambda);
        }
    };

    @Override
    public String name() {
        return "schema";
    }

    @Override
    public Option<CypherRuntimeOption> correspondingRuntimeOption() {
        return None$.MODULE$;
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery state, RuntimeContext context, TransactionalContext.DatabaseMode databaseMode) {
        return (ExecutionPlan)((Function1)this.logicalToExecutable().applyOrElse((Object)state.logicalPlan(), (Function1 & Serializable)unknownPlan -> MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply((Object)context);
    }

    public Nothing$ throwCantCompile(LogicalPlan unknownPlan) {
        throw CantCompileQueryException.planNotSchemaCommand((String)unknownPlan.getClass().getSimpleName());
    }

    public Option<InternalQueryType> queryType(LogicalPlan logicalPlan) {
        if (this.logicalToExecutable().isDefinedAt((Object)logicalPlan)) {
            return new Some((Object)SCHEMA_WRITE$.MODULE$);
        }
        return None$.MODULE$;
    }

    public PartialFunction<LogicalPlan, Function1<RuntimeContext, ExecutionPlan>> logicalToExecutable() {
        return logicalToExecutable;
    }

    public Option<String> getName(Option<Either<String, Parameter>> name, MapValue params) {
        return name.map((Function1 & Serializable)x$17 -> MODULE$.getName((Either<String, Parameter>)x$17, params));
    }

    public String getName(Either<String, Parameter> name, MapValue params) {
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String stringName = (String)left.value();
            return stringName;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Parameter paramName = (Parameter)right.value();
            AnyValue anyValue = params.get(paramName.name());
            if (anyValue instanceof StringValue) {
                StringValue stringValue = (StringValue)anyValue;
                return stringValue.stringValue();
            }
            throw ParameterWrongTypeException.expectedStringButGotType((String)paramName.name(), (String)anyValue.getTypeName(), (String)anyValue.prettify());
        }
        throw new MatchError(either);
    }

    public Tuple2<Object, EntityType> getEntityInfo(ElementTypeName entityName, QueryContext ctx) {
        ElementTypeName elementTypeName = entityName;
        if (elementTypeName instanceof LabelName) {
            LabelName labelName = (LabelName)elementTypeName;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(labelName.name())), (Object)EntityType.NODE);
        }
        if (elementTypeName instanceof RelTypeName) {
            RelTypeName relTypeName = (RelTypeName)elementTypeName;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relTypeName.name())), (Object)EntityType.RELATIONSHIP);
        }
        if (elementTypeName instanceof DynamicLabelExpression) {
            throw new IllegalStateException("Did not expect Dynamic Labels here");
        }
        if (elementTypeName instanceof DynamicRelTypeExpression) {
            throw new IllegalStateException("Did not expect Dynamic Relationships here");
        }
        throw new MatchError((Object)elementTypeName);
    }

    public Tuple2<List<Object>, EntityType> getMultipleEntityInfo(Either<List<LabelName>, List<RelTypeName>> entityName, QueryContext ctx) {
        Either<List<LabelName>, List<RelTypeName>> either = entityName;
        if (either instanceof Left) {
            Left left = (Left)either;
            List labels = (List)left.value();
            return new Tuple2((Object)labels.map((Function1 & Serializable)label -> BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name()))), (Object)EntityType.NODE);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            List relTypes = (List)right.value();
            return new Tuple2((Object)relTypes.map((Function1 & Serializable)relType -> BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name()))), (Object)EntityType.RELATIONSHIP);
        }
        throw new MatchError(either);
    }

    public boolean isApplicable(LogicalPlanState logicalPlanState) {
        return this.logicalToExecutable().isDefinedAt(logicalPlanState.maybeLogicalPlan().get());
    }

    public Function1<ConstraintDescriptor, Object> convertConstraintTypeToConstraintMatcher(CreateConstraintType assertion) {
        CreateConstraintType createConstraintType = assertion;
        if (NodePropertyExistence$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodePropertyExistenceConstraint());
        }
        if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipPropertyExistenceConstraint());
        }
        if (createConstraintType instanceof NodePropertyUniqueness) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeUniquenessConstraint());
        }
        if (createConstraintType instanceof RelationshipPropertyUniqueness) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipUniquenessConstraint());
        }
        if (createConstraintType instanceof NodeKey) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeKeyConstraint());
        }
        if (createConstraintType instanceof RelationshipKey) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipKeyConstraint());
        }
        if (createConstraintType instanceof NodePropertyType) {
            NodePropertyType nodePropertyType = (NodePropertyType)createConstraintType;
            CypherType propType = nodePropertyType.propType();
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SchemaCommandRuntime$.$anonfun$convertConstraintTypeToConstraintMatcher$7(propType, c));
        }
        if (createConstraintType instanceof RelationshipPropertyType) {
            RelationshipPropertyType relationshipPropertyType = (RelationshipPropertyType)createConstraintType;
            CypherType propType = relationshipPropertyType.propType();
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SchemaCommandRuntime$.$anonfun$convertConstraintTypeToConstraintMatcher$8(propType, c));
        }
        throw new MatchError((Object)createConstraintType);
    }

    private boolean checkTypes(CypherType askedForType, PropertyTypeSet preExistingTypes) {
        return preExistingTypes.equals((Object)PropertyTypeMapper$.MODULE$.asPropertyTypeSet(askedForType));
    }

    public PropertyKeyId propertyToId(QueryContext ctx, PropertyKeyName property) {
        return new PropertyKeyId(ctx.getOrCreatePropertyKeyId(property.name()));
    }

    public Tuple3<Object, Object, Option<String>> labelPropWithName(QueryContext ctx, LabelName label, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    public Tuple3<Object, Object, Option<String>> typePropWithName(QueryContext ctx, RelTypeName relType, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    public String indexInfo(String indexType, Option<String> nameOption, ElementTypeName entityName, Seq<PropertyKeyName> properties, Options options) {
        PrettyString name = this.getPrettyName(nameOption);
        PrettyString pattern = this.getPrettyEntityPattern(entityName);
        PrettyString propertyString = this.getPrettyPropertyPattern(properties, "(", ")");
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " INDEX", " IF NOT EXISTS FOR ", " ON ", "", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.raw(indexType), name, pattern, propertyString, LogicalPlan2PlanDescription$.MODULE$.prettyOptions(options)})).prettifiedString();
    }

    public String fulltextIndexInfo(Option<String> nameOption, Either<List<LabelName>, List<RelTypeName>> entityNames, Seq<PropertyKeyName> properties, Options options) {
        PrettyString prettyString;
        PrettyString name = this.getPrettyName(nameOption);
        Either<List<LabelName>, List<RelTypeName>> either = entityNames;
        if (either instanceof Left) {
            Left left = (Left)either;
            List labels = (List)left.value();
            PrettyString innerPattern = asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)labels.map((Function1 & Serializable)l -> asPrettyString$.MODULE$.apply(l.name()))).mkPrettyString("e:", "|", "");
            prettyString = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{innerPattern}));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            List relTypes = (List)right.value();
            PrettyString innerPattern = asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)relTypes.map((Function1 & Serializable)r -> asPrettyString$.MODULE$.apply(r.name()))).mkPrettyString("e:", "|", "");
            prettyString = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{innerPattern}));
        } else {
            throw new MatchError(either);
        }
        PrettyString pattern = prettyString;
        PrettyString propertyString = this.getPrettyPropertyPattern(properties, "[", "]");
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FULLTEXT INDEX", " IF NOT EXISTS FOR ", " ON EACH ", "", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{name, pattern, propertyString, LogicalPlan2PlanDescription$.MODULE$.prettyOptions(options)})).prettifiedString();
    }

    public String lookupIndexInfo(Option<String> nameOption, EntityType entityType, Options options) {
        PrettyString name = this.getPrettyName(nameOption);
        EntityType entityType2 = entityType;
        EntityType entityType3 = EntityType.NODE;
        Tuple2<PrettyString, PrettyString> tuple2 = this.getPrettyLookupIndexPatternAndFunction(!(entityType2 != null ? !entityType2.equals(entityType3) : entityType3 != null));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PrettyString pattern = (PrettyString)tuple2._1();
        PrettyString function = (PrettyString)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pattern, (Object)function);
        PrettyString pattern2 = (PrettyString)tuple22._1();
        PrettyString function2 = (PrettyString)tuple22._2();
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"LOOKUP INDEX", " IF NOT EXISTS FOR ", " ON EACH ", "", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{name, pattern2, function2, LogicalPlan2PlanDescription$.MODULE$.prettyOptions(options)})).prettifiedString();
    }

    public String existingIndexInfo(QueryContext ctx, Function0<IndexInformation> getInfoParts) {
        String string;
        try {
            Tuple2 tuple2;
            ctx.assertShowIndexAllowed();
            IndexInformation indexInformation = (IndexInformation)getInfoParts.apply();
            if (indexInformation == null) {
                throw new MatchError((Object)indexInformation);
            }
            boolean isNode = indexInformation.isNode();
            IndexType indexType = indexInformation.indexType();
            String name = indexInformation.name();
            List entityNames = indexInformation.labelsOrRelTypes();
            List properties = indexInformation.properties();
            Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)isNode), (Object)indexType, (Object)name, (Object)entityNames, (Object)properties);
            boolean isNode2 = BoxesRunTime.unboxToBoolean((Object)tuple5._1());
            IndexType indexType2 = (IndexType)tuple5._2();
            String name2 = (String)tuple5._3();
            List entityNames2 = (List)tuple5._4();
            List properties2 = (List)tuple5._5();
            PrettyString nameString = this.getPrettyName((Option<String>)new Some((Object)name2));
            IndexType indexType3 = indexType2;
            if (IndexType.LOOKUP.equals(indexType3)) {
                Tuple2<PrettyString, PrettyString> tuple22 = this.getPrettyLookupIndexPatternAndFunction(isNode2);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                PrettyString pattern = (PrettyString)tuple22._1();
                PrettyString function = (PrettyString)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)pattern, (Object)function);
                PrettyString pattern2 = (PrettyString)tuple23._1();
                PrettyString function2 = (PrettyString)tuple23._2();
                v0 = new Tuple2((Object)pattern2, (Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"EACH ", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{function2})));
            } else if (IndexType.FULLTEXT.equals(indexType3)) {
                PrettyString innerPattern = asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)entityNames2.map((Function1 & Serializable)e -> asPrettyString$.MODULE$.apply((String)e))).mkPrettyString("e:", "|", "");
                PrettyString pattern = isNode2 ? asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{innerPattern})) : asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{innerPattern}));
                PrettyString propertyString = this.getPrettyPropertyPattern((List<String>)properties2, "[", "]");
                v0 = new Tuple2((Object)pattern, (Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"EACH ", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{propertyString})));
            } else {
                PrettyString pattern = this.getPrettyEntityPattern(isNode2, (String)entityNames2.head());
                PrettyString propertyString = this.getPrettyPropertyPattern((List<String>)properties2, "(", ")");
                v0 = tuple2 = new Tuple2((Object)pattern, (Object)propertyString);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PrettyString pattern = (PrettyString)tuple2._1();
            PrettyString on = (PrettyString)tuple2._2();
            Tuple2 tuple24 = new Tuple2((Object)pattern, (Object)on);
            PrettyString pattern3 = (PrettyString)tuple24._1();
            PrettyString on2 = (PrettyString)tuple24._2();
            string = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " INDEX", " FOR ", " ON ", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.raw(indexType2.name()), nameString, pattern3, on2})).prettifiedString();
        }
        catch (AuthorizationViolationException authorizationViolationException) {
            string = "index";
        }
        return string;
    }

    public String constraintInfo(Option<String> nameOption, ElementTypeName entityName, Seq<Property> properties, CreateConstraintType constraintType, Options options) {
        PrettyString name = this.getPrettyName(nameOption);
        PrettyString pattern = this.getPrettyEntityPattern(entityName);
        PrettyString propertyString = this.getPrettyPropertyPattern((Seq<PropertyKeyName>)((Seq)properties.map((Function1 & Serializable)p -> p.propertyKey())), "(", ")");
        PrettyString prettyAssertion = asPrettyString$.MODULE$.raw(constraintType.predicate());
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CONSTRAINT", " IF NOT EXISTS FOR ", " REQUIRE ", " ", "", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{name, pattern, propertyString, prettyAssertion, LogicalPlan2PlanDescription$.MODULE$.prettyOptions(options)})).prettifiedString();
    }

    public String existingConstraintInfo(QueryContext ctx, Function0<ConstraintInformation> getInfoParts, CypherVersion cypherVersion) {
        String string;
        block16: {
            try {
                PrettyString prettyAssertion;
                PrettyString propertyString;
                PrettyString pattern;
                PrettyString nameString;
                block18: {
                    block17: {
                        Object object;
                        ctx.assertShowConstraintAllowed();
                        ConstraintInformation constraintInformation = (ConstraintInformation)getInfoParts.apply();
                        if (constraintInformation == null) {
                            throw new MatchError((Object)constraintInformation);
                        }
                        boolean isNode = constraintInformation.isNode();
                        ConstraintType constraintType = constraintInformation.constraintType();
                        String name = constraintInformation.name();
                        String entityName = constraintInformation.labelOrRelType();
                        List properties = constraintInformation.properties();
                        Option propertyType = constraintInformation.propertyType();
                        Tuple6 tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)isNode), (Object)constraintType, (Object)name, (Object)entityName, (Object)properties, (Object)propertyType);
                        boolean isNode2 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
                        ConstraintType constraintType2 = (ConstraintType)tuple6._2();
                        String name2 = (String)tuple6._3();
                        String entityName2 = (String)tuple6._4();
                        List properties2 = (List)tuple6._5();
                        Option propertyType2 = (Option)tuple6._6();
                        nameString = this.getPrettyName((Option<String>)new Some((Object)name2));
                        pattern = this.getPrettyEntityPattern(isNode2, entityName2);
                        propertyString = this.getPrettyPropertyPattern((List<String>)properties2, "(", ")");
                        ConstraintType constraintType3 = constraintType2;
                        if (ConstraintType.EXISTS.equals(constraintType3)) {
                            object = "IS NOT NULL";
                        } else if (ConstraintType.UNIQUE_EXISTS.equals(constraintType3)) {
                            CypherVersion cypherVersion2 = cypherVersion;
                            CypherVersion cypherVersion3 = CypherVersion.Cypher5;
                            object = !(cypherVersion2 != null ? !cypherVersion2.equals(cypherVersion3) : cypherVersion3 != null) ? (isNode2 ? "IS NODE KEY" : "IS RELATIONSHIP KEY") : "IS KEY";
                        } else if (ConstraintType.UNIQUE.equals(constraintType3)) {
                            object = "IS UNIQUE";
                        } else if (ConstraintType.PROPERTY_TYPE.equals(constraintType3)) {
                            object = "IS :: " + propertyType2.get();
                        } else if (ConstraintType.RELATIONSHIP_ENDPOINT_LABEL.equals(constraintType3)) {
                            object = "";
                        } else if (ConstraintType.NODE_LABEL_EXISTENCE.equals(constraintType3)) {
                            object = "";
                        } else {
                            throw new MatchError((Object)constraintType3);
                        }
                        String assertion = object;
                        prettyAssertion = asPrettyString$.MODULE$.raw(assertion);
                        ConstraintType constraintType4 = constraintType2;
                        ConstraintType constraintType5 = ConstraintType.RELATIONSHIP_ENDPOINT_LABEL;
                        if (!(constraintType4 == null ? constraintType5 != null : !constraintType4.equals(constraintType5))) break block17;
                        ConstraintType constraintType6 = constraintType2;
                        ConstraintType constraintType7 = ConstraintType.NODE_LABEL_EXISTENCE;
                        if (constraintType6 != null ? !constraintType6.equals(constraintType7) : constraintType7 != null) break block18;
                    }
                    string = "constraint";
                    break block16;
                }
                string = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CONSTRAINT", " FOR ", " REQUIRE ", " ", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{nameString, pattern, propertyString, prettyAssertion})).prettifiedString();
            }
            catch (AuthorizationViolationException authorizationViolationException) {
                string = "constraint";
            }
        }
        return string;
    }

    public VectorIndexVersion vectorIndexVersion(QueryContext ctx) {
        return VectorIndexVersion.latestSupportedVersion((KernelVersion)KernelVersion.getLatestVersion((Configuration)ctx.getConfig()));
    }

    private PrettyString getPrettyName(Option<String> nameOption) {
        return LogicalPlan2PlanDescription$.MODULE$.getPrettyStringName((Option<Either<String, Parameter>>)nameOption.map((Function1 & Serializable)x$23 -> new Left(x$23)));
    }

    private PrettyString getPrettyEntityPattern(ElementTypeName entityName) {
        ElementTypeName elementTypeName = entityName;
        if (elementTypeName instanceof LabelName) {
            LabelName labelName = (LabelName)elementTypeName;
            return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(e:", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply((SymbolicName)labelName)}));
        }
        if (elementTypeName instanceof RelTypeName) {
            RelTypeName relTypeName = (RelTypeName)elementTypeName;
            return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[e:", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply((SymbolicName)relTypeName)}));
        }
        if (elementTypeName instanceof DynamicLabelExpression) {
            throw new IllegalStateException("Did not expect Dynamic Labels here");
        }
        if (elementTypeName instanceof DynamicRelTypeExpression) {
            throw new IllegalStateException("Did not expect Dynamic Labels here");
        }
        throw new MatchError((Object)elementTypeName);
    }

    private PrettyString getPrettyEntityPattern(boolean isNode, String entityName) {
        if (isNode) {
            return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(e:", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply(entityName)}));
        }
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[e:", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply(entityName)}));
    }

    private Tuple2<PrettyString, PrettyString> getPrettyLookupIndexPatternAndFunction(boolean isNode) {
        if (isNode) {
            return new Tuple2((Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(e)"}))), (Seq<PrettyString>)Nil$.MODULE$), (Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "(e)"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.raw(Labels$.MODULE$.name())})));
        }
        return new Tuple2((Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[e]-()"}))), (Seq<PrettyString>)Nil$.MODULE$), (Object)asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "(e)"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.raw(Type$.MODULE$.name())})));
    }

    private PrettyString getPrettyPropertyPattern(Seq<PropertyKeyName> properties, String start, String end) {
        return asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)((IterableOnce)properties.map((Function1 & Serializable)x$24 -> asPrettyString$.MODULE$.apply((SymbolicName)x$24)))).mkPrettyString(start + "e.", ", e.", end);
    }

    private PrettyString getPrettyPropertyPattern(List<String> properties, String start, String end) {
        return asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)properties.map((Function1 & Serializable)x$25 -> asPrettyString$.MODULE$.apply((String)x$25))).mkPrettyString(start + "e.", ", e.", end);
    }

    public IndexProviderContext indexContext(QueryContext ctx) {
        return ctx;
    }

    public static final /* synthetic */ boolean $anonfun$convertConstraintTypeToConstraintMatcher$7(CypherType propType$1, ConstraintDescriptor c) {
        return c.isNodePropertyTypeConstraint() && MODULE$.checkTypes(propType$1, c.asPropertyTypeConstraint().propertyType());
    }

    public static final /* synthetic */ boolean $anonfun$convertConstraintTypeToConstraintMatcher$8(CypherType propType$2, ConstraintDescriptor c) {
        return c.isRelationshipPropertyTypeConstraint() && MODULE$.checkTypes(propType$2, c.asPropertyTypeConstraint().propertyType());
    }

    private SchemaCommandRuntime$() {
    }
}

