/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.constraint;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.ast.CreateConstraintType;
import org.neo4j.cypher.internal.ast.NodeKey;
import org.neo4j.cypher.internal.ast.NodePropertyExistence$;
import org.neo4j.cypher.internal.ast.NodePropertyType;
import org.neo4j.cypher.internal.ast.NodePropertyUniqueness;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.RelationshipKey;
import org.neo4j.cypher.internal.ast.RelationshipPropertyExistence$;
import org.neo4j.cypher.internal.ast.RelationshipPropertyType;
import org.neo4j.cypher.internal.ast.RelationshipPropertyUniqueness;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$;
import org.neo4j.cypher.internal.expressions.ElementTypeName;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions;
import org.neo4j.cypher.internal.optionsmap.IndexBackedConstraintsOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.OptionsConverterResult;
import org.neo4j.cypher.internal.optionsmap.PropertyExistenceOrTypeConstraintOptionsConverter;
import org.neo4j.cypher.internal.procs.IgnoredResult;
import org.neo4j.cypher.internal.procs.PropertyTypeMapper$;
import org.neo4j.cypher.internal.procs.SchemaExecutionResult;
import org.neo4j.cypher.internal.procs.SuccessResult;
import org.neo4j.cypher.internal.procs.SuccessResult$;
import org.neo4j.cypher.internal.runtime.ConstraintInformation;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.util.IndexOrConstraintAlreadyExistsNotification;
import org.neo4j.cypher.internal.util.IndexOrConstraintDoesNotExistNotification;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public final class ConstraintCommandPlanner$ {
    public static final ConstraintCommandPlanner$ MODULE$ = new ConstraintCommandPlanner$();

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createNodeKeyConstraint(NodeKey nodeKey, LabelName label, Seq<Property> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<Procedures> x$5;
            Option<Config> x$4;
            MapValue x$3;
            Options x$22;
            CypherVersion x$1;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(nodeKey.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2 = qual$1.convert(x$1 = cypherVersion, x$22 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option maybeIndexProvider = (Option)tuple2._1();
            Set notifications = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)notifications);
            Option maybeIndexProvider2 = (Option)tuple22._1();
            Set notifications2 = (Set)tuple22._2();
            Option indexProvider = maybeIndexProvider2.flatMap((Function1 & Serializable)x$2 -> x$2.provider());
            int labelId = ctx.getOrCreateLabelId(label.name());
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$createNodeKeyConstraint$3(ctx, p)));
            ctx.createNodeKeyConstraint(labelId, propertyKeyIds, constraintName, indexProvider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createRelationshipKeyConstraint(RelationshipKey relKey, RelTypeName relType, Seq<Property> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<Procedures> x$5;
            Option<Config> x$42;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(relKey.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2 = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$42 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option maybeIndexProvider = (Option)tuple2._1();
            Set notifications = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)notifications);
            Option maybeIndexProvider2 = (Option)tuple22._1();
            Set notifications2 = (Set)tuple22._2();
            Option indexProvider = maybeIndexProvider2.flatMap((Function1 & Serializable)x$4 -> x$4.provider());
            int relId = ctx.getOrCreateRelTypeId(relType.name());
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$createRelationshipKeyConstraint$3(ctx, p)));
            ctx.createRelationshipKeyConstraint(relId, propertyKeyIds, constraintName, indexProvider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createNodePropertyUniquenessConstraint(NodePropertyUniqueness nodePropUnique, LabelName label, Seq<Property> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<Procedures> x$5;
            Option<Config> x$4;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(nodePropUnique.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2 = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option maybeIndexProvider = (Option)tuple2._1();
            Set notifications = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)notifications);
            Option maybeIndexProvider2 = (Option)tuple22._1();
            Set notifications2 = (Set)tuple22._2();
            Option indexProvider = maybeIndexProvider2.flatMap((Function1 & Serializable)x$6 -> x$6.provider());
            int labelId = ctx.getOrCreateLabelId(label.name());
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$createNodePropertyUniquenessConstraint$3(ctx, p)));
            ctx.createNodeUniqueConstraint(labelId, propertyKeyIds, constraintName, indexProvider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createRelationshipPropertyUniquenessConstraint(RelationshipPropertyUniqueness relPropUnique, RelTypeName relType, Seq<Property> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<Procedures> x$5;
            Option<Config> x$4;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(relPropUnique.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2 = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option maybeIndexProvider = (Option)tuple2._1();
            Set notifications = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)notifications);
            Option maybeIndexProvider2 = (Option)tuple22._1();
            Set notifications2 = (Set)tuple22._2();
            Option indexProvider = maybeIndexProvider2.flatMap((Function1 & Serializable)x$8 -> x$8.provider());
            int relTypeId = ctx.getOrCreateRelTypeId(relType.name());
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$createRelationshipPropertyUniquenessConstraint$3(ctx, p)));
            ctx.createRelationshipUniqueConstraint(relTypeId, propertyKeyIds, constraintName, indexProvider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createNodePropertyExistenceConstraint(LabelName label, Seq<Property> prop, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            PropertyExistenceOrTypeConstraintOptionsConverter qual$1 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "existence", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            ((Function3 & Serializable)(Function3 & Serializable)(x$9, x$10, x$11) -> {
                ctx.createNodePropertyExistenceConstraint(BoxesRunTime.unboxToInt((Object)x$9), BoxesRunTime.unboxToInt((Object)x$10), x$11, false);
                return BoxedUnit.UNIT;
            }).tupled().apply(SchemaCommandRuntime$.MODULE$.labelPropWithName((QueryContext)ctx, label, ((Property)prop.head()).propertyKey(), constraintName));
            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createRelationshipPropertyExistenceConstraint(RelTypeName relType, Seq<Property> prop, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            PropertyExistenceOrTypeConstraintOptionsConverter qual$1 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "existence", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            ((Function3 & Serializable)(Function3 & Serializable)(x$12, x$13, x$14) -> {
                ctx.createRelationshipPropertyExistenceConstraint(BoxesRunTime.unboxToInt((Object)x$12), BoxesRunTime.unboxToInt((Object)x$13), x$14, false);
                return BoxedUnit.UNIT;
            }).tupled().apply(SchemaCommandRuntime$.MODULE$.typePropWithName((QueryContext)ctx, relType, ((Property)prop.head()).propertyKey(), constraintName));
            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createNodePropertyTypeConstraint(CypherType propertyType, LabelName label, Seq<Property> prop, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            PropertyExistenceOrTypeConstraintOptionsConverter qual$1 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "type", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            Tuple3<Object, Object, Option<String>> tuple3 = SchemaCommandRuntime$.MODULE$.labelPropWithName((QueryContext)ctx, label, ((Property)prop.head()).propertyKey(), constraintName);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int labelId = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int propId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(labelId, propId);
            int labelId2 = sp2._1$mcI$sp();
            int propId2 = sp2._2$mcI$sp();
            ctx.createNodePropertyTypeConstraint(labelId2, propId2, PropertyTypeMapper$.MODULE$.asPropertyTypeSet(propertyType), constraintName, false);
            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createRelationshipPropertyTypeConstraint(CypherType propertyType, RelTypeName relType, Seq<Property> prop, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            PropertyExistenceOrTypeConstraintOptionsConverter qual$1 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "type", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            Tuple3<Object, Object, Option<String>> tuple3 = SchemaCommandRuntime$.MODULE$.typePropWithName((QueryContext)ctx, relType, ((Property)prop.head()).propertyKey(), constraintName);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int relTypeId = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int propId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(relTypeId, propId);
            int relTypeId2 = sp2._1$mcI$sp();
            int propId2 = sp2._2$mcI$sp();
            ctx.createRelationshipPropertyTypeConstraint(relTypeId2, propId2, PropertyTypeMapper$.MODULE$.asPropertyTypeSet(propertyType), constraintName, false);
            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> dropConstraint(Either<String, Parameter> name, boolean ifExists) {
        return (Function2 & Serializable)(ctx, params) -> {
            Set set;
            String constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            if (!ifExists || ctx.constraintExists(constraintName)) {
                ctx.dropNamedConstraint(constraintName, false);
                set = Predef$.MODULE$.Set().empty();
            } else {
                set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{new IndexOrConstraintDoesNotExistNotification("DROP CONSTRAINT " + Prettifier$.MODULE$.escapeName((Either)new Left((Object)constraintName)) + " IF EXISTS", constraintName)}));
            }
            Set notifications = set;
            return new SuccessResult((Set<InternalNotification>)notifications);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> doNothingIfExists(ElementTypeName entityName, Seq<Property> props, CreateConstraintType assertion, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            OptionsConverterResult<Product> optionsConverterResult;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            CreateConstraintType createConstraintType = assertion;
            if (createConstraintType instanceof NodeKey) {
                NodeKey nodeKey = (NodeKey)createConstraintType;
                IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(nodeKey.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$1 = cypherVersion;
                Options x$2 = options;
                MapValue x$3 = params;
                Option<Config> x$4 = qual$1.convert$default$4();
                Option<Procedures> x$5 = qual$1.convert$default$5();
                optionsConverterResult = qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            } else if (createConstraintType instanceof RelationshipKey) {
                RelationshipKey relationshipKey = (RelationshipKey)createConstraintType;
                IndexBackedConstraintsOptionsConverter qual$2 = new IndexBackedConstraintsOptionsConverter(relationshipKey.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$6 = cypherVersion;
                Options x$7 = options;
                MapValue x$8 = params;
                Option<Config> x$9 = qual$2.convert$default$4();
                Option<Procedures> x$10 = qual$2.convert$default$5();
                optionsConverterResult = qual$2.convert(x$6, x$7, x$8, x$9, x$10);
            } else if (createConstraintType instanceof NodePropertyUniqueness) {
                NodePropertyUniqueness nodePropertyUniqueness = (NodePropertyUniqueness)createConstraintType;
                IndexBackedConstraintsOptionsConverter qual$3 = new IndexBackedConstraintsOptionsConverter(nodePropertyUniqueness.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$11 = cypherVersion;
                Options x$12 = options;
                MapValue x$13 = params;
                Option<Config> x$14 = qual$3.convert$default$4();
                Option<Procedures> x$15 = qual$3.convert$default$5();
                optionsConverterResult = qual$3.convert(x$11, x$12, x$13, x$14, x$15);
            } else if (createConstraintType instanceof RelationshipPropertyUniqueness) {
                RelationshipPropertyUniqueness relationshipPropertyUniqueness = (RelationshipPropertyUniqueness)createConstraintType;
                IndexBackedConstraintsOptionsConverter qual$4 = new IndexBackedConstraintsOptionsConverter(relationshipPropertyUniqueness.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$16 = cypherVersion;
                Options x$17 = options;
                MapValue x$18 = params;
                Option<Config> x$19 = qual$4.convert$default$4();
                Option<Procedures> x$20 = qual$4.convert$default$5();
                optionsConverterResult = qual$4.convert(x$16, x$17, x$18, x$19, x$20);
            } else if (NodePropertyExistence$.MODULE$.equals(createConstraintType)) {
                PropertyExistenceOrTypeConstraintOptionsConverter qual$5 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "existence", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$21 = cypherVersion;
                Options x$22 = options;
                MapValue x$23 = params;
                Option<Config> x$24 = qual$5.convert$default$4();
                Option<Procedures> x$25 = qual$5.convert$default$5();
                optionsConverterResult = qual$5.convert(x$21, x$22, x$23, x$24, x$25);
            } else if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType)) {
                PropertyExistenceOrTypeConstraintOptionsConverter qual$6 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "existence", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$26 = cypherVersion;
                Options x$27 = options;
                MapValue x$28 = params;
                Option<Config> x$29 = qual$6.convert$default$4();
                Option<Procedures> x$30 = qual$6.convert$default$5();
                optionsConverterResult = qual$6.convert(x$26, x$27, x$28, x$29, x$30);
            } else if (createConstraintType instanceof NodePropertyType) {
                PropertyExistenceOrTypeConstraintOptionsConverter qual$7 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "type", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$31 = cypherVersion;
                Options x$32 = options;
                MapValue x$33 = params;
                Option<Config> x$34 = qual$7.convert$default$4();
                Option<Procedures> x$35 = qual$7.convert$default$5();
                optionsConverterResult = qual$7.convert(x$31, x$32, x$33, x$34, x$35);
            } else if (createConstraintType instanceof RelationshipPropertyType) {
                PropertyExistenceOrTypeConstraintOptionsConverter qual$8 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "type", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$36 = cypherVersion;
                Options x$37 = options;
                MapValue x$38 = params;
                Option<Config> x$39 = qual$8.convert$default$4();
                Option<Procedures> x$40 = qual$8.convert$default$5();
                optionsConverterResult = qual$8.convert(x$36, x$37, x$38, x$39, x$40);
            } else {
                throw new MatchError((Object)createConstraintType);
            }
            OptionsConverterResult<CreateIndexProviderOnlyOptions> conversionResult = optionsConverterResult;
            Set optionConverterNotifications = (Set)conversionResult.toOptionNotification()._2();
            Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.getEntityInfo(entityName, (QueryContext)ctx);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int entityId = tuple2._1$mcI$sp();
            int entityId2 = entityId;
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$doNothingIfExists$2(ctx, p)));
            Function1<ConstraintDescriptor, Object> constraintMatcher = SchemaCommandRuntime$.MODULE$.convertConstraintTypeToConstraintMatcher(assertion);
            if (ctx.constraintExists(constraintMatcher, entityId2, propertyKeyIds)) {
                String constraintDescription = SchemaCommandRuntime$.MODULE$.constraintInfo(constraintName, entityName, props, assertion, options);
                String conflictingConstraint = SchemaCommandRuntime$.MODULE$.existingConstraintInfo((QueryContext)ctx, (Function0<ConstraintInformation>)(Function0 & Serializable)() -> ctx.getConstraintInformation(constraintMatcher, entityId2, propertyKeyIds), cypherVersion);
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + constraintDescription, conflictingConstraint);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            if (constraintName.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ctx.constraintExists(name)))) {
                String constraintDescription = SchemaCommandRuntime$.MODULE$.constraintInfo(constraintName, entityName, props, assertion, options);
                String conflictingConstraint = SchemaCommandRuntime$.MODULE$.existingConstraintInfo((QueryContext)ctx, (Function0<ConstraintInformation>)(Function0 & Serializable)() -> ctx.getConstraintInformation((String)constraintName.get()), cypherVersion);
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + constraintDescription, conflictingConstraint);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            return new SuccessResult((Set<InternalNotification>)optionConverterNotifications);
        };
    }

    public static final /* synthetic */ int $anonfun$createNodeKeyConstraint$3(QueryContext ctx$1, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$1, p.propertyKey()).id();
    }

    public static final /* synthetic */ int $anonfun$createRelationshipKeyConstraint$3(QueryContext ctx$2, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$2, p.propertyKey()).id();
    }

    public static final /* synthetic */ int $anonfun$createNodePropertyUniquenessConstraint$3(QueryContext ctx$3, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$3, p.propertyKey()).id();
    }

    public static final /* synthetic */ int $anonfun$createRelationshipPropertyUniquenessConstraint$3(QueryContext ctx$4, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$4, p.propertyKey()).id();
    }

    public static final /* synthetic */ int $anonfun$doNothingIfExists$2(QueryContext ctx$7, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$7, p.propertyKey()).id();
    }

    private ConstraintCommandPlanner$() {
    }
}

