/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.index;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$;
import org.neo4j.cypher.internal.expressions.ElementTypeName;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.optionsmap.CreateFulltextIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions;
import org.neo4j.cypher.internal.optionsmap.CreateIndexWithFullOptions;
import org.neo4j.cypher.internal.optionsmap.CreateLookupIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreatePointIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreatePointIndexOptionsConverter$;
import org.neo4j.cypher.internal.optionsmap.CreateRangeIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateTextIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateTextIndexOptionsConverter$;
import org.neo4j.cypher.internal.optionsmap.CreateVectorIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.IndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.Nothing$;
import org.neo4j.cypher.internal.optionsmap.OptionsConverterResult;
import org.neo4j.cypher.internal.optionsmap.ParsedOptions;
import org.neo4j.cypher.internal.optionsmap.ParsedWithNotifications;
import org.neo4j.cypher.internal.procs.IgnoredResult;
import org.neo4j.cypher.internal.procs.SchemaExecutionResult;
import org.neo4j.cypher.internal.procs.SuccessResult;
import org.neo4j.cypher.internal.runtime.IndexInformation;
import org.neo4j.cypher.internal.runtime.IndexProviderContext;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.util.IndexOrConstraintAlreadyExistsNotification;
import org.neo4j.cypher.internal.util.IndexOrConstraintDoesNotExistNotification;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Try;
import scala.util.Try$;

public final class IndexCommandPlanner$ {
    public static final IndexCommandPlanner$ MODULE$ = new IndexCommandPlanner$();

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createFulltextIndex(Either<List<LabelName>, List<RelTypeName>> entityNames, List<PropertyKeyName> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            ParsedOptions parsedOptions;
            CreateIndexWithFullOptions createIndexWithFullOptions;
            Tuple3 tuple3;
            Option<Procedures> x$5;
            Option<Config> x$4;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            CreateFulltextIndexOptionsConverter qual$1 = new CreateFulltextIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            OptionsConverterResult<CreateIndexWithFullOptions> optionsConverterResult = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5());
            if (Nothing$.MODULE$.equals(optionsConverterResult)) {
                tuple3 = new Tuple3((Object)None$.MODULE$, (Object)IndexConfig.empty(), (Object)Predef$.MODULE$.Set().empty());
            } else if (optionsConverterResult instanceof ParsedOptions && (createIndexWithFullOptions = (CreateIndexWithFullOptions)(parsedOptions = (ParsedOptions)optionsConverterResult).result()) != null) {
                Option<IndexProviderDescriptor> provider = createIndexWithFullOptions.provider();
                IndexConfig config = createIndexWithFullOptions.config();
                tuple3 = new Tuple3(provider, (Object)config, (Object)Predef$.MODULE$.Set().empty());
            } else {
                if (!(optionsConverterResult instanceof ParsedWithNotifications)) throw new MatchError(optionsConverterResult);
                ParsedWithNotifications parsedWithNotifications = (ParsedWithNotifications)optionsConverterResult;
                CreateIndexWithFullOptions createIndexWithFullOptions2 = (CreateIndexWithFullOptions)parsedWithNotifications.result();
                Set<InternalNotification> notifications = parsedWithNotifications.notifications();
                if (createIndexWithFullOptions2 == null) throw new MatchError(optionsConverterResult);
                Option<IndexProviderDescriptor> provider = createIndexWithFullOptions2.provider();
                IndexConfig config = createIndexWithFullOptions2.config();
                tuple3 = new Tuple3(provider, (Object)config, notifications);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            Option indexProvider = (Option)tuple32._1();
            IndexConfig indexConfig = (IndexConfig)tuple32._2();
            Set notifications = (Set)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)indexProvider, (Object)indexConfig, (Object)notifications);
            Option indexProvider2 = (Option)tuple33._1();
            IndexConfig indexConfig2 = (IndexConfig)tuple33._2();
            Set notifications2 = (Set)tuple33._3();
            Tuple2<List<Object>, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.getMultipleEntityInfo(entityNames, (QueryContext)ctx);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List entityIds = (List)tuple2._1();
            EntityType entityType = (EntityType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)entityIds, (Object)entityType);
            List entityIds2 = (List)tuple22._1();
            EntityType entityType2 = (EntityType)tuple22._2();
            List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)IndexCommandPlanner$.$anonfun$createFulltextIndex$2(ctx, p)));
            ctx.addFulltextIndexRule(entityIds2, entityType2, (Seq)propertyKeyIds, indexName, indexProvider2, indexConfig2);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createLookupIndex(EntityType entityType, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<Procedures> x$5;
            Option<Config> x$42;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            CreateLookupIndexOptionsConverter qual$1 = new CreateLookupIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2 = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$42 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option maybeProvider = (Option)tuple2._1();
            Set notifications = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maybeProvider, (Object)notifications);
            Option maybeProvider2 = (Option)tuple22._1();
            Set notifications2 = (Set)tuple22._2();
            Option provider = maybeProvider2.flatMap((Function1 & Serializable)x$4 -> x$4.provider());
            ctx.addLookupIndexRule(entityType, indexName, provider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createPointIndex(ElementTypeName entityName, List<PropertyKeyName> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            ParsedOptions parsedOptions;
            CreateIndexWithFullOptions createIndexWithFullOptions;
            Tuple3 tuple3;
            Option<Procedures> x$5;
            Option<Config> x$4;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            CreatePointIndexOptionsConverter qual$1 = new CreatePointIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            OptionsConverterResult<CreateIndexWithFullOptions> optionsConverterResult = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5());
            if (Nothing$.MODULE$.equals(optionsConverterResult)) {
                tuple3 = new Tuple3((Object)None$.MODULE$, (Object)IndexConfig.empty(), (Object)Predef$.MODULE$.Set().empty());
            } else if (optionsConverterResult instanceof ParsedOptions && (createIndexWithFullOptions = (CreateIndexWithFullOptions)(parsedOptions = (ParsedOptions)optionsConverterResult).result()) != null) {
                Option<IndexProviderDescriptor> provider = createIndexWithFullOptions.provider();
                IndexConfig config = createIndexWithFullOptions.config();
                tuple3 = new Tuple3(provider, (Object)config, (Object)Predef$.MODULE$.Set().empty());
            } else {
                if (!(optionsConverterResult instanceof ParsedWithNotifications)) throw new MatchError(optionsConverterResult);
                ParsedWithNotifications parsedWithNotifications = (ParsedWithNotifications)optionsConverterResult;
                CreateIndexWithFullOptions createIndexWithFullOptions2 = (CreateIndexWithFullOptions)parsedWithNotifications.result();
                Set<InternalNotification> notifications = parsedWithNotifications.notifications();
                if (createIndexWithFullOptions2 == null) throw new MatchError(optionsConverterResult);
                Option<IndexProviderDescriptor> provider = createIndexWithFullOptions2.provider();
                IndexConfig config = createIndexWithFullOptions2.config();
                tuple3 = new Tuple3(provider, (Object)config, notifications);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            Option indexProvider = (Option)tuple32._1();
            IndexConfig indexConfig = (IndexConfig)tuple32._2();
            Set notifications = (Set)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)indexProvider, (Object)indexConfig, (Object)notifications);
            Option indexProvider2 = (Option)tuple33._1();
            IndexConfig indexConfig2 = (IndexConfig)tuple33._2();
            Set notifications2 = (Set)tuple33._3();
            Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.getEntityInfo(entityName, (QueryContext)ctx);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int entityId = tuple2._1$mcI$sp();
            EntityType entityType = (EntityType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
            int entityId2 = tuple22._1$mcI$sp();
            EntityType entityType2 = (EntityType)tuple22._2();
            List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)IndexCommandPlanner$.$anonfun$createPointIndex$2(ctx, p)));
            ctx.addPointIndexRule(entityId2, entityType2, (Seq)propertyKeyIds, indexName, indexProvider2, indexConfig2);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createRangeIndex(ElementTypeName entityName, List<PropertyKeyName> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            String string;
            EntityType entityType;
            Option<String> indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.getEntityInfo(entityName, (QueryContext)ctx);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int entityId = tuple2._1$mcI$sp();
            EntityType entityType2 = (EntityType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType2);
            int entityId2 = tuple22._1$mcI$sp();
            EntityType entityType3 = entityType = (EntityType)tuple22._2();
            if (EntityType.NODE.equals(entityType3)) {
                string = "range node property index";
            } else if (EntityType.RELATIONSHIP.equals(entityType3)) {
                string = "range relationship property index";
            } else {
                throw new MatchError((Object)entityType3);
            }
            String schemaType = string;
            CreateRangeIndexOptionsConverter qual$1 = new CreateRangeIndexOptionsConverter(schemaType, SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple23 = qual$1.convert(x$1, x$2, x$3, x$4, x$5).toOptionNotification();
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            Option maybeProvider = (Option)tuple23._1();
            Set notifications = (Set)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)maybeProvider, (Object)notifications);
            Option maybeProvider2 = (Option)tuple24._1();
            Set notifications2 = (Set)tuple24._2();
            Option provider = maybeProvider2.flatMap((Function1 & Serializable)x$9 -> x$9.provider());
            List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)IndexCommandPlanner$.$anonfun$createRangeIndex$3(ctx, p)));
            ctx.addRangeIndexRule(entityId2, entityType, (Seq)propertyKeyIds, indexName, provider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createTextIndex(ElementTypeName entityName, List<PropertyKeyName> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Set notifications;
            Option maybeProvider;
            Option<String> indexName;
            block5: {
                Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2;
                block4: {
                    Option<Procedures> x$5;
                    Option<Config> x$4;
                    MapValue x$3;
                    Options x$2;
                    CypherVersion x$1;
                    indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
                    CreateTextIndexOptionsConverter qual$1 = new CreateTextIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                    tuple2 = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
                    if (tuple2 == null) break block4;
                    maybeProvider = (Option)tuple2._1();
                    notifications = (Set)tuple2._2();
                    if (maybeProvider != null) break block5;
                }
                throw new MatchError(tuple2);
            }
            Option option = maybeProvider;
            Tuple2 tuple2 = new Tuple2((Object)option, (Object)notifications);
            Option maybeProvider2 = (Option)tuple2._1();
            Set notifications2 = (Set)tuple2._2();
            Option provider = maybeProvider2.flatMap((Function1 & Serializable)x$11 -> x$11.provider());
            Tuple2<Object, EntityType> tuple22 = SchemaCommandRuntime$.MODULE$.getEntityInfo(entityName, (QueryContext)ctx);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            int entityId = tuple22._1$mcI$sp();
            EntityType entityType = (EntityType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
            int entityId2 = tuple23._1$mcI$sp();
            EntityType entityType2 = (EntityType)tuple23._2();
            List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)IndexCommandPlanner$.$anonfun$createTextIndex$3(ctx, p)));
            ctx.addTextIndexRule(entityId2, entityType2, (Seq)propertyKeyIds, indexName, provider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createVectorIndex(ElementTypeName entityName, List<PropertyKeyName> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            ParsedOptions parsedOptions;
            CreateIndexWithFullOptions createIndexWithFullOptions;
            Tuple3 tuple3;
            Option<Procedures> x$5;
            Option<Config> x$4;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            CreateVectorIndexOptionsConverter qual$1 = new CreateVectorIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx), SchemaCommandRuntime$.MODULE$.vectorIndexVersion((QueryContext)ctx));
            OptionsConverterResult<CreateIndexWithFullOptions> optionsConverterResult = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5());
            if (Nothing$.MODULE$.equals(optionsConverterResult)) {
                tuple3 = new Tuple3((Object)None$.MODULE$, (Object)IndexConfig.empty(), (Object)Predef$.MODULE$.Set().empty());
            } else if (optionsConverterResult instanceof ParsedOptions && (createIndexWithFullOptions = (CreateIndexWithFullOptions)(parsedOptions = (ParsedOptions)optionsConverterResult).result()) != null) {
                Option<IndexProviderDescriptor> provider = createIndexWithFullOptions.provider();
                IndexConfig config = createIndexWithFullOptions.config();
                tuple3 = new Tuple3(provider, (Object)config, (Object)Predef$.MODULE$.Set().empty());
            } else {
                if (!(optionsConverterResult instanceof ParsedWithNotifications)) throw new MatchError(optionsConverterResult);
                ParsedWithNotifications parsedWithNotifications = (ParsedWithNotifications)optionsConverterResult;
                CreateIndexWithFullOptions createIndexWithFullOptions2 = (CreateIndexWithFullOptions)parsedWithNotifications.result();
                Set<InternalNotification> notifications = parsedWithNotifications.notifications();
                if (createIndexWithFullOptions2 == null) throw new MatchError(optionsConverterResult);
                Option<IndexProviderDescriptor> provider = createIndexWithFullOptions2.provider();
                IndexConfig config = createIndexWithFullOptions2.config();
                tuple3 = new Tuple3(provider, (Object)config, notifications);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            Option indexProvider = (Option)tuple32._1();
            IndexConfig indexConfig = (IndexConfig)tuple32._2();
            Set notifications = (Set)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)indexProvider, (Object)indexConfig, (Object)notifications);
            Option indexProvider2 = (Option)tuple33._1();
            IndexConfig indexConfig2 = (IndexConfig)tuple33._2();
            Set notifications2 = (Set)tuple33._3();
            Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.getEntityInfo(entityName, (QueryContext)ctx);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int entityId = tuple2._1$mcI$sp();
            EntityType entityType = (EntityType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
            int entityId2 = tuple22._1$mcI$sp();
            EntityType entityType2 = (EntityType)tuple22._2();
            List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)IndexCommandPlanner$.$anonfun$createVectorIndex$2(ctx, p)));
            ctx.addVectorIndexRule(entityId2, entityType2, (Seq)propertyKeyIds, indexName, indexProvider2, indexConfig2);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> dropIndex(Either<String, Parameter> name, boolean ifExists) {
        return (Function2 & Serializable)(ctx, params) -> {
            Set set;
            String indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            if (!ifExists || ctx.indexExists(indexName)) {
                ctx.dropIndexRule(indexName);
                set = Predef$.MODULE$.Set().empty();
            } else {
                set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{new IndexOrConstraintDoesNotExistNotification("DROP INDEX " + Prettifier$.MODULE$.escapeName((Either)new Left((Object)indexName)) + " IF EXISTS", indexName)}));
            }
            Set notifications = set;
            return new SuccessResult((Set<InternalNotification>)notifications);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> doNothingIfExists(ElementTypeName entityName, List<PropertyKeyName> propertyKeyNames, org.neo4j.graphdb.schema.IndexType indexType, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        Tuple2 tuple2;
        org.neo4j.graphdb.schema.IndexType indexType2 = indexType;
        if (org.neo4j.graphdb.schema.IndexType.POINT.equals(indexType2)) {
            tuple2 = new Tuple2((Object)IndexType.POINT, (Object)CreatePointIndexOptionsConverter$.MODULE$);
        } else if (org.neo4j.graphdb.schema.IndexType.RANGE.equals(indexType2)) {
            tuple2 = new Tuple2((Object)IndexType.RANGE, (Function1 & Serializable)ctx -> new CreateRangeIndexOptionsConverter("range index", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx)));
        } else if (org.neo4j.graphdb.schema.IndexType.TEXT.equals(indexType2)) {
            tuple2 = new Tuple2((Object)IndexType.TEXT, (Object)CreateTextIndexOptionsConverter$.MODULE$);
        } else if (org.neo4j.graphdb.schema.IndexType.VECTOR.equals(indexType2)) {
            tuple2 = new Tuple2((Object)IndexType.VECTOR, (Function1 & Serializable)ctx -> new CreateVectorIndexOptionsConverter(SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx), SchemaCommandRuntime$.MODULE$.vectorIndexVersion((QueryContext)ctx)));
        } else {
            throw new IllegalStateException("Did not expect index type " + indexType2 + " here: only point, range, text or vector indexes.");
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        IndexType innerIndexType = (IndexType)tuple22._1();
        Function1 optionsConverter = (Function1)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)innerIndexType, (Object)optionsConverter);
        IndexType innerIndexType2 = (IndexType)tuple23._1();
        Function1 optionsConverter2 = (Function1)tuple23._2();
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            IndexOptionsConverter qual$1 = (IndexOptionsConverter)optionsConverter2.apply(ctx);
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            Set optionConverterNotifications = (Set)qual$1.convert(x$1, x$2, x$3, x$4, x$5).toOptionNotification()._2();
            Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.getEntityInfo(entityName, (QueryContext)ctx);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int entityId = tuple2._1$mcI$sp();
            EntityType entityType = (EntityType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
            int entityId2 = tuple22._1$mcI$sp();
            EntityType entityType2 = (EntityType)tuple22._2();
            List propertyKeyIds = propertyKeyNames.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)IndexCommandPlanner$.$anonfun$doNothingIfExists$4(ctx, p)));
            Try existingIndexDescriptor = Try$.MODULE$.apply((Function0 & Serializable)() -> ctx.indexReference(innerIndexType2, entityId2, entityType2, (Seq)propertyKeyIds));
            if (existingIndexDescriptor.isSuccess()) {
                String indexDescription = SchemaCommandRuntime$.MODULE$.indexInfo(indexType.name(), indexName, entityName, (Seq<PropertyKeyName>)propertyKeyNames, options);
                String conflictingIndex = SchemaCommandRuntime$.MODULE$.existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((IndexDescriptor)existingIndexDescriptor.get()));
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            if (indexName.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ctx.indexExists(name)))) {
                String indexDescription = SchemaCommandRuntime$.MODULE$.indexInfo(indexType.name(), indexName, entityName, (Seq<PropertyKeyName>)propertyKeyNames, options);
                String conflictingIndex = SchemaCommandRuntime$.MODULE$.existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((String)indexName.get()));
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            return new SuccessResult((Set<InternalNotification>)optionConverterNotifications);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> doNothingIfExistsForFulltext(Either<List<LabelName>, List<RelTypeName>> entityNames, List<PropertyKeyName> propertyKeyNames, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            CreateFulltextIndexOptionsConverter qual$1 = new CreateFulltextIndexOptionsConverter((IndexProviderContext)ctx);
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            Set optionConverterNotifications = (Set)qual$1.convert(x$1, x$2, x$3, x$4, x$5).toOptionNotification()._2();
            Tuple2<List<Object>, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.getMultipleEntityInfo(entityNames, (QueryContext)ctx);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List entityIds = (List)tuple2._1();
            EntityType entityType = (EntityType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)entityIds, (Object)entityType);
            List entityIds2 = (List)tuple22._1();
            EntityType entityType2 = (EntityType)tuple22._2();
            List propertyKeyIds = propertyKeyNames.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)IndexCommandPlanner$.$anonfun$doNothingIfExistsForFulltext$2(ctx, p)));
            Try existingIndexDescriptor = Try$.MODULE$.apply((Function0 & Serializable)() -> ctx.fulltextIndexReference(entityIds2, entityType2, (Seq)propertyKeyIds));
            if (existingIndexDescriptor.isSuccess()) {
                String indexDescription = SchemaCommandRuntime$.MODULE$.fulltextIndexInfo(indexName, entityNames, (Seq<PropertyKeyName>)propertyKeyNames, options);
                String conflictingIndex = SchemaCommandRuntime$.MODULE$.existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((IndexDescriptor)existingIndexDescriptor.get()));
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            if (indexName.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ctx.indexExists(name)))) {
                String indexDescription = SchemaCommandRuntime$.MODULE$.fulltextIndexInfo(indexName, entityNames, (Seq<PropertyKeyName>)propertyKeyNames, options);
                String conflictingIndex = SchemaCommandRuntime$.MODULE$.existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((String)indexName.get()));
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            return new SuccessResult((Set<InternalNotification>)optionConverterNotifications);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> doNothingIfExistsForLookup(EntityType entityType, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> indexName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            CreateLookupIndexOptionsConverter qual$1 = new CreateLookupIndexOptionsConverter((IndexProviderContext)ctx);
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            Set optionConverterNotifications = (Set)qual$1.convert(x$1, x$2, x$3, x$4, x$5).toOptionNotification()._2();
            Try existingIndexDescriptor = Try$.MODULE$.apply((Function0 & Serializable)() -> ctx.lookupIndexReference(entityType));
            if (existingIndexDescriptor.isSuccess()) {
                String indexDescription = SchemaCommandRuntime$.MODULE$.lookupIndexInfo(indexName, entityType, options);
                String conflictingIndex = SchemaCommandRuntime$.MODULE$.existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((IndexDescriptor)existingIndexDescriptor.get()));
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            if (indexName.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ctx.indexExists(name)))) {
                String indexDescription = SchemaCommandRuntime$.MODULE$.lookupIndexInfo(indexName, entityType, options);
                String conflictingIndex = SchemaCommandRuntime$.MODULE$.existingIndexInfo((QueryContext)ctx, (Function0<IndexInformation>)(Function0 & Serializable)() -> ctx.getIndexInformation((String)indexName.get()));
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + indexDescription, conflictingIndex);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            return new SuccessResult((Set<InternalNotification>)optionConverterNotifications);
        };
    }

    public static final /* synthetic */ int $anonfun$createFulltextIndex$2(QueryContext ctx$1, PropertyKeyName p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$1, p).id();
    }

    public static final /* synthetic */ int $anonfun$createPointIndex$2(QueryContext ctx$2, PropertyKeyName p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$2, p).id();
    }

    public static final /* synthetic */ int $anonfun$createRangeIndex$3(QueryContext ctx$3, PropertyKeyName p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$3, p).id();
    }

    public static final /* synthetic */ int $anonfun$createTextIndex$3(QueryContext ctx$4, PropertyKeyName p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$4, p).id();
    }

    public static final /* synthetic */ int $anonfun$createVectorIndex$2(QueryContext ctx$5, PropertyKeyName p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$5, p).id();
    }

    public static final /* synthetic */ int $anonfun$doNothingIfExists$4(QueryContext ctx$6, PropertyKeyName p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$6, p).id();
    }

    public static final /* synthetic */ int $anonfun$doNothingIfExistsForFulltext$2(QueryContext ctx$7, PropertyKeyName p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$7, p).id();
    }

    private IndexCommandPlanner$() {
    }
}

