/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class CreateIndexStressIT {
    private static final int NUM_PROPS = 400;
    private final AtomicBoolean hasFailed = new AtomicBoolean(false);
    @Rule
    public ImpermanentDatabaseRule db = new ImpermanentDatabaseRule(){

        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.query_cache_size, "0");
        }
    };
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);

    @After
    public void tearDown() {
        this.executorService.shutdown();
    }

    @Test
    public void shouldHandleConcurrentIndexCreationAndUsage() throws InterruptedException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param", 400);
        this.db.execute("FOREACH(x in range(0,$param) | CREATE (:A {prop:x})) ", params);
        this.db.execute("CREATE INDEX ON :A(prop) ");
        for (int i = 0; i < 400; ++i) {
            params.put("param", i);
            this.executeInThread("MATCH (n:A) WHERE n.prop CONTAINS 'A' RETURN n.prop", params);
        }
        this.awaitAndAssertNoErrors();
    }

    private void awaitAndAssertNoErrors() throws InterruptedException {
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    private void executeInThread(String query, Map<String, Object> params) {
        this.executorService.execute(() -> {
            try {
                this.db.execute(query, params).resultAsString();
            }
            catch (Exception e) {
                this.hasFailed.set(true);
            }
        });
    }
}

