/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class DeleteNodeStressIT {
    private final AtomicBoolean hasFailed = new AtomicBoolean(false);
    @Rule
    public ImpermanentDatabaseRule db = new ImpermanentDatabaseRule();
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);

    @Before
    public void setup() {
        for (int i = 0; i < 100; ++i) {
            try (Transaction tx = this.db.beginTx();){
                for (int j = 0; j < 100; ++j) {
                    Node node2 = this.db.createNode(new Label[]{DynamicLabel.label((String)"L")});
                    node2.setProperty("prop", (Object)(i + j));
                }
                tx.success();
                continue;
            }
        }
    }

    @Test
    public void shouldBeAbleToReturnNodesWhileDeletingNode() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (n:L {prop:42}) OPTIONAL MATCH (m:L {prop:1337}) WITH n MATCH (n) return n");
        this.executeInThread("MATCH (n:L {prop:42}) DELETE n");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    @Test
    public void shouldBeAbleToCheckPropertiesWhileDeletingNode() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (n:L {prop:42}) OPTIONAL MATCH (m:L {prop:1337}) WITH n MATCH (n) RETURN exists(n.prop)");
        this.executeInThread("MATCH (n:L {prop:42}) DELETE n");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    @Test
    public void shouldBeAbleToRemovePropertiesWhileDeletingNode() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (n:L {prop:42}) OPTIONAL MATCH (m:L {prop:1337}) WITH n MATCH (n) REMOVE n.prop");
        this.executeInThread("MATCH (n:L {prop:42}) DELETE n");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    @Test
    public void shouldBeAbleToSetPropertiesWhileDeletingNode() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (n:L {prop:42}) OPTIONAL MATCH (m:L {prop:1337}) WITH n MATCH (n) SET n.foo = 'bar'");
        this.executeInThread("MATCH (n:L {prop:42}) DELETE n");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    @Test
    public void shouldBeAbleToCheckLabelsWhileDeleting() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (n:L {prop:42}) OPTIONAL MATCH (m:L {prop:1337}) WITH n RETURN labels(n)");
        this.executeInThread("MATCH (n:L {prop:42}) DELETE n");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    private void executeInThread(String query) {
        this.executorService.execute(() -> {
            Result execute = this.db.execute(query);
            try {
                execute.resultAsString();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.hasFailed.set(true);
            }
        });
    }
}

