/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class DeleteRelationshipStressIT {
    private final AtomicBoolean hasFailed = new AtomicBoolean(false);
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);
    @Rule
    public ImpermanentDatabaseRule db = new ImpermanentDatabaseRule();

    @Before
    public void setup() {
        for (int i = 0; i < 100; ++i) {
            try (Transaction tx = this.db.beginTx();){
                Node prev = null;
                for (int j = 0; j < 100; ++j) {
                    Node node2 = this.db.createNode(new Label[]{DynamicLabel.label((String)"L")});
                    if (prev != null) {
                        Relationship rel = prev.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"T"));
                        rel.setProperty("prop", (Object)(i + j));
                    }
                    prev = node2;
                }
                tx.success();
                continue;
            }
        }
    }

    @After
    public void tearDown() {
        this.executorService.shutdown();
    }

    @Test
    public void shouldBeAbleToReturnRelsWhileDeletingRelationship() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) OPTIONAL MATCH (:L)-[:T {prop:1337}]-(:L) WITH r MATCH ()-[r]-() return r");
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) DELETE r");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    @Test
    public void shouldBeAbleToGetPropertyWhileDeletingRelationship() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) OPTIONAL MATCH (:L)-[:T {prop:1337}]-(:L) WITH r MATCH ()-[r]-() return r.prop");
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) DELETE r");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    @Test
    public void shouldBeAbleToCheckPropertiesWhileDeletingRelationship() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) OPTIONAL MATCH (:L)-[:T {prop:1337}]-(:L) WITH r MATCH ()-[r]-() return exists(r.prop)");
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) DELETE r");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    @Test
    public void shouldBeAbleToRemovePropertiesWhileDeletingRelationship() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) OPTIONAL MATCH (:L)-[:T {prop:1337}]-(:L) WITH r MATCH ()-[r]-() REMOVE r.prop");
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) DELETE r");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    @Test
    public void shouldBeAbleToSetPropertiesWhileDeletingRelationship() throws IOException, ExecutionException, InterruptedException {
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) OPTIONAL MATCH (:L)-[:T {prop:1337}]-(:L) WITH r MATCH ()-[r]-() SET r.foo = 'bar'");
        this.executeInThread("MATCH (:L)-[r:T {prop:42}]-(:L) DELETE r");
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.hasFailed.get());
    }

    private void executeInThread(String query) {
        this.executorService.execute(() -> {
            Result execute = this.db.execute(query);
            try {
                execute.resultAsString();
            }
            catch (Exception e) {
                this.hasFailed.set(true);
            }
        });
    }
}

