/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.ExecutionEngineFunSuite;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.CypherSerializer;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.pipes.QueryState;
import org.neo4j.cypher.internal.frontend.v3_3.helpers.StringHelper;
import org.neo4j.cypher.internal.frontend.v3_3.helpers.StringHelper$;
import org.neo4j.cypher.internal.spi.v3_3.QueryContext;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001\u0013\t\tRI\u001d:pe6+7o]1hKN$Vm\u001d;\u000b\u0005\r!\u0011AB2za\",'O\u0003\u0002\u0006\r\u0005)a.Z85U*\tq!A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u00159\u0001\"a\u0003\u0007\u000e\u0003\tI!!\u0004\u0002\u0003/\u0015CXmY;uS>tWI\\4j]\u00164UO\\*vSR,\u0007CA\b\u0019\u001b\u0005\u0001\"BA\t\u0013\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0005\u000b\u0002\tY\u001ctl\r\u0006\u0003+Y\tQbY8na\u0006$\u0018NY5mSRL(BA\f\u0003\u0003!Ig\u000e^3s]\u0006d\u0017BA\r\u0011\u0005A\u0019\u0015\u0010\u001d5feN+'/[1mSj,'\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u00111\u0002\u0001\u0005\u0006?\u0001!I\u0001I\u0001\fKb\u0004Xm\u0019;FeJ|'\u000fF\u0002\"OA\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012A!\u00168ji\")\u0001F\ba\u0001S\u0005)\u0011/^3ssB\u0011!&\f\b\u0003E-J!\u0001L\u0012\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003Y\rBQ!\r\u0010A\u0002%\nQ\"\u001a=qK\u000e$X\rZ#se>\u0014\b\"B\u001a\u0001\t\u0013!\u0014!E3ya\u0016\u001cGoU=oi\u0006DXI\u001d:peR!\u0011%\u000e\u001c8\u0011\u0015A#\u00071\u0001*\u0011\u0015\t$\u00071\u0001*\u0011\u0015A$\u00071\u0001:\u00039)\u0007\u0010]3di\u0016$wJ\u001a4tKR\u0004\"A\t\u001e\n\u0005m\u001a#aA%oi\")Q\b\u0001C\u0005}\u0005aQ\r_3dkR,\u0017+^3ssR\u0011\u0011e\u0010\u0005\u0006Qq\u0002\r!\u000b")
public class ErrorMessagesTest
extends ExecutionEngineFunSuite
implements CypherSerializer {
    public String serializeProperties(PropertyContainer x, QueryContext qtx) {
        return CypherSerializer.class.serializeProperties((CypherSerializer)this, (PropertyContainer)x, (QueryContext)qtx);
    }

    public String serialize(Object a, QueryContext qtx) {
        return CypherSerializer.class.serialize((CypherSerializer)this, (Object)a, (QueryContext)qtx);
    }

    public String serializeWithType(Object x, QueryState qs) {
        return CypherSerializer.class.serializeWithType((CypherSerializer)this, (Object)x, (QueryState)qs);
    }

    public String makeSize(String txt, int wantedSize) {
        return CypherSerializer.class.makeSize((CypherSerializer)this, (String)txt, (int)wantedSize);
    }

    public String repeat(String x, int size) {
        return CypherSerializer.class.repeat((CypherSerializer)this, (String)x, (int)size);
    }

    public void org$neo4j$cypher$ErrorMessagesTest$$expectError(String query, String expectedError) {
        CypherException error = (CypherException)this.intercept((Function0)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;
            private final String query$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$executeQuery(this.query$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        }, ManifestFactory$.MODULE$.classType(CypherException.class));
        Assert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.containsString((String)expectedError));
    }

    public void org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError(String query, String expectedError, int expectedOffset) {
        SyntaxException error = (SyntaxException)this.intercept((Function0)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;
            private final String query$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$executeQuery(this.query$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$2 = query$2;
            }
        }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
        Assert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.containsString((String)expectedError));
        Assert.assertThat((Object)error.offset(), (Matcher)CoreMatchers.equalTo((Object)new Some((Object)BoxesRunTime.boxToInteger((int)expectedOffset))));
    }

    public void org$neo4j$cypher$ErrorMessagesTest$$executeQuery(String query) {
        this.execute(StringHelper.RichString$.MODULE$.fixNewLines$extension(StringHelper$.MODULE$.RichString(query)), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).toList();
    }

    public ErrorMessagesTest() {
        CypherSerializer.class.$init$((CypherSerializer)this);
        this.test("foo", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.execute("RETURN 42", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("noReturnColumns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("match (s) where id(s) = 0 return", "Unexpected end of input: expected whitespace, DISTINCT, GRAPHS, SOURCE GRAPH [AS <name>], TARGET GRAPH [AS <name>], GRAPH AT <graph-url> [AS <name>], GRAPH OF <pattern> [AS <name>], GRAPH, GRAPH <graph-ref> [AS <name>], >>, '*' or an expression (line 1, column 33 (offset: 32))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("bad node variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("match (a) where id(a) = 0 match (a)-[WORKED_ON]-, return a", "Invalid input ',': expected whitespace, '>' or a node pattern (line 1, column 49 (offset: 48))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("badStart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("starta = node(0) return a", "Invalid input 'a' (line 1, column 6 (offset: 5))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider extra offset in syntax error messages when there are pre-parsing options", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("PROFILE XX", "", 8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider extra offset in semantic error messages when there are pre-parsing options", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("explain match (a) where id(a) = 0 return dontDoIt(a)", "Unknown function 'dontDoIt' (line 1, column 42 (offset: 41))", 41);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider extra offset in semantic error messages when there are pre-parsing options - multiline", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError(new StringOps(Predef$.MODULE$.augmentString("explain\n        |match (a) where id(a) = 0 return dontDoIt(a)")).stripMargin(), "Unknown function 'dontDoIt' (line 2, column 34 (offset: 41))", 41);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider extra offset in semantic error messages when there are pre-parsing options - multiline 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError(new StringOps(Predef$.MODULE$.augmentString("explain match (a) where id(a) = 0\n        |return dontDoIt(a)")).stripMargin(), "Unknown function 'dontDoIt' (line 2, column 8 (offset: 41))", 41);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("noIndexName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("start a = node(name=\"sebastian\") match (a)-[:WORKED_ON]-b return b", "Invalid input 'n': expected whitespace, an unsigned integer, a parameter or '*' (line 1, column 16 (offset: 15))", 15);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("twoIndexQueriesInSameStart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("start a = node:node_auto_index(name=\"sebastian\",name=\"magnus\") return a", "Invalid input ',': expected whitespace or ')' (line 1, column 48 (offset: 47))", 47);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("badMatch2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("match (p) where id(p) = 2 match p-[:IS_A]>dude return dude.name", "Invalid input '>': expected whitespace or '-' (line 1, column 42 (offset: 41))", 41);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("badMatch3", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("match (p) where id(p) = 2 match p-[:IS_A->dude return dude.name", "Invalid input '-': expected an identifier character, whitespace, '|', a length specification, a property map or ']' (line 1, column 41 (offset: 40))", 40);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("badMatch4", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("match (p) where id(p) = 2 match p-[!]->dude return dude.name", "Invalid input '!': expected whitespace, a variable, relationship types, a length specification, a property map or ']' (line 1, column 36 (offset: 35))", 35);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("badMatch5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("match (p) where id(p) = 2 match p[:likes]->dude return dude.name", "Invalid input '[': expected an identifier character, whitespace, '=', node labels, a property map, a relationship pattern, ',', USING, WHERE, LOAD CSV, FROM, INTO, START, MATCH, UNWIND, MERGE, CREATE GRAPH >>, CREATE >> GRAPH, CREATE GRAPH, CREATE, SET, DELETE GRAPHS, DELETE, REMOVE, FOREACH, WITH, CALL, PERSIST, RELOCATE, RETURN, SNAPSHOT, UNION, ';' or end of input (line 1, column 34 (offset: 33))", 33);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("invalidLabel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("match (p) where id(p) = 2 match (p:super-man) return p.name", "Invalid input 'm': expected whitespace, [ or '-' (line 1, column 42 (offset: 41))", 41);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("noEqualsSignInStart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("start r:relationship:rels() return r", "Invalid input ':': expected an identifier character, whitespace or '=' (line 1, column 8 (offset: 7))", 7);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relTypeInsteadOfRelIdInStart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("start r = relationship(:WORKED_ON) return r", "Invalid input ':': expected whitespace, an unsigned integer, a parameter or '*' (line 1, column 24 (offset: 23))", 23);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("noNodeIdInStart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("start r = node() return r", "Invalid input ')': expected whitespace, an unsigned integer, a parameter or '*' (line 1, column 16 (offset: 15))", 15);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("start expression without variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectSyntaxError("start a = node:node_auto_index(name=\"magnus\"),node:node_auto_index(name=\"sebastian) return b,c", "Invalid input ':': expected an identifier character, whitespace or '=' (line 1, column 51 (offset: 50))", 50);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("fail when using exclamation mark", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("match (n) where id(n) = 0 and n.foo != 2 return n", "Unknown operation '!=' (you probably meant to use '<>', which is the operator for inequality testing) (line 1, column 37 (offset: 36))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trying to drop constraint index should return sensible error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).createConstraint("LabelName", "Prop");
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("DROP INDEX ON :LabelName(Prop)", "Unable to drop index on :LabelName(Prop): Index belongs to constraint: :LabelName(Prop)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trying to drop non existent index", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("DROP INDEX ON :Person(name)", "Unable to drop index on :Person(name): No such INDEX ON :Person(name).");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trying to add unique constraint when duplicates exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long node1 = this.$outer.createLabeledNode((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A")}))), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})).getId();
                long node2 = this.$outer.createLabeledNode((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"A")}))), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})).getId();
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("CREATE CONSTRAINT ON (person:Person) ASSERT person.name IS UNIQUE", String.format(new StringBuilder().append((Object)"Unable to create CONSTRAINT ON ( person:Person ) ASSERT person.name IS UNIQUE:%nBoth Node(").append((Object)BoxesRunTime.boxToLong((long)node1)).append((Object)") and Node(").append((Object)BoxesRunTime.boxToLong((long)node2)).append((Object)") have the label `Person` and property `name` = 'A'").toString(), new Object[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("drop a non existent constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("DROP CONSTRAINT ON (person:Person) ASSERT person.name IS UNIQUE", "No such constraint");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("report wrong usage of index hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).createConstraint("Person", "id");
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("MATCH (n:Person) USING INDEX n:Person(id) WHERE n.name = 'Andres' RETURN n", "Cannot use index hint in this context. Index hints are only supported for the following predicates in WHERE (either directly or as part of a top-level AND or OR): equality comparison, inequality (range) comparison, STARTS WITH, IN condition or checking property existence. The comparison cannot be performed between two property values. Note that the label and property comparison must be specified on a non-optional node (line 1, column 18 (offset: 17))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("report wrong usage of label scan hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("MATCH (n) USING SCAN n:Person WHERE n:Person OR n:Bird RETURN n", "Cannot use label scan hint in this context. Label scan hints require using a simple label test in WHERE (either directly or as part of a top-level AND). Note that the label must be specified on a non-optional node");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should forbid bound relationship list in shortestPath pattern parts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("WITH [] AS r LIMIT 1 MATCH p = shortestPath(src-[r*]->dst) RETURN src, dst", "Bound relationships not allowed in shortestPath(...)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should give nice error when trying to parse multiple statements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("RETURN 42; RETURN 42", "Expected exactly one statement per query but got: 2");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should give proper error message when trying to use Node Key constraint on community", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ErrorMessagesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$ErrorMessagesTest$$expectError("CREATE CONSTRAINT ON (n:Person) ASSERT (n.firstname) IS NODE KEY", String.format("Unable to create CONSTRAINT ON ( person:Person ) ASSERT exists(person.firstname):%nNode Key constraint requires Neo4j Enterprise Edition", new Object[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

