/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class GraphDatabaseServiceExecuteTest {
    @Rule
    public final DatabaseRule graphDb = new ImpermanentDatabaseRule();

    @Test
    public void shouldExecuteCypher() throws Exception {
        long after;
        long before;
        try (Transaction tx = this.graphDb.beginTx();){
            before = Iterables.count((Iterable)this.graphDb.getAllNodes());
            tx.success();
        }
        this.graphDb.execute("CREATE (n:Foo{bar:\"baz\"})");
        tx = this.graphDb.beginTx();
        var6_2 = null;
        try {
            after = Iterables.count((Iterable)this.graphDb.getAllNodes());
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((long)(before + 1L), (long)after);
    }

    @Test
    public void shouldNotReturnInternalGeographicPointType() throws Exception {
        Result execute = this.graphDb.execute("RETURN point({longitude: 144.317718, latitude: -37.031738}) AS p");
        Object obj = execute.next().get("p");
        MatcherAssert.assertThat(obj, (Matcher)Matchers.instanceOf(Point.class));
        Point point = (Point)obj;
        MatcherAssert.assertThat(point.getCoordinate().getCoordinate().get(0), (Matcher)CoreMatchers.equalTo((Object)144.317718));
        MatcherAssert.assertThat(point.getCoordinate().getCoordinate().get(1), (Matcher)CoreMatchers.equalTo((Object)-37.031738));
        CRS crs = point.getCRS();
        MatcherAssert.assertThat((Object)crs.getCode(), (Matcher)CoreMatchers.equalTo((Object)4326));
        MatcherAssert.assertThat((Object)crs.getType(), (Matcher)CoreMatchers.equalTo((Object)"WGS-84"));
        MatcherAssert.assertThat((Object)crs.getHref(), (Matcher)CoreMatchers.equalTo((Object)"http://spatialreference.org/ref/epsg/4326/"));
    }

    @Test
    public void shouldNotReturnInternalCartesianPointType() throws Exception {
        Result execute = this.graphDb.execute("RETURN point({x: 13.37, y: 13.37, crs:'cartesian'}) AS p");
        Object obj = execute.next().get("p");
        MatcherAssert.assertThat(obj, (Matcher)Matchers.instanceOf(Point.class));
        Point point = (Point)obj;
        MatcherAssert.assertThat((Object)point.getCoordinate(), (Matcher)CoreMatchers.equalTo((Object)new Coordinate(new double[]{13.37, 13.37})));
        CRS crs = point.getCRS();
        MatcherAssert.assertThat((Object)crs.getCode(), (Matcher)CoreMatchers.equalTo((Object)7203));
        MatcherAssert.assertThat((Object)crs.getType(), (Matcher)CoreMatchers.equalTo((Object)"cartesian"));
        MatcherAssert.assertThat((Object)crs.getHref(), (Matcher)CoreMatchers.equalTo((Object)"http://spatialreference.org/ref/sr-org/7203/"));
    }

    @Test
    public void shouldNotReturnInternalPointWhenInArray() throws Exception {
        Result execute = this.graphDb.execute("RETURN [point({longitude: 144.317718, latitude: -37.031738})] AS ps");
        List points = (List)execute.next().get("ps");
        MatcherAssert.assertThat(points.get(0), (Matcher)Matchers.instanceOf(Point.class));
    }

    @Test
    public void shouldNotReturnInternalPointWhenInMap() throws Exception {
        Result execute = this.graphDb.execute("RETURN {p: point({longitude: 144.317718, latitude: -37.031738})} AS m");
        Map points = (Map)execute.next().get("m");
        MatcherAssert.assertThat(points.get("p"), (Matcher)Matchers.instanceOf(Point.class));
    }

    @Test
    public void shouldBeAbleToUseResultingPointFromOneQueryAsParameterToNext() throws Exception {
        Result execute = this.graphDb.execute("RETURN point({longitude: 144.317718, latitude: -37.031738}) AS p");
        Point point = (Point)execute.next().get("p");
        Result result2 = this.graphDb.execute("RETURN distance(point({longitude: 144.317718, latitude: -37.031738}),{previous}) AS dist", MapUtil.map((Object[])new Object[]{"previous", point}));
        Double dist = (Double)result2.next().get("dist");
        MatcherAssert.assertThat((Object)dist, (Matcher)CoreMatchers.equalTo((Object)0.0));
    }

    @Test
    public void shouldBeAbleToUseExternalPointAsParameterToQuery() throws Exception {
        Point point = GraphDatabaseServiceExecuteTest.makeFakePoint(144.317718, -37.031738, GraphDatabaseServiceExecuteTest.makeWGS84());
        Result result2 = this.graphDb.execute("RETURN distance(point({longitude: 144.317718, latitude: -37.031738}),{previous}) AS dist", MapUtil.map((Object[])new Object[]{"previous", point}));
        Double dist = (Double)result2.next().get("dist");
        MatcherAssert.assertThat((Object)dist, (Matcher)CoreMatchers.equalTo((Object)0.0));
    }

    @Test
    public void shouldBeAbleToUseExternalGeometryAsParameterToQuery() throws Exception {
        Geometry geometry = GraphDatabaseServiceExecuteTest.makeFakePointAsGeometry(144.317718, -37.031738, GraphDatabaseServiceExecuteTest.makeWGS84());
        Result result2 = this.graphDb.execute("RETURN distance(point({longitude: 144.317718, latitude: -37.031738}),{previous}) AS dist", MapUtil.map((Object[])new Object[]{"previous", geometry}));
        Double dist = (Double)result2.next().get("dist");
        MatcherAssert.assertThat((Object)dist, (Matcher)CoreMatchers.equalTo((Object)0.0));
    }

    @Test
    public void shouldBeAbleToUseExternalPointArrayAsParameterToQuery() throws Exception {
        Point point = GraphDatabaseServiceExecuteTest.makeFakePoint(144.317718, -37.031738, GraphDatabaseServiceExecuteTest.makeWGS84());
        Point[] points = new Point[]{point, point};
        Result result2 = this.graphDb.execute("RETURN distance({points}[0],{points}[1]) AS dist", MapUtil.map((Object[])new Object[]{"points", points}));
        Double dist = (Double)result2.next().get("dist");
        MatcherAssert.assertThat((Object)dist, (Matcher)CoreMatchers.equalTo((Object)0.0));
    }

    @Test
    public void shouldBeAbleToUseResultsOfPointProcedureAsInputToDistanceFunction() throws Exception {
        Procedures procedures = (Procedures)this.graphDb.getDependencyResolver().resolveDependency(Procedures.class);
        procedures.registerProcedure(PointProcs.class);
        Result result2 = this.graphDb.execute("CALL spatial.point(144.317718, -37.031738) YIELD point RETURN distance(point({longitude: 144.317718, latitude: -37.031738}), point) AS dist");
        Double dist = (Double)result2.next().get("dist");
        MatcherAssert.assertThat((Object)dist, (Matcher)CoreMatchers.equalTo((Object)0.0));
    }

    @Test
    public void shouldBeAbleToUseResultsOfPointGeometryProcedureAsInputToDistanceFunction() throws Exception {
        Procedures procedures = (Procedures)this.graphDb.getDependencyResolver().resolveDependency(Procedures.class);
        procedures.registerProcedure(PointProcs.class);
        Result result2 = this.graphDb.execute("CALL spatial.pointGeometry(144.317718, -37.031738) YIELD geometry RETURN distance(point({longitude: 144.317718, latitude: -37.031738}), geometry) AS dist");
        Object dist1 = result2.next().get("dist");
        Double dist = (Double)dist1;
        MatcherAssert.assertThat((Object)dist, (Matcher)CoreMatchers.equalTo((Object)0.0));
    }

    private static Point makeFakePoint(double x, double y, final CRS crs) {
        final Coordinate coord = new Coordinate(new double[]{x, y});
        return new Point(){

            public String getGeometryType() {
                return "Point";
            }

            public List<Coordinate> getCoordinates() {
                return Arrays.asList(coord);
            }

            public CRS getCRS() {
                return crs;
            }
        };
    }

    private static Geometry makeFakePointAsGeometry(double x, double y, final CRS crs) {
        final Coordinate coord = new Coordinate(new double[]{x, y});
        return new Geometry(){

            public String getGeometryType() {
                return "Point";
            }

            public List<Coordinate> getCoordinates() {
                return Arrays.asList(coord);
            }

            public CRS getCRS() {
                return crs;
            }
        };
    }

    private static CRS makeWGS84() {
        return new CRS(){

            public int getCode() {
                return 4326;
            }

            public String getType() {
                return "WGS-84";
            }

            public String getHref() {
                return "http://spatialreference.org/ref/epsg/4326/";
            }
        };
    }

    public static class GeometryResult {
        public Geometry geometry;

        public GeometryResult(Geometry geometry) {
            this.geometry = geometry;
        }
    }

    public static class PointResult {
        public Point point;

        public PointResult(Point point) {
            this.point = point;
        }
    }

    public static class PointProcs {
        @Procedure(value="spatial.point")
        public Stream<PointResult> spatialPoint(@Name(value="longitude") double longitude, @Name(value="latitude") double latitude) {
            Point point = GraphDatabaseServiceExecuteTest.makeFakePoint(longitude, latitude, GraphDatabaseServiceExecuteTest.makeWGS84());
            return Stream.of(new PointResult(point));
        }

        @Procedure(value="spatial.pointGeometry")
        public Stream<GeometryResult> spatialPointGeometry(@Name(value="longitude") double longitude, @Name(value="latitude") double latitude) {
            Geometry geometry = GraphDatabaseServiceExecuteTest.makeFakePointAsGeometry(longitude, latitude, GraphDatabaseServiceExecuteTest.makeWGS84());
            return Stream.of(new GeometryResult(geometry));
        }
    }
}

