/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cypher.javacompat.internal.GraphDatabaseCypherService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

@Ignore(value="Too costly to run by default but useful for testing resource clean up and indexing")
public class ManyMergesStressTest {
    private Random random = new Random();
    private String[] SYLLABLES = new String[]{"Om", "Pa", "So", "Hu", "Ma", "Ni", "Ru", "Gu", "Ha", "Ta"};
    private static final int TRIES = 8000;
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule();

    @Test
    public void shouldWorkFine() throws Throwable {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        GraphDatabaseCypherService graph = new GraphDatabaseCypherService((GraphDatabaseService)db);
        Label person = Label.label((String)"Person");
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(person).on("id").create();
            db.schema().constraintFor(person).assertPropertyIsUnique("id").create();
            tx.success();
        }
        tx = db.beginTx();
        var5_6 = null;
        try {
            db.schema().indexFor(person).on("name").create();
            tx.success();
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var5_6 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        for (int count = 0; count < 8000; ++count) {
            Pair<String, String> stringPair = this.getRandomName();
            String ident = (String)stringPair.first();
            String name = (String)stringPair.other();
            String id = Long.toString(Math.abs(this.random.nextLong()));
            String query = String.format("MERGE (%s:Person {id: %s}) ON CREATE SET %s.name = \"%s\";", ident, id, ident, name);
            try (InternalTransaction tx = graph.beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);){
                Result result2 = db.execute(query);
                result2.close();
                tx.success();
                continue;
            }
        }
    }

    public Pair<String, String> getRandomName() {
        StringBuilder identBuilder = new StringBuilder();
        StringBuilder nameBuilder = new StringBuilder();
        for (int j = 0; j < 10; ++j) {
            String part = this.SYLLABLES[this.random.nextInt(this.SYLLABLES.length)];
            if (j != 0) {
                identBuilder.append('_');
                nameBuilder.append(' ');
            }
            identBuilder.append(part);
            nameBuilder.append(part);
        }
        return Pair.of((Object)identBuilder.toString(), (Object)nameBuilder.toString());
    }
}

