/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cypher.internal.compatibility.v3_3.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Query;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class QueryInvalidationIT {
    private static final int USERS = 10;
    private static final int CONNECTIONS = 100;
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule().withSetting(GraphDatabaseSettings.query_statistics_divergence_threshold, "0.5").withSetting(GraphDatabaseSettings.cypher_min_replan_interval, "1s");

    @Test
    public void shouldRePlanAfterDataChangesFromAnEmptyDatabase() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ((Monitors)this.db.resolveDependency(Monitors.class)).addMonitorListener((Object)monitor, new String[0]);
        this.createIndex();
        this.executeDistantFriendsCountQuery(10);
        long replanTime = System.currentTimeMillis() + 1800L;
        this.createData(0L, 10, 100);
        while (System.currentTimeMillis() < replanTime) {
            Thread.sleep(100L);
        }
        monitor.reset();
        this.executeDistantFriendsCountQuery(10);
        Assert.assertEquals((String)"Query should have been replanned.", (long)1L, (long)monitor.discards.get());
        Assert.assertThat((String)"Replan should have occurred after TTL", (Object)monitor.waitTime.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
    }

    @Test
    public void shouldRePlanAfterDataChangesFromAPopulatedDatabase() throws Exception {
        Config config = this.db.getConfigCopy();
        double divergenceThreshold = (Double)config.get(GraphDatabaseSettings.query_statistics_divergence_threshold);
        long replanInterval = ((Duration)config.get(GraphDatabaseSettings.cypher_min_replan_interval)).toMillis();
        TestMonitor monitor = new TestMonitor();
        ((Monitors)this.db.resolveDependency(Monitors.class)).addMonitorListener((Object)monitor, new String[0]);
        this.createIndex();
        this.createData(0L, 10, 100);
        this.executeDistantFriendsCountQuery(10);
        long replanTime = System.currentTimeMillis() + replanInterval;
        Assert.assertTrue((String)("Test does not work with edge setting for query_statistics_divergence_threshold: " + divergenceThreshold), (divergenceThreshold > 0.0 && divergenceThreshold < 1.0 ? 1 : 0) != 0);
        int usersToCreate = (int)Math.ceil(10.0 / (1.0 - divergenceThreshold)) - 10 + 1;
        this.createData(10L, usersToCreate, 100);
        while (System.currentTimeMillis() <= replanTime) {
            Thread.sleep(100L);
        }
        monitor.reset();
        this.executeDistantFriendsCountQuery(10);
        Assert.assertEquals((String)"Query should have been replanned.", (long)1L, (long)monitor.discards.get());
        Assert.assertThat((String)"Replan should have occurred after TTL", (Object)monitor.waitTime.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(replanInterval / 1000L)));
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(Label.label((String)"User")).on("userId").create();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void createData(long startingUserId, int numUsers, int numConnections) {
        for (long userId = startingUserId; userId < (long)numUsers + startingUserId; ++userId) {
            this.db.execute("CREATE (newUser:User {userId: {userId}})", Collections.singletonMap("userId", userId));
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        for (int i = 0; i < numConnections; ++i) {
            long user2;
            long user1 = startingUserId + (long)QueryInvalidationIT.randomInt(numUsers);
            while (user1 == (user2 = startingUserId + (long)QueryInvalidationIT.randomInt(numUsers))) {
            }
            params.put("user1", user1);
            params.put("user2", user2);
            this.db.execute("MATCH (user1:User { userId: {user1} }), (user2:User { userId: {user2} }) MERGE (user1) -[:FRIEND]- (user2)", params);
        }
    }

    private void executeDistantFriendsCountQuery(int userId) {
        Map<String, Long> params = Collections.singletonMap("userId", Long.valueOf(QueryInvalidationIT.randomInt(userId)));
        try (Result result2 = this.db.execute("MATCH (user:User { userId: {userId} } ) -[:FRIEND]- () -[:FRIEND]- (distantFriend) RETURN COUNT(distinct distantFriend)", params);){
            while (result2.hasNext()) {
                result2.next();
            }
        }
    }

    private static int randomInt(int max) {
        return ThreadLocalRandom.current().nextInt(max);
    }

    private static class TestMonitor
    implements CypherCacheHitMonitor<Query> {
        private final AtomicInteger hits = new AtomicInteger();
        private final AtomicInteger misses = new AtomicInteger();
        private final AtomicInteger discards = new AtomicInteger();
        private final AtomicLong waitTime = new AtomicLong();

        private TestMonitor() {
        }

        public void cacheHit(Query key) {
            this.hits.incrementAndGet();
        }

        public void cacheMiss(Query key) {
            this.misses.incrementAndGet();
        }

        public void cacheDiscard(Query key, String ignored, int secondsSinceReplan) {
            this.discards.incrementAndGet();
            this.waitTime.addAndGet(secondsSinceReplan);
        }

        public String toString() {
            return "TestMonitor{hits=" + this.hits + ", misses=" + this.misses + ", discards=" + this.discards + ", waitTime=" + this.waitTime + "}";
        }

        public void reset() {
            this.hits.set(0);
            this.misses.set(0);
            this.discards.set(0);
            this.waitTime.set(0L);
        }
    }
}

