/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.neo4j.cypher.export.CypherResultSubGraph;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.cypher.export.SubGraphExporter;
import org.neo4j.cypher.internal.javacompat.ExecutionResult;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;

public class ExportTest {
    private GraphDatabaseService gdb;
    private Transaction tx;

    @Before
    public void setUp() throws Exception {
        this.gdb = new TestGraphDatabaseFactory().newImpermanentDatabase();
        this.tx = this.gdb.beginTx();
    }

    @After
    public void tearDown() throws Exception {
        this.tx.close();
        this.gdb.shutdown();
    }

    @Test
    public void testEmptyGraph() throws Exception {
        Assert.assertEquals((Object)"", (Object)this.doExportGraph(this.gdb));
    }

    @Test
    public void testNodeWithProperties() throws Exception {
        this.gdb.createNode().setProperty("name", (Object)"Andres");
        Assert.assertEquals((Object)("create (_0 {`name`:\"Andres\"})" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(this.gdb));
    }

    @Test
    public void testNodeWithFloatProperty() throws Exception {
        float floatValue = 10.1f;
        String expected = "10.100000";
        this.gdb.createNode().setProperty("float", (Object)Float.valueOf(10.1f));
        Assert.assertEquals((Object)("create (_0 {`float`:10.100000})" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(this.gdb));
    }

    @Test
    public void testNodeWithDoubleProperty() throws Exception {
        double doubleValue = 123456.123456;
        String expected = "123456.123456";
        this.gdb.createNode().setProperty("double", (Object)123456.123456);
        Assert.assertEquals((Object)("create (_0 {`double`:123456.123456})" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(this.gdb));
    }

    private String doExportGraph(GraphDatabaseService db) {
        SubGraph graph = DatabaseSubGraph.from((GraphDatabaseService)db);
        return this.doExportGraph(graph);
    }

    private String doExportGraph(SubGraph graph) {
        StringWriter out = new StringWriter();
        new SubGraphExporter(graph).export(new PrintWriter(out));
        return out.toString();
    }

    @Test
    public void testFromSimpleCypherResult() throws Exception {
        Node n = this.gdb.createNode();
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)false);
        Assert.assertEquals((Object)("create (_" + n.getId() + ")" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testSingleNode() throws Exception {
        Node n = this.gdb.createNode();
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)false);
        Assert.assertEquals((Object)("create (_" + n.getId() + ")" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testSingleNodeWithProperties() throws Exception {
        Node n = this.gdb.createNode();
        n.setProperty("name", (Object)"Node1");
        n.setProperty("age", (Object)42);
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)false);
        Assert.assertEquals((Object)("create (_" + n.getId() + " {`age`:42, `name`:\"Node1\"})" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testEscapingOfNodeStringPropertyValue() throws Exception {
        Node n = this.gdb.createNode();
        n.setProperty("name", (Object)"Brutus \"Brutal\" Howell");
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)false);
        Assert.assertEquals((Object)("create (_" + n.getId() + " {`name`:\"Brutus \\\"Brutal\\\" Howell\"})" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testEscapingOfNodeStringArrayPropertyValue() throws Exception {
        Node n = this.gdb.createNode();
        n.setProperty("name", (Object)new String[]{"Brutus \"Brutal\" Howell", "Dr."});
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)false);
        Assert.assertEquals((Object)("create (_" + n.getId() + " {`name`:[\"Brutus \\\"Brutal\\\" Howell\", \"Dr.\"]})" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testEscapingOfRelationshipStringPropertyValue() throws Exception {
        Node n = this.gdb.createNode();
        Relationship rel = n.createRelationshipTo(n, RelationshipType.withName((String)"REL"));
        rel.setProperty("name", (Object)"Brutus \"Brutal\" Howell");
        ExecutionResult result2 = this.result("rel", rel);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)true);
        Assert.assertEquals((Object)("create (_0)" + System.lineSeparator() + "create (_0)-[:`REL` {`name`:\"Brutus \\\"Brutal\\\" Howell\"}]->(_0)" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testEscapingOfRelationshipStringArrayPropertyValue() throws Exception {
        Node n = this.gdb.createNode();
        Relationship rel = n.createRelationshipTo(n, RelationshipType.withName((String)"REL"));
        rel.setProperty("name", (Object)new String[]{"Brutus \"Brutal\" Howell", "Dr."});
        ExecutionResult result2 = this.result("rel", rel);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)true);
        Assert.assertEquals((Object)("create (_0)" + System.lineSeparator() + "create (_0)-[:`REL` {`name`:[\"Brutus \\\"Brutal\\\" Howell\", \"Dr.\"]}]->(_0)" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testEscapingStringPropertyWithBackslash() throws Exception {
        Node n = this.gdb.createNode();
        n.setProperty("name", (Object)"Some\\thing");
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)false);
        Assert.assertEquals((Object)("create (_" + n.getId() + " {`name`:\"Some\\\\thing\"})" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testEscapingStringPropertyWithBackslashAndDoubleQuote() throws Exception {
        Node n = this.gdb.createNode();
        n.setProperty("name", (Object)"Some\\\"thing");
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)false);
        Assert.assertEquals((Object)("create (_" + n.getId() + " {`name`:\"Some\\\\\\\"thing\"})" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testSingleNodeWithArrayProperties() throws Exception {
        Node n = this.gdb.createNode();
        n.setProperty("name", (Object)new String[]{"a", "b"});
        n.setProperty("age", (Object)new int[]{1, 2});
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)false);
        Assert.assertEquals((Object)("create (_" + n.getId() + " {`age`:[1, 2], `name`:[\"a\", \"b\"]})" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testSingleNodeLabels() throws Exception {
        Node n = this.gdb.createNode();
        n.addLabel(Label.label((String)"Foo"));
        n.addLabel(Label.label((String)"Bar"));
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)false);
        Assert.assertEquals((Object)("create (_" + n.getId() + ":`Foo`:`Bar`)" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testExportIndex() throws Exception {
        this.gdb.schema().indexFor(Label.label((String)"Foo")).on("bar").create();
        Assert.assertEquals((Object)("create index on :`Foo`(`bar`);" + System.lineSeparator()), (Object)this.doExportGraph(this.gdb));
    }

    @Test
    public void testExportUniquenessConstraint() throws Exception {
        this.gdb.schema().constraintFor(Label.label((String)"Foo")).assertPropertyIsUnique("bar").create();
        Assert.assertEquals((Object)("create constraint on (n:`Foo`) assert n.`bar` is unique;" + System.lineSeparator()), (Object)this.doExportGraph(this.gdb));
    }

    @Test
    public void testExportIndexesViaCypherResult() throws Exception {
        Label label = Label.label((String)"Foo");
        this.gdb.schema().indexFor(label).on("bar").create();
        this.gdb.schema().indexFor(label).on("bar2").create();
        this.commitAndStartNewTransactionAfterSchemaChanges();
        Node n = this.gdb.createNode(new Label[]{label});
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)true);
        Assert.assertEquals((Object)("create index on :`Foo`(`bar2`);" + System.lineSeparator() + "create index on :`Foo`(`bar`);" + System.lineSeparator() + "create (_0:`Foo`)" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testExportConstraintsViaCypherResult() throws Exception {
        Label label = Label.label((String)"Foo");
        this.gdb.schema().constraintFor(label).assertPropertyIsUnique("bar").create();
        this.gdb.schema().constraintFor(label).assertPropertyIsUnique("bar2").create();
        this.commitAndStartNewTransactionAfterSchemaChanges();
        Node n = this.gdb.createNode(new Label[]{label});
        ExecutionResult result2 = this.result("node", n);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)true);
        Assert.assertEquals((Object)("create constraint on (n:`Foo`) assert n.`bar2` is unique;" + System.lineSeparator() + "create constraint on (n:`Foo`) assert n.`bar` is unique;" + System.lineSeparator() + "create (_0:`Foo`)" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    private void commitAndStartNewTransactionAfterSchemaChanges() {
        this.tx.success();
        this.tx.close();
        this.tx = this.gdb.beginTx();
    }

    @Test
    public void testFromRelCypherResult() throws Exception {
        Node n = this.gdb.createNode();
        Relationship rel = n.createRelationshipTo(n, RelationshipType.withName((String)"REL"));
        ExecutionResult result2 = this.result("rel", rel);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)true);
        Assert.assertEquals((Object)("create (_0)" + System.lineSeparator() + "create (_0)-[:`REL`]->(_0)" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    @Test
    public void testFromPathCypherResult() throws Exception {
        Node n1 = this.gdb.createNode();
        Node n2 = this.gdb.createNode();
        Relationship rel = n1.createRelationshipTo(n2, RelationshipType.withName((String)"REL"));
        Path path = new PathImpl.Builder(n1).push(rel).build();
        ExecutionResult result2 = this.result("path", path);
        SubGraph graph = CypherResultSubGraph.from((Result)result2, (GraphDatabaseService)this.gdb, (boolean)true);
        Assert.assertEquals((Object)("create (_0)" + System.lineSeparator() + "create (_1)" + System.lineSeparator() + "create (_0)-[:`REL`]->(_1)" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    private ExecutionResult result(String column, Object value) {
        ExecutionResult result2 = (ExecutionResult)Mockito.mock(ExecutionResult.class);
        Mockito.when((Object)result2.columns()).thenReturn(Arrays.asList(column));
        final Iterator<Map> inner = Arrays.asList(Collections.singletonMap(column, value)).iterator();
        ResourceIterator<Map<String, Object>> iterator2 = new ResourceIterator<Map<String, Object>>(){

            public void close() {
            }

            public boolean hasNext() {
                return inner.hasNext();
            }

            public Map<String, Object> next() {
                return (Map)inner.next();
            }

            public void remove() {
                inner.remove();
            }
        };
        Mockito.when((Object)result2.iterator()).thenReturn((Object)iterator2);
        Mockito.when((Object)result2.hasNext()).thenAnswer(arg_0 -> ExportTest.lambda$result$0((ResourceIterator)iterator2, arg_0));
        Mockito.when((Object)result2.next()).thenAnswer(arg_0 -> ExportTest.lambda$result$1((ResourceIterator)iterator2, arg_0));
        return result2;
    }

    @Test
    public void testFromSimpleGraph() throws Exception {
        Node n0 = this.gdb.createNode();
        Node n1 = this.gdb.createNode();
        n1.setProperty("name", (Object)"Node1");
        Relationship relationship = n0.createRelationshipTo(n1, RelationshipType.withName((String)"REL"));
        relationship.setProperty("related", (Object)true);
        SubGraph graph = DatabaseSubGraph.from((GraphDatabaseService)this.gdb);
        Assert.assertEquals((Object)("create (_" + n0.getId() + ")" + System.lineSeparator() + "create (_" + n1.getId() + " {`name`:\"Node1\"})" + System.lineSeparator() + "create (_" + n0.getId() + ")-[:`REL` {`related`:true}]->(_" + n1.getId() + ")" + System.lineSeparator() + ";" + System.lineSeparator()), (Object)this.doExportGraph(graph));
    }

    private static /* synthetic */ Object lambda$result$1(ResourceIterator iterator2, InvocationOnMock invocation) throws Throwable {
        return (Map)iterator2.next();
    }

    private static /* synthetic */ Object lambda$result$0(ResourceIterator iterator2, InvocationOnMock invocation) throws Throwable {
        return iterator2.hasNext();
    }
}

